/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.server.component;

import com.ibm.websphere.jaxrs.server.IBMRestServlet;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.api.EndpointPublisher;
import com.ibm.ws.jaxrs20.api.JaxRsEndpointConfigurator;
import com.ibm.ws.jaxrs20.api.JaxRsFactoryBeanCustomizer;
import com.ibm.ws.jaxrs20.api.JaxRsProviderFactoryService;
import com.ibm.ws.jaxrs20.endpoint.JaxRsPublisherContext;
import com.ibm.ws.jaxrs20.endpoint.JaxRsWebEndpoint;
import com.ibm.ws.jaxrs20.metadata.EndpointInfo;
import com.ibm.ws.jaxrs20.server.deprecated.JaxRsExtensionProcessor;
import com.ibm.ws.jaxrs20.server.internal.JaxRsServerConstants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppNameSpaceCollaborator;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="WebEndpointPublisher", immediate=true, property={"service.vendor=IBM"}, configurationPolicy=ConfigurationPolicy.IGNORE)
public class JaxRsWebEndpointPublisher
implements EndpointPublisher {
    private static final TraceComponent tc = Tr.register(JaxRsWebEndpointPublisher.class);
    public Map<String, JaxRsEndpointConfigurator> endpointTypeJaxRsEndpointConfiguratorMap = new ConcurrentHashMap<String, JaxRsEndpointConfigurator>();
    private final AtomicServiceReference<JaxRsProviderFactoryService> jaxRsProviderFactoryServiceSR = new AtomicServiceReference("jaxRsProviderFactoryService");
    private final Set<JaxRsFactoryBeanCustomizer> beanCustomizers = new HashSet<JaxRsFactoryBeanCustomizer>();
    static final long serialVersionUID = 4353427735396774494L;

    @Reference(name="jaxRsFactoryBeanCustomizer", service=JaxRsFactoryBeanCustomizer.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void registerJaxRsFactoryBeanCustomizer(JaxRsFactoryBeanCustomizer beanCustomizer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"registerJaxRsFactoryBeanCustomizer", (Object[])new Object[0]);
        }
        this.beanCustomizers.add(beanCustomizer);
    }

    protected void unregisterJaxRsFactoryBeanCustomizer(JaxRsFactoryBeanCustomizer beanCustomizer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"registerJaxRsFactoryBeanCustomizer", (Object[])new Object[0]);
        }
        this.beanCustomizers.remove(beanCustomizer);
    }

    @Reference(name="jaxRsEndpointConfigurator", service=JaxRsEndpointConfigurator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void registerJaxRsEndpointConfigurator(JaxRsEndpointConfigurator configurator) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Register JaxRsEndpointConfigurator support Servlet", (Object[])new Object[0]);
        }
        this.endpointTypeJaxRsEndpointConfiguratorMap.put("Servlet", configurator);
    }

    protected void unregisterJaxRsEndpointConfigurator(JaxRsEndpointConfigurator configurator) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"unregister JaxRsEndpointConfigurator support Servlet", (Object[])new Object[0]);
        }
        this.endpointTypeJaxRsEndpointConfiguratorMap.remove("Servlet");
    }

    public JaxRsEndpointConfigurator getJaxRsEndpointConfigurator(String endpointType) {
        return this.endpointTypeJaxRsEndpointConfiguratorMap.get(endpointType);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.jaxRsProviderFactoryServiceSR.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.jaxRsProviderFactoryServiceSR.deactivate(cc);
    }

    @Reference(name="jaxRsProviderFactoryService", service=JaxRsProviderFactoryService.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setJaxRsProviderFactoryService(ServiceReference<JaxRsProviderFactoryService> ref) {
        this.jaxRsProviderFactoryServiceSR.setReference(ref);
    }

    protected void unsetJaxRsProviderFactoryService(ServiceReference<JaxRsProviderFactoryService> ref) {
        this.jaxRsProviderFactoryServiceSR.unsetReference(ref);
    }

    /*
     * WARNING - void declaration
     */
    public void publish(EndpointInfo endpointInfo, JaxRsPublisherContext context) {
        JaxRsWebEndpoint jaxRsWebEndpoint;
        block15: {
            WebAppConfig webAppConfig;
            JaxRsEndpointConfigurator jaxRsEndpointConfigurator = this.getJaxRsEndpointConfigurator("Servlet");
            if (jaxRsEndpointConfigurator == null) {
                throw new IllegalStateException("Unsupport endpoint type Servlet");
            }
            IServletContext servletContext = (IServletContext)context.getAttribute("SERVLET_CONTEXT", IServletContext.class);
            if (servletContext == null) {
                throw new IllegalStateException("Unable to publish the endpoint to web container due to null web app instance");
            }
            context.setAttribute(JaxRsServerConstants.BEAN_CUSTOMIZER, this.beanCustomizers);
            jaxRsWebEndpoint = jaxRsEndpointConfigurator.createWebEndpoint(endpointInfo, context);
            if (jaxRsWebEndpoint == null) {
                return;
            }
            Container moduleContainer = context.getPublisherModuleContainer();
            try {
                webAppConfig = (WebAppConfig)moduleContainer.adapt(WebAppConfig.class);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsWebEndpointPublisher", (String)"145", (Object)this, (Object[])new Object[]{endpointInfo, context});
                throw new IllegalStateException((Throwable)e);
            }
            IBMRestServlet restServlet = new IBMRestServlet(jaxRsWebEndpoint, (IWebAppNameSpaceCollaborator)context.getAttribute("collaborator"), (JaxRsProviderFactoryService)this.jaxRsProviderFactoryServiceSR.getServiceWithException());
            IServletConfig sconfig = webAppConfig.getServletInfo(endpointInfo.getServletName());
            if (sconfig == null) {
                try {
                    JaxRsExtensionProcessor processor = new JaxRsExtensionProcessor(servletContext);
                    IServletConfig info = processor.createConfig(endpointInfo.getServletName());
                    info.setServletName(endpointInfo.getServletName());
                    info.setAsyncSupported(true);
                    info.setServlet((Servlet)restServlet);
                    info.setServletClass(((Object)((Object)restServlet)).getClass());
                    webAppConfig.addServletInfo(endpointInfo.getServletName(), info);
                    if (info.getMappings() != null && info.getMappings().size() != 0) break block15;
                    info.setServletContext((ServletContext)servletContext);
                    if (endpointInfo.getServletMappingUrl() != null) {
                        info.addMapping(new String[]{endpointInfo.getServletMappingUrl()});
                        break block15;
                    }
                    info.addMapping(new String[]{endpointInfo.getAppPath()});
                }
                catch (ServletException processor) {
                    FFDCFilter.processException((Throwable)processor, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsWebEndpointPublisher", (String)"183", (Object)this, (Object[])new Object[]{endpointInfo, context});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        void e;
                        Tr.debug((TraceComponent)tc, (String)"Servlet Exception when create a new servlet info:", (Object[])new Object[]{e});
                    }
                    break block15;
                }
            }
            sconfig.setAsyncSupported(true);
            sconfig.setServlet((Servlet)restServlet);
            sconfig.setServletClass(((Object)((Object)restServlet)).getClass());
            if (sconfig.getServletWrapper() != null) {
                sconfig.getServletWrapper().setTarget((Servlet)restServlet);
            }
            if (sconfig.getMappings() == null || sconfig.getMappings().size() == 0) {
                sconfig.setServletContext((ServletContext)servletContext);
                sconfig.addMapping(new String[]{endpointInfo.getAppPath()});
            }
        }
        if (endpointInfo.getServletMappingUrl() != null) {
            jaxRsWebEndpoint.setEndpointInfoAddress(endpointInfo.getServletMappingUrl());
        } else if (endpointInfo.getAppPath() != null) {
            jaxRsWebEndpoint.setEndpointInfoAddress(endpointInfo.getAppPath());
        }
    }

    public String getType() {
        return "WEB";
    }
}

