/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.support;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxrs20.Destroyable;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JaxRsInstanceManager {
    private final ClassLoader classLoader;
    private final List<InstanceInterceptor> interceptors;
    private static final InstanceInterceptor[] EMPTY_INTERCEPTOR_ARRAY;
    static final long serialVersionUID = 4605444750145099527L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JaxRsInstanceManager(ClassLoader classLoader, InstanceInterceptor ... interceptors) {
        this.classLoader = classLoader;
        this.interceptors = new CopyOnWriteArrayList<InstanceInterceptor>(interceptors);
    }

    public Object createInstance(String className) throws InstantiationException, IllegalAccessException, InterceptException, ClassNotFoundException {
        return this.createInstance(this.classLoader.loadClass(className));
    }

    public Object createInstance(String className, InstanceInterceptor ... addintionalInterceptors) throws InstantiationException, IllegalAccessException, InterceptException, ClassNotFoundException {
        return this.createInstance(this.classLoader.loadClass(className), addintionalInterceptors);
    }

    public <T> T createInstance(Class<T> cls) throws IllegalAccessException, InstantiationException, InterceptException {
        return this.createInstance(cls, EMPTY_INTERCEPTOR_ARRAY);
    }

    public boolean addInterceptor(InstanceInterceptor interceptor) {
        return this.interceptors.add(interceptor);
    }

    public boolean removeInterceptor(InstanceInterceptor interceptor) {
        return this.interceptors.remove(interceptor);
    }

    public InstanceInterceptor getInterceptor(String className) {
        for (InstanceInterceptor interceptor : this.interceptors) {
            if (!interceptor.getClass().getName().equals(className)) continue;
            return interceptor;
        }
        return null;
    }

    public <T> T createInstance(Class<T> cls, InstanceInterceptor ... addintionalInterceptors) throws IllegalAccessException, InstantiationException, InterceptException {
        T instance = cls.newInstance();
        if (this.interceptors.size() == 0 && addintionalInterceptors.length == 0) {
            return instance;
        }
        InterceptorContext ctx = this.createInterceptorContext(instance);
        for (InstanceInterceptor instanceInterceptor : addintionalInterceptors) {
            instanceInterceptor.postNewInstance(ctx);
        }
        for (InstanceInterceptor interceptor : this.interceptors) {
            interceptor.postNewInstance(ctx);
        }
        for (InstanceInterceptor instanceInterceptor : addintionalInterceptors) {
            instanceInterceptor.postInjectInstance(ctx);
        }
        for (InstanceInterceptor interceptor : this.interceptors) {
            interceptor.postInjectInstance(ctx);
        }
        return instance;
    }

    protected InterceptorContext createInterceptorContext(Object instance) {
        return new InterceptorContext(instance);
    }

    public void destroyInstance(Object instance) throws InterceptException {
        if (this.interceptors.size() > 0) {
            InterceptorContext ctx = this.createInterceptorContext(instance);
            for (InstanceInterceptor interceptor : this.interceptors) {
                interceptor.preDestroyInstance(ctx);
            }
        }
        if (instance instanceof Destroyable) {
            ((Destroyable)instance).destroy();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JaxRsInstanceManager.class);
        EMPTY_INTERCEPTOR_ARRAY = new InstanceInterceptor[0];
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class InterceptException
    extends Exception {
        static final long serialVersionUID = 6307141757336091358L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public InterceptException(String message, Throwable cause) {
            super(message, cause);
        }

        public InterceptException(String message) {
            super(message);
        }

        public InterceptException(Throwable cause) {
            super(cause);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(InterceptException.class);
        }
    }

    public static interface InstanceInterceptor {
        public void postNewInstance(InterceptorContext var1) throws InterceptException;

        public void postInjectInstance(InterceptorContext var1);

        public void preDestroyInstance(InterceptorContext var1) throws InterceptException;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class InterceptorContext {
        private final Object instance;
        static final long serialVersionUID = 487285122638728576L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public InterceptorContext(Object instance) {
            this.instance = instance;
        }

        public Object getInstance() {
            return this.instance;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(InterceptorContext.class);
        }
    }
}

