/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxrs20.api.JaxRsFactoryBeanCustomizer;
import com.ibm.ws.jaxrs20.injection.InjectionRuntimeContextHelper;
import com.ibm.ws.jaxrs20.providers.jsonp.JsonPProvider;
import com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider;
import com.ibm.ws.jaxrs20.utils.CustomizerUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.activation.DataSource;
import javax.ws.rs.Produces;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.ReaderInterceptorMBR;
import org.apache.cxf.jaxrs.impl.WriterInterceptorMBW;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProxy;
import org.apache.cxf.jaxrs.model.ApplicationInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.FilterProviderInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.provider.BinaryDataProvider;
import org.apache.cxf.jaxrs.provider.ClassPair;
import org.apache.cxf.jaxrs.provider.DataSourceProvider;
import org.apache.cxf.jaxrs.provider.FormEncodingProvider;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.provider.JAXBElementTypedProvider;
import org.apache.cxf.jaxrs.provider.MultipartProvider;
import org.apache.cxf.jaxrs.provider.PrimitiveTextProvider;
import org.apache.cxf.jaxrs.provider.ProviderCache;
import org.apache.cxf.jaxrs.provider.SourceProvider;
import org.apache.cxf.jaxrs.provider.StringTextProvider;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProviderWrapper;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class ProviderFactory {
    private static final TraceComponent tc = Tr.register(ProviderFactory.class);
    public static final String DEFAULT_FILTER_NAME_BINDING = "org.apache.cxf.filter.binding";
    public static final String PROVIDER_SELECTION_PROPERTY_CHANGED = "provider.selection.property.changed";
    public static final String ACTIVE_JAXRS_PROVIDER_KEY = "active.jaxrs.provider";
    protected static final String SERVER_FACTORY_NAME = "org.apache.cxf.jaxrs.provider.ServerProviderFactory";
    protected static final String CLIENT_FACTORY_NAME = "org.apache.cxf.jaxrs.client.ClientProviderFactory";
    protected static final String IGNORE_TYPE_VARIABLES = "org.apache.cxf.jaxrs.providers.ignore.typevars";
    private static final String JAXB_PROVIDER_NAME = "org.apache.cxf.jaxrs.provider.JAXBElementProvider";
    private static final String JSON_PROVIDER_NAME = "org.apache.cxf.jaxrs.provider.json.JSONProvider";
    private static final String BUS_PROVIDERS_ALL = "org.apache.cxf.jaxrs.bus.providers";
    private static final String PROVIDER_CACHE_ALLOWED = "org.apache.cxf.jaxrs.provider.cache.allowed";
    private static final String PROVIDER_CACHE_CHECK_ALL = "org.apache.cxf.jaxrs.provider.cache.checkAllCandidates";
    private static final String JSONPCLASS = "javax.json.Json";
    protected Map<NameKey, ProviderInfo<ReaderInterceptor>> readerInterceptors = new NameKeyMap<ProviderInfo<ReaderInterceptor>>(true);
    protected Map<NameKey, ProviderInfo<WriterInterceptor>> writerInterceptors = new NameKeyMap<ProviderInfo<WriterInterceptor>>(true);
    private final List<ProviderInfo<MessageBodyReader<?>>> messageReaders;
    private final List<ProviderInfo<MessageBodyWriter<?>>> messageWriters;
    private final List<ProviderInfo<ContextResolver<?>>> contextResolvers;
    private final List<ProviderInfo<ContextProvider<?>>> contextProviders;
    private final List<ProviderInfo<ParamConverterProvider>> paramConverters = new ArrayList<ProviderInfo<ParamConverterProvider>>(1);
    private boolean paramConverterContextsAvailable;
    private final Collection<ProviderInfo<?>> injectedProviders = new HashSet();
    private final Bus bus;
    private Comparator<?> providerComparator;
    private final ProviderCache providerCache;
    private static final ConcurrentHashMap<ClassPair, Type[]> genericInterfacesCache = new ConcurrentHashMap();
    private static final Type[] emptyType = new Type[0];
    private static final String[] jsonpClasses = new String[]{"javax.json.JsonArray", "javax.json.JsonObject", "javax.json.JsonStructure"};
    private final Map<MessageBodyReader<?>, List<MediaType>> readerMediaTypesMap = new HashMap();
    private final Map<MessageBodyWriter<?>, List<MediaType>> writerMediaTypesMap = new HashMap();
    static final long serialVersionUID = -3982029675004839473L;

    protected ProviderFactory(Bus bus) {
        String javaVersion = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 857220543767580014L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty("java.version");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        String cs = "1.7";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Java = " + javaVersion), (Object[])new Object[0]);
        }
        if (javaVersion.contains(cs)) {
            this.messageReaders = new ArrayList();
            this.messageWriters = new ArrayList();
            this.contextResolvers = new ArrayList(1);
            this.contextProviders = new ArrayList(1);
        } else {
            this.messageReaders = new CopyOnWriteArrayList();
            this.messageWriters = new CopyOnWriteArrayList();
            this.contextResolvers = new CopyOnWriteArrayList();
            this.contextProviders = new CopyOnWriteArrayList();
        }
        this.bus = bus;
        this.providerCache = ProviderFactory.initCache(bus);
    }

    public Bus getBus() {
        return this.bus;
    }

    protected static ProviderCache initCache(Bus theBus) {
        boolean allowed;
        Object allowProp = theBus.getProperty(PROVIDER_CACHE_ALLOWED);
        boolean bl = allowed = allowProp == null || PropertyUtils.isTrue(allowProp);
        if (!allowed) {
            return null;
        }
        boolean checkAll = PropertyUtils.isTrue(theBus.getProperty(PROVIDER_CACHE_CHECK_ALL));
        return new ProviderCache(checkAll);
    }

    protected static void initFactory(ProviderFactory factory) {
        factory.setProviders(false, false, new BinaryDataProvider(), new SourceProvider(), new DataSourceProvider(), new FormEncodingProvider(), new StringTextProvider(), new PrimitiveTextProvider(), new JAXBElementProvider(), new JAXBElementTypedProvider(), ProviderFactory.createJsonpProvider(), ProviderFactory.createJacksonProvider(), new IBMMultipartProvider(), new MultipartProvider());
        Object prop = factory.getBus().getProperty("skip.default.json.provider.registration");
        if (!PropertyUtils.isTrue(prop)) {
            factory.setProviders(false, false, ProviderFactory.createProvider(JSON_PROVIDER_NAME, factory.getBus()));
        }
    }

    @FFDCIgnore(value={Throwable.class})
    protected static Object createProvider(String className, Bus bus) {
        try {
            Class<?> cls = ClassLoaderUtils.loadClass(className, ProviderFactory.class);
            for (Constructor<?> c : cls.getConstructors()) {
                if (c.getParameterTypes().length != 1 || c.getParameterTypes()[0] != Bus.class) continue;
                return c.newInstance(bus);
            }
            return cls.newInstance();
        }
        catch (Throwable ex) {
            String message = "Problem with creating the default provider " + className;
            message = ex.getMessage() != null ? message + ": " + ex.getMessage() : message + ", exception class : " + ex.getClass().getName();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)message, (Object[])new Object[0]);
            }
            return null;
        }
    }

    private static Object createJsonpProvider() {
        JsonPProvider provider = null;
        ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = 197140491277406512L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return ProviderFactory.class.getClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
        Class<?> c = ProviderFactory.loadClass(cl, JSONPCLASS);
        if (c != null) {
            provider = new JsonPProvider();
        }
        return provider;
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    public static Class<?> loadClass(ClassLoader cl, String className) {
        if (cl == null) {
            return null;
        }
        Class<?> c = null;
        try {
            c = cl.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return c;
    }

    private static Object createJacksonProvider() {
        JacksonJaxbJsonProviderWrapper jacksonjaxbprovider = new JacksonJaxbJsonProviderWrapper();
        jacksonjaxbprovider.addUntouchable(DataSource.class);
        jacksonjaxbprovider.addUntouchable(File.class);
        ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = -2281404427652951704L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return ProviderFactory.class.getClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        });
        for (String clsName : jsonpClasses) {
            Class<?> c = ProviderFactory.loadClass(cl, clsName);
            if (c == null) continue;
            jacksonjaxbprovider.addUntouchable(c);
        }
        ObjectMapper mapperObject = new ObjectMapper();
        AnnotationIntrospector.Pair annotationIntrospectorPairObject = new AnnotationIntrospector.Pair(new JaxbAnnotationIntrospector(), new JacksonAnnotationIntrospector());
        SerializationConfig serializationConfig = mapperObject.getSerializationConfig();
        serializationConfig.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        serializationConfig.setAnnotationIntrospector(annotationIntrospectorPairObject);
        DeserializationConfig deserializationConfig = mapperObject.getDeserializationConfig();
        deserializationConfig.setAnnotationIntrospector(annotationIntrospectorPairObject);
        jacksonjaxbprovider.setMapper(mapperObject);
        return jacksonjaxbprovider;
    }

    public abstract Configuration getConfiguration(Message var1);

    public <T> ContextResolver<T> createContextResolver(Type contextType, Message m) {
        boolean isRequestor = MessageUtils.isRequestor(m);
        Message requestMessage = isRequestor ? m.getExchange().getOutMessage() : m.getExchange().getInMessage();
        Message responseMessage = isRequestor ? m.getExchange().getInMessage() : m.getExchange().getOutMessage();
        Object ctProperty = null;
        ctProperty = responseMessage != null ? (Object)responseMessage.get("Content-Type") : (Object)requestMessage.get("Content-Type");
        MediaType mt = ctProperty != null ? JAXRSUtils.toMediaType(ctProperty.toString()) : MediaType.WILDCARD_TYPE;
        return this.createContextResolver(contextType, m, mt);
    }

    public <T> ContextResolver<T> createContextResolver(Type contextType, Message m, MediaType type) {
        Class<?> contextCls = InjectionUtils.getActualType(contextType);
        if (contextCls == null) {
            return null;
        }
        LinkedList candidates = new LinkedList();
        for (ProviderInfo<ContextResolver<?>> cr : this.contextResolvers) {
            Type[] types;
            for (Type t : types = cr.getProvider().getClass().getGenericInterfaces()) {
                List<MediaType> mTypes;
                Class<?> argCls;
                ParameterizedType pt;
                Type[] args;
                if (!(t instanceof ParameterizedType) || (args = (pt = (ParameterizedType)t).getActualTypeArguments()).length <= 0 || (argCls = InjectionUtils.getActualType(args[0])) == null || !argCls.isAssignableFrom(contextCls) || JAXRSUtils.intersectMimeTypes(mTypes = JAXRSUtils.getProduceTypes(cr.getProvider().getClass().getAnnotation(Produces.class)), type).size() <= 0) continue;
                this.injectContextValues(cr, m);
                candidates.add(cr.getProvider());
            }
        }
        if (candidates.size() == 0) {
            return null;
        }
        if (candidates.size() == 1) {
            return (ContextResolver)candidates.get(0);
        }
        Collections.sort(candidates, new ClassComparator());
        return new ContextResolverProxy(candidates);
    }

    public <T> ContextProvider<T> createContextProvider(Type contextType, Message m) {
        Class<?> contextCls = InjectionUtils.getActualType(contextType);
        if (contextCls == null) {
            return null;
        }
        for (ProviderInfo<ContextProvider<?>> cr : this.contextProviders) {
            Type[] types;
            for (Type t : types = cr.getProvider().getClass().getGenericInterfaces()) {
                Class<?> argCls;
                ParameterizedType pt;
                Type[] args;
                if (!(t instanceof ParameterizedType) || (args = (pt = (ParameterizedType)t).getActualTypeArguments()).length <= 0 || (argCls = InjectionUtils.getActualType(args[0])) == null || !argCls.isAssignableFrom(contextCls)) continue;
                return cr.getProvider();
            }
        }
        return null;
    }

    public <T> ParamConverter<T> createParameterHandler(Class<T> paramType, Type genericType, Annotation[] anns, Message m) {
        if (this.paramConverters != null) {
            anns = anns != null ? anns : new Annotation[]{};
            for (ProviderInfo<ParamConverterProvider> pi : this.paramConverters) {
                this.injectContextValues(pi, m);
                ParamConverter converter = pi.getProvider().getConverter(paramType, genericType, anns);
                if (converter != null) {
                    return converter;
                }
                pi.clearThreadLocalProxies();
            }
        }
        return null;
    }

    protected <T> boolean handleRWMapper(ProviderInfo<T> em, Class<?> expectedType, Message m, Class<?> providerClass) {
        Class<?> mapperClass = ClassHelper.getRealClass(this.bus, em.getOldProvider());
        Type[] types = null;
        types = m != null && MessageUtils.isTrue(m.getContextualProperty(IGNORE_TYPE_VARIABLES)) ? new Type[]{mapperClass} : ProviderFactory.getGenericInterfaces(mapperClass, expectedType);
        for (Type t : types) {
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                Type[] args = pt.getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    Type arg = args[i];
                    if (arg instanceof TypeVariable) {
                        TypeVariable var = (TypeVariable)arg;
                        Type[] bounds = var.getBounds();
                        boolean isResolved = false;
                        for (int j = 0; j < bounds.length; ++j) {
                            Class<?> cls = InjectionUtils.getRawType(bounds[j]);
                            if (cls == null || !cls.isAssignableFrom(expectedType)) continue;
                            isResolved = true;
                            break;
                        }
                        return isResolved;
                    }
                    Class<?> actualClass = InjectionUtils.getRawType(arg);
                    if (actualClass == null) continue;
                    if (expectedType.isArray() && !actualClass.isArray()) {
                        expectedType = expectedType.getComponentType();
                    }
                    if (!actualClass.isAssignableFrom(expectedType) && actualClass != Object.class) continue;
                    return true;
                }
                continue;
            }
            if (!(t instanceof Class) || !providerClass.isAssignableFrom((Class)t)) continue;
            return true;
        }
        return false;
    }

    protected <T> boolean handleMapper(ProviderInfo<T> em, Class<?> expectedType, Message m, Class<?> providerClass, boolean injectContext) {
        Class<?> mapperClass = ClassHelper.getRealClass(this.bus, em.getOldProvider());
        Type[] types = null;
        types = m != null && MessageUtils.isTrue(m.getContextualProperty(IGNORE_TYPE_VARIABLES)) ? new Type[]{mapperClass} : ProviderFactory.getGenericInterfaces(mapperClass, expectedType);
        for (Type t : types) {
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                Type[] args = pt.getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    Type arg = args[i];
                    if (arg instanceof TypeVariable) {
                        TypeVariable var = (TypeVariable)arg;
                        Type[] bounds = var.getBounds();
                        boolean isResolved = false;
                        for (int j = 0; j < bounds.length; ++j) {
                            Class<?> cls = InjectionUtils.getRawType(bounds[j]);
                            if (cls == null || cls != Object.class && !cls.isAssignableFrom(expectedType)) continue;
                            isResolved = true;
                            break;
                        }
                        if (!isResolved) {
                            return false;
                        }
                        if (injectContext) {
                            this.injectContextValues(em, m);
                        }
                        return true;
                    }
                    Class<?> actualClass = InjectionUtils.getRawType(arg);
                    if (actualClass == null) continue;
                    if (expectedType.isArray() && !actualClass.isArray()) {
                        expectedType = expectedType.getComponentType();
                    }
                    if (!actualClass.isAssignableFrom(expectedType) && actualClass != Object.class) continue;
                    if (injectContext) {
                        this.injectContextValues(em, m);
                    }
                    return true;
                }
                continue;
            }
            if (!(t instanceof Class) || !providerClass.isAssignableFrom((Class)t)) continue;
            if (injectContext) {
                this.injectContextValues(em, m);
            }
            return true;
        }
        return false;
    }

    public <T> List<ReaderInterceptor> createMessageBodyReaderInterceptor(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m, boolean checkMbrNow, Set<String> names) {
        MessageBodyReader<T> mr = !checkMbrNow ? null : this.createMessageBodyReader(bodyType, parameterType, parameterAnnotations, mediaType, m);
        int size = this.readerInterceptors.size();
        if (mr != null || size > 0) {
            ReaderInterceptorMBR mbrReader = new ReaderInterceptorMBR(mr, m.getExchange().getInMessage());
            List<ReaderInterceptor> interceptors = null;
            if (size > 0) {
                interceptors = new ArrayList<ReaderInterceptor>(size + 1);
                List<ProviderInfo<T>> readers = ProviderFactory.getBoundFilters(this.readerInterceptors, names);
                for (ProviderInfo<T> p : readers) {
                    this.injectContextValues(p, m);
                    interceptors.add((ReaderInterceptor)p.getProvider());
                }
                interceptors.add(mbrReader);
            } else {
                interceptors = Collections.singletonList(mbrReader);
            }
            return interceptors;
        }
        return null;
    }

    public <T> List<WriterInterceptor> createMessageBodyWriterInterceptor(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m, Set<String> names) {
        MessageBodyWriter<T> mw = this.createMessageBodyWriter(bodyType, parameterType, parameterAnnotations, mediaType, m);
        int size = this.writerInterceptors.size();
        if (mw != null || size > 0) {
            WriterInterceptorMBW mbwWriter = new WriterInterceptorMBW(mw, m);
            List<WriterInterceptor> interceptors = null;
            if (size > 0) {
                interceptors = new ArrayList<WriterInterceptor>(size + 1);
                List<ProviderInfo<T>> writers = ProviderFactory.getBoundFilters(this.writerInterceptors, names);
                for (ProviderInfo<T> p : writers) {
                    this.injectContextValues(p, m);
                    interceptors.add((WriterInterceptor)p.getProvider());
                }
                interceptors.add(mbwWriter);
            } else {
                interceptors = Collections.singletonList(mbwWriter);
            }
            return interceptors;
        }
        return null;
    }

    public <T> MessageBodyReader<T> createMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        if (this.providerCache != null) {
            for (ProviderInfo<MessageBodyReader<?>> ep : this.providerCache.getReaders(type, mediaType)) {
                if (!this.isReadable(ep, type, genericType, annotations, mediaType, m)) continue;
                return ep.getProvider();
            }
        }
        boolean checkAll = this.providerCache != null && this.providerCache.isCheckAllCandidates();
        LinkedList allCandidates = checkAll ? new LinkedList() : null;
        MessageBodyReader<?> selectedReader = null;
        for (ProviderInfo<MessageBodyReader<?>> ep : this.messageReaders) {
            if (!this.matchesReaderMediaTypes(ep, mediaType) || !this.handleMapper(ep, type, m, MessageBodyReader.class, false)) continue;
            if (checkAll) {
                allCandidates.add(ep);
            } else if (this.providerCache != null && this.providerCache.getReaders(type, mediaType).isEmpty()) {
                this.providerCache.putReaders(type, mediaType, Collections.singletonList(ep));
            }
            if (selectedReader != null || !this.isReadable(ep, type, genericType, annotations, mediaType, m)) continue;
            selectedReader = ep.getProvider();
            if (checkAll) continue;
            return selectedReader;
        }
        if (checkAll) {
            this.providerCache.putReaders(type, mediaType, allCandidates);
        }
        return selectedReader;
    }

    public <T> MessageBodyWriter<T> createMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        if (this.providerCache != null) {
            for (ProviderInfo<MessageBodyWriter<?>> ep : this.providerCache.getWriters(type, mediaType)) {
                if (!this.isWriteable(ep, type, genericType, annotations, mediaType, m)) continue;
                return ep.getProvider();
            }
        }
        boolean checkAll = this.providerCache != null && this.providerCache.isCheckAllCandidates();
        LinkedList allCandidates = checkAll ? new LinkedList() : null;
        MessageBodyWriter<?> selectedWriter = null;
        for (ProviderInfo<MessageBodyWriter<?>> ep : this.messageWriters) {
            if (!this.matchesWriterMediaTypes(ep, mediaType) || !this.handleMapper(ep, type, m, MessageBodyWriter.class, false)) continue;
            if (checkAll) {
                allCandidates.add(ep);
            } else if (this.providerCache != null && this.providerCache.getWriters(type, mediaType).isEmpty()) {
                this.providerCache.putWriters(type, mediaType, Collections.singletonList(ep));
            }
            if (selectedWriter != null || !this.isWriteable(ep, type, genericType, annotations, mediaType, m)) continue;
            selectedWriter = ep.getProvider();
            if (checkAll) continue;
            return selectedWriter;
        }
        if (checkAll) {
            this.providerCache.putWriters(type, mediaType, allCandidates);
        }
        return selectedWriter;
    }

    protected void setBusProviders() {
        LinkedList<Object> extensions = new LinkedList<Object>();
        this.addBusExtension(extensions, MessageBodyReader.class, MessageBodyWriter.class, ExceptionMapper.class);
        if (!extensions.isEmpty()) {
            this.setProviders(true, true, extensions.toArray());
        }
    }

    private void addBusExtension(List<Object> extensions, Class<?> ... extClasses) {
        for (Class<?> extClass : extClasses) {
            Object ext = this.bus.getProperty(extClass.getName());
            if (!extClass.isInstance(ext)) continue;
            extensions.add(ext);
        }
        Object allProp = this.bus.getProperty(BUS_PROVIDERS_ALL);
        if (allProp instanceof List) {
            List all = (List)allProp;
            extensions.addAll(all);
        }
    }

    protected abstract void setProviders(boolean var1, boolean var2, Object ... var3);

    protected void setCommonProviders(List<ProviderInfo<? extends Object>> theProviders) {
        LinkedList readInts = new LinkedList();
        LinkedList writeInts = new LinkedList();
        for (ProviderInfo<? extends Object> provider : theProviders) {
            Class<?> providerCls = ClassHelper.getRealClass(this.bus, provider.getProvider());
            if (MessageBodyReader.class.isAssignableFrom(providerCls)) {
                this.addProviderToList(this.messageReaders, provider);
            }
            if (MessageBodyWriter.class.isAssignableFrom(providerCls)) {
                this.addProviderToList(this.messageWriters, provider);
            }
            if (ContextResolver.class.isAssignableFrom(providerCls)) {
                this.addProviderToList(this.contextResolvers, provider);
            }
            if (ContextProvider.class.isAssignableFrom(providerCls)) {
                this.addProviderToList(this.contextProviders, provider);
            }
            if (ProviderFactory.filterContractSupported(provider, providerCls, ReaderInterceptor.class)) {
                readInts.add(provider);
            }
            if (ProviderFactory.filterContractSupported(provider, providerCls, WriterInterceptor.class)) {
                writeInts.add(provider);
            }
            if (!ParamConverterProvider.class.isAssignableFrom(providerCls)) continue;
            this.paramConverters.add(provider);
        }
        this.sortReaders();
        this.sortWriters();
        this.sortContextResolvers();
        ProviderFactory.mapInterceptorFilters(this.readerInterceptors, readInts, ReaderInterceptor.class, true);
        ProviderFactory.mapInterceptorFilters(this.writerInterceptors, writeInts, WriterInterceptor.class, true);
        this.injectContextProxies(this.messageReaders, this.messageWriters, this.contextResolvers, this.paramConverters, this.readerInterceptors.values(), this.writerInterceptors.values());
        this.checkParamConverterContexts();
    }

    private void checkParamConverterContexts() {
        for (ProviderInfo<ParamConverterProvider> pi : this.paramConverters) {
            if (!pi.contextsAvailable()) continue;
            this.paramConverterContextsAvailable = true;
        }
    }

    public boolean isParamConverterContextsAvailable() {
        return this.paramConverterContextsAvailable;
    }

    protected void injectContextValues(ProviderInfo<?> pi, Message m) {
        if (m != null) {
            InjectionUtils.injectContexts(pi.getProvider(), pi, m);
        }
    }

    protected void addProviderToList(List<?> list, ProviderInfo<?> provider) {
        List<ProviderInfo> list2 = CastUtils.cast(list);
        for (ProviderInfo pi : list2) {
            if (pi.getProvider() != provider.getProvider()) continue;
            return;
        }
        list2.add(provider);
    }

    protected void injectContextProxies(Collection<?> ... providerLists) {
        for (Collection<?> list : providerLists) {
            Collection<ProviderInfo> l2 = CastUtils.cast(list);
            for (ProviderInfo pi : l2) {
                this.injectContextProxiesIntoProvider(pi);
            }
        }
    }

    protected void injectContextProxiesIntoProvider(ProviderInfo<?> pi) {
        this.injectContextProxiesIntoProvider(pi, null);
    }

    void injectContextProxiesIntoProvider(ProviderInfo<?> pi, Application app) {
        if (pi.contextsAvailable()) {
            InjectionUtils.injectContextProxiesAndApplication(pi, pi.getProvider(), app);
            this.injectedProviders.add(pi);
        }
    }

    private void sortReaders() {
        if (!this.customComparatorAvailable(MessageBodyReader.class)) {
            Collections.sort(this.messageReaders, new MessageBodyReaderComparator(this.readerMediaTypesMap));
        } else {
            this.doCustomSort(this.messageReaders);
        }
    }

    private <T> void sortWriters() {
        if (!this.customComparatorAvailable(MessageBodyWriter.class)) {
            Collections.sort(this.messageWriters, new MessageBodyWriterComparator(this.writerMediaTypesMap));
        } else {
            this.doCustomSort(this.messageWriters);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder("sortWriters - sorted list:");
            for (int i = 0; i < this.messageWriters.size(); ++i) {
                msg.append(" (" + i + ") " + this.messageWriters.get(i).getProvider());
            }
            Tr.debug((TraceComponent)tc, (String)msg.toString(), (Object[])new Object[0]);
        }
    }

    private boolean customComparatorAvailable(Class<?> providerClass) {
        Type type2;
        ParameterizedType pt;
        Type type;
        return this.providerComparator != null && ((type = ((ParameterizedType)this.providerComparator.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0]) instanceof ParameterizedType ? (pt = (ParameterizedType)type).getRawType() == ProviderInfo.class && ((type2 = pt.getActualTypeArguments()[0]) == providerClass || type2 instanceof WildcardType || type2 instanceof ParameterizedType && ((ParameterizedType)type2).getRawType() == providerClass) : type == Object.class);
    }

    private <T> void doCustomSort(List<?> listOfProviders) {
        ProviderInfoClassComparator theProviderComparator = this.providerComparator;
        Type type = ((ParameterizedType)this.providerComparator.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
        if (type == Object.class) {
            theProviderComparator = new ProviderInfoClassComparator(theProviderComparator);
        }
        List<?> theProviders = listOfProviders;
        ProviderInfoClassComparator theComparator = theProviderComparator;
        Collections.sort(theProviders, theComparator);
    }

    private void sortContextResolvers() {
        Collections.sort(this.contextResolvers, new ContextResolverComparator());
    }

    private static List<MediaType> getProviderConsumeTypes(MessageBodyReader<?> mbr, Map<MessageBodyReader<?>, List<MediaType>> cache) {
        List<MediaType> mediaTypes = cache.get(mbr);
        if (mediaTypes == null) {
            mediaTypes = JAXRSUtils.getProviderConsumeTypes(mbr);
            cache.put(mbr, mediaTypes);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getProviderConsumeTypes - cache miss - caching " + mbr + " = " + mediaTypes), (Object[])new Object[0]);
            }
        }
        return mediaTypes;
    }

    private <T> boolean matchesReaderMediaTypes(ProviderInfo<MessageBodyReader<?>> pi, MediaType mediaType) {
        MessageBodyReader<?> ep = pi.getProvider();
        List<MediaType> supportedMediaTypes = JAXRSUtils.getProviderConsumeTypes(ep);
        List<MediaType> availableMimeTypes = JAXRSUtils.intersectMimeTypes(Collections.singletonList(mediaType), supportedMediaTypes, false);
        return availableMimeTypes.size() != 0;
    }

    private boolean isReadable(ProviderInfo<MessageBodyReader<?>> pi, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        MessageBodyReader<?> ep = pi.getProvider();
        if (m.get(ACTIVE_JAXRS_PROVIDER_KEY) != ep) {
            this.injectContextValues(pi, m);
        }
        return ep.isReadable(type, genericType, annotations, mediaType);
    }

    private static List<MediaType> getProviderProduceTypes(MessageBodyWriter<?> mbw, Map<MessageBodyWriter<?>, List<MediaType>> cache) {
        List<MediaType> mediaTypes = cache.get(mbw);
        if (mediaTypes == null) {
            mediaTypes = JAXRSUtils.getProviderProduceTypes(mbw);
            cache.put(mbw, mediaTypes);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getProviderProduceTypes - cache miss - caching " + mbw + " = " + mediaTypes), (Object[])new Object[0]);
            }
        }
        return mediaTypes;
    }

    private <T> boolean matchesWriterMediaTypes(ProviderInfo<MessageBodyWriter<?>> pi, MediaType mediaType) {
        MessageBodyWriter<?> ep = pi.getProvider();
        List<MediaType> supportedMediaTypes = JAXRSUtils.getProviderProduceTypes(ep);
        List<MediaType> availableMimeTypes = JAXRSUtils.intersectMimeTypes(Collections.singletonList(mediaType), supportedMediaTypes, false);
        return availableMimeTypes.size() != 0;
    }

    private boolean isWriteable(ProviderInfo<MessageBodyWriter<?>> pi, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        MessageBodyWriter<?> ep = pi.getProvider();
        if (m.get(ACTIVE_JAXRS_PROVIDER_KEY) != ep) {
            this.injectContextValues(pi, m);
        }
        return ep.isWriteable(type, genericType, annotations, mediaType);
    }

    List<ProviderInfo<MessageBodyReader<?>>> getMessageReaders() {
        return Collections.unmodifiableList(this.messageReaders);
    }

    List<ProviderInfo<MessageBodyWriter<?>>> getMessageWriters() {
        return Collections.unmodifiableList(this.messageWriters);
    }

    List<ProviderInfo<ContextResolver<?>>> getContextResolvers() {
        return Collections.unmodifiableList(this.contextResolvers);
    }

    public void registerUserProvider(Object provider) {
        this.setUserProviders(Collections.singletonList(provider));
    }

    public void setUserProviders(List<?> userProviders) {
        this.setProviders(true, false, userProviders.toArray());
    }

    static int compareCustomStatus(ProviderInfo<?> p1, ProviderInfo<?> p2) {
        Boolean custom2;
        Boolean custom1 = p1.isCustom();
        int result = custom1.compareTo(custom2 = Boolean.valueOf(p2.isCustom())) * -1;
        if (result == 0 && custom1.booleanValue()) {
            Boolean busGlobal1 = p1.isBusGlobal();
            Boolean busGlobal2 = p2.isBusGlobal();
            result = busGlobal1.compareTo(busGlobal2);
        }
        return result;
    }

    public void clearThreadLocalProxies() {
        this.clearProxies(this.injectedProviders);
    }

    void clearProxies(Collection<?> ... lists) {
        for (Collection<?> list : lists) {
            Collection<ProviderInfo> l2 = CastUtils.cast(list);
            for (ProviderInfo pi : l2) {
                pi.clearThreadLocalProxies();
            }
        }
    }

    public void clearProviders() {
        this.messageReaders.clear();
        this.messageWriters.clear();
        this.contextResolvers.clear();
        this.contextProviders.clear();
        this.readerInterceptors.clear();
        this.writerInterceptors.clear();
        this.paramConverters.clear();
    }

    public void setBus(Bus bus) {
        if (bus == null) {
            return;
        }
        for (ProviderInfo<MessageBodyReader<?>> r : this.messageReaders) {
            this.injectProviderProperty(r.getProvider(), "setBus", Bus.class, bus);
        }
    }

    @FFDCIgnore(value={Exception.class})
    private boolean injectProviderProperty(Object provider, String mName, Class<?> pClass, Object pValue) {
        try {
            Method m = provider.getClass().getMethod(mName, pClass);
            m.invoke(provider, pValue);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setSchemaLocations(List<String> schemas) {
        for (ProviderInfo<MessageBodyReader<?>> r : this.messageReaders) {
            this.injectProviderProperty(r.getProvider(), "setSchemaLocations", List.class, schemas);
        }
    }

    protected static <T> List<ProviderInfo<T>> getBoundFilters(Map<NameKey, ProviderInfo<T>> boundFilters, Set<String> names) {
        if (boundFilters.isEmpty()) {
            return Collections.emptyList();
        }
        names = names == null ? Collections.emptySet() : names;
        MetadataMap map = new MetadataMap();
        for (Map.Entry<NameKey, ProviderInfo<T>> entry : boundFilters.entrySet()) {
            FilterProviderInfo fpi;
            String entryName = entry.getKey().getName();
            ProviderInfo<T> provider = entry.getValue();
            if (entryName.equals(DEFAULT_FILTER_NAME_BINDING)) {
                map.put(provider, Collections.emptyList());
                continue;
            }
            if (provider instanceof FilterProviderInfo && (fpi = (FilterProviderInfo)provider).isDynamic() && !names.containsAll(fpi.getNameBinding())) continue;
            map.add(provider, entryName);
        }
        LinkedList<ProviderInfo<T>> list = new LinkedList<ProviderInfo<T>>();
        for (Map.Entry entry : map.entrySet()) {
            List values = (List)entry.getValue();
            if (!names.containsAll(values)) continue;
            ProviderInfo provider = (ProviderInfo)entry.getKey();
            list.add(provider);
        }
        return list;
    }

    public void initProviders(List<ClassResourceInfo> cris) {
        Set<Object> set = this.getReadersWriters();
        for (Object o : set) {
            Object provider = ((ProviderInfo)o).getProvider();
            if (!(provider instanceof AbstractConfigurableProvider)) continue;
            ((AbstractConfigurableProvider)provider).init(cris);
        }
    }

    Set<Object> getReadersWriters() {
        HashSet<Object> set = new HashSet<Object>();
        set.addAll(this.messageReaders);
        set.addAll(this.messageWriters);
        return set;
    }

    public static ProviderFactory getInstance(Message m) {
        Endpoint e = m.getExchange().getEndpoint();
        Message outM = m.getExchange().getOutMessage();
        boolean isClient = outM != null && MessageUtils.isRequestor(outM);
        String name = isClient ? CLIENT_FACTORY_NAME : SERVER_FACTORY_NAME;
        return (ProviderFactory)e.get(name);
    }

    protected static int compareClasses(Object o1, Object o2) {
        return ProviderFactory.compareClasses(null, o1, o2);
    }

    protected static int compareClasses(Class<?> expectedCls, Object o1, Object o2) {
        Class<?> realClass2;
        Class<?> cl1 = ClassHelper.getRealClass(o1);
        Class<?> cl2 = ClassHelper.getRealClass(o2);
        Type[] types1 = ProviderFactory.getGenericInterfaces(cl1, expectedCls);
        Type[] types2 = ProviderFactory.getGenericInterfaces(cl2, expectedCls);
        if (types1.length == 0 && types2.length == 0) {
            return 0;
        }
        if (types1.length == 0 && types2.length > 0) {
            return 1;
        }
        if (types1.length > 0 && types2.length == 0) {
            return -1;
        }
        Class<?> realClass1 = InjectionUtils.getActualType(types1[0]);
        if (realClass1 == (realClass2 = InjectionUtils.getActualType(types2[0]))) {
            return 0;
        }
        if (realClass1.isAssignableFrom(realClass2)) {
            return 1;
        }
        return -1;
    }

    private static Type[] getGenericInterfaces(Class<?> cls, Class<?> expectedClass) {
        Type[] types;
        Type genericSuperType;
        if (Object.class == cls) {
            return emptyType;
        }
        ClassPair classPair = new ClassPair(cls, expectedClass);
        Type[] cachedTypes = genericInterfacesCache.get(classPair);
        if (cachedTypes != null) {
            return cachedTypes;
        }
        if (expectedClass != null && (genericSuperType = cls.getGenericSuperclass()) instanceof ParameterizedType) {
            Class<?> actualType = InjectionUtils.getActualType(genericSuperType);
            if (actualType != null && actualType.isAssignableFrom(expectedClass)) {
                Type[] tempTypes = new Type[]{genericSuperType};
                genericInterfacesCache.put(classPair, tempTypes);
                return tempTypes;
            }
            if (expectedClass.isAssignableFrom(actualType)) {
                genericInterfacesCache.put(classPair, emptyType);
                return emptyType;
            }
        }
        if ((types = cls.getGenericInterfaces()).length > 0) {
            genericInterfacesCache.put(classPair, types);
            return types;
        }
        Type[] superGenericTypes = ProviderFactory.getGenericInterfaces(cls.getSuperclass(), expectedClass);
        genericInterfacesCache.put(classPair, superGenericTypes);
        return superGenericTypes;
    }

    public static ProviderInfo<? extends Object> createProviderFromConstructor(Constructor<?> c, Map<Class<?>, Object> values, Bus theBus, boolean checkContexts, boolean custom) {
        Map proxiesMap = CastUtils.cast((Map)theBus.getProperty("jaxrs-constructor-proxy-map"));
        Map existingProxies = null;
        if (proxiesMap != null) {
            existingProxies = (Map)proxiesMap.get(c.getDeclaringClass());
        }
        Class<?>[] paramTypes = c.getParameterTypes();
        Object[] cArgs = ResourceUtils.createConstructorArguments(c, null, false, values);
        if (existingProxies != null && existingProxies.size() <= paramTypes.length) {
            for (int i = 0; i < paramTypes.length; ++i) {
                if (!(cArgs[i] instanceof ThreadLocalProxy)) continue;
                cArgs[i] = existingProxies.get(paramTypes[i]);
            }
        }
        Object instance = null;
        try {
            instance = c.newInstance(cArgs);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.jaxrs.provider.ProviderFactory", (String)"1451", null, (Object[])new Object[]{c, values, theBus, checkContexts, custom});
            throw new RuntimeException("Resource or provider class " + c.getDeclaringClass().getName() + " can not be instantiated");
        }
        LinkedHashMap proxies = new LinkedHashMap();
        for (int i = 0; i < paramTypes.length; ++i) {
            if (!(cArgs[i] instanceof ThreadLocalProxy)) continue;
            ThreadLocalProxy proxy = (ThreadLocalProxy)cArgs[i];
            proxies.put(paramTypes[i], proxy);
        }
        boolean isApplication = Application.class.isAssignableFrom(c.getDeclaringClass());
        if (isApplication) {
            return new ApplicationInfo((Application)instance, proxies, theBus);
        }
        return new ProviderInfo<Object>(instance, proxies, theBus, checkContexts, custom);
    }

    protected static <T> void mapInterceptorFilters(Map<NameKey, ProviderInfo<T>> map, List<ProviderInfo<T>> filters, Class<?> providerCls, boolean ascending) {
        for (ProviderInfo<T> p : filters) {
            Set<String> names = ProviderFactory.getFilterNameBindings(p);
            int priority = ProviderFactory.getFilterPriority(p, providerCls);
            for (String name : names) {
                map.put(new NameKey(name, priority, p.getClass()), p);
            }
        }
    }

    protected static Set<String> getFilterNameBindings(ProviderInfo<?> p) {
        Set<String> names = null;
        if (p instanceof FilterProviderInfo) {
            names = ((FilterProviderInfo)p).getNameBinding();
        }
        if (names == null) {
            Class<?> pClass = ClassHelper.getRealClass(p.getBus(), p.getProvider());
            names = AnnotationUtils.getNameBindings(pClass.getAnnotations());
        }
        if (names.isEmpty()) {
            names = Collections.singleton(DEFAULT_FILTER_NAME_BINDING);
        }
        return names;
    }

    protected static int getFilterPriority(ProviderInfo<?> p, Class<?> providerCls) {
        return p instanceof FilterProviderInfo ? ((FilterProviderInfo)p).getPriority(providerCls) : AnnotationUtils.getBindingPriority(p.getProvider().getClass());
    }

    protected static boolean filterContractSupported(ProviderInfo<?> provider, Class<?> providerCls, Class<?> contract) {
        boolean result = false;
        if (contract.isAssignableFrom(providerCls)) {
            Set<Class<?>> actualContracts = null;
            if (provider instanceof FilterProviderInfo) {
                actualContracts = ((FilterProviderInfo)provider).getSupportedContracts();
            }
            result = actualContracts != null ? actualContracts.contains(contract) : true;
        }
        return result;
    }

    protected List<ProviderInfo<? extends Object>> prepareProviders(boolean custom, boolean busGlobal, Object[] providers, ProviderInfo<Application> application) {
        ArrayList<ProviderInfo<? extends Object>> theProviders = new ArrayList<ProviderInfo<? extends Object>>(providers.length);
        Map beanCustomizerContexts = (Map)this.getBus().getProperty("ENDPOINT_BEANCUSTOMIZER_CONTEXTOBJ");
        for (Object o : providers) {
            Object newProviderInstance;
            Object proxyObject;
            if (o == null) continue;
            ProviderInfo<Object> pi = null;
            if (o instanceof Constructor) {
                Map<Class<?>, Object> values = CastUtils.cast(application == null ? null : Collections.singletonMap(Application.class, application.getProvider()));
                pi = ProviderFactory.createProviderFromConstructor((Constructor)o, values, this.getBus(), true, custom);
            } else if (o instanceof ProviderInfo) {
                pi = (ProviderInfo<Object>)o;
            } else {
                pi = new ProviderInfo<Object>(o, this.getBus(), custom);
                pi.setBusGlobal(busGlobal);
            }
            JaxRsFactoryBeanCustomizer beanCustomizer = InjectionRuntimeContextHelper.findBeanCustomizer(o.getClass(), this.getBus());
            if (!(beanCustomizer == null || (proxyObject = beanCustomizer.onSetupProviderProxy(o, beanCustomizerContexts.get(CustomizerUtils.createCustomizerKey(beanCustomizer)))) == null || proxyObject == o && proxyObject.equals(o))) {
                pi.setProvider(proxyObject);
            }
            if (beanCustomizer != null && DynamicFeature.class.isAssignableFrom(pi.getProvider().getClass()) && (newProviderInstance = beanCustomizer.onSingletonProviderInit(pi.getProvider(), beanCustomizerContexts.get(Integer.toString(beanCustomizer.hashCode())), null)) != null) {
                pi.setProvider(newProviderInstance);
            }
            theProviders.add(pi);
        }
        return theProviders;
    }

    public MessageBodyWriter<?> getDefaultJaxbWriter() {
        for (ProviderInfo<MessageBodyWriter<?>> pi : this.messageWriters) {
            Class<?> cls = pi.getProvider().getClass();
            if (!cls.getName().equals(JAXB_PROVIDER_NAME)) continue;
            return pi.getProvider();
        }
        return null;
    }

    public Comparator<?> getProviderComparator() {
        return this.providerComparator;
    }

    public void setProviderComparator(Comparator<?> providerComparator) {
        this.providerComparator = providerComparator;
        this.sortReaders();
        this.sortWriters();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static class NameKeyMap<T>
    extends TreeMap<NameKey, T> {
        private static final long serialVersionUID = -4352258671270502204L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public NameKeyMap(boolean ascending) {
            super(new NameKeyComparator(ascending));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(NameKeyMap.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static class NameKeyComparator
    extends AbstractPriorityComparator
    implements Comparator<NameKey> {
        static final long serialVersionUID = -156933271485292699L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public NameKeyComparator(boolean ascending) {
            super(ascending);
        }

        @Override
        public int compare(NameKey key1, NameKey key2) {
            int result = this.compare(key1.getPriority(), key2.getPriority());
            if (result != 0) {
                return result;
            }
            return this.compare(key1.hashCode(), key2.hashCode());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(NameKeyComparator.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static class NameKey {
        private final String name;
        private final Integer priority;
        private final Class<?> providerCls;
        static final long serialVersionUID = -7444072820502076106L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public NameKey(String name, int priority, Class<?> providerCls) {
            this.name = name;
            this.priority = priority;
            this.providerCls = providerCls;
        }

        public String getName() {
            return this.name;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public boolean equals(Object o) {
            if (!(o instanceof NameKey)) {
                return false;
            }
            NameKey other = (NameKey)o;
            return this.name.equals(other.name) && this.priority.equals(other.priority) && this.providerCls == other.providerCls;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return this.name + ":" + this.priority;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(NameKey.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class ContextResolverProxy<T>
    implements ContextResolver<T> {
        private final List<ContextResolver<T>> candidates;
        static final long serialVersionUID = 6902837084157307485L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ContextResolverProxy(List<ContextResolver<T>> candidates) {
            this.candidates = candidates;
        }

        public T getContext(Class<?> cls) {
            for (ContextResolver<T> resolver : this.candidates) {
                Object context = resolver.getContext(cls);
                if (context == null) continue;
                return (T)context;
            }
            return null;
        }

        public List<ContextResolver<T>> getResolvers() {
            return this.candidates;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ContextResolverProxy.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static class BindingPriorityComparator
    extends AbstractPriorityComparator
    implements Comparator<ProviderInfo<?>> {
        private final Class<?> providerCls;
        static final long serialVersionUID = 4133762782533825089L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public BindingPriorityComparator(Class<?> providerCls, boolean ascending) {
            super(ascending);
            this.providerCls = providerCls;
        }

        @Override
        public int compare(ProviderInfo<?> p1, ProviderInfo<?> p2) {
            return this.compare(ProviderFactory.getFilterPriority(p1, this.providerCls), ProviderFactory.getFilterPriority(p2, this.providerCls));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BindingPriorityComparator.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static class AbstractPriorityComparator {
        private final boolean ascending;
        static final long serialVersionUID = 2930255358206049304L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected AbstractPriorityComparator(boolean ascending) {
            this.ascending = ascending;
        }

        protected int compare(Integer b1Value, Integer b2Value) {
            int result = b1Value.compareTo(b2Value);
            return this.ascending ? result : result * -1;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AbstractPriorityComparator.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class ProviderInfoClassComparator
    implements Comparator<ProviderInfo<?>> {
        final Comparator<Object> comp;
        boolean defaultComp;
        static final long serialVersionUID = 4138240072485416117L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ProviderInfoClassComparator(Class<?> expectedCls) {
            this.comp = new ClassComparator(expectedCls);
            this.defaultComp = true;
        }

        public ProviderInfoClassComparator(Comparator<Object> comp) {
            this.comp = comp;
        }

        @Override
        public int compare(ProviderInfo<?> p1, ProviderInfo<?> p2) {
            int result = this.comp.compare(p1.getProvider(), p2.getProvider());
            if (result == 0 && this.defaultComp) {
                result = ProviderFactory.compareCustomStatus(p1, p2);
            }
            return result;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ProviderInfoClassComparator.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class ClassComparator
    implements Comparator<Object> {
        private Class<?> expectedCls;
        static final long serialVersionUID = -9159606144959439425L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ClassComparator() {
        }

        public ClassComparator(Class<?> expectedCls) {
            this.expectedCls = expectedCls;
        }

        @Override
        public int compare(Object em1, Object em2) {
            return ProviderFactory.compareClasses(this.expectedCls, em1, em2);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ClassComparator.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class ContextResolverComparator
    implements Comparator<ProviderInfo<ContextResolver<?>>> {
        static final long serialVersionUID = 5038808953357812851L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ContextResolverComparator() {
        }

        @Override
        public int compare(ProviderInfo<ContextResolver<?>> p1, ProviderInfo<ContextResolver<?>> p2) {
            ContextResolver<?> e1 = p1.getOldProvider();
            ContextResolver<?> e2 = p2.getOldProvider();
            List<MediaType> types1 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProduceTypes(e1.getClass().getAnnotation(Produces.class)), "qs");
            List<MediaType> types2 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProduceTypes(e2.getClass().getAnnotation(Produces.class)), "qs");
            return JAXRSUtils.compareSortedMediaTypes(types1, types2, "qs");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ContextResolverComparator.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class MessageBodyWriterComparator
    implements Comparator<ProviderInfo<MessageBodyWriter<?>>> {
        private final Map<MessageBodyWriter<?>, List<MediaType>> cache;
        static final long serialVersionUID = 6185920671295486424L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private MessageBodyWriterComparator(Map<MessageBodyWriter<?>, List<MediaType>> cache) {
            this.cache = cache;
        }

        @Override
        public int compare(ProviderInfo<MessageBodyWriter<?>> p1, ProviderInfo<MessageBodyWriter<?>> p2) {
            List<MediaType> types2;
            MessageBodyWriter<?> e2;
            MessageBodyWriter<?> e1 = p1.getOldProvider();
            int result = ProviderFactory.compareClasses(e1, e2 = p2.getOldProvider());
            if (result != 0) {
                return result;
            }
            List<MediaType> types1 = JAXRSUtils.sortMediaTypes(ProviderFactory.getProviderProduceTypes(e1, this.cache), "qs");
            result = JAXRSUtils.compareSortedMediaTypes(types1, types2 = JAXRSUtils.sortMediaTypes(ProviderFactory.getProviderProduceTypes(e2, this.cache), "qs"), "qs");
            if (result != 0) {
                return result;
            }
            return ProviderFactory.compareCustomStatus(p1, p2);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(MessageBodyWriterComparator.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class MessageBodyReaderComparator
    implements Comparator<ProviderInfo<MessageBodyReader<?>>> {
        private final Map<MessageBodyReader<?>, List<MediaType>> cache;
        static final long serialVersionUID = 6873204671968171337L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private MessageBodyReaderComparator(Map<MessageBodyReader<?>, List<MediaType>> cache) {
            this.cache = cache;
        }

        @Override
        public int compare(ProviderInfo<MessageBodyReader<?>> p1, ProviderInfo<MessageBodyReader<?>> p2) {
            MessageBodyReader<?> e1 = p1.getOldProvider();
            MessageBodyReader<?> e2 = p2.getOldProvider();
            List<MediaType> types1 = ProviderFactory.getProviderConsumeTypes(e1, this.cache);
            types1 = JAXRSUtils.sortMediaTypes(types1, null);
            List<MediaType> types2 = ProviderFactory.getProviderConsumeTypes(e2, this.cache);
            int result = JAXRSUtils.compareSortedMediaTypes(types1, types2 = JAXRSUtils.sortMediaTypes(types2, null), null);
            if (result != 0) {
                return result;
            }
            result = ProviderFactory.compareClasses(e1, e2);
            if (result != 0) {
                return result;
            }
            return ProviderFactory.compareCustomStatus(p1, p2);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(MessageBodyReaderComparator.class);
        }
    }
}

