/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter;

import com.ibm.websphere.ce.cm.ConnectionWaitTimeoutException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.impl.DatabaseHelper;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcTracer;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.wsspi.library.Library;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLRecoverableException;
import java.sql.SQLTransientConnectionException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.SecurityException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;

public class AdapterUtil {
    public static final String NLS_FILE = "com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS";
    public static final String TRACE_GROUP = "RRA";
    private static final TraceComponent tc = Tr.register(AdapterUtil.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    public static final int TRANSACTION_SNAPSHOT = 16;
    public static final int TRANSACTION_SS_SNAPSHOT = 4096;
    public static final int CONCUR_SS_SCROLL_LOCKS = 1009;
    public static final int CONCUR_SS_OPTIMISTIC_CCVAL = 1010;
    public static final int TYPE_SS_SCROLL_DYNAMIC = 1006;
    public static final int TYPE_SS_DIRECT_FORWARD_ONLY = 2003;
    public static final int TYPE_SS_SERVER_CURSOR_FORWARD_ONLY = 2004;
    public static final String EOLN;
    private static final String INDENT = "                                 ";
    private static final String os;

    public static XAException createXAException(String key, Object args, int xaErrorCode) {
        XAException xaX = new XAException(args == null ? AdapterUtil.getNLSMessage(key) : AdapterUtil.getNLSMessage(key, args));
        xaX.errorCode = xaErrorCode;
        return xaX;
    }

    public static Throwable getChainedException(Throwable th) {
        Method[] methods = th.getClass().getMethods();
        Throwable chainedX = null;
        for (int i = 0; i < methods.length && chainedX == null; ++i) {
            if (!Throwable.class.isAssignableFrom(methods[i].getReturnType()) || methods[i].getName().equals("getSQLException") || !methods[i].getName().startsWith("get") || methods[i].getParameterTypes().length != 0 || !methods[i].getName().endsWith("Cause") && !methods[i].getName().endsWith("Exception") && !methods[i].getName().endsWith("Error") && !methods[i].getName().endsWith("Warning")) continue;
            try {
                chainedX = (Throwable)methods[i].invoke((Object)th, (Object[])null);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return chainedX;
    }

    public static String getConcurrencyModeString(int concurrency) {
        switch (concurrency) {
            case 1007: {
                return "CONCUR READ ONLY (" + concurrency + ')';
            }
            case 1008: {
                return "CONCUR UPDATABLE (" + concurrency + ')';
            }
            case 1009: {
                return "CONCUR SS SCROLL LOCKS (" + concurrency + ')';
            }
            case 1010: {
                return "CONCUR SS OPTIMISTIC CCVAL (" + concurrency + ')';
            }
        }
        return "UNKNOWN RESULT SET CONCURRENCY (" + concurrency + ')';
    }

    public static String getConnectionEventString(int eventID) {
        switch (eventID) {
            case 1: {
                return "CONNECTION CLOSED (" + eventID + ')';
            }
            case 2: {
                return "LOCAL TRANSACTION STARTED (" + eventID + ')';
            }
            case 3: {
                return "LOCAL TRANSACTION COMMITTED (" + eventID + ')';
            }
            case 4: {
                return "LOCAL TRANSACTION ROLLEDBACK (" + eventID + ')';
            }
            case 5: {
                return "CONNECTION ERROR OCCURRED (" + eventID + ')';
            }
            case 52: {
                return "CONNECTION ERROR OCCURRED NO EVENT (" + eventID + ')';
            }
            case 51: {
                return "SINGLE CONNECTION ERROR OCCURRED (" + eventID + ')';
            }
        }
        return "UNKNOWN CONNECTION EVENT CONSTANT (" + eventID + ')';
    }

    public static String getFetchDirectionString(int direction) {
        switch (direction) {
            case 1000: {
                return "FETCH FORWARD (" + direction + ')';
            }
            case 1001: {
                return "FETCH REVERSE (" + direction + ')';
            }
            case 1002: {
                return "FETCH UNKNOWN (" + direction + ')';
            }
        }
        return "UNRECOGNIZED FETCH DIRECTION CONSTANT (" + direction + ')';
    }

    public static String getIsolationLevelString(int level) {
        switch (level) {
            case 0: {
                return "NONE (" + level + ')';
            }
            case 1: {
                return "READ UNCOMMITTED (" + level + ')';
            }
            case 2: {
                return "READ COMMITTED (" + level + ')';
            }
            case 4: {
                return "REPEATABLE READ (" + level + ')';
            }
            case 8: {
                return "SERIALIZABLE (" + level + ')';
            }
            case 16: 
            case 4096: {
                return "SNAPSHOT (" + level + ')';
            }
        }
        return "UNKNOWN ISOLATION LEVEL CONSTANT (" + level + ')';
    }

    public static final String getNLSMessage(String key) {
        return Tr.formatMessage((TraceComponent)tc, (String)key, (Object[])new Object[0]);
    }

    public static final String getNLSMessage(String key, Object ... args) {
        return Tr.formatMessage((TraceComponent)tc, (String)key, (Object[])args);
    }

    public static String getResultSetTypeString(int type) {
        switch (type) {
            case 1003: {
                return "TYPE FORWARD ONLY (" + type + ')';
            }
            case 1004: {
                return "TYPE SCROLL INSENSITIVE (" + type + ')';
            }
            case 1005: {
                return "TYPE SCROLL SENSITIVE (" + type + ')';
            }
            case 1006: {
                return "TYPE SS SCROLL DYNAMIC (" + type + ')';
            }
            case 2003: {
                return "TYPE SS DIRECT FORWARD ONLY (" + type + ')';
            }
            case 2004: {
                return "TYPE SS SERVER CURSOR FORWARD ONLY (" + type + ')';
            }
        }
        return "UNKNOWN RESULT SET TYPE CONSTANT (" + type + ')';
    }

    public static String getSQLTypeString(int sqlType) {
        switch (sqlType) {
            case 2003: {
                return "ARRAY (" + sqlType + ')';
            }
            case -5: {
                return "BIGINT (" + sqlType + ')';
            }
            case -2: {
                return "BINARY (" + sqlType + ')';
            }
            case -7: {
                return "BIT (" + sqlType + ')';
            }
            case 2004: {
                return "BLOB (" + sqlType + ')';
            }
            case 16: {
                return "BOOLEAN (" + sqlType + ')';
            }
            case 1: {
                return "CHAR (" + sqlType + ')';
            }
            case 2005: {
                return "CLOB (" + sqlType + ')';
            }
            case 70: {
                return "DATALINK (" + sqlType + ')';
            }
            case 91: {
                return "DATE (" + sqlType + ')';
            }
            case 3: {
                return "DECIMAL (" + sqlType + ')';
            }
            case 2001: {
                return "DISTINCT (" + sqlType + ')';
            }
            case 8: {
                return "DOUBLE (" + sqlType + ')';
            }
            case 6: {
                return "FLOAT (" + sqlType + ')';
            }
            case 4: {
                return "INTEGER (" + sqlType + ')';
            }
            case 2000: {
                return "JAVA OBJECT (" + sqlType + ')';
            }
            case -16: {
                return "LONGNVARCHAR (" + sqlType + ')';
            }
            case -4: {
                return "LONGVARBINARY (" + sqlType + ')';
            }
            case -1: {
                return "LONGVARCHAR (" + sqlType + ')';
            }
            case -15: {
                return "NCHAR (" + sqlType + ')';
            }
            case 2011: {
                return "NCLOB (" + sqlType + ')';
            }
            case 0: {
                return "NULL (" + sqlType + ')';
            }
            case 2: {
                return "NUMERIC (" + sqlType + ')';
            }
            case -9: {
                return "NVARCHAR (" + sqlType + ')';
            }
            case 1111: {
                return "OTHER (" + sqlType + ')';
            }
            case 7: {
                return "REAL (" + sqlType + ')';
            }
            case 2006: {
                return "REF (" + sqlType + ')';
            }
            case -8: {
                return "ROWID (" + sqlType + ')';
            }
            case 5: {
                return "SMALLINT (" + sqlType + ')';
            }
            case 2009: {
                return "SQLXML (" + sqlType + ')';
            }
            case 2002: {
                return "STRUCT (" + sqlType + ')';
            }
            case 92: {
                return "TIME (" + sqlType + ')';
            }
            case 93: {
                return "TIMESTAMP (" + sqlType + ')';
            }
            case -6: {
                return "TINYINT (" + sqlType + ')';
            }
            case -3: {
                return "VARBINARY (" + sqlType + ')';
            }
            case 12: {
                return "VARCHAR (" + sqlType + ')';
            }
        }
        return "UNKNOWN SQL TYPE (" + sqlType + ')';
    }

    public static String getXAExceptionCodeString(int code) {
        switch (code) {
            case 107: {
                return "XA_RBTRANSIENT (" + code + ')';
            }
            case 100: {
                return "XA_RBROLLBACK (" + code + ')';
            }
            case 7: {
                return "XA_HEURCOM (" + code + ')';
            }
            case 8: {
                return "XA_HEURHAZ (" + code + ')';
            }
            case 5: {
                return "XA_HEURMIX (" + code + ')';
            }
            case 6: {
                return "XA_HEURRB (" + code + ')';
            }
            case 9: {
                return "XA_NOMIGRATE (" + code + ')';
            }
            case 101: {
                return "XA_RBCOMMFAIL (" + code + ')';
            }
            case 102: {
                return "XA_RBDEADLOCK (" + code + ')';
            }
            case 103: {
                return "XA_RBINTEGRITY (" + code + ')';
            }
            case 104: {
                return "XA_RBOTHER (" + code + ')';
            }
            case 105: {
                return "XA_RBPROTO (" + code + ')';
            }
            case 106: {
                return "XA_RBTIMEOUT (" + code + ')';
            }
            case 3: {
                return "XA_RDONLY (" + code + ')';
            }
            case 4: {
                return "XA_RETRY (" + code + ')';
            }
            case -2: {
                return "XAER_ASYNC (" + code + ')';
            }
            case -8: {
                return "XAER_DUPID (" + code + ')';
            }
            case -5: {
                return "XAER_INVAL (" + code + ')';
            }
            case -4: {
                return "XAER_NOTA (" + code + ')';
            }
            case -9: {
                return "XAER_OUTSIDE (" + code + ')';
            }
            case -6: {
                return "XAER_PROTO (" + code + ')';
            }
            case -3: {
                return "XAER_RMERR (" + code + ')';
            }
            case -7: {
                return "XAER_RMFAIL (" + code + ')';
            }
        }
        return "UNKNOWN XA EXCEPTION CODE (" + code + ')';
    }

    public static String getXAResourceEndFlagString(int flag) {
        switch (flag) {
            case 0x20000000: {
                return "TMFAIL (" + flag + ')';
            }
            case 0x4000000: {
                return "TMSUCCESS (" + flag + ')';
            }
            case 0x2000000: {
                return "TMSUSPEND (" + flag + ')';
            }
        }
        return "UNKNOWN XA RESOURCE END FLAG (" + flag + ')';
    }

    public static String getXAResourceRecoverFlagString(int flag) {
        switch (flag) {
            case 0x800000: {
                return "TMENDRSCAN (" + flag + ')';
            }
            case 0: {
                return "TMNOFLAGS (" + flag + ')';
            }
            case 0x1000000: {
                return "TMSTARTRSCAN (" + flag + ')';
            }
            case 0x1800000: {
                return "TMSTARTRSCAN + TMENDRSCAN (" + flag + ')';
            }
        }
        return "UNKNOWN XA RESOURCE RECOVER FLAG (" + flag + ')';
    }

    public static String getXAResourceStartFlagString(int flag) {
        switch (flag) {
            case 0x200000: {
                return "TMJOIN (" + flag + ')';
            }
            case 0: {
                return "TMNOFLAGS (" + flag + ')';
            }
            case 0x8000000: {
                return "TMRESUME (" + flag + ')';
            }
        }
        return "UNKNOWN XA RESOURCE START FLAG (" + flag + ')';
    }

    public static String getXAResourceVoteString(int vote) {
        switch (vote) {
            case 0: {
                return "XA_OK (" + vote + ')';
            }
            case 3: {
                return "XA_RDONLY (" + vote + ')';
            }
        }
        return "UNKNOWN XA RESOURCE VOTE (" + vote + ')';
    }

    public static final boolean isZOS() {
        return os != null && (os.equalsIgnoreCase("OS/390") || os.equalsIgnoreCase("z/OS"));
    }

    public static final boolean match(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj1.equals(obj2);
    }

    public static final SQLException notSupportedX(String operation, Throwable cause) {
        SQLFeatureNotSupportedException sqlX = new SQLFeatureNotSupportedException(AdapterUtil.getNLSMessage("FEATURE_NOT_IMPLEMENTED", operation));
        if (cause != null) {
            sqlX.initCause(cause);
        }
        return sqlX;
    }

    public static String stackTraceToString(Throwable th) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (int depth = 0; depth < 10 && th != null; ++depth) {
            th.printStackTrace(pw);
            Throwable cause = th.getCause();
            if (cause != null && cause != th) {
                pw.append("-------- chained exception -------").append(EOLN);
            }
            th = cause;
        }
        return sw.toString();
    }

    public static final SQLException staleX() {
        String message = AdapterUtil.getNLSMessage("INVALID_CONNECTION");
        return new SQLRecoverableException(message);
    }

    public static ResourceException translateSQLException(SQLException se, Object mapper, boolean sendEvent, Class<?> caller) {
        return (ResourceException)AdapterUtil.mapException((Exception)((Object)new DataStoreAdapterException("DSA_ERROR", se, caller, se.getMessage())), null, mapper, sendEvent);
    }

    public static Properties toProperties(String properString) throws IOException {
        Properties p = new Properties();
        p.load(new ByteArrayInputStream(properString.replaceAll(";", EOLN).getBytes()));
        return p;
    }

    public static SQLException toSQLException(ResourceException resX) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"toSQLException", (Object[])new Object[]{resX});
        }
        SQLException sqlX = null;
        Object linkedX = resX;
        while (linkedX != null) {
            if (linkedX instanceof SQLException) {
                sqlX = (SQLException)linkedX;
                break;
            }
            if (linkedX instanceof ResourceAllocationException && linkedX.getClass().getName().equals("com.ibm.websphere.ce.j2c.ConnectionWaitTimeoutException")) {
                sqlX = new ConnectionWaitTimeoutException(((Throwable)linkedX).getMessage());
                sqlX.initCause((Throwable)resX);
                sqlX = new SQLTransientConnectionException(((Throwable)linkedX).getMessage(), "08001", 0, sqlX);
                break;
            }
            linkedX = AdapterUtil.getChainedException((Throwable)linkedX);
        }
        if (sqlX == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Converting ResourceException to a SQLException", (Object[])new Object[0]);
            }
            sqlX = new SQLException(resX.getMessage());
            sqlX.initCause((Throwable)resX);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"toSQLException", (Object)AdapterUtil.getStackTraceWithState(sqlX));
        }
        return sqlX;
    }

    public static SQLException toSQLException(Throwable ex) {
        if (ex == null) {
            return null;
        }
        if (ex instanceof SQLException) {
            return (SQLException)ex;
        }
        if (ex instanceof ResourceException) {
            return AdapterUtil.toSQLException((ResourceException)ex);
        }
        SQLException sqlX = new SQLException(ex.getClass().getName() + ": " + ex.getMessage());
        sqlX.initCause(ex);
        return sqlX;
    }

    public static String toString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        if (bytes != null) {
            for (int i = 0; i < bytes.length; ++i) {
                int b = bytes[i] < 0 ? 256 + bytes[i] : bytes[i];
                sb.append(Integer.toHexString(b / 16)).append(Integer.toHexString(b % 16)).append(' ');
            }
        }
        return new String(sb);
    }

    public static String toString(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(123);
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(entry.getKey()).append('=');
            Object value = entry.getValue();
            if (value instanceof Object[]) {
                sb.append(Arrays.toString((Object[])value));
                continue;
            }
            if (value != null && value.getClass().isArray()) {
                int length = Array.getLength(value);
                sb.append('[');
                boolean f = true;
                for (int i = 0; i < length; ++i) {
                    if (f) {
                        f = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(Array.get(value, i));
                }
                sb.append(']');
                continue;
            }
            sb.append(value);
        }
        sb.append('}');
        return sb.toString();
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (Proxy.isProxyClass(obj.getClass()) && Proxy.getInvocationHandler(obj) instanceof WSJdbcTracer) {
            return obj.toString();
        }
        return new StringBuffer(obj.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(obj))).toString();
    }

    public static String toString(Xid xid) {
        StringBuilder sb = new StringBuilder();
        if (xid != null) {
            sb.append(AdapterUtil.toString((Object)xid)).append(EOLN).append(INDENT).append(xid).append(EOLN).append(INDENT).append("Global Transaction ID: ").append(AdapterUtil.toString(xid.getGlobalTransactionId())).append(EOLN).append(INDENT).append("Branch Qualifier:      ").append(AdapterUtil.toString(xid.getBranchQualifier())).append(EOLN).append(INDENT).append("Format ID:             ").append(xid.getFormatId());
        }
        return new String(sb);
    }

    public static StringBuilder getStackTraceWithState(SQLException sqle) {
        SQLException tempSqlX;
        SQLException sqlX = sqle;
        boolean isLinkedThrowable = false;
        StringBuilder trace = new StringBuilder(EOLN);
        do {
            StringWriter s = new StringWriter();
            PrintWriter p = new PrintWriter(s);
            sqlX.printStackTrace(p);
            if (isLinkedThrowable) {
                trace.append("---- Begin backtrace for Nested Throwables").append(EOLN);
            }
            trace.append("SQL STATE:  " + sqlX.getSQLState()).append(EOLN);
            trace.append("ERROR CODE: " + sqlX.getErrorCode()).append(EOLN);
            trace.append(s.toString());
            isLinkedThrowable = true;
        } while ((tempSqlX = sqlX.getNextException()) != sqlX && (sqlX = tempSqlX) != null);
        return trace;
    }

    public static String getResultSetCloseString(int value) {
        switch (value) {
            case 3: {
                return "CLOSE ALL RESULTS (" + value + ')';
            }
            case 1: {
                return "CLOSE CURRENT RESULT (" + value + ')';
            }
            case 2: {
                return "KEEP CURRENT RESULT (" + value + ')';
            }
        }
        return "UNKNOWN CLOSE RESULTSET CONSTANT (" + value + ')';
    }

    public static String getCursorHoldabilityString(int value) {
        switch (value) {
            case 2: {
                return "CLOSE CURSORS AT COMMIT (" + value + ')';
            }
            case 1: {
                return "HOLD CURSORS OVER COMMIT (" + value + ')';
            }
            case 0: {
                return "DEFAULT CURSOR HOLDABILITY VALUE (" + value + ')';
            }
        }
        return "UNKNOWN CURSOR HOLDABILITY CONSTANT (" + value + ')';
    }

    public static String getAutoGeneratedKeyString(int autoGeneratedKey) {
        switch (autoGeneratedKey) {
            case 2: {
                return "NO GENERATED KEYS (" + autoGeneratedKey + ')';
            }
            case 1: {
                return "RETURN GENERATED KEYS (" + autoGeneratedKey + ')';
            }
        }
        return "UNKNOWN AUTO GENERATED KEYS CONSTANT (" + autoGeneratedKey + ')';
    }

    public static Exception mapException(Exception x, WSJdbcConnection handle, Object mapper, boolean sendEvent) {
        DataStoreAdapterException result;
        boolean isAuthenticationError;
        SQLException mappedX;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mapException", (Object[])new Object[]{x.getClass().getName(), AdapterUtil.toString(handle), AdapterUtil.toString(mapper), sendEvent ? "EVENT" : "NO EVENT"});
        }
        WSRdbManagedConnectionImpl mc = mapper instanceof WSRdbManagedConnectionImpl ? (WSRdbManagedConnectionImpl)mapper : null;
        WSManagedConnectionFactoryImpl mcf = mapper instanceof WSManagedConnectionFactoryImpl || mc == null ? (WSManagedConnectionFactoryImpl)((Object)mapper) : mc.getManagedConnectionFactory();
        DatabaseHelper iHelper = mcf == null ? null : mcf.getHelper();
        DataStoreAdapterException dsae = x instanceof DataStoreAdapterException ? (DataStoreAdapterException)((Object)x) : null;
        DataStoreAdapterException securityX = null;
        SQLException sqlX = x instanceof SQLException ? (SQLException)x : (dsae != null && dsae.getCause() instanceof SQLException ? (SQLException)dsae.getCause() : null);
        boolean isStaleStatement = false;
        boolean mapsToStaleConnection = false;
        if (!(mcf == null || sqlX == null || dsae != null && dsae.beenMapped())) {
            mapsToStaleConnection = iHelper.isConnectionError(sqlX);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("stale? " + mapsToStaleConnection + "; original exception is:"), (Object[])new Object[]{AdapterUtil.getStackTraceWithState(sqlX)});
            }
            if (iHelper.isStaleStatement(sqlX)) {
                isStaleStatement = true;
                if (handle == null) {
                    if (mc != null) {
                        mc.clearStatementCache();
                    }
                } else {
                    WSJdbcUtil.handleStaleStatement(handle);
                }
            }
        }
        if ((mappedX = sqlX) instanceof SQLTransientConnectionException && iHelper != null && iHelper.failoverOccurred(sqlX)) {
            SQLException nextX = mappedX.getNextException();
            mappedX = new SQLRecoverableException(mappedX.getMessage(), mappedX.getSQLState(), mappedX.getErrorCode(), mappedX);
            mappedX.setNextException(nextX);
        }
        boolean bl = isAuthenticationError = mcf != null && iHelper.isAnAuthorizationException(mappedX);
        if ((sqlX instanceof SQLRecoverableException || sqlX instanceof SQLNonTransientConnectionException || isAuthenticationError || mapsToStaleConnection) && !isStaleStatement) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(isAuthenticationError ? "Detected an authentication error" : "Detected a connection error."), (Object[])new Object[0]);
            }
            if (dsae != null && isAuthenticationError) {
                securityX = new SecurityException(dsae.getMessage(), (Throwable)mappedX);
            }
            if (sendEvent && (dsae == null || !dsae.beenMapped())) {
                if (handle != null) {
                    handle.fireConnectionErrorEvent(sqlX, true);
                } else if (mc != null) {
                    mc.processConnectionErrorOccurredEvent(null, sqlX);
                }
            }
        }
        if (dsae != null) {
            dsae.setBeenMapped();
        }
        Object object = securityX != null ? securityX : (dsae != null ? dsae : (result = mappedX != null ? mappedX : x));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapException", (Object)(mappedX == null ? x : mappedX).getClass().getName());
        }
        return result;
    }

    public static SQLException mapSQLException(SQLException se, Object mapper) {
        return (SQLException)AdapterUtil.mapException(se, null, mapper, true);
    }

    public static Level getLevelBasedOnName(String level) {
        Level _level = Level.INFO;
        if (level == null) {
            return _level;
        }
        char firstLetter = level.charAt(0);
        switch (firstLetter) {
            case 'I': 
            case 'i': {
                _level = Level.INFO;
                break;
            }
            case 'A': 
            case 'a': {
                _level = Level.ALL;
                break;
            }
            case 'S': 
            case 's': {
                _level = Level.SEVERE;
                break;
            }
            case 'W': 
            case 'w': {
                _level = Level.WARNING;
                break;
            }
            case 'C': 
            case 'c': {
                _level = Level.CONFIG;
                break;
            }
            case 'F': 
            case 'f': {
                if (level.equalsIgnoreCase("fine")) {
                    _level = Level.FINE;
                }
                if (level.equalsIgnoreCase("finer")) {
                    _level = Level.FINER;
                }
                if (!level.equalsIgnoreCase("finest")) break;
                _level = Level.FINEST;
                break;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The level returned is: ", (Object[])new Object[]{_level});
        }
        return _level;
    }

    public static boolean matchGSSName(GSSName gn1, GSSName gn2) {
        try {
            return gn1 == gn2 || gn1 != null && gn1.equals(gn2);
        }
        catch (GSSException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Comparing GSSNAmes received an exception (will return false, to indicate no match): ", (Object[])new Object[]{e});
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"adapterUtil matchGSSName return with exception ", (Object[])new Object[]{false});
            }
            return false;
        }
    }

    public static boolean isUnsupportedException(SQLException sqle) {
        if (sqle instanceof SQLFeatureNotSupportedException) {
            return true;
        }
        String state = sqle.getSQLState() == null ? "" : sqle.getSQLState();
        int code = sqle.getErrorCode();
        return state.startsWith("0A") || 40960 == code || state.startsWith("HYC00") || code == -79700 && "IX000".equals(state);
    }

    public static ClassLoader getClassLoaderWithPriv(final Library lib) {
        if (System.getSecurityManager() == null) {
            return lib.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return lib.getClassLoader();
            }
        });
    }

    public static Class<?> forNameWithPriv(final String className, final boolean initialize, final ClassLoader loader) throws ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            return Class.forName(className, initialize, loader);
        }
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws ClassNotFoundException {
                    return Class.forName(className, initialize, loader);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.setProperty("com.ibm.db2.java.TMClassName", "com.ibm.wsspi.zos.tx.RRSTXSynchronizationManager");
            }
        });
        EOLN = String.format("%n", new Object[0]);
        os = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.name");
            }
        });
    }
}

