/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.jdbc.WSJdbcWrapper;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Wrapper;
import java.util.ArrayList;
import org.osgi.framework.Version;

public class WSJdbcDatabaseMetaData
extends WSJdbcObject
implements DatabaseMetaData {
    private static final TraceComponent tc = Tr.register(WSJdbcDatabaseMetaData.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    protected DatabaseMetaData mDataImpl;
    private int cachedJDBCMajorVerion = -1;

    public WSJdbcDatabaseMetaData(DatabaseMetaData metaDataImpl, WSJdbcConnection connWrapper) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{AdapterUtil.toString(metaDataImpl), connWrapper});
        }
        this.mDataImpl = metaDataImpl;
        this.mcf = connWrapper.mcf;
        this.init(connWrapper);
        this.childWrappers = new ArrayList(8);
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        try {
            return this.mDataImpl.allProceduresAreCallable();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.allProceduresAreCallable", (String)"68", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        try {
            return this.mDataImpl.allTablesAreSelectable();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.allTablesAreSelectable", (String)"88", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        try {
            return this.mDataImpl.autoCommitFailureClosesAllResultSets();
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".autoCommitFailureClosesAllResultSets"), (String)"152", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("DatabaseMetaData.autoCommitFailureClosesAllResultSets", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".autoCommitFailureClosesAllResultSets"), (String)"170", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"autoCommitFailureClosesAllResultSets", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".autoCommitFailureClosesAllResultSets"), (String)"177", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"autoCommitFailureClosesAllResultSets", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    protected final SQLException closeWrapper(boolean closeWrapperOnly) {
        this.parentWrapper.childWrapper = null;
        this.mDataImpl = null;
        return null;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        try {
            return this.mDataImpl.dataDefinitionCausesTransactionCommit();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.dataDefinitionCausesTransactionCommit", (String)"167", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        try {
            return this.mDataImpl.dataDefinitionIgnoredInTransactions();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.dataDefinitionIgnoredInTransactions", (String)"187", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        try {
            return this.mDataImpl.deletesAreDetected(type);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.deletesAreDetected", (String)"207", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        try {
            return this.mDataImpl.doesMaxRowSizeIncludeBlobs();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.doesMaxRowSizeIncludeBlobs", (String)"227", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getBestRowIdentifier(catalog, schema, table, scope, nullable);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getBestRowIdentifier", (String)"254", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getCatalogs();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getCatalogs", (String)"280", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        try {
            return this.mDataImpl.getCatalogSeparator();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getCatalogSeparator", (String)"300", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        try {
            return this.mDataImpl.getCatalogTerm();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getCatalogTerm", (String)"320", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getClientInfoProperties();
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".getClientInfoProperties"), (String)"383", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("DatabaseMetaData.getClientInfoProperties", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".getClientInfoProperties"), (String)"418", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getClientInfoProperties", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".getClientInfoProperties"), (String)"425", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getClientInfoProperties", (Object[])new Object[]{err});
            }
            throw err;
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String colNamePattern) throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getColumnPrivileges(catalog, schema, table, colNamePattern);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getColumnPrivileges", (String)"347", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public ResultSet getColumns(String catalog, String schPattern, String tblNamePattern, String colNamePattern) throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getColumns(catalog, schPattern, tblNamePattern, colNamePattern);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getColumns", (String)"374", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn = (Connection)((Object)this.parentWrapper);
        if (this.state == WSJdbcWrapper.State.CLOSED || conn == null) {
            throw this.createClosedException("Connection");
        }
        return conn;
    }

    @Override
    protected final WSJdbcObject getConnectionWrapper() {
        return this.parentWrapper;
    }

    @Override
    public ResultSet getCrossReference(String pCatalog, String pSchema, String pTable, String fCatalog, String fSchema, String fTable) throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getCrossReference(pCatalog, pSchema, pTable, fCatalog, fSchema, fTable);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getCrossReference", (String)"411", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        try {
            return this.mDataImpl.getDatabaseProductName();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getDatabaseProductName", (String)"431", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        try {
            return this.mDataImpl.getDatabaseProductVersion();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getDatabaseProductVersion", (String)"451", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        try {
            return this.mDataImpl.getDefaultTransactionIsolation();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getDefaultTransactionIsolation", (String)"471", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getDriverMajorVersion() {
        try {
            return this.mDataImpl.getDriverMajorVersion();
        }
        catch (NullPointerException nullX) {
            if (this.state == WSJdbcWrapper.State.CLOSED) {
                throw new RuntimeException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Connection"));
            }
            throw nullX;
        }
    }

    @Override
    public int getDriverMinorVersion() {
        try {
            return this.mDataImpl.getDriverMinorVersion();
        }
        catch (NullPointerException nullX) {
            if (this.state == WSJdbcWrapper.State.CLOSED) {
                throw new RuntimeException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Connection"));
            }
            throw nullX;
        }
    }

    @Override
    public String getDriverName() throws SQLException {
        try {
            return this.mDataImpl.getDriverName();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getDriverName", (String)"513", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public String getDriverVersion() throws SQLException {
        try {
            return this.mDataImpl.getDriverVersion();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getDriverVersion", (String)"533", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getExportedKeys(catalog, schema, table);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getExportedKeys", (String)"560", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        try {
            return this.mDataImpl.getExtraNameCharacters();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getExtraNameCharacters", (String)"580", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".getFunctionColumns"), (String)"734", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("DatabaseMetaData.getFunctionColumns", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".getFunctionColumns"), (String)"820", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getFunctionColumns", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".getFunctionColumns"), (String)"827", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getFunctionColumns", (Object[])new Object[]{err});
            }
            throw err;
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getFunctions(catalog, schemaPattern, functionNamePattern);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".getFunctions"), (String)"759", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("DatabaseMetaData.getFunctions", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".getFunctions"), (String)"942", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getFunctions", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".getFunctions"), (String)"949", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getFunctions", (Object[])new Object[]{err});
            }
            throw err;
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        try {
            return this.mDataImpl.getIdentifierQuoteString();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getIdentifierQuoteString", (String)"600", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getImportedKeys(catalog, schema, table);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getImportedKeys", (String)"627", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getIndexInfo(catalog, schema, table, unique, approximate);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getIndexInfo", (String)"654", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    protected final Wrapper getJDBCImplObject() {
        return this.mDataImpl;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxBinaryLiteralLength();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxBinaryLiteralLength", (String)"674", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxCatalogNameLength();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxCatalogNameLength", (String)"694", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxCharLiteralLength();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxCharLiteralLength", (String)"714", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxColumnNameLength();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxColumnNameLength", (String)"734", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        try {
            return this.mDataImpl.getMaxColumnsInGroupBy();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxColumnsInGroupBy", (String)"754", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        try {
            return this.mDataImpl.getMaxColumnsInIndex();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxColumnsInIndex", (String)"774", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        try {
            return this.mDataImpl.getMaxColumnsInOrderBy();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxColumnsInOrderBy", (String)"794", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        try {
            return this.mDataImpl.getMaxColumnsInSelect();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxColumnsInSelect", (String)"814", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        try {
            return this.mDataImpl.getMaxColumnsInTable();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxColumnsInTable", (String)"834", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getMaxConnections() throws SQLException {
        try {
            return this.mDataImpl.getMaxConnections();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxConnections", (String)"854", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxCursorNameLength();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxCursorNameLength", (String)"874", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxIndexLength();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxIndexLength", (String)"894", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxProcedureNameLength();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxProcedureNameLength", (String)"914", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        try {
            return this.mDataImpl.getMaxRowSize();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxRowSize", (String)"934", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxSchemaNameLength();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxSchemaNameLength", (String)"954", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxStatementLength();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxStatementLength", (String)"974", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getMaxStatements() throws SQLException {
        try {
            return this.mDataImpl.getMaxStatements();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxStatements", (String)"994", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxTableNameLength();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxTableNameLength", (String)"1014", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        try {
            return this.mDataImpl.getMaxTablesInSelect();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxTablesInSelect", (String)"1034", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxUserNameLength();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxUserNameLength", (String)"1054", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        try {
            return this.mDataImpl.getNumericFunctions();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getNumericFunctions", (String)"1088", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getPrimaryKeys(catalog, schema, table);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getPrimaryKeys", (String)"1115", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procNamePattern, String colNamePattern) throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getProcedureColumns(catalog, schemaPattern, procNamePattern, colNamePattern);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getProcedureColumns", (String)"1143", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procNamePattern) throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getProcedures(catalog, schemaPattern, procNamePattern);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getProcedures", (String)"1170", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        try {
            return this.mDataImpl.getProcedureTerm();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getProcedureTerm", (String)"1190", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        try {
            return this.mDataImpl.getRowIdLifetime();
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".getRowIdLifetime"), (String)"1437", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("DatabaseMetaData.getRowIdLifetime", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".getRowIdLifetime"), (String)"1453", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getRowIdLifetime", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".getRowIdLifetime"), (String)"1460", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getRowIdLifetime", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getSchemas();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getSchemas", (String)"1216", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getSchemas(catalog, schemaPattern);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".getSchemas"), (String)"1452", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("DatabaseMetaData.getSchemas", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".getSchemas"), (String)"1713", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getSchemas", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".getSchemas"), (String)"1720", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getSchemas", (Object[])new Object[]{err});
            }
            throw err;
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        try {
            return this.mDataImpl.getSchemaTerm();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getSchemaTerm", (String)"1236", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        try {
            return this.mDataImpl.getSearchStringEscape();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getSearchStringEscape", (String)"1256", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        try {
            return this.mDataImpl.getSQLKeywords();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getSQLKeywords", (String)"1276", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public String getStringFunctions() throws SQLException {
        try {
            return this.mDataImpl.getStringFunctions();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getStringFunctions", (String)"1296", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        try {
            return this.mDataImpl.getSystemFunctions();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getSystemFunctions", (String)"1316", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getTablePrivileges(catalog, schemaPattern, tableNamePattern);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getTablePrivileges", (String)"1343", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getTables(catalog, schemaPattern, tableNamePattern, types);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getTables", (String)"1370", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getTableTypes();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getTableTypes", (String)"1396", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        try {
            return this.mDataImpl.getTimeDateFunctions();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getTimeDateFunctions", (String)"1415", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    protected final TraceComponent getTracer() {
        return tc;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getTypeInfo();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getTypeInfo", (String)"1450", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getUDTs(catalog, schemaPattern, typeNamePattern, types);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getUDTs", (String)"1477", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public String getURL() throws SQLException {
        try {
            return this.mDataImpl.getURL();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getURL", (String)"1497", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public String getUserName() throws SQLException {
        try {
            return this.mDataImpl.getUserName();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getUserName", (String)"1517", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        ResultSet rset;
        try {
            rset = this.mDataImpl.getVersionColumns(catalog, schema, table);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getVersionColumns", (String)"1544", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(rset, this);
        this.childWrappers.add(rset);
        return rset;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        try {
            return this.mDataImpl.insertsAreDetected(type);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.insertsAreDetected", (String)"1564", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    protected void introspectWrapperSpecificInfo(FFDCLogger info) {
        info.append("Underlying DatabaseMetaData: " + AdapterUtil.toString(this.mDataImpl), this.mDataImpl);
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        try {
            return this.mDataImpl.isCatalogAtStart();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.isCatalogAtStart", (String)"1584", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.mDataImpl.isReadOnly();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.isReadOnly", (String)"1604", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        try {
            return this.mDataImpl.nullPlusNonNullIsNull();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.nullPlusNonNullIsNull", (String)"1624", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        try {
            return this.mDataImpl.nullsAreSortedAtEnd();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.nullsAreSortedAtEnd", (String)"1644", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        try {
            return this.mDataImpl.nullsAreSortedAtStart();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.nullsAreSortedAtStart", (String)"1664", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        try {
            return this.mDataImpl.nullsAreSortedHigh();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.nullsAreSortedHigh", (String)"1684", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        try {
            return this.mDataImpl.nullsAreSortedLow();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.nullsAreSortedLow", (String)"1704", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        try {
            return this.mDataImpl.othersDeletesAreVisible(type);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.othersDeletesAreVisible", (String)"1724", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        try {
            return this.mDataImpl.othersInsertsAreVisible(type);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.othersInsertsAreVisible", (String)"1744", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        try {
            return this.mDataImpl.othersUpdatesAreVisible(type);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.othersUpdatesAreVisible", (String)"1764", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        try {
            return this.mDataImpl.ownDeletesAreVisible(type);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.ownDeletesAreVisible", (String)"1784", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        try {
            return this.mDataImpl.ownInsertsAreVisible(type);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.ownInsertsAreVisible", (String)"1804", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        try {
            return this.mDataImpl.ownUpdatesAreVisible(type);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.ownUpdatesAreVisible", (String)"1824", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        try {
            return this.mDataImpl.storesLowerCaseIdentifiers();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.storesLowerCaseIdentifiers", (String)"1844", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    protected final RuntimeException runtimeXIfNotClosed(RuntimeException runtimeX) throws SQLException {
        if (this.state == WSJdbcWrapper.State.CLOSED) {
            throw this.createClosedException("Connection");
        }
        return runtimeX;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.mDataImpl.storesLowerCaseQuotedIdentifiers();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.storesLowerCaseQuotedIdentifiers", (String)"1864", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        try {
            return this.mDataImpl.storesMixedCaseIdentifiers();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.storesMixedCaseIdentifiers", (String)"1885", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.mDataImpl.storesMixedCaseQuotedIdentifiers();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.storesMixedCaseQuotedIdentifiers", (String)"1905", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        try {
            return this.mDataImpl.storesUpperCaseIdentifiers();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.storesUpperCaseIdentifiers", (String)"1925", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.mDataImpl.storesUpperCaseQuotedIdentifiers();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.storesUpperCaseQuotedIdentifiers", (String)"1945", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        try {
            return this.mDataImpl.supportsAlterTableWithAddColumn();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsAlterTableWithAddColumn", (String)"1965", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        try {
            return this.mDataImpl.supportsAlterTableWithDropColumn();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsAlterTableWithDropColumn", (String)"1985", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        try {
            return this.mDataImpl.supportsANSI92EntryLevelSQL();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsANSI92EntryLevelSQL", (String)"2005", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        try {
            return this.mDataImpl.supportsANSI92FullSQL();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsANSI92FullSQL", (String)"2025", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        try {
            return this.mDataImpl.supportsANSI92IntermediateSQL();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsANSI92IntermediateSQL", (String)"2045", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        try {
            return this.mDataImpl.supportsBatchUpdates();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsBatchUpdates", (String)"2065", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        try {
            return this.mDataImpl.supportsCatalogsInDataManipulation();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsCatalogsInDataManipulation", (String)"2085", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        try {
            return this.mDataImpl.supportsCatalogsInIndexDefinitions();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsCatalogsInIndexDefinitions", (String)"2105", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        try {
            return this.mDataImpl.supportsCatalogsInPrivilegeDefinitions();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsCatalogsInPrivilegeDefinitions", (String)"2125", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        try {
            return this.mDataImpl.supportsCatalogsInProcedureCalls();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsCatalogsInProcedureCalls", (String)"2145", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        try {
            return this.mDataImpl.supportsCatalogsInTableDefinitions();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsCatalogsInTableDefinitions", (String)"2165", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        try {
            return this.mDataImpl.supportsColumnAliasing();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsColumnAliasing", (String)"2185", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        try {
            return this.mDataImpl.supportsConvert();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsConvert", (String)"2205", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        try {
            return this.mDataImpl.supportsConvert(fromType, toType);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsConvert", (String)"2225", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        try {
            return this.mDataImpl.supportsCoreSQLGrammar();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsCoreSQLGrammar", (String)"2245", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        try {
            return this.mDataImpl.supportsCorrelatedSubqueries();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsCorrelatedSubqueries", (String)"2265", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        try {
            return this.mDataImpl.supportsDataDefinitionAndDataManipulationTransactions();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsDataDefinitionAndDataManipulationTransactions", (String)"2286", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        try {
            return this.mDataImpl.supportsDataManipulationTransactionsOnly();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsDataManipulationTransactionsOnly", (String)"2306", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        try {
            return this.mDataImpl.supportsDifferentTableCorrelationNames();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsDifferentTableCorrelationNames", (String)"2326", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        try {
            return this.mDataImpl.supportsExpressionsInOrderBy();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsExpressionsInOrderBy", (String)"2346", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        try {
            return this.mDataImpl.supportsExtendedSQLGrammar();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsExtendedSQLGrammar", (String)"2366", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        try {
            return this.mDataImpl.supportsFullOuterJoins();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsFullOuterJoins", (String)"2386", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        try {
            return this.mDataImpl.supportsGroupBy();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsGroupBy", (String)"2406", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        try {
            return this.mDataImpl.supportsGroupByBeyondSelect();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsGroupByBeyondSelect", (String)"2426", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        try {
            return this.mDataImpl.supportsGroupByUnrelated();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsGroupByUnrelated", (String)"2446", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        try {
            return this.mDataImpl.supportsIntegrityEnhancementFacility();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsIntegrityEnhancementFacility", (String)"2466", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        try {
            return this.mDataImpl.supportsLikeEscapeClause();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsLikeEscapeClause", (String)"2486", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        try {
            return this.mDataImpl.supportsLimitedOuterJoins();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsLimitedOuterJoins", (String)"2506", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        try {
            return this.mDataImpl.supportsMinimumSQLGrammar();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsMinimumSQLGrammar", (String)"2526", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        try {
            return this.mDataImpl.supportsMixedCaseIdentifiers();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsMixedCaseIdentifiers", (String)"2546", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.mDataImpl.supportsMixedCaseQuotedIdentifiers();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsMixedCaseQuotedIdentifiers", (String)"2566", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        try {
            return this.mDataImpl.supportsMultipleResultSets();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsMultipleResultSets", (String)"2586", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        try {
            return this.mDataImpl.supportsMultipleTransactions();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsMultipleTransactions", (String)"2606", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        try {
            return this.mDataImpl.supportsNonNullableColumns();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsNonNullableColumns", (String)"2626", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        try {
            return this.mDataImpl.supportsOpenCursorsAcrossCommit();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsOpenCursorsAcrossCommit", (String)"2646", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        try {
            return this.mDataImpl.supportsOpenCursorsAcrossRollback();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsOpenCursorsAcrossRollback", (String)"2666", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        try {
            return this.mDataImpl.supportsOpenStatementsAcrossCommit();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsOpenStatementsAcrossCommit", (String)"2686", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        try {
            return this.mDataImpl.supportsOpenStatementsAcrossRollback();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsOpenStatementsAcrossRollback", (String)"2706", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        try {
            return this.mDataImpl.supportsOrderByUnrelated();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsOrderByUnrelated", (String)"2726", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        try {
            return this.mDataImpl.supportsOuterJoins();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsOuterJoins", (String)"2746", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        try {
            return this.mDataImpl.supportsPositionedDelete();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsPositionedDelete", (String)"2766", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        try {
            return this.mDataImpl.supportsPositionedUpdate();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsPositionedUpdate", (String)"2786", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        try {
            return this.mDataImpl.supportsResultSetConcurrency(type, concurrency);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsResultSetConcurrency", (String)"2807", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        try {
            return this.mDataImpl.supportsResultSetType(type);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsResultSetType", (String)"2827", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        try {
            return this.mDataImpl.supportsSchemasInDataManipulation();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSchemasInDataManipulation", (String)"2847", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        try {
            return this.mDataImpl.supportsSchemasInIndexDefinitions();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSchemasInIndexDefinitions", (String)"2867", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        try {
            return this.mDataImpl.supportsSchemasInPrivilegeDefinitions();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSchemasInPrivilegeDefinitions", (String)"2887", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        try {
            return this.mDataImpl.supportsSchemasInProcedureCalls();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSchemasInProcedureCalls", (String)"2907", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        try {
            return this.mDataImpl.supportsSchemasInTableDefinitions();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSchemasInTableDefinitions", (String)"2927", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        try {
            return this.mDataImpl.supportsSelectForUpdate();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSelectForUpdate", (String)"2947", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        try {
            return this.mDataImpl.supportsStoredFunctionsUsingCallSyntax();
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".supportsStoredFunctionsUsingCallSyntax"), (String)"3241", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("DatabaseMetaData.supportsStoredFunctionsUsingCallSyntax", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".supportsStoredFunctionsUsingCallSyntax"), (String)"3544", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"supportsStoredFunctionsUsingCallSyntax", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".supportsStoredFunctionsUsingCallSyntax"), (String)"3551", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"supportsStoredFunctionsUsingCallSyntax", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        try {
            return this.mDataImpl.supportsStoredProcedures();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsStoredProcedures", (String)"2967", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        try {
            return this.mDataImpl.supportsSubqueriesInComparisons();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSubqueriesInComparisons", (String)"2987", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        try {
            return this.mDataImpl.supportsSubqueriesInExists();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSubqueriesInExists", (String)"3007", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        try {
            return this.mDataImpl.supportsSubqueriesInIns();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSubqueriesInIns", (String)"3027", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        try {
            return this.mDataImpl.supportsSubqueriesInQuantifieds();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSubqueriesInQuantifieds", (String)"3047", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        try {
            return this.mDataImpl.supportsTableCorrelationNames();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsTableCorrelationNames", (String)"3067", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        try {
            return this.mDataImpl.supportsTransactionIsolationLevel(level);
        }
        catch (SQLException ex) {
            if (level == 0 || level == 1 || level == 2 || level == 4 || level == 8) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsTransactionIsolationLevel", (String)"3088", (Object)this);
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        try {
            return this.mDataImpl.supportsTransactions();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsTransactions", (String)"3108", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        try {
            return this.mDataImpl.supportsUnion();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsUnion", (String)"3128", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        try {
            return this.mDataImpl.supportsUnionAll();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsUnionAll", (String)"3148", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        try {
            return this.mDataImpl.updatesAreDetected(type);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.updatesAreDetected", (String)"3168", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        try {
            return this.mDataImpl.usesLocalFilePerTable();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.usesLocalFilePerTable", (String)"3188", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        try {
            return this.mDataImpl.usesLocalFiles();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.usesLocalFiles", (String)"3208", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        try {
            WSJdbcResultSet rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(this.mDataImpl.getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern), this);
            this.childWrappers.add(rset);
            return rset;
        }
        catch (AbstractMethodError ame) {
            Tr.warning((TraceComponent)tc, (String)"UNSUPPORTED_JDBC30_METHOD", (Object[])new Object[]{"getAttributes"});
            SQLException se = AdapterUtil.notSupportedX("getAttributes", ame);
            throw WSJdbcUtil.mapException(this, se);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getAttributes", (String)"3279", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        try {
            return this.mDataImpl.getDatabaseMajorVersion();
        }
        catch (AbstractMethodError ame) {
            Tr.warning((TraceComponent)tc, (String)"UNSUPPORTED_JDBC30_METHOD", (Object[])new Object[]{"getDatabaseMajorVersion"});
            SQLException se = AdapterUtil.notSupportedX("getDatabaseMajorVersion", ame);
            throw WSJdbcUtil.mapException(this, se);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getDatabaseMajorVersion", (String)"3292", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        try {
            return this.mDataImpl.getDatabaseMinorVersion();
        }
        catch (AbstractMethodError ame) {
            Tr.warning((TraceComponent)tc, (String)"UNSUPPORTED_JDBC30_METHOD", (Object[])new Object[]{"getDatabaseMinorVersion"});
            SQLException se = AdapterUtil.notSupportedX("getDatabaseMinorVersion", ame);
            throw WSJdbcUtil.mapException(this, se);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getDatabaseMinorVersion", (String)"3310", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        try {
            int majorVersion_was;
            if (this.cachedJDBCMajorVerion != -1) {
                return this.cachedJDBCMajorVerion;
            }
            int majorVersion_driver = this.mDataImpl.getJDBCMajorVersion();
            this.cachedJDBCMajorVerion = majorVersion_driver > (majorVersion_was = this.mcf.jdbcRuntime.getVersion().getMajor()) ? majorVersion_was : majorVersion_driver;
            return this.cachedJDBCMajorVerion;
        }
        catch (AbstractMethodError ame) {
            Tr.warning((TraceComponent)tc, (String)"UNSUPPORTED_JDBC30_METHOD", (Object[])new Object[]{"getJDBCMajorVersion"});
            SQLException se = AdapterUtil.notSupportedX("getJDBCMajorVersion", ame);
            throw WSJdbcUtil.mapException(this, se);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getJDBCMajorVersion", (String)"3325", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        try {
            Version jdbcVersion_was = this.mcf.jdbcRuntime.getVersion();
            int jdbcMinorVersion_driver = this.mDataImpl.getJDBCMinorVersion();
            int jdbcMajorVersion_driver = this.cachedJDBCMajorVerion == -1 ? this.getJDBCMajorVersion() : this.cachedJDBCMajorVerion;
            Version jdbcVersion_driver = new Version(jdbcMajorVersion_driver, jdbcMinorVersion_driver, 0);
            if (jdbcVersion_was.compareTo(jdbcVersion_driver) < 0) {
                return jdbcVersion_was.getMinor();
            }
            return jdbcMinorVersion_driver;
        }
        catch (AbstractMethodError ame) {
            Tr.warning((TraceComponent)tc, (String)"UNSUPPORTED_JDBC30_METHOD", (Object[])new Object[]{"getJDBCMinorVersion"});
            SQLException se = AdapterUtil.notSupportedX("getJDBCMinorVersion", ame);
            throw WSJdbcUtil.mapException(this, se);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getJDBCMinorVersion", (String)"3340", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this.mDataImpl.getResultSetHoldability();
        }
        catch (AbstractMethodError ame) {
            Tr.warning((TraceComponent)tc, (String)"UNSUPPORTED_JDBC30_METHOD", (Object[])new Object[]{"getResultSetHoldability"});
            SQLException se = AdapterUtil.notSupportedX("getResultSetHoldability", ame);
            throw WSJdbcUtil.mapException(this, se);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getResultSetHoldability", (String)"3355", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getSQLStateType() throws SQLException {
        try {
            return this.mDataImpl.getSQLStateType();
        }
        catch (AbstractMethodError ame) {
            Tr.warning((TraceComponent)tc, (String)"UNSUPPORTED_JDBC30_METHOD", (Object[])new Object[]{"getSQLStateType"});
            SQLException se = AdapterUtil.notSupportedX("getSQLStateType", ame);
            throw WSJdbcUtil.mapException(this, se);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getSQLStateType", (String)"3370", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            WSJdbcResultSet rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(this.mDataImpl.getSuperTables(catalog, schemaPattern, tableNamePattern), this);
            this.childWrappers.add(rset);
            return rset;
        }
        catch (AbstractMethodError ame) {
            Tr.warning((TraceComponent)tc, (String)"UNSUPPORTED_JDBC30_METHOD", (Object[])new Object[]{"getSuperTables"});
            SQLException se = AdapterUtil.notSupportedX("getSuperTables", ame);
            throw WSJdbcUtil.mapException(this, se);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getSuperTables", (String)"3385", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        try {
            WSJdbcResultSet rset = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(this.mDataImpl.getSuperTypes(catalog, schemaPattern, typeNamePattern), this);
            this.childWrappers.add(rset);
            return rset;
        }
        catch (AbstractMethodError ame) {
            Tr.warning((TraceComponent)tc, (String)"UNSUPPORTED_JDBC30_METHOD", (Object[])new Object[]{"getSuperTypes"});
            SQLException se = AdapterUtil.notSupportedX("getSuperTypes", ame);
            throw WSJdbcUtil.mapException(this, se);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getSuperTypes", (String)"3399", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        try {
            return this.mDataImpl.locatorsUpdateCopy();
        }
        catch (AbstractMethodError ame) {
            Tr.warning((TraceComponent)tc, (String)"UNSUPPORTED_JDBC30_METHOD", (Object[])new Object[]{"locatorsUpdateCopy"});
            SQLException se = AdapterUtil.notSupportedX("locatorsUpdateCopy", ame);
            throw WSJdbcUtil.mapException(this, se);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.locatorsUpdateCopy", (String)"3414", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        try {
            return this.mDataImpl.supportsGetGeneratedKeys();
        }
        catch (AbstractMethodError ame) {
            Tr.warning((TraceComponent)tc, (String)"UNSUPPORTED_JDBC30_METHOD", (Object[])new Object[]{"supportsGetGeneratedKeys"});
            SQLException se = AdapterUtil.notSupportedX("supportsGetGeneratedKeys", ame);
            throw WSJdbcUtil.mapException(this, se);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsGetGeneratedKeys", (String)"3429", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        try {
            return this.mDataImpl.supportsNamedParameters();
        }
        catch (AbstractMethodError ame) {
            Tr.warning((TraceComponent)tc, (String)"UNSUPPORTED_JDBC30_METHOD", (Object[])new Object[]{"supportsNamedParameters"});
            SQLException se = AdapterUtil.notSupportedX("supportsNamedParameters", ame);
            throw WSJdbcUtil.mapException(this, se);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsNamedParameters", (String)"3444", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        try {
            return this.mDataImpl.supportsResultSetHoldability(holdability);
        }
        catch (AbstractMethodError ame) {
            Tr.warning((TraceComponent)tc, (String)"UNSUPPORTED_JDBC30_METHOD", (Object[])new Object[]{"supportsResultSetHoldability"});
            SQLException se = AdapterUtil.notSupportedX("supportsResultSetHoldability", ame);
            throw WSJdbcUtil.mapException(this, se);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsResultSetHoldability", (String)"3460", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        try {
            return this.mDataImpl.supportsSavepoints();
        }
        catch (AbstractMethodError ame) {
            Tr.warning((TraceComponent)tc, (String)"UNSUPPORTED_JDBC30_METHOD", (Object[])new Object[]{"supportsSavepoints"});
            SQLException se = AdapterUtil.notSupportedX("supportsSavepoints", ame);
            throw WSJdbcUtil.mapException(this, se);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSavepoints", (String)"3475", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        try {
            return this.mDataImpl.supportsMultipleOpenResults();
        }
        catch (AbstractMethodError ame) {
            Tr.warning((TraceComponent)tc, (String)"UNSUPPORTED_JDBC30_METHOD", (Object[])new Object[]{"supportsMultipleOpenResults"});
            SQLException se = AdapterUtil.notSupportedX("supportsMultipleOpenResults", ame);
            throw WSJdbcUtil.mapException(this, se);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsMultipleOpenResults", (String)"3505", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

