/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.wab.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.app.manager.module.DeployedModuleInfo;
import com.ibm.ws.app.manager.wab.internal.WABInstaller;
import com.ibm.ws.app.manager.wab.internal.WABState;
import com.ibm.ws.app.manager.wab.internal.WABTracker;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.event.Event;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class WAB
implements BundleTrackerCustomizer<WAB> {
    static final String OSGI_WEB_EVENT_TOPIC_PREFIX = "org/osgi/service/web/";
    private static final Bundle extenderBundle;
    private static final long extenderId;
    private static final String extenderSymbolicName;
    private static final Version extenderVersion;
    private final Bundle wabBundle;
    private final long wabBundleId;
    private final String wabBundleSymbolicName;
    private final Version wabBundleVersion;
    private final String wabContextPath;
    private final WABInstaller installer;
    private final WABTracker<WAB> trackerForThisWAB;
    private final AddRemoveLock addRemoveLock = new AddRemoveLock();
    private final AtomicReference<Boolean> terminated = new AtomicReference<Boolean>(Boolean.FALSE);
    private final AtomicReference<WABState.State> state = new AtomicReference<WABState.State>(WABState.State.UNDEPLOYED);
    private ApplicationInfo appInfo;
    private boolean createdAppInfo = false;
    private DeployedModuleInfo deployedModuleInfo = null;
    private ServiceRegistration<Bundle> reg = null;
    private ServiceRegistration<ServletContext> scReg = null;
    static final long serialVersionUID = 1550570454044732881L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    WAB(Bundle wabBundle, String wabContextPath, WABInstaller installer) {
        this.wabBundle = wabBundle;
        this.wabBundleId = wabBundle.getBundleId();
        this.wabBundleSymbolicName = wabBundle.getSymbolicName();
        this.wabBundleVersion = wabBundle.getVersion();
        this.wabContextPath = wabContextPath;
        this.installer = installer;
        this.trackerForThisWAB = installer.getTracker(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminateWAB() {
        AtomicReference<Boolean> atomicReference = this.terminated;
        synchronized (atomicReference) {
            this.installer.wabLifecycleDebug("SubTracker being terminated ", this);
            this.terminated.set(true);
            this.closeTracker();
        }
    }

    void performCollisionResolution() {
        this.installer.attemptRedeployOfPreviouslyCollidedContextPath(this.wabContextPath);
    }

    void enableTracker() {
        if (this.trackerForThisWAB.getTrackingCount() == -1) {
            this.installer.executeRunnable(new Runnable(){
                static final long serialVersionUID = 116935636305608018L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (FrameworkState.isStopping()) {
                        return;
                    }
                    WAB.this.installer.wabLifecycleDebug("SubTracker open has initiated. ", WAB.this);
                    AtomicReference atomicReference = WAB.this.terminated;
                    synchronized (atomicReference) {
                        WAB.this.installer.wabLifecycleDebug("SubTracker open has obtained terminate lock ", WAB.this);
                        if (((Boolean)WAB.this.terminated.get()).booleanValue()) {
                            return;
                        }
                        if (WAB.this.getState() == WABState.State.DEPLOYING) {
                            WAB.this.installer.wabLifecycleDebug("SubTracker opening tracker.", WAB.this);
                            WAB.this.trackerForThisWAB.open();
                            WAB.this.installer.wabLifecycleDebug("SubTracker open.", WAB.this);
                        }
                        int bundleState = WAB.this.wabBundle.getState();
                        if (WAB.this.getState() == WABState.State.DEPLOYING) {
                            if (bundleState != 32 && bundleState != 8) {
                                WAB.this.installer.wabLifecycleDebug("SubTracker detected WAB state has not advanced, and bundle state no longer eligible.", WAB.this, WAB.this.wabBundle.getState());
                                WAB.this.setState(WABState.State.FAILED);
                                WAB.this.terminated.set(true);
                                WAB.this.installer.removeWabFromEligibleForCollisionResolution(WAB.this);
                                WAB.this.closeTracker();
                                WAB.this.performCollisionResolution();
                            } else {
                                WAB.this.installer.wabLifecycleDebug("SubTracker did not advance WAB state during open, and bundle is still eligible.", this, WAB.this.wabBundle.getState());
                            }
                        }
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
    }

    String getContextRoot() {
        return this.wabContextPath;
    }

    Bundle getBundle() {
        return this.wabBundle;
    }

    WABState.State getState() {
        return this.state.get();
    }

    private boolean setState(WABState.State newState) {
        switch (newState) {
            case DEPLOYED: {
                return this.changeState(WABState.State.DEPLOYING, WABState.State.DEPLOYED);
            }
            case DEPLOYING: {
                return this.changeState(WABState.State.UNDEPLOYED, WABState.State.DEPLOYING) || this.changeState(WABState.State.FAILED, WABState.State.DEPLOYING);
            }
            case UNDEPLOYING: {
                return this.changeState(WABState.State.DEPLOYED, WABState.State.UNDEPLOYING);
            }
            case UNDEPLOYED: {
                return this.changeState(WABState.State.UNDEPLOYING, WABState.State.UNDEPLOYED);
            }
            case FAILED: {
                return this.changeState(WABState.State.DEPLOYING, WABState.State.FAILED);
            }
        }
        return false;
    }

    private boolean changeState(WABState.State oldState, WABState.State newState) {
        if (this.state.compareAndSet(oldState, newState)) {
            if (newState != WABState.State.FAILED) {
                this.installer.postEvent(this.createEvent(newState));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attemptDeployOfPreviouslyBlockedWab() {
        AtomicReference<Boolean> atomicReference = this.terminated;
        synchronized (atomicReference) {
            if (this.terminated.get().booleanValue()) {
                return;
            }
            if (this.setState(WABState.State.DEPLOYING)) {
                this.installer.wabLifecycleDebug("WAB opening SubTracker for WAB as a result of collision resolution ", this);
                this.enableTracker();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveToDeploying() {
        AtomicReference<Boolean> atomicReference = this.terminated;
        synchronized (atomicReference) {
            if (this.terminated.get().booleanValue()) {
                return false;
            }
            return this.setState(WABState.State.DEPLOYING);
        }
    }

    void setApplicationInfo(ApplicationInfo appInfo) {
        this.appInfo = appInfo;
    }

    ApplicationInfo getApplicationInfo() {
        return this.appInfo;
    }

    void setCreatedApplicationInfo() {
        this.createdAppInfo = true;
    }

    boolean getCreatedApplicationInfo() {
        return this.createdAppInfo;
    }

    void setDeployedModuleInfo(DeployedModuleInfo deployedModuleInfo) {
        if (this.deployedModuleInfo == null) {
            this.deployedModuleInfo = deployedModuleInfo;
        }
    }

    DeployedModuleInfo getDeployedModuleInfo() {
        return this.deployedModuleInfo;
    }

    Event createEvent(WABState.State t) {
        return this.createEvent(t, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Event createFailedEvent(Throwable t) {
        AtomicReference<Boolean> atomicReference = this.terminated;
        synchronized (atomicReference) {
            if (this.terminated.get().booleanValue()) {
                return null;
            }
            if (this.setState(WABState.State.FAILED)) {
                this.installer.removeWabFromEligibleForCollisionResolution(this);
                this.installer.attemptRedeployOfPreviouslyCollidedContextPath(this.wabContextPath);
                return this.createEvent(WABState.State.FAILED, t, null, null);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Event createFailedEvent(String collisionContext, long[] cIds) {
        AtomicReference<Boolean> atomicReference = this.terminated;
        synchronized (atomicReference) {
            if (this.terminated.get().booleanValue()) {
                return null;
            }
            if (this.setState(WABState.State.FAILED)) {
                return this.createEvent(WABState.State.FAILED, null, collisionContext, cIds);
            }
        }
        return null;
    }

    private Event createEvent(WABState.State t, Throwable e, String collisionContext, long[] cIds) {
        Dictionary<String, Object> eventProps = this.createEventProperties();
        if (WABState.State.FAILED.equals((Object)t)) {
            if (collisionContext != null && cIds.length > 0) {
                eventProps.put("collision", collisionContext);
                eventProps.put("collision.bundles", cIds);
            } else if (e != null) {
                eventProps.put("exception", e);
            }
        }
        return new Event(OSGI_WEB_EVENT_TOPIC_PREFIX + t.toString(), eventProps);
    }

    Dictionary<String, Object> createEventProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("extender.bundle", extenderBundle);
        ((Dictionary)props).put("extender.bundle.id", extenderId);
        ((Dictionary)props).put("extender.bundle.symbolicName", extenderSymbolicName);
        ((Dictionary)props).put("extender.bundle.version", extenderVersion);
        ((Dictionary)props).put("bundle.symbolicName", this.wabBundleSymbolicName);
        ((Dictionary)props).put("bundle.id", this.wabBundleId);
        ((Dictionary)props).put("bundle", this.wabBundle);
        ((Dictionary)props).put("bundle.version", this.wabBundleVersion);
        ((Dictionary)props).put("context.path", this.wabContextPath);
        ((Dictionary)props).put("timestamp", System.currentTimeMillis());
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToWebContainer() {
        if (!Thread.holdsLock(this.terminated)) {
            throw new IllegalStateException();
        }
        AddRemoveLock addRemoveLock = this.addRemoveLock;
        synchronized (addRemoveLock) {
            if (this.installer.installIntoWebContainer(this)) {
                this.setState(WABState.State.DEPLOYED);
                return true;
            }
            this.closeTracker();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromWebContainer() {
        if (!Thread.holdsLock(this.terminated)) {
            throw new IllegalStateException();
        }
        AddRemoveLock addRemoveLock = this.addRemoveLock;
        synchronized (addRemoveLock) {
            this.closeTracker();
            if (this.getDeployedModuleInfo() != null) {
                this.installer.uninstallFromWebContainer(this);
                this.unregister();
                this.setState(WABState.State.UNDEPLOYED);
            }
        }
    }

    synchronized void setRegistration(ServiceRegistration<Bundle> reg) {
        this.reg = reg;
    }

    void registerServletContext(ServletContext sc) {
        Hashtable<String, String> scRegProps = new Hashtable<String, String>(3);
        ((Dictionary)scRegProps).put("osgi.web.symbolicname", this.wabBundleSymbolicName);
        ((Dictionary)scRegProps).put("osgi.web.version", (String)this.wabBundleVersion);
        ((Dictionary)scRegProps).put("osgi.web.contextpath", this.wabContextPath);
        this.scReg = this.wabBundle.getBundleContext().registerService(ServletContext.class, (Object)sc, scRegProps);
    }

    @FFDCIgnore(value={IllegalStateException.class})
    void unregister() {
        if (this.reg != null) {
            try {
                this.reg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (this.scReg != null) {
            try {
                this.scReg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    public WAB addingBundle(Bundle bundle, BundleEvent event) {
        if (bundle.getBundleId() == this.wabBundleId) {
            AtomicReference<Boolean> atomicReference = this.terminated;
            synchronized (atomicReference) {
                if (this.terminated.get().booleanValue()) {
                    this.installer.wabLifecycleDebug("SubTracker unable to add bundle, as has been terminated.", this, bundle.getBundleId());
                    return null;
                }
                this.installer.wabLifecycleDebug("SubTracker adding bundle.", this);
                if (this.getState() == WABState.State.DEPLOYING) {
                    this.installer.wabLifecycleDebug("SubTracker adding WAB to WebContainer", this);
                    return this.addToWebContainer() ? this : null;
                }
                return null;
            }
        }
        return null;
    }

    @Trivial
    public void modifiedBundle(Bundle bundle, BundleEvent event, WAB wab) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    public void removedBundle(Bundle bundle, BundleEvent event, WAB wab) {
        if (bundle.getBundleId() == this.wabBundleId) {
            AtomicReference<Boolean> atomicReference = this.terminated;
            synchronized (atomicReference) {
                if (this.terminated.get().booleanValue()) {
                    this.installer.wabLifecycleDebug("SubTracker unable to remove bundle, as has been terminated.", this, wab);
                    return;
                }
                this.installer.wabLifecycleDebug("Sub Tracker for WAB processing remove event", wab);
                this.removeWAB();
                this.terminateWAB();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeWAB() {
        AtomicReference<Boolean> atomicReference = this.terminated;
        synchronized (atomicReference) {
            if (this.terminated.get().booleanValue()) {
                this.installer.wabLifecycleDebug("WAB processing removal of terminated WAB.", this);
            } else {
                this.installer.wabLifecycleDebug("WAB processing removal.", this);
            }
            this.installer.removeWabFromEligibleForCollisionResolution(this);
            boolean result = true;
            switch (this.getState()) {
                case DEPLOYED: {
                    if (result &= this.setState(WABState.State.UNDEPLOYING)) {
                        this.removeFromWebContainer();
                    }
                    return result;
                }
                case DEPLOYING: {
                    this.performCollisionResolution();
                    return result &= this.setState(WABState.State.FAILED);
                }
                case UNDEPLOYING: {
                    this.removeFromWebContainer();
                    return result;
                }
                case UNDEPLOYED: {
                    return result;
                }
                case FAILED: {
                    return result;
                }
            }
            return false;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.hashCode());
        sb.append(":");
        sb.append(this.wabBundleId);
        sb.append(":");
        sb.append((Object)this.getState());
        sb.append(":");
        sb.append(this.wabContextPath);
        return sb.toString();
    }

    private void closeTracker() {
        this.installer.wabLifecycleDebug("SubTracker closing tracker.", this, this.wabBundle.getState());
        if (this.trackerForThisWAB.getTrackingCount() != -1) {
            this.trackerForThisWAB.close();
            this.installer.wabLifecycleDebug("SubTracker closed.", this, this.wabBundle.getState());
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(WAB.class);
        extenderBundle = FrameworkUtil.getBundle(WAB.class);
        extenderId = extenderBundle.getBundleId();
        extenderSymbolicName = extenderBundle.getSymbolicName();
        extenderVersion = extenderBundle.getVersion();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class AddRemoveLock {
        static final long serialVersionUID = -2545611143059778056L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private AddRemoveLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AddRemoveLock.class);
        }
    }
}

