/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.persistent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl;
import com.ibm.ws.concurrent.persistent.serializable.TaskFailure;
import com.ibm.ws.concurrent.persistent.serializable.TaskSkipped;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.concurrent.LastExecution;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LastExecutionImpl
implements LastExecution {
    private static final TraceComponent tc = Tr.register(LastExecutionImpl.class);
    private final ClassLoader classLoader;
    private final long id;
    private final String identityName;
    private final PersistentExecutorImpl persistentExecutor;
    private final byte[] resultBytes;
    private final AtomicReference<Object> resultRef = new AtomicReference();
    private final long runEnd;
    private final long runStart;
    private final long scheduledStart;
    static final long serialVersionUID = -7329724148176854458L;

    LastExecutionImpl(PersistentExecutorImpl persistentExecutor, long id, String identityName, @Sensitive byte[] resultInfoBytes, long runEnd, long runStart, long scheduledStart, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.id = id;
        this.identityName = identityName;
        this.persistentExecutor = persistentExecutor;
        this.resultBytes = resultInfoBytes;
        this.runEnd = runEnd;
        this.runStart = runStart;
        this.scheduledStart = scheduledStart;
    }

    LastExecutionImpl(PersistentExecutorImpl persistentExecutor, long id, String identityName, Object result, long runEnd, long runStart, long scheduledStart) {
        this.id = id;
        this.identityName = identityName;
        this.persistentExecutor = persistentExecutor;
        this.resultBytes = null;
        this.resultRef.set(result);
        this.runEnd = runEnd;
        this.runStart = runStart;
        this.scheduledStart = scheduledStart;
        this.classLoader = null;
    }

    private final String getIdAndName() {
        StringBuilder sb = new StringBuilder().append(this.id);
        if (this.identityName != null && this.identityName.length() > 0) {
            sb.append(" (").append(this.identityName).append(')');
        }
        return sb.toString();
    }

    public String getIdentityName() {
        return this.identityName;
    }

    /*
     * WARNING - void declaration
     */
    public Object getResult() {
        Object result = this.resultRef.get();
        if (result == null && this.resultBytes != null) {
            try {
                Object newResult = this.persistentExecutor.deserialize(this.resultBytes, this.classLoader);
                if (newResult instanceof TaskFailure) {
                    if (((TaskFailure)newResult).getReason() == 2) {
                        // empty if block
                    }
                } else if (newResult instanceof TaskSkipped) {
                    byte[] resultBytes = ((TaskSkipped)newResult).getPreviousResult();
                    Object object = newResult = resultBytes == null ? null : this.persistentExecutor.deserialize(resultBytes, this.classLoader);
                    result = this.resultRef.compareAndSet(null, newResult) ? newResult : this.resultRef.get();
                } else {
                    result = this.resultRef.compareAndSet(null, newResult) ? newResult : this.resultRef.get();
                }
            }
            catch (ClassNotFoundException newResult) {
                void x;
                FFDCFilter.processException((Throwable)newResult, (String)"com.ibm.ws.concurrent.persistent.internal.LastExecutionImpl", (String)"133", (Object)this, (Object[])new Object[0]);
                throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1553.result.inaccessible", (Object[])new Object[]{this.persistentExecutor.name, this.getIdAndName()}), (Throwable)x);
            }
            catch (IOException x) {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.LastExecutionImpl", (String)"135", (Object)this, (Object[])new Object[0]);
                throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1553.result.inaccessible", (Object[])new Object[]{this.persistentExecutor.name, this.getIdAndName()}), x);
            }
        }
        return result;
    }

    public Date getRunEnd() {
        return new Date(this.runEnd);
    }

    public Date getRunStart() {
        return new Date(this.runStart);
    }

    public Date getScheduledStart() {
        return new Date(this.scheduledStart);
    }
}

