/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.persistent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.ThreadContextDeserializer;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TaskInfo
implements Serializable {
    private static final long serialVersionUID = 114469733965157007L;
    private static final TraceComponent tc = Tr.register(TaskInfo.class);
    private static final String INITIAL_DELAY = "D";
    private static final String INTERVAL = "I";
    private static final String IS_FIXED_RATE = "F";
    private static final String NONSER_TASK_CLASS_NAME = "T";
    private static final String NONSER_TRIGGER_CLASS_NAME = "G";
    private static final String SUBMITTED_AS_CALLABLE = "c";
    private static final String THREAD_CONTEXT_DESCRIPTOR = "C";
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("D", Long.TYPE), new ObjectStreamField("I", Long.TYPE), new ObjectStreamField("F", Boolean.TYPE), new ObjectStreamField("T", String.class), new ObjectStreamField("G", String.class), new ObjectStreamField("c", Boolean.TYPE), new ObjectStreamField("C", byte[].class)};
    private static final Set<Class<?>> RESULT_TYPES = new HashSet();
    private transient long initialDelay = -1L;
    private transient long interval = -1L;
    private transient boolean submittedAsCallable;
    private transient boolean isFixedRate;
    private transient String nonserTaskClassName;
    private transient String nonserTriggerClassName;
    private transient ThreadContextDescriptor threadContext;
    private transient byte[] threadContextBytes;

    TaskInfo(boolean submittedAsCallable) {
        this.submittedAsCallable = submittedAsCallable;
    }

    public ThreadContextDescriptor deserializeThreadContext(Map<String, String> execProps) throws IOException, ClassNotFoundException {
        return this.threadContextBytes == null ? null : ThreadContextDeserializer.deserialize((byte[])this.threadContextBytes, execProps);
    }

    @Trivial
    public String getClassNameForNonSerializableTask() {
        return this.nonserTaskClassName;
    }

    @Trivial
    public String getClassNameForNonSerializableTrigger() {
        return this.nonserTriggerClassName;
    }

    @Trivial
    public long getInitialDelay() {
        return this.initialDelay;
    }

    @Trivial
    public long getInterval() {
        return this.interval;
    }

    @Trivial
    void initForNonSerializableTask(String className) {
        this.nonserTaskClassName = className;
    }

    @Trivial
    void initForNonSerializableTrigger(String className) {
        this.nonserTriggerClassName = className;
    }

    @Trivial
    void initForOneShotTask(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    @Trivial
    void initForRepeatingTask(boolean isFixedRate, long initialDelay, long interval) {
        this.initialDelay = initialDelay;
        this.interval = interval;
        this.isFixedRate = isFixedRate;
    }

    void initThreadContext(WSContextService contextSvc, Map<String, String> execProps) {
        this.threadContext = contextSvc.captureThreadContext(execProps, new Map[0]);
    }

    @Trivial
    public boolean isFixedRate() {
        return this.isFixedRate;
    }

    @Trivial
    public boolean isSubmittedAsCallable() {
        return this.submittedAsCallable;
    }

    @Trivial
    @ManualTrace
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"readObject", (Object[])new Object[0]);
        }
        ObjectInputStream.GetField fields = in.readFields();
        this.initialDelay = fields.get(INITIAL_DELAY, -1L);
        this.interval = fields.get(INTERVAL, -1L);
        this.isFixedRate = fields.get(IS_FIXED_RATE, false);
        this.nonserTaskClassName = (String)fields.get(NONSER_TASK_CLASS_NAME, null);
        this.nonserTriggerClassName = (String)fields.get(NONSER_TRIGGER_CLASS_NAME, null);
        this.submittedAsCallable = fields.get(SUBMITTED_AS_CALLABLE, false);
        this.threadContextBytes = (byte[])fields.get(THREAD_CONTEXT_DESCRIPTOR, null);
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"readObject", (Object)new Object[]{this.nonserTaskClassName, this.nonserTriggerClassName, "initial delay " + this.initialDelay, "interval " + this.interval, this.isFixedRate ? "fixed rate" : Boolean.valueOf(false), this.submittedAsCallable ? "callable" : "runnable", this.threadContextBytes == null ? null : Integer.valueOf(this.threadContextBytes.length)});
        }
    }

    @ManualTrace
    private void writeObject(ObjectOutputStream out) throws IOException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"writeObject", (Object[])new Object[]{this.nonserTaskClassName, this.nonserTriggerClassName, "initial delay " + this.initialDelay, "interval " + this.interval, this.isFixedRate ? "fixed rate" : Boolean.valueOf(false), this.submittedAsCallable ? "callable" : "runnable", this.threadContext});
        }
        if (this.threadContextBytes == null) {
            this.threadContextBytes = this.threadContext == null ? null : this.threadContext.serialize();
        }
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put(INITIAL_DELAY, this.initialDelay);
        fields.put(INTERVAL, this.interval);
        fields.put(IS_FIXED_RATE, this.isFixedRate);
        fields.put(NONSER_TASK_CLASS_NAME, this.nonserTaskClassName);
        fields.put(NONSER_TRIGGER_CLASS_NAME, this.nonserTriggerClassName);
        fields.put(SUBMITTED_AS_CALLABLE, this.submittedAsCallable);
        fields.put(THREAD_CONTEXT_DESCRIPTOR, this.threadContextBytes);
        out.writeFields();
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"writeObject");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        RESULT_TYPES.add(BigDecimal.class);
        RESULT_TYPES.add(BigInteger.class);
        RESULT_TYPES.add(Boolean.class);
        RESULT_TYPES.add(Byte.class);
        RESULT_TYPES.add(Character.class);
        RESULT_TYPES.add(Double.class);
        RESULT_TYPES.add(Float.class);
        RESULT_TYPES.add(Integer.class);
        RESULT_TYPES.add(Long.class);
        RESULT_TYPES.add(Short.class);
        RESULT_TYPES.add(String.class);
        RESULT_TYPES.add(StringBuffer.class);
        RESULT_TYPES.add(StringBuilder.class);
    }
}

