/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.h2internal.Constants;
import com.ibm.ws.http.channel.h2internal.FrameReadProcessor;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2ConnectionSettings;
import com.ibm.ws.http.channel.h2internal.H2HttpInboundLinkWrap;
import com.ibm.ws.http.channel.h2internal.H2MuxTCPReadCallback;
import com.ibm.ws.http.channel.h2internal.H2MuxTCPWriteCallback;
import com.ibm.ws.http.channel.h2internal.H2StreamProcessor;
import com.ibm.ws.http.channel.h2internal.H2VirtualConnectionImpl;
import com.ibm.ws.http.channel.h2internal.H2WorkQInterface;
import com.ibm.ws.http.channel.h2internal.H2WriteQEntry;
import com.ibm.ws.http.channel.h2internal.H2WriteTree;
import com.ibm.ws.http.channel.h2internal.ItemForCompletion;
import com.ibm.ws.http.channel.h2internal.StreamState;
import com.ibm.ws.http.channel.h2internal.exceptions.FlowControlException;
import com.ibm.ws.http.channel.h2internal.exceptions.Http2Exception;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.hpack.H2HeaderTable;
import com.ibm.ws.http.channel.h2internal.priority.Node;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundChannel;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundLink;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class H2InboundLink
extends HttpInboundLink {
    private static final TraceComponent tc = Tr.register(H2InboundLink.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    LINK_STATUS linkStatus = LINK_STATUS.INIT;
    READ_LINK_STATUS readLinkStatus = READ_LINK_STATUS.NOT_READING;
    WRITE_LINK_STATUS writeLinkStatus = WRITE_LINK_STATUS.NOT_WRITING;
    private ScheduledFuture<?> closeFuture = null;
    private H2ConnectionTimeout connTimeout = null;
    Object linkStatusSync = new Object(){};
    private int highestClientStreamId = 0;
    private int highestLocalStreamId = -1;
    boolean connection_preface_sent = false;
    boolean connection_preface_string_rcvd = false;
    public volatile CountDownLatch initLock = new CountDownLatch(1){};
    volatile long initialWindowSize = Constants.SPEC_INITIAL_WINDOW_SIZE;
    volatile long connectionReadWindowSize = Constants.SPEC_INITIAL_WINDOW_SIZE;
    volatile long maxReadWindowSize = Constants.SPEC_INITIAL_WINDOW_SIZE;
    FrameReadProcessor frameReadProcessor = null;
    H2MuxTCPReadCallback h2MuxReadCallback = null;
    TCPReadRequestContext h2MuxTCPReadContext = null;
    H2MuxTCPWriteCallback h2MuxWriteCallback = null;
    TCPWriteRequestContext h2MuxTCPWriteContext = null;
    WsByteBuffer slicedBuffer = null;
    ItemForCompletion readWaitingForCompletion = new ItemForCompletion();
    ItemForCompletion writeWaitingForCompletion = new ItemForCompletion();
    ConcurrentHashMap<Integer, H2StreamProcessor> streamTable = new ConcurrentHashMap();
    ConcurrentHashMap<Integer, H2StreamProcessor> closeTable = new ConcurrentHashMap();
    private static long CLOSE_TABLE_PURGE_TIME = 30000000000L;
    HttpInboundLink initialHttpInboundLink = null;
    VirtualConnection initialVC = null;
    HttpInboundChannel httpInboundChannel = null;
    TCPConnectionContext h2MuxTCPConnectionContext = null;
    HttpInboundServiceContextImpl h2MuxServiceContextImpl = null;
    H2ConnectionSettings connectionSettings;
    H2WorkQInterface writeQ = null;
    int h2NextPromisedStreamId = 0;
    private H2HeaderTable readContextTable = null;
    private H2HeaderTable writeContextTable = null;
    HttpChannelConfig config = null;
    private int readStackDepthCount = 0;
    private static final int READ_STACK_DEPTH_LIMIT = 64;
    int hcDebug = 0;
    private boolean continuationFrameExpected = false;

    public boolean isContinuationExpected() {
        return this.continuationFrameExpected;
    }

    public void setContinuationExpected(boolean expected) {
        this.continuationFrameExpected = expected;
    }

    public H2InboundLink(HttpInboundChannel channel, VirtualConnection vc, TCPConnectionContext tcc) {
        super(channel, vc);
        this.initialVC = vc;
        this.httpInboundChannel = channel;
        this.frameReadProcessor = new FrameReadProcessor(this);
        this.h2MuxReadCallback = new H2MuxTCPReadCallback();
        this.h2MuxWriteCallback = new H2MuxTCPWriteCallback();
        this.h2MuxReadCallback.setConnLinkCallback(this);
        this.h2MuxTCPConnectionContext = tcc;
        this.h2MuxTCPReadContext = tcc.getReadInterface();
        this.h2MuxTCPWriteContext = tcc.getWriteInterface();
        this.connectionSettings = new H2ConnectionSettings();
        this.config = channel.getHttpConfig();
        this.connectionReadWindowSize = this.maxReadWindowSize = (long)this.config.getH2ConnReadWindowSize();
        this.writeQ = new H2WriteTree();
        this.writeQ.init(this.h2MuxTCPWriteContext, this.h2MuxWriteCallback);
        this.readContextTable = new H2HeaderTable();
        this.writeContextTable = new H2HeaderTable();
        this.hcDebug = ((Object)((Object)this)).hashCode();
    }

    public synchronized long getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public H2StreamProcessor createNewInboundLink(Integer streamID) {
        if ((streamID & 1) == 0) {
            if (streamID > this.highestLocalStreamId) {
                this.highestLocalStreamId = streamID;
            }
        } else if (streamID > this.highestClientStreamId) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("highestClientStreamId set to stream-id: " + streamID), (Object[])new Object[0]);
            }
            this.highestClientStreamId = streamID;
        }
        H2VirtualConnectionImpl h2VC = new H2VirtualConnectionImpl(this.initialVC);
        h2VC.getStateMap().remove("HttpDispatcherLink");
        H2HttpInboundLinkWrap link = new H2HttpInboundLinkWrap(this.httpInboundChannel, h2VC, streamID, this);
        H2StreamProcessor stream = new H2StreamProcessor(streamID, link, this);
        this.writeQ.addNewNodeToQ(streamID, Node.ROOT_STREAM_ID, Node.DEFAULT_NODE_PRIORITY, false);
        this.streamTable.put(streamID, stream);
        return stream;
    }

    public TCPConnectionContext getTCPConnectionContext() {
        return this.h2MuxTCPConnectionContext;
    }

    public void processConnectionPrefaceMagic() {
        this.connection_preface_string_rcvd = true;
        H2StreamProcessor controlStream = this.createNewInboundLink(0);
        controlStream.completeConnectionPreface();
        this.connection_preface_sent = true;
    }

    @Override
    public void ready(VirtualConnection inVC) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ready called illegally!", (Object[])new Object[0]);
        }
    }

    @Override
    protected void processRequest() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"processRequest called illegally!", (Object[])new Object[0]);
        }
    }

    public boolean handleHTTP2UpgradeRequest(Map<String, String> headers, HttpInboundLink link) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleHTTP2UpgradeRequest entry", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleHTTP2UpgradeRequest, sending 101 response", (Object[])new Object[0]);
        }
        link.getHTTPContext().send101SwitchingProtocol("h2c");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleHTTP2UpgradeRequest, sent 101 response", (Object[])new Object[0]);
        }
        Integer streamID = new Integer(1);
        H2VirtualConnectionImpl h2VC = new H2VirtualConnectionImpl(this.initialVC);
        h2VC.getStateMap().remove("HttpDispatcherLink");
        H2HttpInboundLinkWrap wrap = new H2HttpInboundLinkWrap(this.httpInboundChannel, h2VC, streamID, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleHTTP2UpgradeRequest, creating stream processor", (Object[])new Object[0]);
        }
        H2StreamProcessor streamProcessor = new H2StreamProcessor(streamID, wrap, this, StreamState.HALF_CLOSED_REMOTE);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("handleHTTP2UpgradeRequest, created stream processor : " + streamProcessor), (Object[])new Object[0]);
        }
        this.writeQ.addNewNodeToQ(streamID, Node.ROOT_STREAM_ID, Node.DEFAULT_NODE_PRIORITY, false);
        this.streamTable.put(streamID, streamProcessor);
        this.highestClientStreamId = streamID;
        String settings = headers.get("HTTP2-Settings");
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("handleHTTP2UpgradeRequest, processing upgrade header settings : " + settings), (Object[])new Object[0]);
            }
            this.getConnectionSettings().processUpgradeHeaderSettings(settings);
        }
        catch (ProtocolException e1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"handleHTTP2UpgradeRequest an error occurred processing the settings during connection initialization", (Object[])new Object[0]);
            }
            return false;
        }
        this.initialHttpInboundLink = link;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("handleHTTP2UpgradeRequest, reinit the link : " + (Object)((Object)link)), (Object[])new Object[0]);
        }
        link.reinit(wrap.getConnectionContext(), wrap.getVirtualConnection(), wrap);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleHTTP2UpgradeRequest, exit", (Object[])new Object[0]);
        }
        return true;
    }

    public void startAsyncRead(boolean newFrame) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("startAsyncRead entry; newframe = " + newFrame), (Object[])new Object[0]);
        }
        if (newFrame) {
            this.frameReadProcessor.reset(true);
        }
        if (this.slicedBuffer != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("startAsyncRead reading slicedBuffer length: " + this.slicedBuffer.limit()), (Object[])new Object[0]);
            }
            this.slicedBuffer.position(this.slicedBuffer.limit());
            this.h2MuxTCPReadContext.setBuffer(this.slicedBuffer);
            this.slicedBuffer = null;
            if (this.readStackDepthCount < 64) {
                ++this.readStackDepthCount;
                this.h2MuxReadCallback.complete(this.initialVC, this.h2MuxTCPReadContext);
            } else {
                ExecutorService executorService = CHFWBundle.getExecutorService();
                AsyncCallback ac = new AsyncCallback();
                this.readStackDepthCount = 0;
                executorService.execute(ac);
            }
            return;
        }
        WsByteBufferPoolManager mgr = HttpDispatcher.getBufferManager();
        WsByteBuffer buf = mgr.allocate(8192);
        this.h2MuxTCPReadContext.setBuffer(buf);
        boolean forceQueue = true;
        int numBytes = 1;
        this.readStackDepthCount = 0;
        this.h2MuxTCPReadContext.read((long)numBytes, (TCPReadCompletedCallback)this.h2MuxReadCallback, forceQueue, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRead(VirtualConnection vc, TCPReadRequestContext rrc) {
        boolean readForNewFrame = true;
        Object object = this.linkStatusSync;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processRead: :linkStatus: " + (Object)((Object)this.linkStatus) + " writeLinkStatus: " + (Object)((Object)this.writeLinkStatus) + " H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
            }
            if (this.writeLinkStatus == WRITE_LINK_STATUS.WRITE_IN_PROGRESS || this.linkStatus == LINK_STATUS.CLOSING || this.linkStatus == LINK_STATUS.GOAWAY_SENDING) {
                this.readWaitingForCompletion.setReadComplete(vc, rrc);
                return;
            }
            this.readLinkStatus = READ_LINK_STATUS.PROCESSING_READ;
            if (this.closeFuture != null) {
                boolean result = this.closeFuture.cancel(false);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processRead: closeFuture detected while processing a read :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
                if (!result) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("processRead: could not cancel closeFuture :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                    }
                    return;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processRead: cancelled successful, remove closeFuture :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
                this.closeFuture = null;
                this.connTimeout = null;
            }
        }
        int frameReadStatus = 0;
        WsByteBuffer nextBuffer = rrc.getBuffer();
        nextBuffer.flip();
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processRead: next buffer length: " + nextBuffer.limit()), (Object[])new Object[0]);
            }
            if ((frameReadStatus = this.frameReadProcessor.processNextBuffer(nextBuffer)) == -2) {
                readForNewFrame = false;
            } else {
                if (frameReadStatus > 0) {
                    int oldPosition = nextBuffer.position();
                    this.slicedBuffer = nextBuffer.position(frameReadStatus).slice();
                    nextBuffer.position(oldPosition);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"processRead: process complete frame", (Object[])new Object[0]);
                }
                this.frameReadProcessor.processCompleteFrame();
            }
        }
        catch (Http2Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processRead: an error occurred processing a frame: " + e.getErrorString()), (Object[])new Object[0]);
            }
            try {
                this.getStreamProcessor(0).sendGOAWAYFrame(e);
            }
            catch (ProtocolException protocolException) {
                // empty catch block
            }
        }
        finally {
            boolean doRead = false;
            Object object2 = this.linkStatusSync;
            synchronized (object2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processRead: check to arm read: :linkStatus: " + (Object)((Object)this.linkStatus) + " H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
                this.readWaitingForCompletion.reset();
                if (this.linkStatus != LINK_STATUS.CLOSING && this.linkStatus != LINK_STATUS.GOAWAY_SENDING) {
                    this.readLinkStatus = READ_LINK_STATUS.READ_OUTSTANDING;
                    doRead = true;
                }
            }
            if (doRead) {
                this.startAsyncRead(readForNewFrame);
            }
        }
    }

    public H2StreamProcessor getStreamProcessor(Integer sID) {
        H2StreamProcessor p = null;
        p = this.streamTable.get(sID);
        return p;
    }

    public void destroy() {
        this.httpInboundChannel.stop(50L);
        this.initialVC = null;
        this.frameReadProcessor = null;
        this.h2MuxReadCallback = null;
        this.h2MuxTCPConnectionContext = null;
        this.h2MuxTCPReadContext = null;
        this.h2MuxTCPWriteContext = null;
        this.connectionSettings = null;
        this.readContextTable = null;
        this.writeContextTable = null;
        super.destroy();
    }

    public void writeSync(WsByteBuffer buf, WsByteBuffer[] bufs, long numBytes, int timeout, FrameTypes fType, int payloadLength, int streamID) throws IOException, FlowControlException {
        H2WorkQInterface.WRITE_ACTION action = H2WorkQInterface.WRITE_ACTION.NOT_SET;
        if (buf != null && bufs != null) {
            IOException up = new IOException("Internal error - incorrect buffers specified");
            throw up;
        }
        H2WriteQEntry e = new H2WriteQEntry(buf, bufs, numBytes, timeout, H2WriteQEntry.WRITE_TYPE.SYNC, fType, payloadLength, streamID);
        e.armWriteCompleteLatch();
        action = this.writeQ.writeOrAddToQ(e);
        if (action == H2WorkQInterface.WRITE_ACTION.QUEUED) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"writeSync - call entry.waitWriteCompleteLatch", (Object[])new Object[0]);
            }
            e.waitWriteCompleteLatch();
        }
    }

    public synchronized int getNextPromisedStreamId() {
        this.h2NextPromisedStreamId += 2;
        return this.h2NextPromisedStreamId;
    }

    public H2HeaderTable getReadTable() {
        return this.readContextTable;
    }

    public H2HeaderTable getWriteTable() {
        return this.writeContextTable;
    }

    public H2WorkQInterface getWorkQ() {
        return this.writeQ;
    }

    public void incrementConnectionWindowUpdateLimit(int x) throws FlowControlException {
        this.writeQ.incrementConnectionWindowUpdateLimit(x);
    }

    public synchronized void changeInitialWindowSizeAllStreams(int newSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("changeInitialWindowSizeAllStreams entry: newSize: " + newSize), (Object[])new Object[0]);
        }
        this.initialWindowSize = newSize;
        for (Integer i : this.streamTable.keySet()) {
            H2StreamProcessor stream = this.streamTable.get(i);
            stream.updateInitialWindowsUpdateSize(newSize);
        }
    }

    public H2ConnectionSettings getConnectionSettings() {
        return this.connectionSettings;
    }

    public void cleanupStream(int streamID) {
        this.streamTable.remove(streamID);
        this.writeQ.removeNodeFromQ(streamID);
    }

    @Override
    public void destroy(Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"destroy entry", (Object[])new Object[0]);
        }
        for (Integer i : this.streamTable.keySet()) {
            H2StreamProcessor stream = this.streamTable.get(i);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("destroying " + stream + ", " + stream.myID), (Object[])new Object[0]);
            }
            if (stream.myID == 0) continue;
            stream.h2HttpInboundLinkWrap.destroy(e);
        }
        this.initialVC = null;
        this.frameReadProcessor = null;
        this.h2MuxReadCallback = null;
        this.h2MuxTCPConnectionContext = null;
        this.h2MuxTCPReadContext = null;
        this.h2MuxTCPWriteContext = null;
        this.connectionSettings = null;
        this.readContextTable = null;
        this.writeContextTable = null;
        super.destroy(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setStatusLinkToGoAwaySending() {
        Object object = this.linkStatusSync;
        synchronized (object) {
            if (this.linkStatus != LINK_STATUS.CLOSING) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setStatusLinkToGoAwaySending: setting :linkStatus: to GOAWAY_SENDING:close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
                this.linkStatus = LINK_STATUS.GOAWAY_SENDING;
                return true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setStatusLinkToGoAwaySending: return without setting status since :linkstatus: is " + (Object)((Object)this.linkStatus) + " :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnectionLink(Exception exceptionForCloseFromHere) {
        boolean closeFromHere = false;
        Object object = this.linkStatusSync;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("closeConnectionLink: :linkstatus: is: " + (Object)((Object)this.linkStatus) + " :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
            }
            if (this.linkStatus == LINK_STATUS.CLOSING) {
                return;
            }
            if (this.closeFuture == null) {
                closeFromHere = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("closeConnectionLink: no closeFuture, so closing down from here :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
            } else if (!this.closeFuture.isDone()) {
                closeFromHere = this.closeFuture.cancel(false);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("closeConnectionLink: closeFuture.cancel returned: " + closeFromHere + " :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
            }
            if (closeFromHere) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("closeConnectionLink: close the device link now. setting :linkStatus: to CLOSING :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
                this.linkStatus = LINK_STATUS.CLOSING;
                if (exceptionForCloseFromHere != null && this.connTimeout != null) {
                    exceptionForCloseFromHere = this.connTimeout.e;
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("closeConnectionLink: another thread will close :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
            }
        }
        if (closeFromHere) {
            ConnectionLink deviceLink = this.initialHttpInboundLink.getDeviceLink();
            if (deviceLink != null) {
                try {
                    this.initialHttpInboundLink.getDeviceLink().close(this.initialVC, exceptionForCloseFromHere);
                }
                catch (Throwable x) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("closeConnectionLink: could not close, :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode() + " device link close caught: " + x), (Object[])new Object[0]);
                        StringBuffer sb = new StringBuffer();
                        StackTraceElement[] trace = x.getStackTrace();
                        for (int i = 0; i < trace.length; ++i) {
                            sb.append(" " + trace[i] + "\r\n");
                        }
                        sb.append("");
                        String s = sb.toString();
                        Tr.debug((TraceComponent)tc, (String)("closeConnectionLink: " + s), (Object[])new Object[0]);
                    }
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("closeConnectionLink: could not close, device link was null :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIfGoAwaySendingOrClosing() {
        Object object = this.linkStatusSync;
        synchronized (object) {
            if (this.linkStatus != LINK_STATUS.CLOSING && this.linkStatus != LINK_STATUS.GOAWAY_SENDING) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checkifGoAwaySending() returning false :linkstatus: " + (Object)((Object)this.linkStatus)), (Object[])new Object[0]);
                }
                return false;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkifGoAwaySending() returning true :linkstatus: " + (Object)((Object)this.linkStatus)), (Object[])new Object[0]);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkInitAndOpen() {
        Object object = this.linkStatusSync;
        synchronized (object) {
            if (this.linkStatus == LINK_STATUS.INIT) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checkInitAndOpen: connection preface completed, set :linkStatus: to OPEN H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
                this.linkStatus = LINK_STATUS.OPEN;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(VirtualConnection inVC, Exception e) {
        Object object = this.linkStatusSync;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("close(vc,e): :linkstatus: is: " + (Object)((Object)this.linkStatus) + " :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
            }
            if (this.linkStatus == LINK_STATUS.CLOSING || this.linkStatus == LINK_STATUS.GOAWAY_SENDING || this.linkStatus == LINK_STATUS.WAIT_TO_SEND_GOAWAY) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("close(vc,e): returning: close of muxLink is being done on a differnt thread :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
                return;
            }
            if (e == null) {
                for (Integer i : this.streamTable.keySet()) {
                    H2StreamProcessor stream = this.streamTable.get(i);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("close(vc,e): looking at stream: " + stream.myID), (Object[])new Object[0]);
                    }
                    if (stream.myID != 0 && !stream.isHalfClosed() && !stream.isStreamClosed() && this.highestLocalStreamId > -1) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("close(vc,e): stream not ready to close: " + stream.myID + " :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                    }
                    return;
                }
            }
            this.linkStatus = LINK_STATUS.WAIT_TO_SEND_GOAWAY;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("close(vc,e): loading up the wait to close timeout :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
            }
            ScheduledExecutorService scheduler = CHFWBundle.getScheduledExecutorService();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("close : scheduler : " + scheduler + " config : " + this.config), (Object[])new Object[0]);
            }
            this.connTimeout = new H2ConnectionTimeout(this.initialVC, e);
            if (e == null) {
                this.closeFuture = scheduler.schedule(this.connTimeout, this.config.getH2ConnCloseTimeout(), TimeUnit.SECONDS);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("close(vc,e): close on link called with exception: " + e), (Object[])new Object[0]);
                }
                this.connTimeout.run();
            }
        }
    }

    public void triggerStreamClose(H2StreamProcessor streamProcessor) {
        if (this.closeTable.size() >= 512) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"triggerStreamClose : close table size greater than or equal to 512, purge the table of old entries", (Object[])new Object[0]);
            }
            this.purgeCloseTable();
        }
        streamProcessor.setCloseTime(System.nanoTime());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("triggerStreamClose : move stream into close table.  stream-id: " + streamProcessor.myID), (Object[])new Object[0]);
        }
        this.closeTable.put(streamProcessor.myID, streamProcessor);
        this.streamTable.remove(streamProcessor.myID);
    }

    public H2StreamProcessor getStream(int streamID) {
        H2StreamProcessor streamProcessor = null;
        streamProcessor = this.streamTable.get(streamID);
        if (streamProcessor == null) {
            streamProcessor = this.closeTable.get(streamID);
        }
        return streamProcessor;
    }

    public boolean significantlyPastCloseTime(int streamID) {
        if (this.streamTable.contains(streamID)) {
            return false;
        }
        if (this.closeTable.containsKey(streamID)) {
            H2StreamProcessor streamProcessor = this.closeTable.get(streamID);
            if (streamProcessor.getCloseTime() != 0L) {
                long diff = System.nanoTime() - streamProcessor.getCloseTime();
                if (diff > CLOSE_TABLE_PURGE_TIME) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("stream-id: " + streamID + " closed and significantly past the close time, close time: " + streamProcessor.getCloseTime() + " now: " + System.nanoTime() + " diff: " + diff), (Object[])new Object[0]);
                    }
                    this.closeTable.remove(streamID);
                    return true;
                }
                return false;
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Stream ID: " + streamID + " not in stream or close table"), (Object[])new Object[0]);
        }
        return true;
    }

    public void purgeCloseTable() {
        long now = System.nanoTime();
        for (Map.Entry<Integer, H2StreamProcessor> entry : this.closeTable.entrySet()) {
            if (entry.getValue().getCloseTime() + CLOSE_TABLE_PURGE_TIME >= now) continue;
            this.closeTable.remove(entry.getKey());
        }
    }

    public int getHighestClientStreamId() {
        return this.highestClientStreamId;
    }

    private class H2ConnectionTimeout
    implements Runnable {
        private final VirtualConnection vc;
        private final Exception e;

        public H2ConnectionTimeout(VirtualConnection inVC, Exception inE) {
            this.vc = inVC;
            this.e = inE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = H2InboundLink.this.linkStatusSync;
            synchronized (object) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("H2ConnectionTimeout-run: timeout has elapsed, look to close connection. :linkStatus: " + (Object)((Object)H2InboundLink.this.linkStatus) + " :close: H2InboundLink hc: " + H2InboundLink.this.hcDebug), (Object[])new Object[0]);
                }
                if (H2InboundLink.this.linkStatus != LINK_STATUS.WAIT_TO_SEND_GOAWAY) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("H2ConnectionTimeout-run: timeout too late - close being handled on another thread :close: H2InboundLink hc: " + H2InboundLink.this.hcDebug), (Object[])new Object[0]);
                    }
                    return;
                }
                H2InboundLink.this.linkStatus = LINK_STATUS.GOAWAY_SENDING;
            }
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("H2ConnectionTimeout-run: sending GOAWAY Frame :close: H2InboundLink hc: " + H2InboundLink.this.hcDebug), (Object[])new Object[0]);
                }
                H2InboundLink.this.streamTable.get(0).sendGOAWAYFrame(new Http2Exception("the http2 connection has timed out"));
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("H2ConnectionTimeout-run: exeception received while sending GOAWAY:  :close: H2InboundLink hc: " + H2InboundLink.this.hcDebug + " " + e), (Object[])new Object[0]);
                }
            }
            finally {
                boolean closeFromHere = false;
                Object deviceLink = H2InboundLink.this.linkStatusSync;
                synchronized (deviceLink) {
                    if (H2InboundLink.this.linkStatus != LINK_STATUS.CLOSING) {
                        H2InboundLink.this.linkStatus = LINK_STATUS.CLOSING;
                        closeFromHere = true;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("H2ConnectionTimeout-run: closefromeHere: " + closeFromHere + " :close: H2InboundLink hc: " + H2InboundLink.this.hcDebug), (Object[])new Object[0]);
                }
                if (closeFromHere) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("H2ConnectionTimeout-run: set :linkStatus: to CLOSING and close the device link :close: H2InboundLink hc: " + H2InboundLink.this.hcDebug), (Object[])new Object[0]);
                    }
                    if ((deviceLink = H2InboundLink.this.initialHttpInboundLink.getDeviceLink()) != null) {
                        H2InboundLink.this.initialHttpInboundLink.getDeviceLink().close(this.vc, this.e);
                    }
                }
            }
        }
    }

    protected class AsyncCallback
    implements Runnable {
        protected AsyncCallback() {
        }

        @Override
        public void run() {
            block3: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"doing async callback internally on a new thread", (Object[])new Object[0]);
                }
                try {
                    H2InboundLink.this.h2MuxReadCallback.complete(H2InboundLink.this.initialVC, H2InboundLink.this.h2MuxTCPReadContext);
                }
                catch (Throwable t) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("caught a Throwable. log and leave: " + t), (Object[])new Object[0]);
                }
            }
        }
    }

    public static enum WRITE_LINK_STATUS {
        NOT_WRITING,
        WRITE_IN_PROGRESS;

    }

    public static enum READ_LINK_STATUS {
        NOT_READING,
        READ_OUTSTANDING,
        PROCESSING_READ;

    }

    public static enum LINK_STATUS {
        INIT,
        OPEN,
        WAIT_TO_SEND_GOAWAY,
        GOAWAY_SENDING,
        CLOSING;

    }
}

