/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.frames;

import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.FrameContinuation;
import com.ibm.ws.http.channel.h2internal.frames.FrameData;
import com.ibm.ws.http.channel.h2internal.frames.FrameGoAway;
import com.ibm.ws.http.channel.h2internal.frames.FrameHeaders;
import com.ibm.ws.http.channel.h2internal.frames.FramePing;
import com.ibm.ws.http.channel.h2internal.frames.FramePriority;
import com.ibm.ws.http.channel.h2internal.frames.FramePushPromise;
import com.ibm.ws.http.channel.h2internal.frames.FrameRstStream;
import com.ibm.ws.http.channel.h2internal.frames.FrameSettings;
import com.ibm.ws.http.channel.h2internal.frames.FrameWindowUpdate;

public class FrameFactory {
    public static Frame getFrame(byte frameType, int streamId, int payloadLength, byte flags, boolean reserveBit, Frame.FrameDirection direction) {
        FrameTypes frameTypeWrite = FrameFactory.getFrameType(frameType);
        switch (frameTypeWrite) {
            case DATA: {
                return new FrameData(streamId, payloadLength, flags, reserveBit, direction);
            }
            case HEADERS: {
                return new FrameHeaders(streamId, payloadLength, flags, reserveBit, direction);
            }
            case PRIORITY: {
                return new FramePriority(streamId, payloadLength, flags, reserveBit, direction);
            }
            case RST_STREAM: {
                return new FrameRstStream(streamId, payloadLength, flags, reserveBit, direction);
            }
            case SETTINGS: {
                return new FrameSettings(streamId, payloadLength, flags, reserveBit, direction);
            }
            case PUSH_PROMISE: {
                return new FramePushPromise(streamId, payloadLength, flags, reserveBit, direction);
            }
            case CONTINUATION: {
                return new FrameContinuation(streamId, payloadLength, flags, reserveBit, direction);
            }
            case PING: {
                return new FramePing(streamId, payloadLength, flags, reserveBit, direction);
            }
            case GOAWAY: {
                return new FrameGoAway(streamId, payloadLength, flags, reserveBit, direction);
            }
            case WINDOW_UPDATE: {
                return new FrameWindowUpdate(streamId, payloadLength, flags, reserveBit, direction);
            }
        }
        return null;
    }

    public static FrameTypes getFrameType(byte byteFrameType) {
        if (byteFrameType == 0) {
            return FrameTypes.DATA;
        }
        if (byteFrameType == 1) {
            return FrameTypes.HEADERS;
        }
        if (byteFrameType == 2) {
            return FrameTypes.PRIORITY;
        }
        if (byteFrameType == 3) {
            return FrameTypes.RST_STREAM;
        }
        if (byteFrameType == 4) {
            return FrameTypes.SETTINGS;
        }
        if (byteFrameType == 5) {
            return FrameTypes.PUSH_PROMISE;
        }
        if (byteFrameType == 6) {
            return FrameTypes.PING;
        }
        if (byteFrameType == 7) {
            return FrameTypes.GOAWAY;
        }
        if (byteFrameType == 8) {
            return FrameTypes.WINDOW_UPDATE;
        }
        if (byteFrameType == 9) {
            return FrameTypes.CONTINUATION;
        }
        return FrameTypes.UNKNOWN;
    }
}

