/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.frames;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.h2internal.FrameReadProcessor;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2ConnectionSettings;
import com.ibm.ws.http.channel.h2internal.exceptions.FrameSizeException;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.utils;

public class FrameRstStream
extends Frame {
    private int errorCode;

    public FrameRstStream(int streamId, int payloadLength, byte flags, boolean reserveBit, Frame.FrameDirection direction) {
        super(streamId, payloadLength, flags, reserveBit, direction);
        this.frameType = FrameTypes.RST_STREAM;
    }

    public FrameRstStream(int streamId, int errorCode, boolean reserveBit) {
        super(streamId, 4, (byte)0, reserveBit, Frame.FrameDirection.WRITE);
        this.frameType = FrameTypes.RST_STREAM;
        this.errorCode = errorCode;
        this.setInitialized();
    }

    @Override
    public void processPayload(FrameReadProcessor frp) throws FrameSizeException {
        this.errorCode = frp.grabNext32BitInt();
    }

    @Override
    public byte[] buildFrameForWrite() {
        byte[] frame = super.buildFrameForWrite();
        this.setFrameHeaders(frame, (byte)3);
        int frameIndex = 9;
        utils.Move32BitstoByteArray(this.errorCode, frame, frameIndex);
        return frame;
    }

    @Override
    public void validate(H2ConnectionSettings settings) throws ProtocolException {
        if (this.streamId == 0) {
            throw new ProtocolException("RST_STREAM frame stream ID cannot be 0x0");
        }
    }

    @Override
    protected void setFlags() {
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FrameRstStream)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"equals: object is not a FrameRstStream", (Object[])new Object[0]);
            }
            return false;
        }
        FrameRstStream frameRstStreamToCompare = (FrameRstStream)object;
        if (!super.equals(frameRstStreamToCompare)) {
            return false;
        }
        if (this.getErrorCode() != frameRstStreamToCompare.getErrorCode()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("this.getErrorCode() = " + this.getErrorCode() + " frameRstStreamToCompare.getErrorCode() = " + frameRstStreamToCompare.getErrorCode()), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder frameToString = new StringBuilder();
        frameToString.append(super.toString());
        frameToString.append("ErrorCode: " + this.getErrorCode() + "\n");
        return frameToString.toString();
    }
}

