/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.hpack;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.h2internal.exceptions.CompressionException;
import com.ibm.ws.http.channel.h2internal.hpack.H2HeaderField;
import com.ibm.ws.http.channel.h2internal.hpack.H2HeaderTable;
import com.ibm.ws.http.channel.h2internal.hpack.HpackConstants;
import com.ibm.ws.http.channel.h2internal.hpack.HpackUtils;
import com.ibm.ws.http.channel.h2internal.hpack.IntegerRepresentation;
import com.ibm.ws.http.channel.h2internal.huffman.HuffmanDecoder;
import com.ibm.ws.http.channel.h2internal.huffman.HuffmanEncoder;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;

public class H2Headers {
    private static final TraceComponent tc = Tr.register(H2Headers.class, (String)"GenericBNF", null);

    public static H2HeaderField decodeHeader(WsByteBuffer buffer, H2HeaderTable table) throws CompressionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"decodeHeader", (Object[])new Object[0]);
        }
        if (!table.isDynamicTableValid()) {
            throw new CompressionException("The context for this dynamic table is not valid.");
        }
        if (buffer == null || !buffer.hasRemaining()) {
            throw new CompressionException("Invalid attempt to decode empty or null buffer.");
        }
        byte currentByte = buffer.get();
        buffer.position(buffer.position() - 1);
        byte maskedByte = HpackUtils.format(currentByte, HpackConstants.MASK_0F);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Operation Byte: " + HpackUtils.byteToHexString(currentByte)), (Object[])new Object[0]);
        }
        int decodedInteger = 0;
        H2HeaderField header = null;
        if (maskedByte < HpackConstants.MASK_00) {
            if (currentByte == HpackConstants.MASK_80) {
                throw new CompressionException("An indexed header cannot have an index of 0");
            }
            decodedInteger = IntegerRepresentation.decode(buffer, HpackConstants.ByteFormatType.INDEXED);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Operation byte indicated header is already indexed at index location: " + decodedInteger + ". Searching table..."), (Object[])new Object[0]);
            }
            header = table.getHeaderEntry(decodedInteger);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found header: [" + header.getName() + ", " + header.getValue() + "]"), (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"decodeHeader");
            }
            return header;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Header not fully indexed in table, determining indexing type.", (Object[])new Object[0]);
        }
        if (maskedByte >= HpackConstants.MASK_4F) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Indexing decode type: INCREMENTAL", (Object[])new Object[0]);
            }
            header = H2Headers.decodeHeader(buffer, table, HpackConstants.ByteFormatType.INCREMENTAL);
        } else if (maskedByte < HpackConstants.MASK_2F) {
            if (maskedByte == HpackConstants.MASK_1F) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Indexing decode type: NEVERINDEX", (Object[])new Object[0]);
                }
                header = H2Headers.decodeHeader(buffer, table, HpackConstants.ByteFormatType.NEVERINDEX);
            } else if (maskedByte == HpackConstants.MASK_0F) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Indexing decode type: NOINDEXING", (Object[])new Object[0]);
                }
                header = H2Headers.decodeHeader(buffer, table, HpackConstants.ByteFormatType.NOINDEXING);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Decoded the header: [" + header.getName() + ", " + header.getValue() + "]"), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"decodeHeader");
        }
        return header;
    }

    private static H2HeaderField decodeHeader(WsByteBuffer buffer, H2HeaderTable table, HpackConstants.ByteFormatType type) throws CompressionException {
        String decodedName;
        int integerLength = 0;
        integerLength = IntegerRepresentation.decode(buffer, type);
        if (integerLength > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Operation byte indicates header name is indexed at location " + integerLength + ". Searching table for header name..."), (Object[])new Object[0]);
            }
            decodedName = table.getHeaderEntry(integerLength).getName();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Decoding header name.", (Object[])new Object[0]);
            }
            if (!HpackUtils.isAllLower(decodedName = H2Headers.decodeFragment(buffer))) {
                throw new CompressionException("Header field names must not contain uppercase characters. Decoded header name: " + decodedName);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Decoding header value.", (Object[])new Object[0]);
        }
        String decodedValue = H2Headers.decodeFragment(buffer);
        H2HeaderField header = new H2HeaderField(decodedName, decodedValue);
        if (type == HpackConstants.ByteFormatType.INCREMENTAL) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Incremental indexing: adding decoded header to table.", (Object[])new Object[0]);
            }
            table.addHeaderEntry(header);
        }
        return header;
    }

    private static String decodeFragment(WsByteBuffer buffer) throws CompressionException {
        boolean huffman;
        String decodedResult = null;
        byte currentByte = buffer.get();
        buffer.position(buffer.position() - 1);
        boolean bl = huffman = HpackUtils.getBit(currentByte, 7) == 1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Decoding using huffman encoding: " + huffman), (Object[])new Object[0]);
        }
        int fragmentLength = IntegerRepresentation.decode(buffer, HpackConstants.ByteFormatType.HUFFMAN);
        byte[] bytes = new byte[fragmentLength];
        buffer.get(bytes);
        if (huffman) {
            HuffmanDecoder decoder = new HuffmanDecoder();
            bytes = decoder.convertHuffmanToAscii(bytes);
        }
        decodedResult = new String(bytes, Charset.forName("US-ASCII"));
        return decodedResult;
    }

    public static byte[] encodeHeader(H2HeaderTable table, String name, String value, HpackConstants.LiteralIndexType type) throws CompressionException, IOException {
        return H2Headers.encodeHeader(table, name, value, type, true);
    }

    public static byte[] encodeHeader(H2HeaderTable table, String name, String value, HpackConstants.LiteralIndexType type, boolean huffman) throws CompressionException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"encodeHeader", (Object[])new Object[]{"Encoding [" + name + ", value"});
        }
        if (table == null || !table.isDynamicTableValid()) {
            throw new CompressionException("The context for this dynamic table is not valid.");
        }
        ByteArrayOutputStream encodedHeader = new ByteArrayOutputStream();
        String compliantName = name.toLowerCase();
        int indexLocation = 0;
        H2HeaderField indexedHeader = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Searching in table for header...", (Object[])new Object[0]);
        }
        if ((indexedHeader = table.getHeaderEntry(compliantName, value)) != null) {
            indexLocation = indexedHeader.getCurrentIndex();
            if (indexedHeader.getValueHash() == value.hashCode()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Header name and value found in table at index location: " + indexLocation + ". Encoding header as INDEXED."), (Object[])new Object[0]);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"encodeHeader");
                }
                return IntegerRepresentation.encode(indexLocation, HpackConstants.ByteFormatType.INDEXED);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found header name in table at location: " + indexLocation + "."), (Object[])new Object[0]);
            }
        }
        encodedHeader.write(IntegerRepresentation.encode(indexLocation, type));
        if (indexLocation == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Header name not found in table, encoding header name...", (Object[])new Object[0]);
            }
            H2Headers.encodeFragment(encodedHeader, compliantName, huffman);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Encoding header value...", (Object[])new Object[0]);
        }
        H2Headers.encodeFragment(encodedHeader, value, huffman);
        if (type == HpackConstants.LiteralIndexType.INDEX) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Incremental indexing: adding encoded header to table.", (Object[])new Object[0]);
            }
            table.addHeaderEntry(new H2HeaderField(compliantName, value));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"encodeHeader");
        }
        return encodedHeader.toByteArray();
    }

    private static void encodeFragment(ByteArrayOutputStream encodedHeader, String headerFragment, boolean huffman) throws CompressionException, IOException {
        byte[] fragmentBytes = headerFragment.getBytes("US-ASCII");
        HpackConstants.ByteFormatType encodingType = HpackConstants.ByteFormatType.NOHUFFMAN;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Encoding using huffman encoding: " + huffman), (Object[])new Object[0]);
        }
        if (huffman) {
            fragmentBytes = HuffmanEncoder.convertAsciiToHuffman(fragmentBytes);
            encodingType = HpackConstants.ByteFormatType.HUFFMAN;
        }
        encodedHeader.write(IntegerRepresentation.encode(fragmentBytes.length, encodingType));
        encodedHeader.write(fragmentBytes);
    }
}

