/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.schemagen.internal;

import com.ibm.websphere.metatype.SchemaGenerator;
import com.ibm.websphere.metatype.SchemaGeneratorOptions;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.schemagen.internal.IndentingXMLStreamWriter;
import com.ibm.ws.config.schemagen.internal.SchemaWriter;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.equinox.metatype.EquinoxMetaTypeInformation;
import org.eclipse.equinox.metatype.EquinoxMetaTypeService;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.metatype.MetaTypeInformation;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SchemaGeneratorImpl
implements SchemaGenerator {
    private EquinoxMetaTypeService metaTypeService;
    ComponentContext ctxt;
    static final long serialVersionUID = 1378689510174486062L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void activate(ComponentContext ctxt) throws Exception {
        this.ctxt = ctxt;
    }

    public void generate(OutputStream out, SchemaGeneratorOptions options) throws IOException {
        String encoding = options.getEncoding();
        OutputStreamWriter writer = encoding == null ? new OutputStreamWriter(out) : new OutputStreamWriter(out, encoding);
        this.generate(writer, options);
    }

    /*
     * WARNING - void declaration
     */
    public void generate(Writer writer, SchemaGeneratorOptions options) throws IOException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            IndentingXMLStreamWriter xmlWriter = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer), writer);
            this.generate(xmlWriter, options);
        }
        catch (XMLStreamException xmlWriter) {
            void e;
            FFDCFilter.processException((Throwable)xmlWriter, (String)"com.ibm.ws.config.schemagen.internal.SchemaGeneratorImpl", (String)"56", (Object)this, (Object[])new Object[]{writer, options});
            throw new IOException("Error generating schema", (Throwable)e);
        }
    }

    private void generate(XMLStreamWriter xmlWriter, SchemaGeneratorOptions options) throws XMLStreamException {
        SchemaWriter schemaWriter = new SchemaWriter(xmlWriter);
        schemaWriter.setEncoding(options.getEncoding());
        schemaWriter.setGenerateDocumentation(true);
        schemaWriter.setLocale(options.getLocale());
        schemaWriter.setIgnoredPids(options.getIgnoredPids());
        schemaWriter.setIsRuntime(options.isRuntime());
        for (Bundle bundle : options.getBundles()) {
            EquinoxMetaTypeInformation info = this.metaTypeService.getMetaTypeInformation(bundle);
            schemaWriter.add((MetaTypeInformation)info);
        }
        schemaWriter.generate(true);
    }

    protected void setMetaTypeService(EquinoxMetaTypeService ref) {
        this.metaTypeService = ref;
    }

    protected void unsetMetaTypeService(EquinoxMetaTypeService ref) {
        this.metaTypeService = null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SchemaGeneratorImpl.class);
    }
}

