/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.DiskCacheSizeInfo;
import com.ibm.ws.cache.DiskCleanupThread;
import com.ibm.ws.cache.DynacacheOnDisk;
import com.ibm.ws.cache.GarbageCollectorThread;
import com.ibm.ws.cache.HTODDynacache;
import com.ibm.ws.cache.Result;
import com.ibm.ws.cache.Scheduler;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.util.ExceptionUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.concurrent.Future;

public class CacheOnDisk
implements DynacacheOnDisk {
    private static final boolean IS_UNIT_TEST = false;
    private static final long SECONDS_FOR_24_HOURS = 86400L;
    private static final long SECONDS_FOR_23_HOURS = 82800L;
    public static final byte PROPERTY_FILE_OK = 0;
    public static final byte PROPERTY_ERROR_NO_FILES = 1;
    public static final byte PROPERTY_ERROR_FILE_NOT_EXIST = 2;
    public static final byte PROPERTY_ERROR_FILE_CORRUPT = 4;
    public static final byte PROPERTY_ERROR_DISABLE_DEPID = 8;
    public static final byte PROPERTY_ERROR_DISABLE_TEMPLATE = 16;
    public static final byte PROPERTY_ERROR_CACHE_SIZE = 32;
    public static final byte PROPERTY_ERROR_FIELD_CHECK = 64;
    public static final byte PROPERTY_ERROR_GB = -128;
    public static final String HTOD_VERSION = "version";
    public static final String HTOD_VERSION_NUM = "6.0";
    public static final String DISABLE_DEPENDENCY_ID = "disableDependencyId";
    public static final String DISABLE_TEMPLATE_SUPPORT = "disableTemplatesSupport";
    public static final String CACHE_SIZE_IN_BYTES = "cacheSizeInBytes";
    public static final String FIELD_CHECK = "fieldCheck";
    public static final String DATA_GB = "dataGB";
    public static final String DEPID_GB = "dependencyIdGB";
    public static final String TEMPLATE_GB = "templateGB";
    public static final String HTOD_LAST_SCAN_FILENAME = "lastscantime";
    public static final String HTOD_PROPERTIES_FILENAME = "htod.properties";
    public static final String HTOD_INVALIDATION_FILENAME = "invalidations.htod";
    public static final String HTOD_IN_PROGRESS_FILENAME = "InProgress";
    public static final int START_NONE = 0;
    public static final int START_LPBT_SCAN = 1;
    public static final int START_LPBT_REMOVE = 2;
    public static final boolean FILTER = true;
    public static final boolean DELETE_IN_PROGRESS_FILE = true;
    public static final int DISK_CACHE_SIZE_IN_ENTRIES_TYPE = 1;
    public static final int DISK_CACHE_SIZE_IN_BYTES_TYPE = 2;
    public static final int LOCATION_OK = 0;
    public static final int LOCATION_NOT_DEFINED = 1;
    public static final int LOCATION_NOT_VALID = 2;
    public static final int LOCATION_NOT_DIRECTORY = 3;
    public static final int LOCATION_NOT_WRITABLE = 4;
    public static final int LOCATION_CANNOT_MAKE_DIR = 5;
    public static final int GC_THRESHOLD = 20;
    private static TraceComponent tc = Tr.register(CacheOnDisk.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    protected String sep = File.separator;
    protected String swapDirPath = null;
    protected String swapRootDirPath = null;
    protected String cacheName = null;
    protected String diskCacheName = null;
    protected long sleepInterval = 1800000L;
    protected int cleanupHour = 0;
    protected long invalInterval = 86400000L;
    protected int cleanupFrequency = 0;
    protected boolean delayOffload;
    protected int delayOffloadEntriesLimit = 1000;
    protected int delayOffloadDepIdBuckets = 1000;
    protected int delayOffloadTemplateBuckets = 100;
    protected boolean dependencyCacheIndexEnabled = false;
    protected int dataHashtableSize;
    protected int depIdHashtableSize;
    protected int templateHashtableSize;
    protected int numberOfPools;
    protected int poolSize;
    protected int poolEntryLife;
    protected int invalidationBufferSize;
    protected int invalidationBufferLife;
    protected boolean disableDependencyId = false;
    protected boolean disableTemplatesSupport = false;
    protected boolean disableDependencyIdFromPropertyFile = false;
    protected boolean disableTemplatesSupprotFromPropertyFile = false;
    protected int dataFiles = 0;
    protected int dependencyIdFiles = 0;
    protected int templateFiles = 0;
    protected boolean ignoreValueInInvalidationEvent = false;
    protected int diskCachePerformanceLevel = 1;
    protected int explicitBufferLimitOnStop = 0;
    protected long sleepTime = 0L;
    protected boolean setAlarm = true;
    protected String lastScanFileName = null;
    protected String htodPropertyFileName = null;
    protected String invalidationFileName = null;
    protected String inProgressFileName = null;
    protected final String HTOD_PREF = "_dynacache";
    protected DCache cache = null;
    protected HTODDynacache htod = null;
    protected long lastScanTime = 0L;
    protected byte propertyFileStatus = 0;
    protected ValueSet valueSet = null;
    protected boolean stopping = false;
    protected int startState = 0;
    protected boolean enableCacheSizeInBytes = false;
    protected long currentCacheSizeInBytes = 0L;
    protected int dataGB = 1;
    protected int dependencyIdGB = 1;
    protected int templateGB = 1;
    protected boolean populateEvictionTable = false;
    protected boolean populateDependencyTable = false;
    protected GarbageCollectorThread garbageCollectionThread = null;
    protected DiskCleanupThread diskCleanupThread = null;
    protected int evictionPolicy = 0;
    protected DiskCacheSizeInfo diskCacheSizeInfo = null;
    protected boolean doNotify = false;
    protected Object diskCacheMonitor = new Object(){};
    private String definedLocation = "";
    private String alternateLocation = "";

    public CacheOnDisk(CacheConfig cacheConfig, DCache c) {
        String systemProperty;
        String methodName = "constructor()";
        if (cacheConfig.diskOffloadLocation == null) {
            cacheConfig.setOffloadOffloadLocationAndProcess("");
        }
        this.cache = c;
        this.cacheName = c.getCacheName();
        String location = cacheConfig.diskOffloadLocation;
        this.cleanupHour = cacheConfig.htodCleanupHour;
        this.invalInterval = cacheConfig.htodInvalInterval;
        this.cleanupFrequency = cacheConfig.htodCleanupFrequency;
        this.delayOffload = cacheConfig.htodDelayOffload;
        this.delayOffloadEntriesLimit = cacheConfig.htodDelayOffloadEntriesLimit;
        this.delayOffloadDepIdBuckets = cacheConfig.htodDelayOffloadDepIdBuckets;
        this.delayOffloadTemplateBuckets = cacheConfig.htodDelayOffloadTemplateBuckets;
        this.dependencyCacheIndexEnabled = cacheConfig.htodDependencyCacheIndexEnabled;
        this.dataHashtableSize = cacheConfig.htodDataHashtableSize;
        this.depIdHashtableSize = cacheConfig.htodDepIdHashtableSize;
        this.templateHashtableSize = cacheConfig.htodTemplateHashtableSize;
        this.numberOfPools = cacheConfig.htodNumberOfPools;
        this.poolSize = cacheConfig.htodPoolSize;
        this.poolEntryLife = cacheConfig.htodPoolEntryLife;
        this.invalidationBufferSize = cacheConfig.htodInvalidationBufferSize;
        this.invalidationBufferLife = cacheConfig.htodInvalidationBufferLife;
        this.disableDependencyId = cacheConfig.disableDependencyId;
        this.disableTemplatesSupport = cacheConfig.disableTemplatesSupport;
        this.disableTemplatesSupport = cacheConfig.enableServletSupport ? cacheConfig.disableTemplatesSupport : true;
        this.ignoreValueInInvalidationEvent = cacheConfig.ignoreValueInInvalidationEvent;
        this.diskCachePerformanceLevel = cacheConfig.diskCachePerformanceLevel;
        this.evictionPolicy = cacheConfig.diskCacheEvictionPolicy;
        this.explicitBufferLimitOnStop = cacheConfig.explicitBufferLimitOnStop;
        int diskCacheSizeLimit = cacheConfig.diskCacheSize;
        int diskCacheSizeInGBLimit = cacheConfig.diskCacheSizeInGB;
        int diskCacheEntrySizeInMBLimit = cacheConfig.diskCacheEntrySizeInMB;
        int highThreshold = cacheConfig.diskCacheHighThreshold;
        int lowThreshold = cacheConfig.diskCacheLowThreshold;
        this.diskCacheSizeInfo = new DiskCacheSizeInfo(this.cacheName);
        if (this.diskCachePerformanceLevel < 0 || this.diskCachePerformanceLevel > 3) {
            Tr.warning((TraceComponent)tc, (String)"DYNA0069W", (Object[])new Object[]{new Integer(this.diskCachePerformanceLevel), "diskCachePerformanceLevel", this.cacheName, new Integer(0), new Integer(3), new Integer(1)});
            this.diskCachePerformanceLevel = 1;
        }
        if (this.diskCachePerformanceLevel == 3 || this.diskCachePerformanceLevel == 2 || this.diskCachePerformanceLevel == 1) {
            this.delayOffload = true;
            if (this.diskCachePerformanceLevel == 1) {
                this.delayOffloadEntriesLimit = 1000;
                this.delayOffloadDepIdBuckets = 1000;
                this.delayOffloadTemplateBuckets = 100;
            } else if (this.diskCachePerformanceLevel == 3) {
                this.delayOffloadEntriesLimit = Integer.MAX_VALUE;
                this.delayOffloadDepIdBuckets = Integer.MAX_VALUE;
                this.delayOffloadTemplateBuckets = Integer.MAX_VALUE;
            } else {
                if (this.delayOffloadEntriesLimit < 100) {
                    Tr.warning((TraceComponent)tc, (String)"DYNA0069W", (Object[])new Object[]{new Integer(this.delayOffloadEntriesLimit), "htodDelayOffloadEntriesLimit", this.cacheName, new Integer(100), new Integer(Integer.MAX_VALUE), new Integer(100)});
                    this.delayOffloadEntriesLimit = 100;
                }
                if (this.delayOffloadDepIdBuckets < 100) {
                    Tr.warning((TraceComponent)tc, (String)"DYNA0069W", (Object[])new Object[]{new Integer(this.delayOffloadDepIdBuckets), "htodDelayOffloadDepIdBuckets", this.cacheName, new Integer(100), new Integer(Integer.MAX_VALUE), new Integer(100)});
                    this.delayOffloadDepIdBuckets = 100;
                }
                if (this.delayOffloadTemplateBuckets < 10) {
                    Tr.warning((TraceComponent)tc, (String)"DYNA0069W", (Object[])new Object[]{new Integer(this.delayOffloadTemplateBuckets), "htodDelayOffloadTemplateBuckets", this.cacheName, new Integer(10), new Integer(Integer.MAX_VALUE), new Integer(10)});
                    this.delayOffloadTemplateBuckets = 10;
                }
            }
        } else {
            this.delayOffload = false;
        }
        if (this.diskCachePerformanceLevel != 3) {
            if (this.cleanupFrequency < 0) {
                Tr.warning((TraceComponent)tc, (String)"DYNA0069W", (Object[])new Object[]{new Integer(this.cleanupFrequency), "htodCleanupFrequency", this.cacheName, new Integer(0), new Integer(1440), new Integer(0)});
                this.cleanupFrequency = 0;
            }
            if (this.cleanupFrequency > 1440) {
                Tr.warning((TraceComponent)tc, (String)"DYNA0069W", (Object[])new Object[]{new Integer(this.cleanupFrequency), "htodCleanupFrequency", this.cacheName, new Integer(0), new Integer(1440), new Integer(1440)});
                this.cleanupFrequency = 1440;
            }
        }
        if (this.evictionPolicy < 0 || this.evictionPolicy > 2) {
            Tr.warning((TraceComponent)tc, (String)"DYNA0069W", (Object[])new Object[]{new Integer(this.evictionPolicy), "diskCacheEvictionPolicy", this.cacheName, new Integer(0), new Integer(2), new Integer(0)});
            this.evictionPolicy = 0;
        }
        if (diskCacheSizeLimit < 0 || diskCacheSizeLimit > 0 && diskCacheSizeLimit < 20) {
            Tr.warning((TraceComponent)tc, (String)"DYNA0069W", (Object[])new Object[]{new Integer(diskCacheSizeLimit), "diskCacheSize", this.cacheName, new Integer(20), new Integer(Integer.MAX_VALUE), new Integer(20)});
            diskCacheSizeLimit = 20;
        }
        if (diskCacheSizeInGBLimit < 0 || diskCacheSizeInGBLimit > 0 && diskCacheSizeInGBLimit < 3) {
            Tr.warning((TraceComponent)tc, (String)"DYNA0069W", (Object[])new Object[]{new Integer(diskCacheSizeInGBLimit), "diskCacheSizeInGB", this.cacheName, new Integer(3), new Integer(Integer.MAX_VALUE), new Integer(3)});
            diskCacheSizeInGBLimit = 3;
        }
        if (diskCacheEntrySizeInMBLimit < 0) {
            Tr.warning((TraceComponent)tc, (String)"DYNA0069W", (Object[])new Object[]{new Integer(diskCacheEntrySizeInMBLimit), "diskCacheEntrySizeInMB", this.cacheName, new Integer(0), new Integer(Integer.MAX_VALUE), new Integer(0)});
            diskCacheEntrySizeInMBLimit = 0;
        }
        if (this.evictionPolicy != 0 && (highThreshold < 1 || highThreshold > 100 || lowThreshold < 1 || lowThreshold > 100 || highThreshold <= lowThreshold)) {
            Tr.info((TraceComponent)tc, (String)"DYNA0068W", (Object[])new Object[]{this.cacheName});
            highThreshold = 80;
            lowThreshold = 70;
        }
        this.diskCacheName = this.cacheName;
        this.diskCacheName = this.diskCacheName.replace('/', '_');
        this.diskCacheName = this.diskCacheName.replace('\\', '_');
        boolean found = this.findSwapDirPath(location);
        if (!found) {
            return;
        }
        boolean flushToDiskOnStop = cacheConfig.flushToDiskOnStop;
        if (this.cacheName.equals("baseCache") && (systemProperty = System.getProperty("com.ibm.ws.cache.flushToDiskOnStop")) != null && systemProperty.equalsIgnoreCase("true")) {
            flushToDiskOnStop = true;
        }
        if (flushToDiskOnStop) {
            Tr.info((TraceComponent)tc, (String)"DYNA0060I", (Object[])new Object[]{this.cacheName});
        } else {
            Tr.info((TraceComponent)tc, (String)"DYNA0061I", (Object[])new Object[]{this.cacheName});
        }
        int lastIndex = this.swapDirPath.lastIndexOf(this.sep);
        this.swapRootDirPath = this.swapDirPath.substring(0, lastIndex);
        this.lastScanFileName = this.swapDirPath + this.sep + HTOD_LAST_SCAN_FILENAME;
        this.htodPropertyFileName = this.swapDirPath + this.sep + HTOD_PROPERTIES_FILENAME;
        this.invalidationFileName = this.swapDirPath + this.sep + HTOD_INVALIDATION_FILENAME;
        this.inProgressFileName = this.swapDirPath + this.sep + HTOD_IN_PROGRESS_FILENAME;
        File df = new File(this.inProgressFileName);
        if (df.exists()) {
            Tr.warning((TraceComponent)tc, (String)"DYNA0056W", (Object[])new Object[0]);
            this.deleteDiskCacheFiles();
        }
        this.createInProgressFile();
        this.loadAndCheckPropertyFile();
        if (this.propertyFileStatus != 0 && ((this.propertyFileStatus & 4) > 0 || (this.propertyFileStatus & 0x20) > 0 || (this.propertyFileStatus & 0x40) > 0 || (this.propertyFileStatus & 0xFFFFFF80) > 0)) {
            if (this.currentCacheSizeInBytes > 0L) {
                this.dataGB = this.dataFiles;
                this.dependencyIdGB = this.dependencyIdFiles;
                this.templateGB = this.templateFiles;
            }
            this.deletePropertyFile();
        }
        try {
            this.htod = new HTODDynacache(this.swapDirPath, this.swapDirPath + this.sep + "_dynacache", this.cache, this);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.CacheOnDisk.CacheOnDisk", (String)"338", (Object)this);
            this.traceDebug("constructor()", "cacheName=" + this.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t));
            Tr.error((TraceComponent)tc, (String)"DYNA0055E", (Object[])new Object[]{this.cacheName, this.definedLocation, this.alternateLocation});
            c.setSwapToDisk(false);
            return;
        }
        if (this.disableDependencyId) {
            if (this.dependencyIdFiles > 0) {
                Tr.warning((TraceComponent)tc, (String)"DYNA1033W", (Object[])new Object[]{String.valueOf(this.disableDependencyId), this.cacheName, String.valueOf(!this.disableDependencyId)});
                this.disableDependencyId = false;
                if (this.dependencyIdGB == 0) {
                    this.dependencyIdGB = this.dependencyIdFiles;
                }
            } else {
                this.dependencyIdGB = 0;
            }
        } else if (this.dependencyIdFiles == 0) {
            Tr.warning((TraceComponent)tc, (String)"DYNA1033W", (Object[])new Object[]{String.valueOf(this.disableDependencyId), this.cacheName, String.valueOf(!this.disableDependencyId)});
            this.disableDependencyId = true;
            if (this.dependencyIdGB > 0) {
                this.dependencyIdGB = 0;
            }
        } else if (this.dependencyIdGB == 0) {
            this.dependencyIdGB = this.dependencyIdFiles;
        }
        if (this.disableTemplatesSupport) {
            if (this.templateFiles > 0) {
                Tr.warning((TraceComponent)tc, (String)"DYNA1034W", (Object[])new Object[]{String.valueOf(this.disableTemplatesSupport), this.cacheName, String.valueOf(!this.disableTemplatesSupport)});
                this.disableTemplatesSupport = false;
                if (this.templateGB == 0) {
                    this.templateGB = this.templateFiles;
                }
            } else {
                this.templateGB = 0;
            }
        } else if (this.templateFiles == 0) {
            Tr.warning((TraceComponent)tc, (String)"DYNA1034W", (Object[])new Object[]{String.valueOf(this.disableTemplatesSupport), this.cacheName, String.valueOf(!this.disableTemplatesSupport)});
            this.disableTemplatesSupport = true;
            if (this.templateGB > 0) {
                this.templateGB = 0;
            }
        } else if (this.templateGB == 0) {
            this.templateGB = this.templateFiles;
        }
        int minGB = this.dataGB + this.dependencyIdGB + this.templateGB;
        if (diskCacheSizeInGBLimit > 0 && minGB > diskCacheSizeInGBLimit) {
            diskCacheSizeInGBLimit = minGB;
            Tr.warning((TraceComponent)tc, (String)"DYNA0071W", (Object[])new Object[]{this.cacheName, new Integer(diskCacheSizeInGBLimit), this.swapDirPath});
        }
        c.setEnableDiskCacheSizeInBytesChecking(false);
        if (this.currentCacheSizeInBytes > 0L) {
            if (diskCacheSizeInGBLimit > 0) {
                c.setEnableDiskCacheSizeInBytesChecking(true);
            }
            this.enableCacheSizeInBytes = true;
        } else if (diskCacheSizeInGBLimit > 0) {
            Tr.error((TraceComponent)tc, (String)"DYNA0066W", (Object[])new Object[]{this.cacheName, this.swapDirPath});
            diskCacheSizeInGBLimit = 0;
        }
        this.diskCacheSizeInfo.initialize(diskCacheSizeLimit, diskCacheEntrySizeInMBLimit, diskCacheSizeInGBLimit, this.dataGB, this.dependencyIdGB, this.templateGB, highThreshold, lowThreshold);
        if (this.propertyFileStatus != 0) {
            this.updatePropertyFile();
        }
        if (this.cleanupFrequency != 0) {
            this.sleepTime = this.cleanupFrequency * 60 * 1000;
        }
        this.readLastScanFile();
        this.setAlarm = true;
        if (this.diskCachePerformanceLevel == 3) {
            this.setAlarm = false;
            this.cleanupFrequency = 0;
            this.startState = 1;
        }
        long now = System.currentTimeMillis();
        if (this.lastScanTime > 0L && this.cleanupFrequency > 0) {
            if (this.lastScanTime + (long)this.cleanupFrequency <= now) {
                this.setAlarm = false;
                this.startState = 1;
            }
        } else {
            this.updateLastScanFile();
        }
        if (this.evictionPolicy != 0) {
            if (!this.enableCacheSizeInBytes) {
                this.evictionPolicy = 0;
                this.populateEvictionTable = false;
                Tr.error((TraceComponent)tc, (String)"DYNA0067W", (Object[])new Object[]{this.cacheName, this.swapDirPath});
            } else if (diskCacheSizeLimit == 0 && diskCacheSizeInGBLimit == 0) {
                this.evictionPolicy = 0;
                this.populateEvictionTable = false;
                Tr.error((TraceComponent)tc, (String)"DYNA0070W", (Object[])new Object[]{this.cacheName});
            } else {
                this.htod.initializeEvictionTable();
                this.populateEvictionTable = true;
                this.garbageCollectionThread = new GarbageCollectorThread(this);
            }
        }
        this.diskCleanupThread = new DiskCleanupThread(this);
        cacheConfig.htodCleanupHour = this.cleanupHour;
        cacheConfig.htodInvalInterval = this.invalInterval;
        cacheConfig.htodCleanupFrequency = this.cleanupFrequency;
        cacheConfig.htodDelayOffload = this.delayOffload;
        cacheConfig.htodDelayOffloadEntriesLimit = this.delayOffloadEntriesLimit;
        cacheConfig.htodDelayOffloadDepIdBuckets = this.delayOffloadDepIdBuckets;
        cacheConfig.htodDelayOffloadTemplateBuckets = this.delayOffloadTemplateBuckets;
        cacheConfig.disableDependencyId = this.disableDependencyId;
        cacheConfig.disableTemplatesSupport = this.disableTemplatesSupport;
        cacheConfig.diskCachePerformanceLevel = this.diskCachePerformanceLevel;
        cacheConfig.diskCacheEvictionPolicy = this.evictionPolicy;
        cacheConfig.explicitBufferLimitOnStop = this.explicitBufferLimitOnStop;
        cacheConfig.diskCacheSize = diskCacheSizeLimit;
        cacheConfig.diskCacheSizeInGB = diskCacheSizeInGBLimit;
        cacheConfig.diskCacheEntrySizeInMB = diskCacheEntrySizeInMBLimit;
        cacheConfig.diskCacheHighThreshold = highThreshold;
        cacheConfig.diskCacheLowThreshold = lowThreshold;
        StringBuffer configMsg = new StringBuffer();
        if (diskCacheSizeLimit > 0) {
            configMsg.append("  DiskCacheSize=");
            configMsg.append(diskCacheSizeLimit);
        }
        if (diskCacheSizeInGBLimit > 0) {
            configMsg.append("  DiskCacheSizeInGB=");
            configMsg.append(diskCacheSizeInGBLimit);
        }
        if (diskCacheEntrySizeInMBLimit > 0) {
            configMsg.append("  DiskCacheEntryInMB=");
            configMsg.append(diskCacheEntrySizeInMBLimit);
        }
        configMsg.append("  DiskCachePerformanceLevel=");
        configMsg.append(this.diskCachePerformanceLevel);
        configMsg.append("  DelayOffload=");
        configMsg.append(this.delayOffload);
        if (this.diskCachePerformanceLevel == 0) {
            if (this.cleanupFrequency == 0) {
                configMsg.append("  CleanupHour=");
                configMsg.append(this.cleanupHour);
            } else {
                configMsg.append("  CleanupFrequency=");
                configMsg.append(this.cleanupFrequency);
            }
        } else if (this.diskCachePerformanceLevel == 2 || this.diskCachePerformanceLevel == 1) {
            configMsg.append("  DelayOffloadEntriesLimit=");
            configMsg.append(this.delayOffloadEntriesLimit);
            configMsg.append("  DelayOffloadDepIdBuckets=");
            configMsg.append(this.delayOffloadDepIdBuckets);
            configMsg.append("  DelayOffloadTemplateBuckets=");
            configMsg.append(this.delayOffloadTemplateBuckets);
            if (this.cleanupFrequency == 0) {
                configMsg.append("  CleanupHour=");
                configMsg.append(this.cleanupHour);
            } else {
                configMsg.append("  CleanupFrequency=");
                configMsg.append(this.cleanupFrequency);
            }
        }
        configMsg.append("  DiskCacheEvictionPolicy=");
        configMsg.append(this.evictionPolicy);
        if (this.evictionPolicy != 0) {
            configMsg.append("  DiskCacheHighThreshold=");
            configMsg.append(highThreshold);
            configMsg.append("  DiskCacheLowThreshold=");
            configMsg.append(lowThreshold);
        }
        configMsg.append("  DataHashtableSize=");
        configMsg.append(this.dataHashtableSize);
        configMsg.append("  DepIdHashtableSize=");
        configMsg.append(this.depIdHashtableSize);
        configMsg.append("  TemplateHashtableSize=");
        configMsg.append(this.templateHashtableSize);
        Tr.info((TraceComponent)tc, (String)"DYNA0059I", (Object[])new Object[]{this.cacheName, configMsg.toString()});
        if (this.setAlarm) {
            if (this.cleanupFrequency == 0) {
                this.sleepTime = this.calculateSleepTime();
                if (this.sleepTime > 82800000L) {
                    this.setAlarm = false;
                    this.startState = 1;
                } else {
                    this.traceDebug("constructor()", "cacheName=" + this.cacheName + " sleepTime=" + this.sleepTime);
                }
            }
            if (this.setAlarm && this.startState != 1 && this.startState != 2 && !this.populateEvictionTable) {
                Scheduler.createNonDeferrable(this.sleepTime, null, new Runnable(){

                    @Override
                    public void run() {
                        CacheOnDisk.this.alarm(null);
                    }
                });
            }
        }
        if (this.diskCachePerformanceLevel != 0) {
            this.populateDependencyTable = true;
        }
    }

    @Override
    public void close(boolean deleteProgressFile) {
        String methodName = "close()";
        this.traceDebug("close()", "cacheName=" + this.cacheName + " deleteProgressFile=" + deleteProgressFile);
        if (deleteProgressFile) {
            this.deleteInProgressFile();
        }
        try {
            this.htod.close();
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.CacheOnDisk.close", (String)"574", (Object)this);
            this.traceDebug("close()", "cacheName=" + this.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t));
        }
    }

    @Override
    public int writeAuxiliaryDepTables() {
        int returnCode = this.htod.writeAuxiliaryDepTables();
        if (returnCode == 1) {
            this.stopOnError(this.htod.diskCacheException);
        } else {
            this.updatePropertyFile();
        }
        return returnCode;
    }

    private void readLastScanFile() {
        String methodName = "readLastScanFile()";
        final File f = new File(this.lastScanFileName);
        this.traceDebug("readLastScanFile()", "cacheName=" + this.cacheName);
        if (f.exists()) {
            final CacheOnDisk cod = this;
            AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    FileInputStream fis = null;
                    ObjectInputStream ois = null;
                    try {
                        fis = new FileInputStream(f);
                        ois = new ObjectInputStream(fis);
                        cod.lastScanTime = ois.readLong();
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.CacheOnDisk.readLastScanFile", (String)"611", (Object)cod);
                        CacheOnDisk.this.traceDebug("readLastScanFile()", "cacheName=" + cod.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t));
                    }
                    finally {
                        try {
                            if (ois != null) {
                                ois.close();
                            }
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        catch (Throwable t) {
                            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.CacheOnDisk.readLastScanFile", (String)"622", (Object)cod);
                            CacheOnDisk.this.traceDebug("readLastScanFile()", "cacheName=" + cod.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t));
                        }
                    }
                    return null;
                }
            });
        }
    }

    protected void updateLastScanFile() {
        String methodName = "updateLastScanFile()";
        final File f = new File(this.lastScanFileName);
        final CacheOnDisk cod = this;
        this.traceDebug("updateLastScanFile()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                FileOutputStream fos = null;
                ObjectOutputStream oos = null;
                try {
                    fos = new FileOutputStream(f);
                    oos = new ObjectOutputStream(fos);
                    oos.writeLong(System.currentTimeMillis());
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.CacheOnDisk.updateLastScanFile", (String)"650", (Object)cod);
                    CacheOnDisk.this.traceDebug("updateLastScanFile()", "cacheName=" + cod.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t));
                }
                finally {
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.CacheOnDisk.updateLastScanFile", (String)"661", (Object)cod);
                        CacheOnDisk.this.traceDebug("updateLastScanFile()", "cacheName=" + cod.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t));
                    }
                }
                return null;
            }
        });
    }

    private void loadAndCheckPropertyFile() {
        String methodName = "loadAndCheckPropertyFile()";
        final File f = new File(this.htodPropertyFileName);
        final File swapDirPathFile = new File(this.swapDirPath);
        final CacheOnDisk cod = this;
        this.traceDebug("loadAndCheckPropertyFile()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                cod.propertyFileStatus = 0;
                String[] files = swapDirPathFile.list();
                if (files != null && files.length > 0) {
                    for (int i = 0; i < files.length; ++i) {
                        if (files[i].startsWith("_dynacache" + HTODDynacache.object_suffix)) {
                            ++cod.dataFiles;
                            continue;
                        }
                        if (files[i].startsWith("_dynacache" + HTODDynacache.dependency_suffix)) {
                            ++cod.dependencyIdFiles;
                            continue;
                        }
                        if (!files[i].startsWith("_dynacache" + HTODDynacache.template_suffix)) continue;
                        ++cod.templateFiles;
                    }
                } else {
                    CacheOnDisk.this.traceDebug("loadAndCheckPropertyFile()", "cacheName=" + cod.cacheName + " no disk cache files exist");
                    cod.propertyFileStatus = (byte)(cod.propertyFileStatus | 1);
                    return null;
                }
                if (f.exists()) {
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(f);
                        Properties htodProp = new Properties();
                        htodProp.load(fis);
                        String sTemp = (String)htodProp.get(CacheOnDisk.DISABLE_DEPENDENCY_ID);
                        if (sTemp != null) {
                            cod.disableDependencyIdFromPropertyFile = Boolean.valueOf(sTemp);
                        } else {
                            cod.propertyFileStatus = (byte)(cod.propertyFileStatus | 8);
                        }
                        sTemp = (String)htodProp.get(CacheOnDisk.DISABLE_TEMPLATE_SUPPORT);
                        if (sTemp != null) {
                            cod.disableTemplatesSupprotFromPropertyFile = Boolean.valueOf(sTemp);
                        } else {
                            cod.propertyFileStatus = (byte)(cod.propertyFileStatus | 0x10);
                        }
                        sTemp = (String)htodProp.get(CacheOnDisk.CACHE_SIZE_IN_BYTES);
                        long currentCacheSizeInBytes = 0L;
                        if (sTemp == null) {
                            cod.propertyFileStatus = (byte)(cod.propertyFileStatus | 0x20);
                            Object var7_10 = null;
                            return var7_10;
                        }
                        currentCacheSizeInBytes = Long.parseLong(sTemp);
                        byte[] b = sTemp.getBytes("UTF-8");
                        int fieldCheck = 0;
                        for (int i = 0; i < b.length; ++i) {
                            fieldCheck += b[i];
                        }
                        fieldCheck *= 3;
                        sTemp = (String)htodProp.get(CacheOnDisk.FIELD_CHECK);
                        if (sTemp != null) {
                            int expFieldCheck = Integer.parseInt(sTemp);
                            if (fieldCheck != expFieldCheck) {
                                cod.propertyFileStatus = (byte)(cod.propertyFileStatus | 0x40);
                                Object var10_16 = null;
                                return var10_16;
                            }
                        } else {
                            cod.propertyFileStatus = (byte)(cod.propertyFileStatus | 0x40);
                            Object expFieldCheck = null;
                            return expFieldCheck;
                        }
                        sTemp = (String)htodProp.get(CacheOnDisk.DATA_GB);
                        int dataGB = 0;
                        if (sTemp == null) {
                            cod.propertyFileStatus = (byte)(cod.propertyFileStatus | 0xFFFFFF80);
                            Object t = null;
                            return t;
                        }
                        dataGB = Integer.parseInt(sTemp);
                        sTemp = (String)htodProp.get(CacheOnDisk.DEPID_GB);
                        int dependencyIdGB = 0;
                        if (sTemp == null) {
                            cod.propertyFileStatus = (byte)(cod.propertyFileStatus | 0xFFFFFF80);
                            Object t = null;
                            return t;
                        }
                        dependencyIdGB = Integer.parseInt(sTemp);
                        sTemp = (String)htodProp.get(CacheOnDisk.TEMPLATE_GB);
                        int templateGB = 0;
                        if (sTemp == null) {
                            cod.propertyFileStatus = (byte)(cod.propertyFileStatus | 0xFFFFFF80);
                            Object var12_25 = null;
                            return var12_25;
                        }
                        templateGB = Integer.parseInt(sTemp);
                        cod.currentCacheSizeInBytes = currentCacheSizeInBytes;
                        cod.dataGB = dataGB;
                        cod.dependencyIdGB = dependencyIdGB;
                        cod.templateGB = templateGB;
                        CacheOnDisk.this.traceDebug("loadAndCheckPropertyFile()", "cacheName=" + cod.cacheName + " htod.properties exist with status=" + cod.propertyFileStatus + " disableDependencyIdFromProperty=" + cod.disableDependencyIdFromPropertyFile + " disableTemplatesSupportFromProperty=" + cod.disableTemplatesSupprotFromPropertyFile + " cacheSizeInBytes=" + cod.currentCacheSizeInBytes + " dataGB=" + cod.dataGB + " dependencyIdGB=" + cod.dependencyIdGB + " templateGB=" + cod.templateGB);
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.CacheOnDisk.loadAndCheckPropertyFile", (String)"782", (Object)cod);
                        CacheOnDisk.this.traceDebug("loadAndCheckPropertyFile()", "cacheName=" + cod.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t));
                        cod.propertyFileStatus = (byte)(cod.propertyFileStatus | 4);
                    }
                    finally {
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        catch (Throwable t) {
                            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.CacheOnDisk.loadAndCheckPropertyFile", (String)"791", (Object)cod);
                            CacheOnDisk.this.traceDebug("loadAndCheckPropertyFile()", "cacheName=" + cod.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t));
                        }
                    }
                } else {
                    cod.propertyFileStatus = (byte)(cod.propertyFileStatus | 2);
                    CacheOnDisk.this.traceDebug("loadAndCheckPropertyFile()", "cacheName=" + cod.cacheName + " htod.properties not exist dependencyIdFiles=" + cod.dependencyIdFiles + " templateFiles=" + cod.templateFiles);
                }
                return null;
            }
        });
    }

    protected void updatePropertyFile() {
        String methodName = "updatePropertyFile()";
        final File f = new File(this.htodPropertyFileName);
        final CacheOnDisk cod = this;
        this.traceDebug("updatePropertyFile()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                FileOutputStream fos = null;
                Properties htodProp = new Properties();
                try {
                    fos = new FileOutputStream(f);
                    htodProp.put(CacheOnDisk.HTOD_VERSION, CacheOnDisk.HTOD_VERSION_NUM);
                    htodProp.put(CacheOnDisk.DISABLE_DEPENDENCY_ID, Boolean.toString(CacheOnDisk.this.disableDependencyId));
                    htodProp.put(CacheOnDisk.DISABLE_TEMPLATE_SUPPORT, Boolean.toString(CacheOnDisk.this.disableTemplatesSupport));
                    long cacheSizeInBytes = 0L;
                    int fieldCheck = 0;
                    if (cod.enableCacheSizeInBytes) {
                        if (cod.currentCacheSizeInBytes < cod.htod.minDiskCacheSizeInBytes) {
                            cod.currentCacheSizeInBytes = cod.htod.minDiskCacheSizeInBytes;
                        }
                        cacheSizeInBytes = cod.currentCacheSizeInBytes;
                        htodProp.put(CacheOnDisk.CACHE_SIZE_IN_BYTES, Long.toString(cacheSizeInBytes));
                        String s = String.valueOf(cacheSizeInBytes);
                        byte[] b = s.getBytes("UTF-8");
                        fieldCheck = 0;
                        for (int i = 0; i < b.length; ++i) {
                            fieldCheck += b[i];
                        }
                        htodProp.put(CacheOnDisk.FIELD_CHECK, String.valueOf(fieldCheck *= 3));
                        htodProp.put(CacheOnDisk.DATA_GB, String.valueOf(cod.diskCacheSizeInfo.currentDataGB));
                        htodProp.put(CacheOnDisk.DEPID_GB, String.valueOf(cod.diskCacheSizeInfo.currentDependencyIdGB));
                        htodProp.put(CacheOnDisk.TEMPLATE_GB, String.valueOf(cod.diskCacheSizeInfo.currentTemplateGB));
                        CacheOnDisk.this.traceDebug("updatePropertyFile()", "cacheName=" + cod.cacheName + " disableDependencyId=" + CacheOnDisk.this.disableDependencyId + " disableTemplatesSupport=" + CacheOnDisk.this.disableTemplatesSupport + " cacheSizeInBytes=" + cacheSizeInBytes + " fieldCheck=" + fieldCheck + " dataGB=" + cod.diskCacheSizeInfo.currentDataGB + " dependencyIdGB=" + cod.diskCacheSizeInfo.currentDependencyIdGB + " templateGB=" + cod.diskCacheSizeInfo.currentTemplateGB);
                    } else {
                        CacheOnDisk.this.traceDebug("updatePropertyFile()", "cacheName=" + cod.cacheName + " disableDependencyId=" + CacheOnDisk.this.disableDependencyId + " disableTemplatesSupport=" + CacheOnDisk.this.disableTemplatesSupport);
                    }
                    htodProp.store(fos, "HTOD properties - Do not modify the properties");
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.CacheOnDisk.updatePropertyFile", (String)"651", (Object)cod);
                    CacheOnDisk.this.traceDebug("updatePropertyFile()", "cacheName=" + cod.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t));
                }
                finally {
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.CacheOnDisk.updatePropertyFile", (String)"859", (Object)cod);
                        CacheOnDisk.this.traceDebug("updatePropertyFile()", "cacheName=" + cod.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t));
                    }
                }
                return null;
            }
        });
    }

    private void deletePropertyFile() {
        String methodName = "deletePropertyFile()";
        final File f = new File(this.htodPropertyFileName);
        final CacheOnDisk cod = this;
        this.traceDebug("deletePropertyFile()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    f.delete();
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.CacheOnDisk.deletePropertyFile", (String)"883", (Object)cod);
                    CacheOnDisk.this.traceDebug("deletePropertyFile()", "cacheName=" + cod.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t));
                }
                return null;
            }
        });
    }

    @Override
    public void deleteDiskCacheFiles() {
        String methodName = "deleteDiskCacheFiles()";
        final File f = new File(this.swapDirPath);
        final CacheOnDisk cod = this;
        this.traceDebug("deleteDiskCacheFiles()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File[] fl = f.listFiles();
                for (int i = 0; i < fl.length; ++i) {
                    try {
                        fl[i].delete();
                        continue;
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.CacheOnDisk.deleteDiskCacheFiles", (String)"908", (Object)cod);
                        CacheOnDisk.this.traceDebug("deleteDiskCacheFiles()", "cacheName=" + cod.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t));
                    }
                }
                return null;
            }
        });
    }

    private void deleteAllDiskCacheFiles() {
        String methodName = "deleteAllDiskCacheFiles()";
        final File f = new File(this.swapRootDirPath);
        final CacheOnDisk cod = this;
        this.traceDebug("deleteAllDiskCacheFiles()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File[] fd = f.listFiles();
                for (int i = 0; i < fd.length; ++i) {
                    if (!fd[i].isDirectory()) continue;
                    File[] fl = fd[i].listFiles();
                    for (int j = 0; j < fl.length; ++j) {
                        try {
                            fl[j].delete();
                            continue;
                        }
                        catch (Throwable t) {
                            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.CacheOnDisk.deleteAllDiskCacheFiles", (String)"938", (Object)cod);
                            CacheOnDisk.this.traceDebug("deleteAllDiskCacheFiles()", "cacheName=" + cod.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t));
                        }
                    }
                }
                return null;
            }
        });
    }

    private void createInProgressFile() {
        String methodName = "createInProgressFile()";
        final File f = new File(this.inProgressFileName);
        final CacheOnDisk cod = this;
        this.traceDebug("createInProgressFile()", "cacheName=" + this.cacheName + " file=" + this.inProgressFileName);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    f.createNewFile();
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.CacheOnDisk.createInProgressFile", (String)"964", (Object)cod);
                    CacheOnDisk.this.traceDebug("createInProgressFile()", "cacheName=" + cod.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t));
                }
                return null;
            }
        });
    }

    private void deleteInProgressFile() {
        String methodName = "deleteInProgressFile()";
        final File f = new File(this.inProgressFileName);
        final CacheOnDisk cod = this;
        this.traceDebug("deleteInProgressFile()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    f.delete();
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.CacheOnDisk.deleteInProgressFile", (String)"987", (Object)cod);
                    CacheOnDisk.this.traceDebug("deleteInProgressFile()", "cacheName=" + cod.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t));
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean completeClear) {
        Object object;
        this.stopping = true;
        this.htod.invalidationBuffer.setStopping(true);
        this.htod.stop(completeClear);
        if (this.garbageCollectionThread != null) {
            object = this.garbageCollectionThread.gcMonitor;
            synchronized (object) {
                if (this.garbageCollectionThread.currentThread != null) {
                    this.garbageCollectionThread.currentThread.cancel(false);
                }
            }
        }
        if (this.diskCleanupThread != null) {
            object = this.diskCleanupThread.dcMonitor;
            synchronized (object) {
                this.diskCleanupThread.stopped = true;
                this.diskCleanupThread.processDiskCleanup = true;
                if (this.diskCleanupThread.currentThread != null) {
                    this.diskCleanupThread.currentThread.cancel(false);
                }
            }
        }
    }

    @Override
    public void stopOnError(Exception ex) {
        this.cache.setSwapToDisk(false);
        this.stop(true);
        this.close(false);
        Tr.error((TraceComponent)tc, (String)"DYNA0072E", (Object[])new Object[]{this.cacheName, this.swapDirPath, ex.getMessage()});
    }

    protected ValueSet readAndDeleteInvalidationFile() {
        String methodName = "readAndDeleteInvalidationFile()";
        final File f = new File(this.invalidationFileName);
        final CacheOnDisk cod = this;
        this.valueSet = new ValueSet(1);
        if (f.exists()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    FileInputStream fis = null;
                    ObjectInputStream ois = null;
                    try {
                        fis = new FileInputStream(f);
                        ois = new ObjectInputStream(fis);
                        int size = ois.readInt();
                        cod.valueSet = new ValueSet(size);
                        for (int i = 0; i < size; ++i) {
                            cod.valueSet.add(ois.readObject());
                        }
                    }
                    catch (Throwable t1) {
                        FFDCFilter.processException((Throwable)t1, (String)"com.ibm.ws.cache.CacheOnDisk.readAndDeleteInvalidationFile", (String)"1056", (Object)cod);
                        CacheOnDisk.this.traceDebug("readAndDeleteInvalidationFile()", "cacheName=" + cod.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t1));
                    }
                    finally {
                        try {
                            if (ois != null) {
                                ois.close();
                            }
                            if (fis != null) {
                                fis.close();
                            }
                            f.delete();
                        }
                        catch (Throwable t2) {
                            FFDCFilter.processException((Throwable)t2, (String)"com.ibm.ws.cache.CacheOnDisk.readAndDeleteInvalidationFile", (String)"1068", (Object)cod);
                            CacheOnDisk.this.traceDebug("readAndDeleteInvalidationFile()", "cacheName=" + cod.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t2));
                        }
                    }
                    return null;
                }
            });
        }
        this.traceDebug("readAndDeleteInvalidationFile()", "cacheName=" + this.cacheName + " " + this.invalidationFileName + " valueSet=" + this.valueSet.size());
        return this.valueSet;
    }

    protected void createInvalidationFile() {
        String methodName = "createInvalidationFile()";
        final File f = new File(this.invalidationFileName);
        final CacheOnDisk cod = this;
        this.traceDebug("createInvalidationFile()", "cacheName=" + this.cacheName + " valueSet=" + cod.valueSet.size());
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                FileOutputStream fos = null;
                ObjectOutputStream oos = null;
                try {
                    fos = new FileOutputStream(f);
                    oos = new ObjectOutputStream(fos);
                    oos.writeInt(cod.valueSet.size());
                    for (Object entryId : CacheOnDisk.this.valueSet) {
                        oos.writeObject(entryId);
                    }
                }
                catch (Throwable t1) {
                    FFDCFilter.processException((Throwable)t1, (String)"com.ibm.ws.cache.CacheOnDisk.createInvalidationFile", (String)"1106", (Object)cod);
                    CacheOnDisk.this.traceDebug("createInvalidationFile()", "cacheName=" + cod.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t1));
                }
                finally {
                    try {
                        oos.close();
                        fos.close();
                    }
                    catch (Throwable t2) {
                        FFDCFilter.processException((Throwable)t2, (String)"com.ibm.ws.cache.CacheOnDisk.createInvalidationFile", (String)"1113", (Object)cod);
                        CacheOnDisk.this.traceDebug("createInvalidationFile()", "cacheName=" + cod.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t2));
                    }
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(final Object alarmContext) {
        String methodName = "alarm()";
        CacheOnDisk cacheOnDisk = this;
        synchronized (cacheOnDisk) {
            if (!this.stopping && !this.htod.invalidationBuffer.isDiskClearInProgress()) {
                this.htod.invalidationBuffer.invokeBackgroundInvalidation(true);
            } else if (this.stopping) {
                this.traceDebug("alarm()", "cacheName=" + this.cacheName + " abort disk cleanup because of server is stopping.");
            } else {
                if (this.cleanupFrequency == 0) {
                    this.sleepTime = this.calculateSleepTime();
                }
                this.traceDebug("alarm()", "cacheName=" + this.cacheName + " disk clear is in progress - skip disk scan and set alarm sleepTime=" + this.sleepTime);
                Scheduler.createNonDeferrable(this.sleepTime, alarmContext, new Runnable(){

                    @Override
                    public void run() {
                        CacheOnDisk.this.alarm(alarmContext);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Trivial
    public void invokeDiskCleanup(boolean scan) {
        if ((scan || this.htod.invalidationBuffer.size() > 0 || this.htod.invalidationBuffer.size(3) > 0) && this.diskCleanupThread != null) {
            Object object = this.diskCleanupThread.dcMonitor;
            synchronized (object) {
                if (this.diskCleanupThread.currentThread == null) {
                    this.diskCleanupThread.scan = scan;
                    this.diskCleanupThread.processDiskCleanup = true;
                    this.diskCleanupThread.currentThread = this.spawnThread(this.diskCleanupThread);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean invokeDiskCacheGarbageCollector(int GCType) {
        boolean notified = false;
        if (this.garbageCollectionThread != null) {
            Object object = this.garbageCollectionThread.gcMonitor;
            synchronized (object) {
                if (this.garbageCollectionThread.currentThread == null) {
                    this.garbageCollectionThread.GCType = GCType;
                    this.garbageCollectionThread.processGC = true;
                    this.garbageCollectionThread.currentThread = this.spawnThread(this.garbageCollectionThread);
                    notified = true;
                }
            }
        }
        return notified;
    }

    @Override
    public void clearDiskCache() {
        if (this.htod.clearDiskCache() == 1) {
            this.stopOnError(this.htod.diskCacheException);
        } else {
            this.updateLastScanFile();
            this.updatePropertyFile();
            this.createInProgressFile();
        }
    }

    @Override
    public int writeCacheEntry(CacheEntry ce) {
        int returnCode = this.htod.writeCacheEntry(ce);
        if (returnCode == 1) {
            this.stopOnError(this.htod.diskCacheException);
        }
        return returnCode;
    }

    @Override
    public CacheEntry readCacheEntry(Object id) {
        Result result = this.htod.readCacheEntry(id);
        if (result.returnCode == 1) {
            this.stopOnError(result.diskException);
            this.htod.returnToResultPool(result);
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)result.data;
        this.htod.returnToResultPool(result);
        return cacheEntry;
    }

    @Override
    public CacheEntry readCacheEntry(Object id, boolean calledFromRemove) {
        Result result = this.htod.readCacheEntry(id, calledFromRemove);
        if (result.returnCode == 1) {
            this.stopOnError(result.diskException);
            this.htod.returnToResultPool(result);
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)result.data;
        this.htod.returnToResultPool(result);
        return cacheEntry;
    }

    @Override
    public void delCacheEntry(CacheEntry ce, int cause, int source, boolean fromDepIdTemplateInvalidation) {
        this.htod.delCacheEntry(ce, cause, source, fromDepIdTemplateInvalidation);
    }

    @Override
    public void delCacheEntry(ValueSet removeList, int cause, int source, boolean fromDepIdTemplateInvalidation, boolean fireEvent) {
        this.htod.delCacheEntry(removeList, cause, source, fromDepIdTemplateInvalidation, fireEvent);
    }

    @Override
    public ValueSet readDependency(Object id, boolean delete) {
        Result result = this.htod.readDependency(id, delete);
        if (result.returnCode == 1) {
            this.stopOnError(result.diskException);
            this.htod.returnToResultPool(result);
            return HTODDynacache.EMPTY_VS;
        }
        ValueSet valueSet = (ValueSet)result.data;
        if (valueSet == null) {
            valueSet = HTODDynacache.EMPTY_VS;
        }
        this.htod.returnToResultPool(result);
        return valueSet;
    }

    @Override
    public ValueSet readTemplate(String template, boolean delete) {
        Result result = this.htod.readTemplate(template, delete);
        if (result.returnCode == 1) {
            this.stopOnError(result.diskException);
            this.htod.returnToResultPool(result);
            return HTODDynacache.EMPTY_VS;
        }
        ValueSet valueSet = (ValueSet)result.data;
        if (valueSet == null) {
            valueSet = HTODDynacache.EMPTY_VS;
        }
        this.htod.returnToResultPool(result);
        return valueSet;
    }

    @Override
    public ValueSet readCacheIdsByRange(int index, int length) {
        Result result = this.htod.readCacheIdsByRange(index, length);
        if (result.returnCode == 1) {
            this.stopOnError(result.diskException);
            this.htod.returnToResultPool(result);
            return HTODDynacache.EMPTY_VS;
        }
        ValueSet valueSet = (ValueSet)result.data;
        if (valueSet == null) {
            valueSet = HTODDynacache.EMPTY_VS;
        }
        this.htod.returnToResultPool(result);
        return valueSet;
    }

    @Override
    public ValueSet readDependencyByRange(int index, int length) {
        Result result = this.htod.readDependencyByRange(index, length);
        if (result.returnCode == 1) {
            this.stopOnError(result.diskException);
            this.htod.returnToResultPool(result);
            return HTODDynacache.EMPTY_VS;
        }
        ValueSet valueSet = (ValueSet)result.data;
        if (valueSet == null) {
            valueSet = HTODDynacache.EMPTY_VS;
        }
        this.htod.returnToResultPool(result);
        return valueSet;
    }

    @Override
    public ValueSet readTemplatesByRange(int index, int length) {
        Result result = this.htod.readTemplatesByRange(index, length);
        if (result.returnCode == 1) {
            this.stopOnError(result.diskException);
            this.htod.returnToResultPool(result);
            return HTODDynacache.EMPTY_VS;
        }
        ValueSet valueSet = (ValueSet)result.data;
        if (valueSet == null) {
            valueSet = HTODDynacache.EMPTY_VS;
        }
        this.htod.returnToResultPool(result);
        return valueSet;
    }

    @Override
    public int getCacheIdsSize(boolean filter) {
        if (filter) {
            return this.htod.getCacheIdsSize(filter) - this.htod.invalidationBuffer.size();
        }
        return this.htod.getCacheIdsSize(filter);
    }

    @Override
    public int getDepIdsSize() {
        return this.htod.getDepIdsSize();
    }

    @Override
    public int getTemplatesSize() {
        return this.htod.getTemplatesSize();
    }

    @Override
    public long getCacheSizeInBytes() {
        return this.currentCacheSizeInBytes;
    }

    @Override
    public int getDiskCacheSizeLimit() {
        return this.diskCacheSizeInfo.diskCacheSizeLimit;
    }

    @Override
    public int getDiskCacheSizeHighLimit() {
        return this.diskCacheSizeInfo.diskCacheSizeHighLimit;
    }

    public int getDiskCachesizeLowLimit() {
        return this.diskCacheSizeInfo.diskCacheSizeLowLimit;
    }

    @Override
    public int getDiskCacheSizeInGBLimit() {
        return this.diskCacheSizeInfo.diskCacheSizeInGBLimit;
    }

    @Override
    public long getDiskCacheEntrySizeInBytesLimit() {
        return this.diskCacheSizeInfo.diskCacheEntrySizeInBytesLimit;
    }

    @Override
    public long getDiskCacheSizeInBytesLimit() {
        return this.diskCacheSizeInfo.getDiskCacheSizeInBytesLimit();
    }

    @Override
    public long getDiskCacheSizeInBytesHighLimit() {
        return this.diskCacheSizeInfo.getDiskCacheSizeInBytesHighLimit();
    }

    public long getDiskCacheSizeInBytesLowLimit() {
        return this.diskCacheSizeInfo.getDiskCacheSizeInBytesLowLimit();
    }

    @Override
    public int getEvictionPolicy() {
        return this.evictionPolicy;
    }

    @Override
    public void delDependencyEntry(Object id, Object entry) {
        if (this.htod.delDependencyEntry(id, entry) == 1) {
            this.stopOnError(this.htod.diskCacheException);
        }
    }

    @Override
    public void delTemplateEntry(String template, Object entry) {
        if (this.htod.delTemplateEntry(template, entry) == 1) {
            this.stopOnError(this.htod.diskCacheException);
        }
    }

    @Override
    public void delDependency(Object id) {
        if (this.htod.delDependency(id) == 1) {
            this.stopOnError(this.htod.diskCacheException);
        }
    }

    @Override
    public void delTemplate(String template) {
        if (this.htod.delTemplate(template) == 1) {
            this.stopOnError(this.htod.diskCacheException);
        }
    }

    @Override
    public int writeDependency(Object id, ValueSet vs) {
        int returnCode = this.htod.writeDependency(id, vs);
        if (returnCode == 1) {
            this.stopOnError(this.htod.diskCacheException);
        }
        return returnCode;
    }

    @Override
    public int writeTemplate(String template, ValueSet vs) {
        int returnCode = this.htod.writeTemplate(template, vs);
        if (returnCode == 1) {
            this.stopOnError(this.htod.diskCacheException);
        }
        return returnCode;
    }

    @Override
    public int writeDependencyEntry(Object id, Object entry) {
        int returnCode = this.htod.writeDependencyEntry(id, entry);
        if (returnCode == 1) {
            this.stopOnError(this.htod.diskCacheException);
        }
        return returnCode;
    }

    @Override
    public int writeTemplateEntry(String template, Object entry) {
        int returnCode = this.htod.writeTemplateEntry(template, entry);
        if (returnCode == 1) {
            this.stopOnError(this.htod.diskCacheException);
        }
        return returnCode;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.htod.containsKey(key);
    }

    @Override
    public int getStartState() {
        return this.startState;
    }

    @Override
    public boolean shouldPopulateEvictionTable() {
        return this.populateEvictionTable;
    }

    @Override
    public int getPendingRemovalSize() {
        return this.htod.getPendingRemovalSize();
    }

    @Override
    public int getDepIdsBufferedSize() {
        return this.htod.getDepIdsBufferedSize();
    }

    @Override
    public int getTemplatesBufferedSize() {
        return this.htod.getTemplatesBufferedSize();
    }

    protected long calculateSleepTime() {
        int currentSec;
        int currentMin;
        GregorianCalendar c = new GregorianCalendar();
        int currentHour = c.get(11);
        long stime = 86400L - (long)((currentHour * 60 + (currentMin = c.get(12))) * 60 + (currentSec = c.get(13))) + (long)(this.cleanupHour * 60 * 60);
        if (stime > 86400L) {
            stime -= 86400L;
        }
        if (stime < 10L) {
            stime = 10L;
        }
        return stime *= 1000L;
    }

    @Override
    public boolean isCleanupRunning() {
        return this.htod.invalidationBuffer.isBackgroundInvalidationInProgress();
    }

    @Override
    public void clearInvalidationBuffers() {
        this.htod.invalidationBuffer.clear(2);
        this.htod.invalidationBuffer.clear(1);
        if (this.evictionPolicy != 0) {
            this.htod.invalidationBuffer.clear(3);
        }
    }

    @Override
    @Trivial
    public boolean isInvalidationBuffersFull() {
        return this.htod.invalidationBuffer.isFull();
    }

    @Override
    public void releaseUnusedPools() {
        this.htod.releaseUnusedPools();
    }

    @Override
    public Result readHashcodeByRange(int index, int length, boolean debug, boolean useValue) {
        Result result = this.htod.readHashcodeByRange(index, length, debug, useValue);
        if (result.returnCode == 1) {
            this.stopOnError(result.diskException);
        }
        return result;
    }

    @Override
    public int updateExpirationTime(Object id, long oldExpirationTime, int size, long newExpirationTime, long newValidatorExpirationTime) {
        int returnCode = this.htod.updateExpirationTime(id, oldExpirationTime, size, newExpirationTime, newValidatorExpirationTime);
        if (returnCode == 1) {
            this.stopOnError(this.htod.diskCacheException);
        }
        return returnCode;
    }

    @Override
    public Exception getDiskCacheException() {
        return this.htod.diskCacheException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCleanupComplete() {
        String methodName = "waitForCleanupComplete()";
        if (this.diskCleanupThread != null) {
            boolean running = false;
            Object object = this.diskCleanupThread;
            synchronized (object) {
                running = this.diskCleanupThread.currentThread != null && this.diskCleanupThread.scan;
            }
            if (running) {
                object = this.diskCacheMonitor;
                synchronized (object) {
                    this.doNotify = true;
                    try {
                        this.traceDebug("waitForCleanupComplete()", "waiting for cleanup completion (max 5 sec) for cache name \"" + this.cacheName);
                        this.diskCacheMonitor.wait(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.doNotify = false;
                }
            }
        }
    }

    private boolean findSwapDirPath(String location) {
        int index;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + " findSwapDirPath " + location), (Object[])new Object[0]);
        }
        if ((index = location.indexOf("##")) == -1) {
            this.alternateLocation = location;
        } else {
            this.definedLocation = location.substring(0, index);
            this.alternateLocation = location.substring(index + 2);
        }
        if (!this.definedLocation.equals("")) {
            this.definedLocation = this.definedLocation + this.sep + this.diskCacheName;
        }
        if (!this.alternateLocation.equals("")) {
            this.alternateLocation = this.alternateLocation + this.sep + this.diskCacheName;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + " definedLocation " + this.definedLocation), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + " alternateLocation " + this.alternateLocation), (Object[])new Object[0]);
        }
        int rc1 = this.checkDirectoryWriteable(this.definedLocation);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + " rc1 " + rc1), (Object[])new Object[0]);
        }
        if (rc1 == 0) {
            this.swapDirPath = this.definedLocation;
            if (tc.isInfoEnabled()) {
                Tr.info((TraceComponent)tc, (String)"DYNA0053I", (Object[])new Object[]{this.cacheName, this.definedLocation});
            }
        } else {
            int rc2 = this.checkDirectoryWriteable(this.alternateLocation);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.cacheName + " rc2 " + rc2), (Object[])new Object[0]);
            }
            if (rc2 == 0 && rc1 == 1) {
                this.swapDirPath = this.alternateLocation;
                if (tc.isInfoEnabled()) {
                    Tr.info((TraceComponent)tc, (String)"DYNA0053I", (Object[])new Object[]{this.cacheName, this.alternateLocation});
                }
            } else if (rc2 == 0) {
                this.swapDirPath = this.alternateLocation;
                if (tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"DYNA0054W", (Object[])new Object[]{this.cacheName, this.definedLocation, this.alternateLocation});
                }
            } else {
                this.swapDirPath = "";
                if (tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0055E", (Object[])new Object[]{this.cacheName, this.definedLocation, this.alternateLocation});
                }
                this.cache.setSwapToDisk(false);
                return false;
            }
        }
        return true;
    }

    protected int checkDirectoryWriteable(String location) {
        String methodName = "checkDirectoryWriteable()";
        int rc = 0;
        if (location.equals("")) {
            rc = 1;
        } else if (location.startsWith("${") && location.indexOf("}") > 0) {
            rc = 2;
        } else {
            try {
                File f = new File(location);
                if (!f.exists()) {
                    if (!f.mkdirs()) {
                        rc = 5;
                    }
                } else if (!f.isDirectory()) {
                    rc = 3;
                } else if (!f.canWrite()) {
                    rc = 4;
                }
            }
            catch (Throwable t) {
                rc = 4;
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.CacheOnDisk.checkDirectoryWriteable", (String)"1779", (Object)this);
                this.traceDebug("checkDirectoryWriteable()", "cacheName=" + this.cacheName + " location=" + location + "\nException: " + ExceptionUtility.getStackTrace(t));
            }
        }
        this.traceDebug("checkDirectoryWriteable()", "cacheName=" + this.cacheName + " location=" + location + " rc=" + rc);
        return rc;
    }

    @Override
    public boolean isCacheIdInAuxDepIdTable(Object id) {
        return this.htod.isCacheIdInAuxDepIdTable(id);
    }

    private Future<?> spawnThread(Runnable task) {
        return Scheduler.submit(task);
    }

    private void traceDebug(String methodName, String message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " " + message), (Object[])new Object[0]);
        }
    }
}

