/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.InvalidationEvent;
import com.ibm.ws.cache.util.ObjectSizer;
import com.ibm.ws.cache.util.SerializationUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class InvalidateByIdEvent
implements InvalidationEvent,
Externalizable {
    private static final long serialVersionUID = 0x50002002L;
    static final boolean INVOKE_INTERNAL_INVALIDATE_BY_ID = true;
    static final boolean INVOKE_DRS_RENOUNCE = true;
    private static TraceComponent tc = Tr.register(InvalidateByIdEvent.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private Object id = null;
    private byte[] serializedId = null;
    private long timeStamp = -1L;
    private long drsClock = -1L;
    public boolean useServerClassLoader = false;
    public int causeOfInvalidation;
    public int source;
    public transient boolean invokeInternalInvalidateById = true;
    public transient boolean invokeDRSRenounce = true;
    private String cacheName = null;

    public InvalidateByIdEvent(Object id, int causeOfInvalidation, int source, boolean invokeInternalInvalidateById, boolean invokeDRSRenounce, String cacheName) {
        this.id = id;
        this.causeOfInvalidation = causeOfInvalidation;
        this.source = source;
        this.timeStamp = System.currentTimeMillis();
        this.invokeInternalInvalidateById = invokeInternalInvalidateById;
        this.invokeDRSRenounce = invokeDRSRenounce;
        this.cacheName = cacheName;
    }

    public InvalidateByIdEvent(Object id, int causeOfInvalidation, int source, boolean invokeInternalInvalidateById, boolean invokeDRSRenounce) {
        this.id = id;
        this.causeOfInvalidation = causeOfInvalidation;
        this.source = source;
        this.timeStamp = System.currentTimeMillis();
        this.invokeInternalInvalidateById = invokeInternalInvalidateById;
        this.invokeDRSRenounce = invokeDRSRenounce;
    }

    public InvalidateByIdEvent(Object id) {
        this.id = id;
        this.timeStamp = System.currentTimeMillis();
    }

    public InvalidateByIdEvent(Object id, long timeStamp) {
        this.id = id;
        this.timeStamp = timeStamp;
    }

    public InvalidateByIdEvent() {
    }

    public void setClassLoaderType(boolean cl) {
        this.useServerClassLoader = cl;
    }

    public Object getId() {
        return this.id;
    }

    public byte[] getSerializedId() {
        return this.serializedId;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public boolean prepareForSerialization() {
        boolean success = true;
        String exceptionMessage = null;
        if (this.serializedId == null) {
            try {
                this.serializedId = SerializationUtility.serialize((Serializable)this.id);
            }
            catch (IOException e) {
                exceptionMessage = e.toString();
            }
            catch (ClassCastException e) {
                exceptionMessage = e.toString();
            }
            if (this.serializedId == null) {
                Tr.error((TraceComponent)tc, (String)"DYNA0052E", (Object[])new Object[]{this.id, this.id.getClass().getName(), exceptionMessage});
                success = false;
            }
        }
        return success;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (!this.prepareForSerialization()) {
            throw new IOException("Object not serializable: " + (this.serializedId == null ? "null object" : this.serializedId.getClass().getName()));
        }
        if (this.serializedId != null) {
            out.writeInt(this.serializedId.length);
            out.write(this.serializedId);
        } else {
            out.writeInt(-1);
        }
        out.writeLong(this.timeStamp);
        out.writeLong(this.drsClock);
        out.writeInt(this.causeOfInvalidation);
        out.writeInt(this.source);
        out.writeBoolean(this.useServerClassLoader);
        out.writeObject(this.getCacheName());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int keyLength = in.readInt();
        if (keyLength > 0) {
            this.serializedId = new byte[keyLength];
            in.readFully(this.serializedId);
        } else {
            this.serializedId = null;
        }
        this.id = null;
        this.timeStamp = in.readLong();
        this.drsClock = in.readLong();
        this.causeOfInvalidation = in.readInt();
        this.source = in.readInt();
        try {
            this.useServerClassLoader = in.readBoolean();
        }
        catch (Exception ex) {
            this.useServerClassLoader = false;
        }
        try {
            this.cacheName = (String)in.readObject();
        }
        catch (Exception ex) {
            this.cacheName = null;
        }
        if (this.serializedId != null) {
            try {
                this.id = SerializationUtility.deserialize(this.serializedId, this.cacheName);
                this.serializedId = null;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.InvalidateByIdEvent.getId", (String)"146", (Object)this);
            }
        } else {
            this.id = null;
        }
    }

    public boolean isInvokeInternalInvalidateById() {
        return this.invokeInternalInvalidateById;
    }

    public boolean isInvokeDRSRenounce() {
        return this.invokeDRSRenounce;
    }

    public long getSerializedSize() {
        long totalSize = 0L;
        if (this.serializedId != null) {
            totalSize += ObjectSizer.getSize(this.serializedId);
        }
        return totalSize;
    }

    public String toString() {
        return "InvalidateByIdEvent [id=" + this.id + ", causeOfInvalidation=" + this.causeOfInvalidation + ", invokeInternalInvalidateById=" + this.invokeInternalInvalidateById + ", source=" + this.source + ", timeStamp=" + this.timeStamp + ", cacheName=" + this.cacheName + "]";
    }
}

