/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.server.schemagen;

import com.ibm.ws.kernel.service.util.UtilityTemplate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class ServerSchemaGenCommand
extends UtilityTemplate {
    private static final String SCRIPT_NAME = "serverSchemaGen";
    private static final ResourceBundle messages = ResourceBundle.getBundle("com.ibm.ws.config.server.schemagen.resources.SchemaGenMessages");
    private static final ResourceBundle options = ResourceBundle.getBundle("com.ibm.ws.config.server.schemagen.resources.SchemaGenOptions");
    private final PrintStream stdout;
    private final PrintStream stderr;
    private static final int RC_INVALID_OPTION = 20;
    private static final int RC_SERVER_NOT_FOUND = 21;
    private static final int RC_LOCAL_CONNECTOR_URL_NOT_FOUND = 22;
    private static final int RC_MBEAN_NOT_FOUND = 23;
    private static final int RC_MBEAN_INVALID_RESULT = 24;
    private static final int RC_SERVER_OUTPUT_NOT_FOUND = 25;
    private static final int RC_UNEXPECTED_ERROR = 255;

    protected ServerSchemaGenCommand() {
        this(System.out, System.err);
    }

    private ServerSchemaGenCommand(PrintStream stdout, PrintStream stderr) {
        this.stdout = stdout;
        this.stderr = stderr;
    }

    private String getMessage(String key, Object ... args) {
        String message = messages.getString(key);
        return args.length == 0 ? message : MessageFormat.format(message, args);
    }

    private String getScriptUsage() {
        return this.getMessage("usage", SCRIPT_NAME);
    }

    protected int generateServerSchema(String[] args) {
        int retCode = 0;
        try {
            String[] mbeanParams = new String[4];
            if (args == null || args.length == 0) {
                this.stdout.println(this.getScriptUsage());
                return 0;
            }
            String userDir = this.getUserDir();
            String serverName = args[0];
            File serverDirectory = new File(userDir + File.separator + "servers" + File.separator + serverName);
            if (!serverDirectory.exists() || !serverDirectory.isDirectory()) {
                this.stderr.println(this.getMessage("server.not.found", serverName, serverDirectory.getAbsolutePath()));
                this.stdout.println(this.getScriptUsage());
                return 21;
            }
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                String argToLower = arg.toLowerCase();
                if (argToLower.contains("help")) {
                    this.stdout.println(this.getScriptUsage());
                    this.stdout.println();
                    this.showUsageInfo();
                    return 0;
                }
                if (!arg.startsWith("-")) continue;
                if (argToLower.contains("-schemaversion")) {
                    mbeanParams[0] = this.getArgumentValue(args[i]);
                    continue;
                }
                if (argToLower.contains("-outputversion")) {
                    mbeanParams[1] = this.getArgumentValue(argToLower);
                    continue;
                }
                if (argToLower.contains("-encoding")) {
                    mbeanParams[2] = this.getArgumentValue(argToLower);
                    continue;
                }
                if (argToLower.contains("-locale")) {
                    mbeanParams[3] = this.getArgumentValue(argToLower);
                    continue;
                }
                this.stdout.println(MessageFormat.format(messages.getString("error.unknownArgument"), arg));
                this.stdout.println();
                return 20;
            }
            retCode = this.invokeSchemaGen(serverName, mbeanParams);
        }
        catch (Throwable t) {
            this.stderr.println(this.getMessage("exception.catch", t.toString()));
            t.printStackTrace(this.stderr);
            return 255;
        }
        return retCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private int invokeSchemaGen(String serverName, String[] mbeanParams) {
        block49: {
            block47: {
                block48: {
                    block45: {
                        block46: {
                            block43: {
                                block44: {
                                    block41: {
                                        block42: {
                                            block39: {
                                                block40: {
                                                    block37: {
                                                        block38: {
                                                            block35: {
                                                                block36: {
                                                                    logsDir = new File(this.getOutputDir(serverName) + serverName + File.separator + "logs");
                                                                    if (!logsDir.exists()) {
                                                                        this.stderr.println(this.getMessage("server.output.logs.dir.not.found", new Object[]{serverName, logsDir.getAbsolutePath()}));
                                                                        return 25;
                                                                    }
                                                                    jmxLocalConnectorUrlFile = new File(this.getOutputDir(serverName) + serverName + File.separator + "logs" + File.separator + "state" + File.separator + "/com.ibm.ws.jmx.local.address");
                                                                    if (!jmxLocalConnectorUrlFile.exists()) {
                                                                        this.stderr.println(this.getMessage("local.connector.not.found", new Object[]{serverName}));
                                                                        return 22;
                                                                    }
                                                                    signature = new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()};
                                                                    connector = null;
                                                                    br = new BufferedReader(new FileReader(jmxLocalConnectorUrlFile));
                                                                    urlString = br.readLine();
                                                                    br.close();
                                                                    if (urlString != null) break block35;
                                                                    this.stderr.println(this.getMessage("local.connector.url.empty", new Object[]{serverName}));
                                                                    var9_12 = 255;
                                                                    if (connector == null) break block36;
                                                                    try {
                                                                        connector.close();
                                                                        connector = null;
                                                                    }
                                                                    catch (Throwable var10_15) {
                                                                        // empty catch block
                                                                    }
                                                                }
                                                                return var9_12;
                                                            }
                                                            url = new JMXServiceURL(urlString);
                                                            connector = JMXConnectorFactory.connect(url);
                                                            con = connector.getMBeanServerConnection();
                                                            name = new ObjectName("WebSphere:name=com.ibm.ws.config.serverSchemaGenerator");
                                                            objects = con.queryMBeans(name, null);
                                                            if (objects == null || objects.size() <= 0) ** GOTO lbl116
                                                            i = objects.iterator();
                                                            o = i.next();
                                                            instanceName = o.getObjectName();
                                                            generateResults = (Map)con.invoke(instanceName, "generateServerSchema", mbeanParams, signature);
                                                            if (generateResults != null) break block37;
                                                            this.stderr.println(this.getMessage("mbean.null.result", new Object[0]));
                                                            var17_25 = 24;
                                                            if (connector == null) break block38;
                                                            try {
                                                                connector.close();
                                                                connector = null;
                                                            }
                                                            catch (Throwable var18_28) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        return var17_25;
                                                    }
                                                    if (!generateResults.containsKey("keyReturnCode")) ** GOTO lbl70
                                                    success = (Integer)generateResults.get("keyReturnCode");
                                                    if (success != null && success == 0) break block39;
                                                    this.stderr.println(this.getMessage("mbean.bad.result", new Object[0]));
                                                    var18_29 = 24;
                                                    if (connector == null) break block40;
                                                    try {
                                                        connector.close();
                                                        connector = null;
                                                    }
                                                    catch (Throwable var19_33) {
                                                        // empty catch block
                                                    }
                                                }
                                                return var18_29;
                                            }
                                            break block41;
lbl70:
                                            // 1 sources

                                            this.stderr.println(this.getMessage("mbean.missing.result", new Object[0]));
                                            success = 24;
                                            if (connector == null) break block42;
                                            try {
                                                connector.close();
                                                connector = null;
                                            }
                                            catch (Throwable var18_30) {
                                                // empty catch block
                                            }
                                        }
                                        return success;
                                    }
                                    outputDirectory = null;
                                    if (!generateResults.containsKey("keyFilePath")) ** GOTO lbl102
                                    outputDirectory = (String)generateResults.get("keyFilePath");
                                    if (outputDirectory != null && outputDirectory.length() > 0) break block43;
                                    this.stderr.println(this.getMessage("mbean.missing.output.dir", new Object[0]));
                                    var18_31 = 24;
                                    if (connector == null) break block44;
                                    try {
                                        connector.close();
                                        connector = null;
                                    }
                                    catch (Throwable var19_34) {
                                        // empty catch block
                                    }
                                }
                                return var18_31;
                            }
                            this.stdout.println(this.getMessage("mbean.output.dir", new Object[]{outputDirectory}));
                            break block45;
lbl102:
                            // 1 sources

                            this.stderr.println(this.getMessage("mbean.missing.output.dir", new Object[0]));
                            var18_32 = 24;
                            if (connector == null) break block46;
                            try {
                                connector.close();
                                connector = null;
                            }
                            catch (Throwable var19_35) {
                                // empty catch block
                            }
                        }
                        return var18_32;
                    }
                    break block47;
lbl116:
                    // 1 sources

                    this.stderr.println(this.getMessage("mbean.not.found", new Object[]{serverName}));
                    var13_20 = 23;
                    if (connector == null) break block48;
                    try {
                        connector.close();
                        connector = null;
                    }
                    catch (Throwable var14_22) {
                        // empty catch block
                    }
                }
                return var13_20;
            }
            if (connector != null) {
                try {
                    connector.close();
                    connector = null;
                }
                catch (Throwable br) {}
            }
            break block49;
            catch (Throwable t) {
                try {
                    this.stderr.println(this.getMessage("exception.catch", new Object[]{t.toString()}));
                    t.printStackTrace(this.stderr);
                    var8_11 = 255;
                    return var8_11;
                }
                catch (Throwable var20_36) {
                    throw var20_36;
                }
                finally {
                    if (connector != null) {
                        try {
                            connector.close();
                            connector = null;
                        }
                        catch (Throwable var9_14) {}
                    }
                }
            }
        }
        return 0;
    }

    private String getArgumentValue(String arg) {
        int idx = arg.lastIndexOf("=");
        if (idx < 1) {
            throw new RuntimeException(MessageFormat.format(messages.getString("error.invalidArgument"), arg));
        }
        return arg.substring(idx + 1);
    }

    public static void main(String[] args) {
        ServerSchemaGenCommand util = new ServerSchemaGenCommand();
        int rc = util.generateServerSchema(args);
        System.exit(rc);
    }

    private void showUsageInfo() {
        String[] optionKeys = new String[]{"option-key.schemaversion", "option-key.outputversion", "option-key.encoding", "option-key.locale"};
        String okpfx = "option-key.";
        String odpfx = "option-desc.";
        this.stdout.println(options.getString("use.options"));
        this.stdout.println();
        for (String optionKey : optionKeys) {
            String option = optionKey.substring("option-key.".length());
            this.stdout.println(options.getString(optionKey));
            this.stdout.println(options.getString("option-desc." + option));
            this.stdout.println();
        }
    }
}

