/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jndi.internal.WSContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class WASObjectFactoryBuilder
implements ObjectFactoryBuilder {
    private static final TraceNLS nls;
    static final long serialVersionUID = -7055327423419959170L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    @FFDCIgnore(value={ClassNotFoundException.class, Throwable.class, IllegalAccessException.class, InstantiationException.class})
    public ObjectFactory createObjectFactory(Object o, Hashtable<?, ?> envmt) throws NamingException {
        ObjectFactory of = null;
        String className = null;
        if (o instanceof Reference) {
            className = ((Reference)o).getFactoryClassName();
        } else if (o instanceof Referenceable) {
            className = ((Referenceable)o).getReference().getFactoryClassName();
        }
        if (className != null) {
            try {
                Class<?> clazz = Class.forName(className, true, this.getClassLoader());
                of = (ObjectFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                try {
                    Class<?> clazz = Class.forName(className);
                    of = (ObjectFactory)clazz.newInstance();
                }
                catch (Throwable clazz) {
                    // empty catch block
                }
                if (of == null) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.osgi.jndi.fep.WASObjectFactoryBuilder.createObjectFactory", (String)"44", (Object)this, (Object[])new Object[]{o, envmt});
                    String errorString = nls.getFormattedMessage("jndi.objectfactory.no.class", new Object[]{o.getClass().getName(), className}, "Could not find class to create ObjectFactory " + className + " for class " + o.getClass().getName());
                    NamingException ne = new NamingException(errorString);
                    ne.initCause(e);
                    throw ne;
                }
            }
            catch (IllegalAccessException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.osgi.jndi.fep.WASObjectFactoryBuilder.createObjectFactory", (String)"51", (Object)this, (Object[])new Object[]{o, envmt});
                String errorString = nls.getFormattedMessage("jndi.objectfactory.create.failed", new Object[]{o.getClass().getName(), className}, "Unable to create ObjectFactory for " + o.getClass().getName() + " with factory class name " + className);
                NamingException ne = new NamingException(errorString);
                ne.initCause(e);
                throw ne;
            }
            catch (InstantiationException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.osgi.jndi.fep.WASObjectFactoryBuilder.createObjectFactory", (String)"58", (Object)this, (Object[])new Object[]{o, envmt});
                String errorString = nls.getFormattedMessage("jndi.objectfactory.create.failed", new Object[]{o.getClass().getName(), className}, "Unable to create ObjectFactory for " + o.getClass().getName() + " with factory class name " + className);
                NamingException ne = new NamingException(errorString);
                ne.initCause(e);
                throw ne;
            }
        }
        return of;
    }

    private ClassLoader getClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = -3646431036605493588L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(WASObjectFactoryBuilder.class);
        nls = TraceNLS.getTraceNLS(WSContext.class, (String)"com.ibm.ws.jndi.internal.resources.JNDIMessages");
    }
}

