/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.session.SessionEventDispatcher;
import com.ibm.ws.session.SessionStateEventDispatcher;
import com.ibm.ws.session.StoreCallback;
import com.ibm.ws.session.utils.IIDGenerator;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.wsspi.session.IGenericSessionManager;
import com.ibm.wsspi.session.IProtocolAdapter;
import com.ibm.wsspi.session.ISession;
import com.ibm.wsspi.session.ISessionAffinityManager;
import com.ibm.wsspi.session.ISessionManagerCustomizer;
import com.ibm.wsspi.session.ISessionObserver;
import com.ibm.wsspi.session.ISessionStateObserver;
import com.ibm.wsspi.session.IStore;
import com.ibm.wsspi.session.IStoreCallback;
import com.ibm.wsspi.session.IStorer;
import com.ibm.wsspi.session.SessionAffinityContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SessionManager
implements IGenericSessionManager,
ISessionManagerCustomizer {
    private final int _numOfPartitions = 10;
    private final int _replicationType = 1;
    private final int _replicationInterval = 10;
    private final boolean _shareAcrossApps = false;
    protected static boolean _loggedVersion = false;
    protected IIDGenerator _idGenerator = null;
    protected IStore _store = null;
    protected ArrayList _sessionObservers = new ArrayList();
    protected ArrayList _sessionStateObservers = new ArrayList();
    protected String _ID;
    protected IStoreCallback _storeCallback = null;
    protected ISessionStateObserver _sessionStateEventDispatcher = null;
    protected ISessionObserver _sessionEventDispatcher = null;
    protected int _sessionTimeout = 1800;
    protected IStorer _storer = null;
    protected boolean _shareAcrossWebApps;
    protected ObjectName _statsModuleObjectName = null;
    protected static final String methodClassName = "SessionManager";
    protected ISessionAffinityManager _sam;
    protected ServletContext _servletContext = null;
    public IProtocolAdapter _adapter = null;
    private static final int CREATE_ISESSION = 0;
    private static final int SHUTDOWN = 1;
    private static final String[] methodNames = new String[]{"createISession", "shutdown"};
    private final HashMap createSync = new HashMap();
    protected SessionManager appSessionMgr = null;
    private static final String overflowId = "overflowed-session";
    private static Map<String, SessionManager> sessionManagerMap = new HashMap<String, SessionManager>();

    public SessionManager(String id) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE) && !_loggedVersion) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "", "CMVC Version 1.3 3/13/07 12:00:50");
            _loggedVersion = true;
        }
        this._ID = id;
        this._sessionStateEventDispatcher = new SessionStateEventDispatcher(this._sessionStateObservers);
        this._sessionEventDispatcher = new SessionEventDispatcher(this._sessionObservers);
        this._storeCallback = new StoreCallback(this);
        sessionManagerMap.put(id, this);
    }

    protected void setAppSessionMgr(SessionManager asm) {
        this.appSessionMgr = asm;
    }

    public SessionManager getAppSessionMgr() {
        return this.appSessionMgr;
    }

    public static SessionManager getSessionManager(String id) {
        return sessionManagerMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISession createISession(String id, int sessionVersion, boolean reuseTheId) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[0], "id= " + id);
        }
        ISession iSession = null;
        boolean created = true;
        if (null == id || !reuseTheId && !this._store.idExists(id) || reuseTheId && id.equals(overflowId)) {
            while (iSession == null) {
                id = this._idGenerator.getID();
                iSession = this._store.createSession(id, true);
            }
        } else {
            String createLock = null;
            Object object = this;
            synchronized (object) {
                createLock = (String)this.createSync.get(id);
                if (createLock == null) {
                    createLock = id;
                    this.createSync.put(id, createLock);
                }
            }
            object = createLock;
            synchronized (object) {
                iSession = (ISession)this._store.getFromMemory(id);
                if (iSession == null) {
                    iSession = this._store.createSession(id, false);
                    if (sessionVersion != -1) {
                        iSession.setVersion(sessionVersion);
                    }
                    this.createSync.remove(id);
                } else {
                    this.createSync.remove(id);
                    created = false;
                }
            }
        }
        iSession.incrementRefCount();
        if (created) {
            iSession.setMaxInactiveInterval(this._sessionTimeout);
            this._sessionEventDispatcher.sessionCreated(iSession);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[0]);
        }
        return iSession;
    }

    @Override
    public Object generateNewId(HttpServletRequest req, HttpServletResponse resp, SessionAffinityContext sac, ISession iSession) {
        Object session = this.updateSessionId((ServletRequest)req, (ServletResponse)resp, sac, iSession);
        return session;
    }

    public Object createSession(String id, int sessionVersion, Object correlator) {
        if (!TraceComponent.isAnyTracingEnabled() || LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            // empty if block
        }
        ISession iSession = null;
        if (null == id || !this._store.idExists(id, correlator)) {
            id = this._idGenerator.getID();
            iSession = this._store.createSession(id, correlator);
        } else {
            iSession = this._store.createSession(id, correlator);
            if (sessionVersion != -1) {
                iSession.setVersion(sessionVersion);
            }
        }
        iSession.incrementRefCount();
        iSession.setMaxInactiveInterval(this._sessionTimeout);
        this._sessionEventDispatcher.sessionCreated(iSession);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, "createSession", "iSession = " + iSession);
        }
        return iSession;
    }

    public boolean needToRedirect(Object correlator) {
        return this._store.needToRedirect(correlator);
    }

    public void setExternalStore(IStore store) {
        this._store = store;
        this._store.setStoreCallback(this._storeCallback);
    }

    public IStore getExternalStore() {
        return this._store;
    }

    public void setIdGenerator(IIDGenerator idGenerator) {
        this._idGenerator = idGenerator;
    }

    public void setStorer(IStorer storer) {
        this._storer = storer;
    }

    public void setStatsModuleObjectName(ObjectName moduleObjectName) {
        this._statsModuleObjectName = moduleObjectName;
    }

    public Object getSession(String id, int version, boolean isSessionAccess, Object xdCorrelator) {
        return this.getSession(id, version, isSessionAccess, false, xdCorrelator);
    }

    protected Object getSession(String id, int version, boolean isSessionAccess, boolean forceSessionRetrieval, Object xdCorrelator) {
        ISession iSession;
        if (isSessionAccess) {
            if (version == -1) {
                this._store.refreshSession(id, xdCorrelator);
            } else {
                this._store.refreshSession(id, version, xdCorrelator);
            }
        }
        if ((iSession = this.getSessionFromStore(id, version, isSessionAccess, forceSessionRetrieval, xdCorrelator)) != null) {
            if (isSessionAccess) {
                boolean stillValid = this._store.checkSessionStillValid(iSession, iSession.getLastAccessedTime());
                if (stillValid) {
                    iSession.incrementRefCount();
                    this._sessionEventDispatcher.sessionAccessed(iSession);
                } else {
                    iSession = null;
                }
            }
        } else if (isSessionAccess) {
            this._sessionEventDispatcher.sessionAccessUnknownKey(id);
        }
        return iSession;
    }

    protected ISession getSessionFromStore(String id, int version, boolean isSessionAccess, boolean forceSessionRetrieval, Object xdCorrelator) {
        return this._store.getSession(id, version, isSessionAccess, xdCorrelator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSession(Object sessionObject, SessionAffinityContext affinityContext) {
        ISession session = (ISession)sessionObject;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, "releaseSession", "sessionID = " + session.getId());
        }
        ISession iSession = session;
        synchronized (iSession) {
            session.decrementRefCount();
            if (session.isValid()) {
                session.updateLastAccessTime();
                session.setIsNew(false);
                boolean fromCookie = false;
                if (affinityContext != null) {
                    fromCookie = affinityContext.isRequestedSessionIDFromCookie();
                }
                this._storer.storeSession(session, fromCookie);
            }
            this._store.releaseSession(session);
            this._sessionEventDispatcher.sessionReleased(session);
        }
    }

    @Override
    public void shutdown() {
        ArrayList<MBeanServer> mbeanSvrs = MBeanServerFactory.findMBeanServer(null);
        if (mbeanSvrs != null && mbeanSvrs.size() > 0 && this._statsModuleObjectName != null) {
            MBeanServer svr = mbeanSvrs.get(0);
            try {
                svr.unregisterMBean(this._statsModuleObjectName);
            }
            catch (InstanceNotFoundException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.session.SessionManager.shutdown", (String)"263", (Object)this);
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.SEVERE, methodClassName, methodNames[1], "CommonMessage.exception", e);
            }
            catch (MBeanRegistrationException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.session.SessionManager.shutdown", (String)"265", (Object)this);
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.SEVERE, methodClassName, methodNames[1], "CommonMessage.exception", e);
            }
        }
    }

    @Override
    public String getID() {
        return this._ID;
    }

    @Override
    public void setID(String id) {
        this._ID = id;
        if (this._store != null) {
            this._store.setID(id);
        }
    }

    @Override
    public void setSessionTimeout(int i) {
        this._sessionTimeout = i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSessionObserver(ISessionObserver observer) {
        ArrayList arrayList = this._sessionObservers;
        synchronized (arrayList) {
            this._sessionObservers.add(observer);
        }
    }

    public ISessionObserver getSessionEventDispatcher() {
        return this._sessionEventDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSessionStateObserver(ISessionStateObserver observer) {
        ArrayList arrayList = this._sessionStateObservers;
        synchronized (arrayList) {
            this._sessionStateObservers.add(observer);
        }
    }

    public ISessionStateObserver getSessionStateEventDispatcher() {
        return this._sessionStateEventDispatcher;
    }

    @Override
    public boolean isSharedAcrossWebApps() {
        return this._shareAcrossWebApps;
    }

    @Override
    public void setSharedAcrossWebApps(boolean share) {
        this._shareAcrossWebApps = share;
    }

    public ObjectName getStatsModuleObjectName() {
        return this._statsModuleObjectName;
    }

    @Override
    public ISessionManagerCustomizer getSessionManagerCustomizer() {
        return this;
    }

    @Override
    public Object getSession(ServletRequest request, ServletResponse response, SessionAffinityContext affinityContext, boolean create) {
        String sessionID = this._sam.getInUseSessionID(request, affinityContext);
        int sessionVersion = this._sam.getInUseSessionVersion(request, affinityContext);
        ISession session = null;
        if (sessionID != null && (session = (ISession)this.getSession(sessionID, sessionVersion, true, null)) == null && affinityContext.isRequestedSessionIDFromCookie() && !affinityContext.isAllSessionIdsSetViaSet()) {
            List allSessionIds = this._sam.getAllCookieValues(request);
            affinityContext.setAllSessionIds(allSessionIds);
        }
        while (session == null && this._sam.setNextId(affinityContext)) {
            sessionID = this._sam.getInUseSessionID(request, affinityContext);
            sessionVersion = this._sam.getInUseSessionVersion(request, affinityContext);
            session = (ISession)this.getSession(sessionID, sessionVersion, true, null);
        }
        if (session == null && create) {
            boolean reuseThisID = false;
            if (this._store.getShouldReuseId() || affinityContext.isResponseIdSet() || affinityContext.isRequestedSessionIDFromSSL()) {
                reuseThisID = true;
            }
            session = this.createISession(sessionID, sessionVersion, reuseThisID);
        }
        return this.adaptAndSetCookie(request, response, affinityContext, session);
    }

    @Override
    public Object createSession(ServletRequest req, ServletResponse res, SessionAffinityContext sac, boolean reuseTheId) {
        String id = this._sam.getInUseSessionID(req, sac);
        int version = this._sam.getInUseSessionVersion(req, sac);
        ISession isess = this.createISession(id, version, reuseTheId);
        return this.adaptAndSetCookie(req, res, sac, isess);
    }

    private Object updateSessionId(ServletRequest req, ServletResponse res, SessionAffinityContext sac, ISession sess) {
        String oldId = sess.getId();
        String id = this._idGenerator.getID();
        int version = this._sam.getInUseSessionVersion(req, sac);
        this.updateSessionIdInObject(sess, id, version);
        this._sessionEventDispatcher.sessionIdChanged(oldId, sess);
        return this.adaptAndSetCookie(req, res, sac, sess);
    }

    private void updateSessionIdInObject(ISession sess, String id, int version) {
        String oldId = sess.getId();
        sess.setId(id);
        this._store.updateSessionId(oldId, sess);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "updateSessionIdInObject", "updated session id from " + oldId + " to " + id + " _store = " + this._store.toString());
        }
    }

    protected Object adaptAndSetCookie(ServletRequest req, ServletResponse res, SessionAffinityContext sac, ISession isess) {
        Object adaptedSession = null;
        if (isess != null) {
            adaptedSession = this._adapter.adapt(isess);
            sac.setResponseSessionID(isess.getId());
            sac.setResponseSessionVersion(isess.getVersion());
            this._sam.setCookie(req, res, sac, adaptedSession);
        }
        return adaptedSession;
    }

    @Override
    public ISessionAffinityManager getAffinityManager() {
        return this._sam;
    }

    @Override
    public IStore getIStore() {
        return this._store;
    }

    @Override
    public ISession getISession(String id) {
        return (ISession)this.getSession(id, 0, false, null);
    }

    @Override
    public Object getSession(String id) {
        return this.getSession(id, true);
    }

    @Override
    public Object getSession(String id, boolean sessionAccess) {
        ISession isess = null;
        Object adaptedSession = null;
        if (id != null) {
            isess = (ISession)this.getSession(id, 0, sessionAccess, null);
        }
        if (isess != null) {
            adaptedSession = this._adapter.adapt(isess);
        }
        return adaptedSession;
    }

    @Override
    public boolean isRequestedSessionIDValid(String sessionID, int version) {
        ISession session;
        boolean isValid = false;
        if (sessionID != null && (session = (ISession)this.getSession(sessionID, version, false, null)) != null) {
            isValid = session.isValid();
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "isRequestedSessionIDValid", "" + isValid);
        }
        return isValid;
    }

    @Override
    public void registerStore(IStore store) {
        this._store = store;
        this._store.setStoreCallback(this._storeCallback);
        if (store instanceof ISessionObserver) {
            this.registerSessionObserver((ISessionObserver)((Object)store));
        }
        if (store instanceof ISessionStateObserver) {
            this.registerSessionStateObserver((ISessionStateObserver)((Object)store));
        }
    }

    @Override
    public void registerStorer(IStorer storer) {
        this._storer = storer;
    }

    public IStorer getStorer() {
        return this._storer;
    }

    @Override
    public void setIDGenerator(IIDGenerator IDGenerator) {
        this._idGenerator = IDGenerator;
    }

    @Override
    public void setServletContext(ServletContext context) {
        this._servletContext = context;
    }

    @Override
    public void registerAffinityManager(ISessionAffinityManager manager) {
        this._sam = manager;
    }

    @Override
    public void registerStatsModuleObjectName(ObjectName moduleObjectName) {
        this._statsModuleObjectName = moduleObjectName;
    }

    @Override
    public void setAdapter(IProtocolAdapter adapter) {
        this._adapter = adapter;
    }

    @Override
    public IProtocolAdapter getAdapter() {
        return this._adapter;
    }

    @Override
    public IProtocolAdapter getProtocolAdapter() {
        return null;
    }

    @Override
    public boolean isRequestedSessionIDValid(ServletRequest request, String sessionID, int version) {
        return false;
    }

    @Override
    public boolean needToRedirect(ServletRequest req, SessionAffinityContext affinityContext, Object session) {
        return false;
    }

    @Override
    public void createProtocolAdapter(Properties props) {
    }

    @Override
    public void registerListeners(ClassLoader classloader, ArrayList list) {
    }
}

