/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.config.SettableConfig;
import com.netflix.archaius.config.AbstractConfig;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DefaultSettableConfig
extends AbstractConfig
implements SettableConfig {
    private ConcurrentMap<String, Object> props = new ConcurrentHashMap<String, Object>();

    @Override
    public <T> void setProperty(String propName, T propValue) {
        this.props.put(propName, propValue);
        this.notifyConfigUpdated(this);
    }

    @Override
    public void clearProperty(String propName) {
        this.props.remove(propName);
        this.notifyConfigUpdated(this);
    }

    @Override
    public boolean containsKey(String key) {
        return this.props.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    @Override
    public Object getRawProperty(String key) {
        return this.props.get(key);
    }

    @Override
    public Iterator<String> getKeys() {
        return this.props.keySet().iterator();
    }

    @Override
    public void setProperties(Properties properties) {
        if (null != properties) {
            for (Map.Entry<Object, Object> prop : properties.entrySet()) {
                this.setProperty(prop.getKey().toString(), prop.getValue());
            }
        }
    }

    @Override
    public void setProperties(Config config) {
        if (null != config) {
            Iterator<String> iter = config.getKeys();
            while (iter.hasNext()) {
                String key = iter.next();
                this.setProperty(key, config.getRawProperty(key));
            }
        }
    }
}

