/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.StrInterpolator;
import com.netflix.archaius.config.AbstractConfig;
import com.netflix.archaius.interpolate.ConfigStrLookup;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class PrefixedViewConfig
extends AbstractConfig {
    private final Config config;
    private final String prefix;
    private final StrInterpolator.Lookup nonPrefixedLookup;

    public PrefixedViewConfig(String prefix, Config config) {
        this.config = config;
        this.prefix = prefix.endsWith(".") ? prefix : prefix + ".";
        this.nonPrefixedLookup = ConfigStrLookup.from(config);
    }

    @Override
    public Iterator<String> getKeys() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Iterator<String> iter = this.config.getKeys();
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.startsWith(this.prefix)) continue;
            result.add(key.substring(this.prefix.length()));
        }
        return result.iterator();
    }

    @Override
    public boolean containsKey(String key) {
        return this.config.containsKey(this.prefix + key);
    }

    @Override
    public boolean isEmpty() {
        return !this.config.getKeys().hasNext();
    }

    @Override
    public <T> T accept(Config.Visitor<T> visitor) {
        return this.config.accept(visitor);
    }

    @Override
    public Object getRawProperty(String key) {
        if (this.config.containsKey(this.prefix + key)) {
            return this.config.getRawProperty(this.prefix + key);
        }
        return null;
    }

    @Override
    protected StrInterpolator.Lookup getLookup() {
        return this.nonPrefixedLookup;
    }

    @Override
    public synchronized void setDecoder(Decoder decoder) {
        super.setDecoder(decoder);
        this.config.setDecoder(decoder);
    }

    @Override
    public synchronized void setStrInterpolator(StrInterpolator interpolator) {
        super.setStrInterpolator(interpolator);
        this.config.setStrInterpolator(interpolator);
    }

    @Override
    public synchronized void addListener(ConfigListener listener) {
        super.addListener(listener);
        this.config.addListener(listener);
    }

    @Override
    public synchronized void removeListener(ConfigListener listener) {
        super.removeListener(listener);
        this.config.removeListener(listener);
    }
}

