/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.astefanutti.metrics.cdi.MetricName;
import io.astefanutti.metrics.cdi.MetricsExtension;
import io.astefanutti.metrics.cdi.MetricsParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Vetoed;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.Timed;

@ApplicationScoped
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class MetricResolver {
    @Inject
    private MetricsExtension extension;
    @Inject
    private MetricName metricName;
    static final long serialVersionUID = -945175490108829466L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    MetricResolver() {
    }

    <E extends Member & AnnotatedElement> Of<Counted> counted(Class<?> topClass, E element) {
        return this.resolverOf(topClass, element, (Class)Counted.class);
    }

    Of<Gauge> gauge(Class<?> topClass, Method method) {
        return this.resolverOf(topClass, method, Gauge.class);
    }

    <E extends Member & AnnotatedElement> Of<Metered> metered(Class<?> topClass, E element) {
        return this.resolverOf(topClass, element, (Class)Metered.class);
    }

    <E extends Member & AnnotatedElement> Of<Timed> timed(Class<?> bean, E element) {
        return this.resolverOf(bean, element, (Class)Timed.class);
    }

    private <E extends Member & AnnotatedElement, T extends Annotation> Of<T> resolverOf(Class<?> bean, E element, Class<T> metric) {
        if (((AnnotatedElement)element).isAnnotationPresent(metric)) {
            return this.elementResolverOf(element, metric);
        }
        return this.beanResolverOf(element, metric, bean);
    }

    private <E extends Member & AnnotatedElement, T extends Annotation> Of<T> elementResolverOf(E element, Class<T> metric) {
        T annotation = ((AnnotatedElement)element).getAnnotation(metric);
        String name = this.metricName(element, (Class<? extends Annotation>)metric, this.metricName((Annotation)annotation), this.isMetricAbsolute((Annotation)annotation));
        Metadata metadata = new Metadata(name, this.getType((Annotation)annotation), this.getUnit((Annotation)annotation));
        metadata.setDescription(this.getDescription((Annotation)annotation));
        metadata.setDisplayName(this.getDisplayname((Annotation)annotation));
        for (String tag : this.getTags((Annotation)annotation)) {
            metadata.addTag(tag);
        }
        return new DoesHaveMetric((Annotation)annotation, name, metadata, null);
    }

    private <E extends Member & AnnotatedElement, T extends Annotation> Of<T> beanResolverOf(E element, Class<T> metric, Class<?> bean) {
        if (bean.isAnnotationPresent(metric)) {
            T annotation = bean.getAnnotation(metric);
            String name = this.metricName(bean, element, (Class<? extends Annotation>)metric, this.metricName((Annotation)annotation), this.isMetricAbsolute((Annotation)annotation));
            Metadata metadata = new Metadata(name, this.getType((Annotation)annotation), this.getUnit((Annotation)annotation));
            metadata.setDescription(this.getDescription((Annotation)annotation));
            metadata.setDisplayName(this.getDisplayname((Annotation)annotation));
            for (String tag : this.getTags((Annotation)annotation)) {
                metadata.addTag(tag);
            }
            return new DoesHaveMetric((Annotation)annotation, name, metadata, null);
        }
        if (bean.getSuperclass() != null) {
            return this.beanResolverOf(element, metric, bean.getSuperclass());
        }
        return new DoesNotHaveMetric();
    }

    private <E extends Member & AnnotatedElement> String metricName(E element, Class<? extends Annotation> type, String name, boolean absolute) {
        String metric = name.isEmpty() ? this.defaultName(element, type) : this.metricName.of(name);
        return absolute ? metric : MetricRegistry.name(element.getDeclaringClass(), (String[])new String[]{metric});
    }

    private <E extends Member & AnnotatedElement> String metricName(Class<?> bean, E element, Class<? extends Annotation> type, String name, boolean absolute) {
        String metric = name.isEmpty() ? bean.getSimpleName() : this.metricName.of(name);
        return absolute ? MetricRegistry.name((String)metric, (String[])new String[]{this.defaultName(element, type)}) : MetricRegistry.name((String)bean.getPackage().getName(), (String[])new String[]{metric, this.defaultName(element, type)});
    }

    private <E extends Member & AnnotatedElement> String defaultName(E element, Class<? extends Annotation> type) {
        return this.memberName(element);
    }

    private String memberName(Member member) {
        if (member instanceof Constructor) {
            return member.getDeclaringClass().getSimpleName();
        }
        return member.getName();
    }

    private String metricName(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).name();
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).name();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).name();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).name();
        }
        throw new IllegalArgumentException("Unsupported Metrics forMethod [" + annotation.getClass().getName() + "]");
    }

    private boolean isMetricAbsolute(Annotation annotation) {
        if (this.extension.getParameters().contains((Object)MetricsParameter.useAbsoluteName)) {
            return true;
        }
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).absolute();
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).absolute();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).absolute();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).absolute();
        }
        throw new IllegalArgumentException("Unsupported Metrics forMethod [" + annotation.getClass().getName() + "]");
    }

    private String[] getTags(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).tags();
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).tags();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).tags();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).tags();
        }
        throw new IllegalArgumentException("Unsupported Metrics forMethod [" + annotation.getClass().getName() + "]");
    }

    private String getDisplayname(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).displayName();
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).displayName();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).displayName();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).displayName();
        }
        throw new IllegalArgumentException("Unsupported Metrics forMethod [" + annotation.getClass().getName() + "]");
    }

    private String getDescription(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).description();
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).description();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).description();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).description();
        }
        throw new IllegalArgumentException("Unsupported Metrics forMethod [" + annotation.getClass().getName() + "]");
    }

    private MetricType getType(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return MetricType.COUNTER;
        }
        if (Gauge.class.isInstance(annotation)) {
            return MetricType.GAUGE;
        }
        if (Metered.class.isInstance(annotation)) {
            return MetricType.METERED;
        }
        if (Timed.class.isInstance(annotation)) {
            return MetricType.TIMER;
        }
        throw new IllegalArgumentException("Unsupported Metrics forMethod [" + annotation.getClass().getName() + "]");
    }

    private String getUnit(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).unit();
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).unit();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).unit();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).unit();
        }
        throw new IllegalArgumentException("Unsupported Metrics forMethod [" + annotation.getClass().getName() + "]");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MetricResolver.class);
    }

    @Vetoed
    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class DoesNotHaveMetric<T extends Annotation>
    implements Of<T> {
        static final long serialVersionUID = 3871601493274993670L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private DoesNotHaveMetric() {
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public String metricName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T metricAnnotation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata metadata() {
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(DoesNotHaveMetric.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class DoesHaveMetric<T extends Annotation>
    implements Of<T> {
        private final T annotation;
        private final String name;
        private final Metadata metadata;
        static final long serialVersionUID = 5398848202387869882L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private DoesHaveMetric(T annotation, String name, Metadata metadata) {
            this.annotation = annotation;
            this.name = name;
            this.metadata = metadata;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public String metricName() {
            return this.name;
        }

        @Override
        public T metricAnnotation() {
            return this.annotation;
        }

        @Override
        public Metadata metadata() {
            return this.metadata;
        }

        /* synthetic */ DoesHaveMetric(Annotation x0, String x1, Metadata x2, 1 x3) {
            this(x0, x1, x2);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(DoesHaveMetric.class);
        }
    }

    static interface Of<T extends Annotation> {
        public boolean isPresent();

        public String metricName();

        public Metadata metadata();

        public T metricAnnotation();
    }
}

