/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer31.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.webcontainer.collaborator.WebAppInjectionClassListCollaborator;
import com.ibm.wsspi.webcontainer.filter.IFilterConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import org.osgi.service.component.annotations.Component;

@Component(name="com.ibm.ws.webcontainer31.util.ServletInjectionClassListCollaborator", service={WebAppInjectionClassListCollaborator.class}, immediate=true, property={"service.vendor=IBM"})
public class ServletInjectionClassListCollaborator
implements WebAppInjectionClassListCollaborator {
    private static final TraceComponent tc = Tr.register(ServletInjectionClassListCollaborator.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer31.resources.Messages");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer31.util.ServletInjectionClassListCollaborator";
    private final String[] _FilterClasses = new String[]{"javax.servlet.Filter"};
    private final String[] _ListenerClasses = new String[]{"javax.servlet.ServletContextListener", "javax.servlet.ServletContextAttributeListener", "javax.servlet.ServletRequestListener", "javax.servlet.ServletRequestAttributeListener", "javax.servlet.http.HttpUpgradeHandler", "javax.servlet.http.HttpSessionListener", "javax.servlet.http.HttpSessionAttributeListener", "javax.servlet.http.HttpSessionIdListener", "javax.servlet.AsyncListener"};
    private final String[] _ServletSubClasses = new String[]{"javax.servlet.http.HttpServlet"};

    public List<String> getInjectionClasses(Container moduleContainer) {
        ArrayList<String> classList;
        block8: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getInjectionClasses", (Object[])new Object[0]);
            }
            classList = new ArrayList<String>();
            try {
                WebAppConfig webAppConfig = (WebAppConfig)moduleContainer.adapt(WebAppConfig.class);
                if (webAppConfig == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getInjectionClasses", (Object)"WebAppConfig was null");
                    }
                    return classList;
                }
                Iterator servlets = webAppConfig.getServletInfos();
                ArrayList<String> configuredServlets = new ArrayList<String>();
                while (servlets.hasNext()) {
                    IServletConfig servlet = (IServletConfig)servlets.next();
                    configuredServlets.add(servlet.getClassName());
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("found servlet in web.xml : " + servlet.getClassName()), (Object[])new Object[0]);
                }
                WebAnnotations webAnnotations = (WebAnnotations)moduleContainer.adapt(WebAnnotations.class);
                AnnotationTargets_Targets annotationTargets = webAnnotations.getAnnotationTargets();
                configuredServlets.addAll(this.getAnnotatedClasses(annotationTargets, WebServlet.class.getName(), configuredServlets));
                classList.addAll(this.verifyImplementation(annotationTargets, this._ServletSubClasses, false, configuredServlets));
                Iterator filters = webAppConfig.getFilterInfos();
                ArrayList<String> configuredFilters = new ArrayList<String>();
                while (filters.hasNext()) {
                    IFilterConfig filter = (IFilterConfig)filters.next();
                    configuredFilters.add(filter.getClassName());
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("found filter in web.xml : " + filter.getClassName()), (Object[])new Object[0]);
                }
                configuredFilters.addAll(this.getAnnotatedClasses(annotationTargets, WebFilter.class.getName(), configuredFilters));
                classList.addAll(this.verifyImplementation(annotationTargets, this._FilterClasses, true, configuredFilters));
                ArrayList<String> configuredListeners = new ArrayList<String>();
                configuredListeners.addAll(webAppConfig.getListeners());
                configuredListeners.addAll(this.getAnnotatedClasses(annotationTargets, WebListener.class.getName(), configuredListeners));
                classList.addAll(this.verifyImplementation(annotationTargets, this._ListenerClasses, true, configuredListeners));
            }
            catch (UnableToAdaptException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)CLASS_NAME, (Object[])new Object[]{"failed to adapt to InfoStore for class annotations", e});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInjectionClasses");
        }
        return classList;
    }

    private ArrayList<String> getAnnotatedClasses(AnnotationTargets_Targets annotationTargets, String annotation, ArrayList<String> knownClasses) {
        ArrayList<String> annotatedList = new ArrayList<String>();
        Set servletAnnotatedClasses = annotationTargets.getAnnotatedClasses(annotation);
        for (String serveltAnnotatedClass : servletAnnotatedClasses) {
            if (knownClasses.contains(serveltAnnotatedClass)) continue;
            annotatedList.add(serveltAnnotatedClass);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("found new class annotated with " + annotation + " : " + serveltAnnotatedClass), (Object[])new Object[0]);
        }
        return annotatedList;
    }

    private ArrayList<String> verifyImplementation(AnnotationTargets_Targets annotationTargets, String[] implClasses, boolean isInterface, ArrayList<String> knownClasses) {
        ArrayList<String> verifiedList = new ArrayList<String>();
        for (String implClass : implClasses) {
            Set classNames = !isInterface ? annotationTargets.getSubclassNames(implClass) : annotationTargets.getAllImplementorsOf(implClass);
            for (String className : classNames) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found implementor of " + implClass + " : " + className), (Object[])new Object[0]);
                }
                if (!knownClasses.contains(className)) continue;
                verifiedList.add(className);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Found valid implementor of " + implClass + " : " + className), (Object[])new Object[0]);
            }
        }
        return verifiedList;
    }
}

