/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.adapter.urbridge.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.adapter.urbridge.URBridge;
import com.ibm.wsspi.security.wim.exception.WIMApplicationException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Entity;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class URBridgeEntity {
    private static final TraceComponent tc = Tr.register(URBridgeEntity.class);
    private static final String LOCAL_DOMAIN_REGISTRY_PROP = "com.ibm.websphere.registry.UseRegistry";
    private static final String SECURITY_NAME_RDN_PROP = "ldap.basedn";
    protected Map<String, String> attrMap;
    protected String baseEntryName;
    protected final URBridge urBridge;
    protected Entity entity;
    protected Map<String, String> entityConfigMap;
    protected String securityNameProp;
    protected String uniqueIdProp;
    protected String displayNameProp;
    protected String rdnProp;
    static final long serialVersionUID = 8165538929985936358L;

    public URBridgeEntity(Entity inEntity, URBridge urBridge, Map<String, String> inAttrMap, String inBaseEntryName, Map<String, String> inEntityConfigMap) {
        this.entity = inEntity;
        this.urBridge = urBridge;
        this.attrMap = inAttrMap;
        this.entityConfigMap = inEntityConfigMap;
        this.baseEntryName = inBaseEntryName;
    }

    public abstract String getSecurityNameForEntity(String var1) throws Exception;

    public abstract String getUniqueIdForEntity(String var1) throws Exception;

    public abstract String getDisplayNameForEntity(String var1) throws Exception;

    /*
     * WARNING - void declaration
     */
    public void populateEntity(List<String> attrList) throws WIMException {
        boolean uniqueIdPropSet = false;
        this.setIdentifierProperties();
        for (int i = 0; i < attrList.size(); ++i) {
            String attrName = attrList.get(i);
            try {
                if (attrName.equals(this.displayNameProp)) {
                    this.getDisplayName(true);
                    continue;
                }
                if (attrName.equals(this.rdnProp)) {
                    this.entity.set(this.rdnProp, this.entity.getIdentifier().get(this.securityNameProp));
                    continue;
                }
                if (!attrName.equals("principalName") && !attrName.equals("displayBridgePrincipalName")) continue;
                if (this.attrMap.containsKey(LOCAL_DOMAIN_REGISTRY_PROP) && (this.attrMap.get(LOCAL_DOMAIN_REGISTRY_PROP).toString().equalsIgnoreCase("local") || this.attrMap.get(LOCAL_DOMAIN_REGISTRY_PROP).toString().equalsIgnoreCase("domain")) || this.attrMap.containsKey(SECURITY_NAME_RDN_PROP)) {
                    this.entity.set("principalName", (Object)this.urBridge.getUserSecurityName(this.getUniqueId(true)));
                    continue;
                }
                this.entity.set("principalName", this.entity.getIdentifier().get(this.securityNameProp));
                continue;
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgeEntity", (String)"122", (Object)this, (Object[])new Object[]{attrList});
                throw new WIMApplicationException((Throwable)e);
            }
        }
        if (this.entity.getIdentifier().isSet(this.uniqueIdProp)) {
            this.entity.getIdentifier().set("externalId", this.entity.getIdentifier().get(this.uniqueIdProp));
        }
        if (!uniqueIdPropSet) {
            this.entity.getIdentifier().unset(this.uniqueIdProp);
        }
    }

    public void setSecurityNameProp(String securityName) {
        if (securityName != null) {
            this.entity.getIdentifier().set(this.securityNameProp, (Object)securityName);
        }
    }

    public void setPrincipalName(String securityName) {
        if (securityName != null) {
            this.entity.set("principalName", (Object)securityName);
        }
    }

    public String getSecurityName(boolean setAttr) throws Exception {
        String securityName = null;
        if (this.entity.getIdentifier().isSet(this.securityNameProp)) {
            securityName = (String)this.entity.getIdentifier().get(this.securityNameProp);
        }
        if (securityName == null && !this.entity.getIdentifier().isSet(this.uniqueIdProp)) {
            throw new WIMApplicationException("REQUIRED_IDENTIFIERS_MISSING", Tr.formatMessage((TraceComponent)tc, (String)"REQUIRED_IDENTIFIERS_MISSING", (Object[])new Object[0]));
        }
        if (securityName == null) {
            String uniqueId = (String)this.entity.getIdentifier().get(this.uniqueIdProp);
            securityName = this.getSecurityNameForEntity(uniqueId);
        }
        if (setAttr) {
            this.entity.getIdentifier().set(this.securityNameProp, (Object)securityName);
        }
        return securityName;
    }

    /*
     * WARNING - void declaration
     */
    public void setIdentifierProperties() throws WIMException {
        try {
            this.getUniqueId(true);
            this.getSecurityName(true);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgeEntity", (String)"192", (Object)this, (Object[])new Object[0]);
            throw new WIMApplicationException((Throwable)e);
        }
    }

    public String getUniqueId(boolean setAttr) throws Exception {
        String uniqueName = null;
        String uniqueId = null;
        if (this.entity.getIdentifier().isSet(this.uniqueIdProp)) {
            uniqueId = (String)this.entity.getIdentifier().get(this.uniqueIdProp);
            return uniqueId;
        }
        uniqueName = (String)this.entity.getIdentifier().get(this.securityNameProp);
        if (uniqueId == null && uniqueName == null) {
            throw new WIMApplicationException("REQUIRED_IDENTIFIERS_MISSING", Tr.formatMessage((TraceComponent)tc, (String)"REQUIRED_IDENTIFIERS_MISSING", (Object[])new Object[0]));
        }
        uniqueId = this.getUniqueIdForEntity(uniqueName);
        if (setAttr) {
            this.entity.getIdentifier().set(this.uniqueIdProp, (Object)uniqueId);
        }
        return uniqueId;
    }

    public String getDisplayName(boolean setAttr) throws Exception {
        String displayName = null;
        String securityName = this.getSecurityName(false);
        displayName = this.getDisplayNameForEntity(securityName);
        if (displayName != null && displayName.trim().length() != 0 && setAttr) {
            ((List)this.entity.get("displayName")).add(displayName);
        }
        return displayName;
    }

    public void setRDNPropValue(String value) {
        if (value != null) {
            this.entity.set(this.entityConfigMap.get(this.entity.getTypeName()), (Object)value);
        }
    }

    public void getGroupsForUser(List<String> grpMbrshipAttrs, int countLimit) throws Exception {
        throw new WIMApplicationException("METHOD_NOT_IMPLEMENTED", Tr.formatMessage((TraceComponent)tc, (String)"METHOD_NOT_IMPLEMENTED", (Object[])new Object[0]));
    }

    public void getUsersForGroup(List<String> grpMbrAttrs, int countLimit) throws Exception {
        throw new WIMApplicationException("METHOD_NOT_IMPLEMENTED", Tr.formatMessage((TraceComponent)tc, (String)"METHOD_NOT_IMPLEMENTED", (Object[])new Object[0]));
    }
}

