/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.env.was;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.security.wim.env.ISSLUtil;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.exception.WIMSystemException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

@Trivial
public class SSLUtilImpl
implements ISSLUtil {
    private static final TraceComponent tc = Tr.register(SSLUtilImpl.class);

    @Override
    public Properties getSSLPropertiesOnThread() {
        return JSSEHelper.getInstance().getSSLPropertiesOnThread();
    }

    @Override
    public void resetSSLAlias() {
        JSSEHelper.getInstance().setSSLPropertiesOnThread(null);
    }

    @Override
    public void setSSLAlias(String sslAlias, Hashtable<?, ?> ldapEnv) throws WIMException {
        String METHODNAME = "setSSLAlias";
        try {
            HashMap<String, String> connectionInfo = null;
            String provider = (String)ldapEnv.get("java.naming.provider.url");
            if (provider != null) {
                StringTokenizer providerTokens = new StringTokenizer(provider);
                provider = providerTokens.nextToken();
                provider = provider.replaceFirst("ldap", "http");
                URL providerURL = new URL(provider);
                connectionInfo = new HashMap<String, String>();
                connectionInfo.put("com.ibm.ssl.direction", "outbound");
                connectionInfo.put("com.ibm.ssl.remoteHost", providerURL.getHost());
                connectionInfo.put("com.ibm.ssl.remotePort", providerURL.getPort() == -1 ? "636" : Integer.toString(providerURL.getPort()));
            }
            Properties props = connectionInfo != null ? JSSEHelper.getInstance().getProperties(sslAlias, connectionInfo, null) : JSSEHelper.getInstance().getProperties(sslAlias);
            JSSEHelper.getInstance().setSSLPropertiesOnThread(props);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setSSLAlias Properties for SSL Alias '" + sslAlias + "':" + props), (Object[])new Object[0]);
            }
        }
        catch (SSLException e) {
            throw new WIMSystemException("INVALID_INIT_PROPERTY", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_INIT_PROPERTY", (Object[])WIMMessageHelper.generateMsgParms((Object)"sslConfiguration")));
        }
        catch (MalformedURLException e) {
            throw new WIMSystemException("INVALID_INIT_PROPERTY", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_INIT_PROPERTY", (Object[])WIMMessageHelper.generateMsgParms((Object)((String)ldapEnv.get("java.naming.provider.url")))));
        }
    }

    @Override
    public void setSSLPropertiesOnThread(Properties props) {
        JSSEHelper.getInstance().setSSLPropertiesOnThread(props);
    }
}

