/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.CosNaming.tnaming2;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.yoko.orb.CosNaming.tnaming2.BindingIteratorImpl;
import org.apache.yoko.orb.CosNaming.tnaming2.NamingContextBase;
import org.apache.yoko.orb.CosNaming.tnaming2.RemotableObject;
import org.apache.yoko.orb.spi.naming.RemoteAccess;
import org.apache.yoko.orb.util.UnmodifiableEnumMap;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.BindingIteratorHelper;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.BindingTypeHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.Servant;

public final class NamingContextImpl
extends LocalObject
implements NamingContextExt,
RemotableObject {
    private static final long serialVersionUID = 1L;
    private final Core core;
    private final java.lang.Object servantCreationLock = new ServantCreationLock();

    public NamingContextImpl() throws Exception {
        this.core = new Core((Object)this);
    }

    public NamingContextImpl(Object rootContext) throws Exception {
        this.core = new Core(rootContext);
    }

    public void bind(NameComponent[] n, Object obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        this.core.bind(n, obj);
    }

    public void bind_context(NameComponent[] n, NamingContext nc) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        this.core.bind_context(n, nc);
    }

    public void rebind(NameComponent[] n, Object obj) throws NotFound, CannotProceed, InvalidName {
        this.core.rebind(n, obj);
    }

    public void rebind_context(NameComponent[] n, NamingContext nc) throws NotFound, CannotProceed, InvalidName {
        this.core.rebind_context(n, nc);
    }

    public Object resolve(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        return this.core.resolve(n);
    }

    public void unbind(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        this.core.unbind(n);
    }

    public void list(int how_many, BindingListHolder bl, BindingIteratorHolder bi) {
        this.core.list(how_many, bl, bi);
    }

    public NamingContext new_context() {
        return this.core.new_context();
    }

    public NamingContext bind_new_context(NameComponent[] n) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        return this.core.bind_new_context(n);
    }

    public void destroy() throws NotEmpty {
        this.core.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Servant getServant(POA poa, RemoteAccess remoteAccess) throws Exception {
        byte[] sid = this.core.getServantId(remoteAccess);
        java.lang.Object object = this.servantCreationLock;
        synchronized (object) {
            try {
                return poa.id_to_servant(sid);
            }
            catch (ObjectNotActive expected) {
                return POAServant.create(this, this.core, poa, remoteAccess);
            }
        }
    }

    public String to_string(NameComponent[] n) throws InvalidName {
        return this.core.to_string(n);
    }

    public NameComponent[] to_name(String sn) throws InvalidName {
        return this.core.to_name(sn);
    }

    public String to_url(String addr, String sn) throws InvalidAddress, InvalidName {
        return this.core.to_url(addr, sn);
    }

    public Object resolve_str(String n) throws NotFound, CannotProceed, InvalidName {
        return this.core.resolve_str(n);
    }

    public static final class BoundObject {
        public final NameComponent name;
        public final BindingType type;
        public final Object boundObject;

        private BoundObject(NameComponent name, Object boundObject, BindingType type) {
            this.name = name;
            this.boundObject = boundObject;
            this.type = type;
        }

        public String toString() {
            return this.name + "->" + this.boundObject;
        }
    }

    private static abstract class POAServant
    extends NamingContextBase {
        final java.lang.Object localContext;
        final NamingContextBase core;
        final POA poa;

        static POAServant create(NamingContextImpl localContext, Core core, POA poa, RemoteAccess remoteAccess) throws Exception {
            switch (remoteAccess) {
                case readOnly: {
                    return new ReadOnly(localContext, core, poa);
                }
                case readWrite: {
                    return new ReadWrite(localContext, core, poa);
                }
            }
            throw new IllegalArgumentException("Unsupported remote access type: " + (java.lang.Object)((java.lang.Object)remoteAccess));
        }

        protected POAServant(NamingContextImpl localContext, Core core, POA poa, byte[] servantId) throws Exception {
            this.localContext = localContext;
            this.core = core;
            this.poa = poa;
            poa.activate_object_with_id(servantId, (Servant)this);
        }

        abstract Servant convertLocalContextToRemoteContext(NamingContextImpl var1) throws Exception;

        @Override
        protected final Object resolveObject(NameComponent n, BindingTypeHolder type) {
            try {
                Object o = this.core.resolveObject(n, type);
                if (o == this.localContext) {
                    return this._this_object();
                }
                if (!(o instanceof NamingContextImpl)) {
                    return o;
                }
                Servant poaNamingContext = this.convertLocalContextToRemoteContext((NamingContextImpl)o);
                return NamingContextHelper.narrow((Object)poaNamingContext._this_object());
            }
            catch (SystemException e) {
                throw e;
            }
            catch (Exception e) {
                throw (INTERNAL)new INTERNAL("Unable to create new naming context").initCause((Throwable)e);
            }
        }

        @Override
        public final void list(int how_many, BindingListHolder bl, BindingIteratorHolder bi) {
            this.core.list(how_many, bl, bi);
            try {
                Servant iterator = ((BindingIteratorImpl)bi.value).getServant(this.poa, null);
                bi.value = BindingIteratorHelper.narrow((Object)iterator._this_object());
            }
            catch (SystemException e) {
                throw e;
            }
            catch (Exception e) {
                throw (INTERNAL)new INTERNAL("Unable to activate BindingIterator").initCause((Throwable)e);
            }
        }

        private static final class ReadWrite
        extends POAServant {
            ReadWrite(NamingContextImpl localContext, Core core, POA poa) throws Exception {
                super(localContext, core, poa, core.getServantId(RemoteAccess.readWrite));
            }

            @Override
            public NamingContext new_context() {
                try {
                    NamingContextImpl nci = (NamingContextImpl)this.core.new_context();
                    Servant newContext = nci.getServant(this.poa, RemoteAccess.readWrite);
                    return NamingContextHelper.narrow((Object)newContext._this_object());
                }
                catch (SystemException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw (INTERNAL)new INTERNAL("Unable to create new naming context").initCause((Throwable)e);
                }
            }

            @Override
            protected void bindObject(NameComponent n, Object obj, BindingTypeHolder type) throws SystemException, CannotProceed {
                this.core.bindObject(n, obj, type);
            }

            @Override
            protected Object unbindObject(NameComponent n) throws SystemException, CannotProceed {
                return this.core.unbindObject(n);
            }

            @Override
            protected Servant convertLocalContextToRemoteContext(NamingContextImpl context) throws Exception {
                return context.getServant(this.poa, RemoteAccess.readWrite);
            }

            @Override
            public void destroy() throws NotEmpty {
                try {
                    byte[] objectId = this.poa.servant_to_id((Servant)this);
                    if (objectId != null) {
                        this.poa.deactivate_object(objectId);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private static final class ReadOnly
        extends POAServant {
            ReadOnly(NamingContextImpl localContext, Core core, POA poa) throws Exception {
                super(localContext, core, poa, core.getServantId(RemoteAccess.readOnly));
            }

            private SystemException newSystemException() {
                return new NO_PERMISSION();
            }

            @Override
            public NamingContext new_context() {
                throw this.newSystemException();
            }

            @Override
            protected void bindObject(NameComponent n, Object obj, BindingTypeHolder type) {
                throw this.newSystemException();
            }

            @Override
            protected Object unbindObject(NameComponent n) {
                throw this.newSystemException();
            }

            @Override
            protected Servant convertLocalContextToRemoteContext(NamingContextImpl context) throws Exception {
                return context.getServant(this.poa, RemoteAccess.readOnly);
            }

            @Override
            public void destroy() {
                throw this.newSystemException();
            }
        }
    }

    private static final class Core
    extends NamingContextBase {
        private static final AtomicLong NEXT_ID = new AtomicLong();
        private final long instanceId = NEXT_ID.getAndIncrement();
        private final Map<RemoteAccess, String> servantIds = new UnmodifiableEnumMap<RemoteAccess, String>(RemoteAccess.class){

            @Override
            public String computeValueFor(RemoteAccess key) {
                return "NamingContext#" + Core.this.instanceId + "$" + (java.lang.Object)((java.lang.Object)key);
            }
        };
        private final HashMap<BindingKey, BoundObject> bindings = new HashMap();
        private final Object rootContext;

        private Core(Object rootContext) throws Exception {
            this.rootContext = rootContext;
        }

        private byte[] getServantId(RemoteAccess access) {
            return this.servantIds.get((java.lang.Object)access).getBytes();
        }

        @Override
        public NamingContext new_context() {
            try {
                NamingContextImpl newContext = new NamingContextImpl(this.rootContext);
                return newContext;
            }
            catch (SystemException e) {
                throw e;
            }
            catch (Exception e) {
                throw (INTERNAL)new INTERNAL("Unable to create new naming context").initCause((Throwable)e);
            }
        }

        @Override
        public synchronized void destroy() throws NotEmpty {
            if (!this.bindings.isEmpty()) {
                throw new NotEmpty();
            }
        }

        @Override
        public synchronized void list(int how_many, BindingListHolder bl, BindingIteratorHolder bi) {
            BindingIteratorImpl iterator = new BindingIteratorImpl(this.bindings.values());
            iterator.next_n(how_many, bl);
            bi.value = iterator;
        }

        @Override
        protected Object resolveObject(NameComponent n, BindingTypeHolder type) {
            if (n.id.length() == 0 && n.kind.length() == 0) {
                type.value = BindingType.ncontext;
                return this.rootContext;
            }
            BindingKey key = new BindingKey(n);
            BoundObject obj = this.bindings.get(key);
            if (obj == null) {
                return null;
            }
            type.value = obj.type;
            return obj.boundObject;
        }

        @Override
        protected void bindObject(NameComponent n, Object obj, BindingTypeHolder type) {
            this.bindings.put(new BindingKey(n), new BoundObject(n, obj, type.value));
        }

        @Override
        protected Object unbindObject(NameComponent n) {
            BindingKey key = new BindingKey(n);
            BoundObject obj = this.bindings.remove(key);
            if (obj != null) {
                return obj.boundObject;
            }
            return null;
        }

        private static final class BindingKey {
            private final NameComponent name;
            private final int hashval;

            public BindingKey(NameComponent n) {
                this.name = n;
                this.hashval = Objects.hashCode(this.name.id) + Objects.hashCode(this.name.kind);
            }

            public int hashCode() {
                return this.hashval;
            }

            public boolean equals(java.lang.Object other) {
                if (!(other instanceof BindingKey)) {
                    return false;
                }
                BindingKey otherKey = (BindingKey)other;
                return Objects.equals(this.name.id, otherKey.name.id) && Objects.equals(this.name.kind, otherKey.name.kind);
            }

            public String toString() {
                return "" + this.name;
            }
        }
    }

    private static final class ServantCreationLock {
        private ServantCreationLock() {
        }
    }
}

