/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Locale;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.CharMapDatabaseInit;
import org.apache.yoko.orb.OB.CharMapInfo;
import org.apache.yoko.orb.OB.CodeConverterBase;
import org.apache.yoko.orb.OB.CodeConverterBoth;
import org.apache.yoko.orb.OB.CodeConverterFrom;
import org.apache.yoko.orb.OB.CodeConverterNone;
import org.apache.yoko.orb.OB.CodeConverterSimple;
import org.apache.yoko.orb.OB.CodeConverterTo;
import org.apache.yoko.orb.OB.CodeSetDatabaseInit;
import org.apache.yoko.orb.OB.CodeSetInfo;
import org.apache.yoko.orb.OB.CodeSetUtil;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CORBA.CODESET_INCOMPATIBLE;

public final class CodeSetDatabase {
    public static final int ISOLATIN1 = 65537;
    public static final int ISOLATIN2 = 65538;
    public static final int ISOLATIN3 = 65539;
    public static final int ISOLATIN4 = 65540;
    public static final int ISOLATIN5 = 65541;
    public static final int ISOLATIN7 = 65543;
    public static final int ISOLATIN9 = 65545;
    public static final int PCS = 65568;
    public static final int UTF8 = 0x5010001;
    public static final int UTF16 = 65801;
    public static final int UCS2 = 65792;
    private static CodeSetDatabase instance_;
    private static CharMapDatabaseInit database_;

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public static CodeSetDatabase instance() {
        if (instance_ == null) {
            instance_ = new CodeSetDatabase();
            String locale = Locale.getDefault().getLanguage();
            if (locale.equals("C") || locale.equals("POSIX")) {
                CodeSetUtil.addCharCodeSet(65537);
            } else {
                String loc = locale.substring(0, 2);
                if (loc.equals("de") || loc.equals("en") || loc.equals("fr") || loc.equals("nl") || loc.equals("pt")) {
                    CodeSetUtil.addCharCodeSet(65537);
                } else if (loc.equals("da") || loc.equals("fi") || loc.equals("is") || loc.equals("no") || loc.equals("sv")) {
                    CodeSetUtil.addCharCodeSet(65540);
                } else if (loc.equals("it")) {
                    CodeSetUtil.addCharCodeSet(65539);
                } else if (loc.equals("cs") || loc.equals("hu") || loc.equals("pl") || loc.equals("sk") || loc.equals("sl")) {
                    CodeSetUtil.addCharCodeSet(65538);
                } else if (loc.equals("el")) {
                    CodeSetUtil.addCharCodeSet(65543);
                } else if (loc.equals("ru")) {
                    CodeSetUtil.addCharCodeSet(65541);
                } else if (loc.equals("tr")) {
                    CodeSetUtil.addCharCodeSet(65545);
                }
            }
            CodeSetUtil.addCharCodeSet(65568);
            CodeSetUtil.addCharCodeSet(0x5010001);
            CodeSetUtil.addWcharCodeSet(65801);
        }
        return instance_;
    }

    public synchronized CodeConverterBase getConverter(int to, int from) {
        CodeSetInfo toSet = this.getCodeSetInfo(to);
        CodeSetInfo fromSet = this.getCodeSetInfo(from);
        if (toSet != null && fromSet != null && toSet.max_bytes == 1 && to == from) {
            return null;
        }
        CodeConverterBase converter = null;
        if (fromSet == null || toSet == null) {
            converter = new CodeConverterNone(fromSet, toSet);
        } else if (!(toSet.rgy_value != 65801 && toSet.rgy_value != 65792 || fromSet.rgy_value != 65801 && fromSet.rgy_value != 65792)) {
            converter = new CodeConverterSimple(fromSet, toSet);
        } else if ((toSet.rgy_value == 0x5010001 || toSet.rgy_value == 65537) && fromSet.rgy_value == 0x5010001 || toSet.rgy_value == 0x5010001 && fromSet.rgy_value == 65537) {
            converter = new CodeConverterSimple(fromSet, toSet);
        } else {
            int toBase;
            int fromBase;
            CharMapInfo fromMap = null;
            CharMapInfo toMap = null;
            int n = fromBase = fromSet.max_bytes == 1 ? 65537 : 65801;
            if (fromSet.rgy_value != fromBase) {
                fromMap = this.getCharMapInfo(fromSet.rgy_value);
            }
            int n2 = toBase = toSet.max_bytes == 1 ? 65537 : 65801;
            if (toSet.rgy_value != toBase) {
                toMap = this.getCharMapInfo(toSet.rgy_value);
            }
            if (fromMap != null && toMap != null) {
                converter = new CodeConverterBoth(fromSet, toSet, fromMap, toMap);
            } else if (fromMap != null) {
                converter = new CodeConverterFrom(fromSet, toSet, fromMap);
            } else if (toMap != null) {
                converter = new CodeConverterTo(fromSet, toSet, toMap);
            } else {
                Assert._OB_assert(false);
            }
        }
        return converter;
    }

    public CodeSetInfo getCodeSetInfo(int rgy_value) {
        for (int i = 0; i < CodeSetDatabaseInit.codeSetInfoArraySize_; ++i) {
            if (CodeSetDatabaseInit.codeSetInfoArray_[i].rgy_value != rgy_value) continue;
            return CodeSetDatabaseInit.codeSetInfoArray_[i];
        }
        return null;
    }

    int determineTCS(CodeSetComponent clientCS, CodeSetComponent serverCS, int fallback) {
        if (clientCS.native_code_set != 0 && serverCS.native_code_set != 0) {
            if (clientCS.native_code_set == serverCS.native_code_set) {
                return serverCS.native_code_set;
            }
            if (this.checkCodeSetId(clientCS, serverCS.native_code_set)) {
                return serverCS.native_code_set;
            }
            if (this.checkCodeSetId(serverCS, clientCS.native_code_set)) {
                return clientCS.native_code_set;
            }
        }
        for (int i = 0; i < serverCS.conversion_code_sets.length; ++i) {
            if (!this.checkCodeSetId(clientCS, serverCS.conversion_code_sets[i])) continue;
            return serverCS.conversion_code_sets[i];
        }
        if (clientCS.native_code_set != 0 && serverCS.native_code_set != 0 && this.isCompatible(clientCS.native_code_set, serverCS.native_code_set)) {
            return fallback;
        }
        throw new CODESET_INCOMPATIBLE();
    }

    private boolean isCompatible(int id1, int id2) {
        CodeSetInfo cs1 = this.getCodeSetInfo(id1);
        CodeSetInfo cs2 = this.getCodeSetInfo(id2);
        if (cs1 == null || cs2 == null) {
            return false;
        }
        for (int i = 0; i < cs1.char_values_size; ++i) {
            for (int j = 0; j < cs2.char_values_size; ++j) {
                if (cs1.char_values[i] != cs2.char_values[j]) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkCodeSetId(CodeSetComponent cs, int id) {
        for (int i = 0; i < cs.conversion_code_sets.length; ++i) {
            if (cs.conversion_code_sets[i] != id) continue;
            return true;
        }
        return false;
    }

    public int nameToId(String name) {
        Assert._OB_assert(name != null);
        for (int i = 0; i < CodeSetDatabaseInit.codeSetInfoArraySize_; ++i) {
            String s = CodeSetDatabaseInit.codeSetInfoArray_[i].description;
            if (s.indexOf(name) == -1) continue;
            return CodeSetDatabaseInit.codeSetInfoArray_[i].rgy_value;
        }
        return 0;
    }

    private CharMapInfo getCharMapInfo(int rgy_value) {
        String name = "";
        switch (rgy_value) {
            case 65537: {
                name = "ISO/IEC 8859-1:1998 to Unicode";
                break;
            }
            case 65538: {
                name = "ISO 8859-2:1999 to Unicode";
                break;
            }
            case 65539: {
                name = "ISO/IEC 8859-3:1999 to Unicode";
                break;
            }
            case 65540: {
                name = "ISO/IEC 8859-4:1998 to Unicode";
                break;
            }
            case 65541: {
                name = "ISO 8859-5:1999 to Unicode";
                break;
            }
            case 65543: {
                name = "ISO 8859-7:1987 to Unicode";
                break;
            }
            case 65545: {
                name = "ISO/IEC 8859-9:1999 to Unicode";
                break;
            }
            case 65568: {
                name = "PCS to Unicode";
                break;
            }
        }
        for (int i = 0; i < CharMapDatabaseInit.charMapInfoArraySize_; ++i) {
            if (!CharMapDatabaseInit.charMapInfoArray_[i].name.equals(name)) continue;
            return CharMapDatabaseInit.charMapInfoArray_[i];
        }
        return null;
    }

    static {
        database_ = new CharMapDatabaseInit();
    }
}

