/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.Messaging.MaxHopsPolicy_impl;
import org.apache.yoko.orb.Messaging.QueueOrderPolicy_impl;
import org.apache.yoko.orb.Messaging.RebindPolicy_impl;
import org.apache.yoko.orb.Messaging.ReplyEndTimePolicy_impl;
import org.apache.yoko.orb.Messaging.ReplyPriorityPolicy_impl;
import org.apache.yoko.orb.Messaging.ReplyStartTimePolicy_impl;
import org.apache.yoko.orb.Messaging.RequestEndTimePolicy_impl;
import org.apache.yoko.orb.Messaging.RequestPriorityPolicy_impl;
import org.apache.yoko.orb.Messaging.RequestStartTimePolicy_impl;
import org.apache.yoko.orb.Messaging.RoutingPolicy_impl;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.RefCountPolicyList;
import org.apache.yoko.orb.OB.TimeHelper;
import org.apache.yoko.orb.OCI.Buffer;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.MessageRouting.PersistentRequestRouter;
import org.omg.MessageRouting.PersistentRequestRouterHelper;
import org.omg.MessageRouting.Router;
import org.omg.MessageRouting.RouterHelper;
import org.omg.MessageRouting.RouterListHelper;
import org.omg.MessageRouting.RouterListHolder;
import org.omg.Messaging.MaxHopsPolicy;
import org.omg.Messaging.MaxHopsPolicyHelper;
import org.omg.Messaging.OrderingHelper;
import org.omg.Messaging.PolicyValue;
import org.omg.Messaging.PolicyValueSeqHolder;
import org.omg.Messaging.PriorityRange;
import org.omg.Messaging.PriorityRangeHelper;
import org.omg.Messaging.QueueOrderPolicy;
import org.omg.Messaging.QueueOrderPolicyHelper;
import org.omg.Messaging.RebindModeHelper;
import org.omg.Messaging.RebindPolicy;
import org.omg.Messaging.RebindPolicyHelper;
import org.omg.Messaging.RelativeRequestTimeoutPolicy;
import org.omg.Messaging.RelativeRequestTimeoutPolicyHelper;
import org.omg.Messaging.RelativeRoundtripTimeoutPolicy;
import org.omg.Messaging.RelativeRoundtripTimeoutPolicyHelper;
import org.omg.Messaging.ReplyPriorityPolicy;
import org.omg.Messaging.ReplyPriorityPolicyHelper;
import org.omg.Messaging.ReplyStartTimePolicy;
import org.omg.Messaging.ReplyStartTimePolicyHelper;
import org.omg.Messaging.RequestEndTimePolicy;
import org.omg.Messaging.RequestEndTimePolicyHelper;
import org.omg.Messaging.RequestPriorityPolicy;
import org.omg.Messaging.RequestPriorityPolicyHelper;
import org.omg.Messaging.RequestStartTimePolicy;
import org.omg.Messaging.RequestStartTimePolicyHelper;
import org.omg.Messaging.RoutingPolicy;
import org.omg.Messaging.RoutingPolicyHelper;
import org.omg.Messaging.RoutingTypeRange;
import org.omg.Messaging.RoutingTypeRangeHelper;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.TimeBase.UtcT;
import org.omg.TimeBase.UtcTHelper;

public final class MessageRoutingUtil {
    public static void getRouterListFromConfig(ORBInstance orbInstance, RouterListHolder routerList) {
        int i;
        Properties properties = orbInstance.getProperties();
        Enumeration<java.lang.Object> keys = properties.keys();
        Vector<String> amiPropKeys = new Vector<String>();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith("yoko.ami.router.")) continue;
            amiPropKeys.add(key);
        }
        String[] routerKeys = amiPropKeys.toArray(new String[0]);
        for (i = 0; i < routerKeys.length; ++i) {
            int min = i;
            for (int j = i + 1; j < routerKeys.length; ++j) {
                if (routerKeys[min].compareTo(routerKeys[j]) <= 0) continue;
                min = j;
            }
            String tmp = routerKeys[i];
            routerKeys[i] = routerKeys[min];
            routerKeys[min] = tmp;
        }
        for (i = 0; i < routerKeys.length; ++i) {
            Object obj;
            String value = properties.getProperty(routerKeys[i]);
            if (value.startsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            ORB orb = orbInstance.getORB();
            try {
                if (value.startsWith("corbaloc:") || value.startsWith("corbaname:") || value.startsWith("IOR:") || value.startsWith("relfile:") || value.startsWith("file:")) {
                    obj = orb.string_to_object(value);
                } else {
                    String address = "corbaloc::" + value + "/AMIRouter";
                    obj = orb.string_to_object(address);
                }
            }
            catch (BAD_PARAM ex) {
                continue;
            }
            Router router = RouterHelper.unchecked_narrow((Object)obj);
            int len = routerList.value.length;
            Router[] newList = new Router[len + 1];
            System.arraycopy(routerList.value, 0, newList, 0, len);
            newList[len] = router;
            routerList.value = newList;
        }
    }

    public static PersistentRequestRouter getPersistentRouterFromConfig(ORBInstance orbInstance) throws SystemException {
        PersistentRequestRouter router;
        Object obj;
        String key;
        Properties properties = orbInstance.getProperties();
        String value = properties.getProperty(key = "yoko.ami.persistent_router");
        if (value.startsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        if (key == null) {
            throw new BAD_PARAM("No persistent router specified");
        }
        ORB orb = orbInstance.getORB();
        if (value.startsWith("corbaloc:") || value.startsWith("corbaname:") || value.startsWith("IOR:") || value.startsWith("relfile:") || value.startsWith("file:")) {
            obj = orb.string_to_object(value);
        } else {
            String address = "corbaloc::" + value + "/AMIPersistentRouter";
            obj = orb.string_to_object(address);
        }
        try {
            router = PersistentRequestRouterHelper.narrow((Object)obj);
        }
        catch (SystemException ex) {
            throw (TRANSIENT)new TRANSIENT("PersistentRequestRouter not available").initCause((Throwable)ex);
        }
        return router;
    }

    public static void getRouterListFromComponents(ORBInstance orbInstance, ProfileInfo info, RouterListHolder routerList) {
        if (info.major == 1 && info.minor == 0) {
            return;
        }
        for (int i = 0; i < info.components.length; ++i) {
            if (info.components[i].tag != 30) continue;
            byte[] data = info.components[i].component_data;
            Buffer buf = new Buffer(data, data.length);
            InputStream in = new InputStream(buf);
            in._OB_readEndian();
            in._OB_ORBInstance(orbInstance);
            Router[] routers = RouterListHelper.read((org.omg.CORBA.portable.InputStream)in);
            int routerLen = routers.length;
            int currentLen = routerList.value.length;
            Router[] newList = new Router[routerLen + currentLen];
            System.arraycopy(routerList.value, 0, newList, 0, currentLen);
            System.arraycopy(routers, 0, newList, currentLen, routerLen);
            routerList.value = newList;
        }
    }

    public static PolicyValue createMessagingPolicyValue(Policy policy) {
        PolicyValue value = new PolicyValue();
        switch (policy.policy_type()) {
            case 23: {
                RebindPolicy p = RebindPolicyHelper.narrow((Object)policy);
                short mode = p.rebind_mode();
                value.ptype = 23;
                Buffer buf = new Buffer();
                OutputStream out = new OutputStream(buf);
                out._OB_writeEndian();
                RebindModeHelper.write((org.omg.CORBA.portable.OutputStream)out, (short)mode);
                value.pvalue = new byte[buf.length()];
                System.arraycopy(buf.data(), 0, value.pvalue, 0, buf.length());
                break;
            }
            case 25: {
                RequestPriorityPolicy p = RequestPriorityPolicyHelper.narrow((Object)policy);
                PriorityRange range = p.priority_range();
                value.ptype = 25;
                Buffer buf = new Buffer();
                OutputStream out = new OutputStream(buf);
                out._OB_writeEndian();
                PriorityRangeHelper.write((org.omg.CORBA.portable.OutputStream)out, (PriorityRange)range);
                value.pvalue = new byte[buf.length()];
                System.arraycopy(buf.data(), 0, value.pvalue, 0, buf.length());
                break;
            }
            case 26: {
                ReplyPriorityPolicy p = ReplyPriorityPolicyHelper.narrow((Object)policy);
                PriorityRange range = p.priority_range();
                value.ptype = 26;
                Buffer buf = new Buffer();
                OutputStream out = new OutputStream(buf);
                out._OB_writeEndian();
                PriorityRangeHelper.write((org.omg.CORBA.portable.OutputStream)out, (PriorityRange)range);
                value.pvalue = new byte[buf.length()];
                System.arraycopy(buf.data(), 0, value.pvalue, 0, buf.length());
                break;
            }
            case 27: {
                RequestStartTimePolicy p = RequestStartTimePolicyHelper.narrow((Object)policy);
                UtcT time = p.start_time();
                value.ptype = 27;
                Buffer buf = new Buffer();
                OutputStream out = new OutputStream(buf);
                out._OB_writeEndian();
                UtcTHelper.write((org.omg.CORBA.portable.OutputStream)out, (UtcT)time);
                value.pvalue = new byte[buf.length()];
                System.arraycopy(buf.data(), 0, value.pvalue, 0, buf.length());
                break;
            }
            case 28: {
                RequestEndTimePolicy p = RequestEndTimePolicyHelper.narrow((Object)policy);
                UtcT time = p.end_time();
                value.ptype = 28;
                Buffer buf = new Buffer();
                OutputStream out = new OutputStream(buf);
                out._OB_writeEndian();
                UtcTHelper.write((org.omg.CORBA.portable.OutputStream)out, (UtcT)time);
                value.pvalue = new byte[buf.length()];
                System.arraycopy(buf.data(), 0, value.pvalue, 0, buf.length());
                break;
            }
            case 29: {
                ReplyStartTimePolicy p = ReplyStartTimePolicyHelper.narrow((Object)policy);
                UtcT time = p.start_time();
                value.ptype = 29;
                Buffer buf = new Buffer();
                OutputStream out = new OutputStream(buf);
                out._OB_writeEndian();
                UtcTHelper.write((org.omg.CORBA.portable.OutputStream)out, (UtcT)time);
                value.pvalue = new byte[buf.length()];
                System.arraycopy(buf.data(), 0, value.pvalue, 0, buf.length());
                break;
            }
            case 30: {
                RequestEndTimePolicy p = RequestEndTimePolicyHelper.narrow((Object)policy);
                UtcT time = p.end_time();
                value.ptype = 30;
                Buffer buf = new Buffer();
                OutputStream out = new OutputStream(buf);
                out._OB_writeEndian();
                UtcTHelper.write((org.omg.CORBA.portable.OutputStream)out, (UtcT)time);
                value.pvalue = new byte[buf.length()];
                System.arraycopy(buf.data(), 0, value.pvalue, 0, buf.length());
                break;
            }
            case 31: {
                RelativeRequestTimeoutPolicy p = RelativeRequestTimeoutPolicyHelper.narrow((Object)policy);
                long time = p.relative_expiry();
                UtcT timeout = TimeHelper.add(TimeHelper.utcNow(0L), time);
                value.ptype = 28;
                Buffer buf = new Buffer();
                OutputStream out = new OutputStream(buf);
                out._OB_writeEndian();
                UtcTHelper.write((org.omg.CORBA.portable.OutputStream)out, (UtcT)timeout);
                value.pvalue = new byte[buf.length()];
                System.arraycopy(buf.data(), 0, value.pvalue, 0, buf.length());
                break;
            }
            case 32: {
                RelativeRoundtripTimeoutPolicy p = RelativeRoundtripTimeoutPolicyHelper.narrow((Object)policy);
                long time = p.relative_expiry();
                UtcT timeout = TimeHelper.add(TimeHelper.utcNow(0L), time);
                value.ptype = 30;
                Buffer buf = new Buffer();
                OutputStream out = new OutputStream(buf);
                out._OB_writeEndian();
                UtcTHelper.write((org.omg.CORBA.portable.OutputStream)out, (UtcT)timeout);
                value.pvalue = new byte[buf.length()];
                System.arraycopy(buf.data(), 0, value.pvalue, 0, buf.length());
                break;
            }
            case 33: {
                RoutingPolicy p = RoutingPolicyHelper.narrow((Object)policy);
                RoutingTypeRange range = p.routing_range();
                value.ptype = 33;
                Buffer buf = new Buffer();
                OutputStream out = new OutputStream(buf);
                out._OB_writeEndian();
                RoutingTypeRangeHelper.write((org.omg.CORBA.portable.OutputStream)out, (RoutingTypeRange)range);
                value.pvalue = new byte[buf.length()];
                System.arraycopy(buf.data(), 0, value.pvalue, 0, buf.length());
                break;
            }
            case 34: {
                MaxHopsPolicy p = MaxHopsPolicyHelper.narrow((Object)policy);
                short hops = p.max_hops();
                value.ptype = 34;
                Buffer buf = new Buffer();
                OutputStream out = new OutputStream(buf);
                out._OB_writeEndian();
                out.write_ushort(hops);
                value.pvalue = new byte[buf.length()];
                System.arraycopy(buf.data(), 0, value.pvalue, 0, buf.length());
                break;
            }
            case 35: {
                QueueOrderPolicy p = QueueOrderPolicyHelper.narrow((Object)policy);
                short order = p.allowed_orders();
                value.ptype = 35;
                Buffer buf = new Buffer();
                OutputStream out = new OutputStream(buf);
                out._OB_writeEndian();
                OrderingHelper.write((org.omg.CORBA.portable.OutputStream)out, (short)order);
                value.pvalue = new byte[buf.length()];
                System.arraycopy(buf.data(), 0, value.pvalue, 0, buf.length());
                break;
            }
            default: {
                throw new INV_POLICY();
            }
        }
        return value;
    }

    public static void getComponentPolicyValues(IORInfo info, PolicyValueSeqHolder policies) {
        PolicyValue[] newSeq;
        int len;
        PolicyValue value;
        Policy p2;
        try {
            p2 = info.get_effective_policy(25);
            value = MessageRoutingUtil.createMessagingPolicyValue(p2);
            len = policies.value.length;
            newSeq = new PolicyValue[len + 1];
            System.arraycopy(policies.value, 0, newSeq, 0, len);
            newSeq[len] = value;
            policies.value = newSeq;
        }
        catch (INV_POLICY p2) {
            // empty catch block
        }
        try {
            p2 = info.get_effective_policy(26);
            value = MessageRoutingUtil.createMessagingPolicyValue(p2);
            len = policies.value.length;
            newSeq = new PolicyValue[len + 1];
            System.arraycopy(policies.value, 0, newSeq, 0, len);
            newSeq[len] = value;
            policies.value = newSeq;
        }
        catch (INV_POLICY p3) {
            // empty catch block
        }
        try {
            p2 = info.get_effective_policy(34);
            value = MessageRoutingUtil.createMessagingPolicyValue(p2);
            len = policies.value.length;
            newSeq = new PolicyValue[len + 1];
            System.arraycopy(policies.value, 0, newSeq, 0, len);
            newSeq[len] = value;
            policies.value = newSeq;
        }
        catch (INV_POLICY p4) {
            // empty catch block
        }
        try {
            p2 = info.get_effective_policy(35);
            value = MessageRoutingUtil.createMessagingPolicyValue(p2);
            len = policies.value.length;
            newSeq = new PolicyValue[len + 1];
            System.arraycopy(policies.value, 0, newSeq, 0, len);
            newSeq[len] = value;
            policies.value = newSeq;
        }
        catch (INV_POLICY iNV_POLICY) {
            // empty catch block
        }
    }

    public static void getInvocationPolicyValues(RefCountPolicyList policyList, PolicyValueSeqHolder policies) {
        OutputStream out;
        PolicyValue[] newSeq;
        int len;
        UtcT timeout;
        boolean rebind = false;
        boolean queueOrder = false;
        boolean useRelativeRequest = false;
        boolean useRelativeRoundtrip = false;
        if (policyList.relativeRequestTimeout != 0L) {
            useRelativeRequest = true;
            if (TimeHelper.notEqual(policyList.requestEndTime, TimeHelper.utcMin()) && TimeHelper.greaterThan(timeout = TimeHelper.utcMin(), policyList.requestEndTime)) {
                useRelativeRequest = false;
            }
        }
        if (policyList.relativeRoundTripTimeout != 0L) {
            useRelativeRoundtrip = true;
            if (TimeHelper.notEqual(policyList.replyEndTime, TimeHelper.utcMin()) && TimeHelper.greaterThan(timeout = TimeHelper.utcMin(), policyList.replyEndTime)) {
                useRelativeRequest = false;
            }
        }
        int numPolicies = policyList.value.length;
        for (int i = 0; i < numPolicies; ++i) {
            try {
                int type = policyList.value[i].policy_type();
                if (type == 31 && !useRelativeRequest || type == 28 && useRelativeRequest || type == 32 && !useRelativeRoundtrip || type == 30 && useRelativeRoundtrip) continue;
                PolicyValue val = MessageRoutingUtil.createMessagingPolicyValue(policyList.value[i]);
                if (val.ptype == 23) {
                    rebind = true;
                }
                if (val.ptype == 35) {
                    queueOrder = true;
                }
                len = policies.value.length;
                newSeq = new PolicyValue[len + 1];
                System.arraycopy(policies.value, 0, newSeq, 0, len);
                policies.value = newSeq;
                continue;
            }
            catch (INV_POLICY type) {
                // empty catch block
            }
        }
        if (!rebind) {
            PolicyValue val = new PolicyValue();
            val.ptype = 23;
            Buffer buf = new Buffer();
            out = new OutputStream(buf);
            out._OB_writeEndian();
            RebindModeHelper.write((org.omg.CORBA.portable.OutputStream)out, (short)policyList.rebindMode);
            val.pvalue = new byte[out._OB_pos()];
            System.arraycopy(buf.data(), 0, val.pvalue, 0, buf.length());
            len = policies.value.length;
            newSeq = new PolicyValue[len + 1];
            System.arraycopy(policies.value, 0, newSeq, 0, len);
            newSeq[len] = val;
            policies.value = newSeq;
        }
        if (!queueOrder) {
            PolicyValue val = new PolicyValue();
            val.ptype = 35;
            Buffer buf = new Buffer();
            out = new OutputStream(buf);
            out._OB_writeEndian();
            OrderingHelper.write((org.omg.CORBA.portable.OutputStream)out, (short)policyList.queueOrder);
            val.pvalue = new byte[out._OB_pos()];
            System.arraycopy(buf.data(), 0, val.pvalue, 0, buf.length());
            len = policies.value.length;
            newSeq = new PolicyValue[len + 1];
            System.arraycopy(policies.value, 0, newSeq, 0, len);
            newSeq[len] = val;
            policies.value = newSeq;
        }
    }

    public static Policy[] getPolicyListFromPolicyValues(PolicyValue[] policies) {
        Vector<Policy> list = new Vector<Policy>(0);
        int policiesLength = policies.length;
        for (int i = 0; i < policiesLength; ++i) {
            Policy policy;
            try {
                policy = MessageRoutingUtil.getPolicyFromPolicyValue(policies[i]);
            }
            catch (INV_POLICY ex) {
                continue;
            }
            list.addElement(policy);
        }
        Policy[] policyList = new Policy[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            policyList[i] = (Policy)list.elementAt(i);
        }
        return policyList;
    }

    public static Policy getPolicyFromPolicyValue(PolicyValue policyValue) {
        switch (policyValue.ptype) {
            case 23: {
                byte[] data = policyValue.pvalue;
                Buffer buf = new Buffer(data, data.length);
                InputStream in = new InputStream(buf);
                in._OB_readEndian();
                short mode = RebindModeHelper.read((org.omg.CORBA.portable.InputStream)in);
                return new RebindPolicy_impl(mode);
            }
            case 25: {
                byte[] data = policyValue.pvalue;
                Buffer buf = new Buffer(data, data.length);
                InputStream in = new InputStream(buf);
                in._OB_readEndian();
                PriorityRange range = PriorityRangeHelper.read((org.omg.CORBA.portable.InputStream)in);
                return new RequestPriorityPolicy_impl(range);
            }
            case 26: {
                byte[] data = policyValue.pvalue;
                Buffer buf = new Buffer(data, data.length);
                InputStream in = new InputStream(buf);
                in._OB_readEndian();
                PriorityRange range = PriorityRangeHelper.read((org.omg.CORBA.portable.InputStream)in);
                return new ReplyPriorityPolicy_impl(range);
            }
            case 27: {
                byte[] data = policyValue.pvalue;
                Buffer buf = new Buffer(data, data.length);
                InputStream in = new InputStream(buf);
                in._OB_readEndian();
                UtcT time = UtcTHelper.read((org.omg.CORBA.portable.InputStream)in);
                return new RequestStartTimePolicy_impl(time);
            }
            case 28: {
                byte[] data = policyValue.pvalue;
                Buffer buf = new Buffer(data, data.length);
                InputStream in = new InputStream(buf);
                in._OB_readEndian();
                UtcT time = UtcTHelper.read((org.omg.CORBA.portable.InputStream)in);
                return new RequestEndTimePolicy_impl(time);
            }
            case 29: {
                byte[] data = policyValue.pvalue;
                Buffer buf = new Buffer(data, data.length);
                InputStream in = new InputStream(buf);
                in._OB_readEndian();
                UtcT time = UtcTHelper.read((org.omg.CORBA.portable.InputStream)in);
                return new ReplyStartTimePolicy_impl(time);
            }
            case 30: {
                byte[] data = policyValue.pvalue;
                Buffer buf = new Buffer(data, data.length);
                InputStream in = new InputStream(buf);
                in._OB_readEndian();
                UtcT time = UtcTHelper.read((org.omg.CORBA.portable.InputStream)in);
                return new ReplyEndTimePolicy_impl(time);
            }
            case 33: {
                byte[] data = policyValue.pvalue;
                Buffer buf = new Buffer(data, data.length);
                InputStream in = new InputStream(buf);
                in._OB_readEndian();
                RoutingTypeRange range = RoutingTypeRangeHelper.read((org.omg.CORBA.portable.InputStream)in);
                return new RoutingPolicy_impl(range);
            }
            case 34: {
                byte[] data = policyValue.pvalue;
                Buffer buf = new Buffer(data, data.length);
                InputStream in = new InputStream(buf);
                in._OB_readEndian();
                short hops = in.read_ushort();
                return new MaxHopsPolicy_impl(hops);
            }
            case 35: {
                byte[] data = policyValue.pvalue;
                Buffer buf = new Buffer(data, data.length);
                InputStream in = new InputStream(buf);
                in._OB_readEndian();
                short order = OrderingHelper.read((org.omg.CORBA.portable.InputStream)in);
                return new QueueOrderPolicy_impl(order);
            }
        }
        throw new INV_POLICY();
    }
}

