/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Properties;
import java.util.Vector;
import org.apache.yoko.orb.CORBA.ORB;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.Logger;
import org.apache.yoko.orb.OCI.Plugin;
import org.apache.yoko.orb.OCI.PluginInit;
import org.apache.yoko.osgi.ProviderLocator;
import org.omg.CORBA.StringSeqHolder;
import org.omg.CORBA.SystemException;

public final class PluginManager {
    private org.omg.CORBA.ORB orb_;
    private Vector plugins_ = new Vector();
    private boolean destroy_;

    public PluginManager(org.omg.CORBA.ORB orb) {
        this.orb_ = orb;
        this.destroy_ = false;
    }

    public void destroy() {
        Assert._OB_assert(!this.destroy_);
        this.destroy_ = true;
        this.plugins_.removeAllElements();
        this.orb_ = null;
    }

    public Plugin initPlugin(String name, StringSeqHolder args) {
        Plugin result = null;
        for (int i = 0; i < this.plugins_.size(); ++i) {
            PluginData data = (PluginData)this.plugins_.elementAt(i);
            if (!name.equals(data.name)) continue;
            result = data.plugin;
            break;
        }
        if (result == null) {
            String propName;
            ORB oborb = (ORB)this.orb_;
            Properties props = oborb.properties();
            String className = props.getProperty(propName = "yoko.oci.plugin." + name);
            if (className == null) {
                className = "org.apache.yoko.orb.OCI." + name;
            }
            Logger logger = oborb.logger();
            PluginInit pi = null;
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class c = ProviderLocator.loadClass((String)className, this.getClass(), (ClassLoader)loader);
                pi = (PluginInit)c.newInstance();
            }
            catch (SystemException ex) {
                throw ex;
            }
            catch (Exception ex) {
                String err = "unable to load OCI plug-in `" + name + "':\n" + ex.getMessage();
                logger.error(err, ex);
                return null;
            }
            pi.version(this.orb_, "1.0");
            result = pi.init(this.orb_, args);
            if (result != null) {
                this.plugins_.addElement(new PluginData(name, result));
            }
        }
        return result;
    }

    static class PluginData {
        public String name;
        public Plugin plugin;

        PluginData(String name, Plugin plugin) {
            this.name = name;
            this.plugin = plugin;
        }
    }
}

