/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.util;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;

public abstract class UnmodifiableEnumMap<K extends Enum<K>, V>
extends EnumMap<K, V> {
    private static final long serialVersionUID = 1L;

    public UnmodifiableEnumMap(Class<K> keyType) {
        super(keyType);
        for (Enum key : (Enum[])keyType.getEnumConstants()) {
            super.put(key, this.computeValueFor(key));
        }
    }

    protected abstract V computeValueFor(K var1);

    @Override
    public final V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Set<K> keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    @Override
    public final Collection<V> values() {
        return Collections.unmodifiableCollection(super.values());
    }
}

