/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.container.osgi.internal.url;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSJPAUrlUtils {
    public static final String WSJPA_PROTOCOL_NAME = "wsjpa";
    static final long serialVersionUID = -7618525031133863146L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    @Trivial
    public static URL createWSJPAURL(URL url) throws MalformedURLException {
        URL returnURL;
        if (url == null) {
            return null;
        }
        final String encodedURLPathStr = WSJPAUrlUtils.encode(url.toExternalForm());
        try {
            returnURL = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){
                static final long serialVersionUID = 3408314764037571385L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                @Trivial
                public URL run() throws MalformedURLException {
                    return new URL("wsjpa:" + encodedURLPathStr);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.jpa.container.osgi.internal.url.WSJPAUrlUtils", (String)"52", null, (Object[])new Object[]{url});
            throw (MalformedURLException)e.getException();
        }
        return returnURL;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    public static URL extractEmbeddedURL(URL url) throws MalformedURLException {
        if (url == null) {
            return null;
        }
        if (!url.getProtocol().equalsIgnoreCase(WSJPA_PROTOCOL_NAME)) {
            throw new IllegalArgumentException("The specified URL \"" + url + "\" does not use the \"" + WSJPA_PROTOCOL_NAME + "\" protocol.");
        }
        String encodedPath = url.getPath();
        if (encodedPath == null || encodedPath.trim().equals("")) {
            throw new IllegalArgumentException("The specified URL \"" + url + "\" is missing path information.");
        }
        final String decodedPath = WSJPAUrlUtils.decode(encodedPath);
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){
                static final long serialVersionUID = -1020291942130021917L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                @Trivial
                public URL run() throws MalformedURLException {
                    return new URL(decodedPath);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.jpa.container.osgi.internal.url.WSJPAUrlUtils", (String)"93", null, (Object[])new Object[]{url});
            throw (MalformedURLException)e.getException();
        }
    }

    @Trivial
    private static String encode(String s) {
        if (s == null) {
            return null;
        }
        if (s.contains("%21")) {
            throw new IllegalArgumentException("WSJPAURLUtils.encode() cannot encode Strings containing \"%21\".");
        }
        return s.replace("!", "%21");
    }

    @Trivial
    private static String decode(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("%21", "!");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(WSJPAUrlUtils.class);
    }
}

