/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.yoko;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.yoko.helper.SocketFactoryHelper;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.omg.CORBA.Policy;
import org.omg.CSIIOP.TransportAddress;
import org.omg.IOP.TaggedComponent;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DefaultSocketFactory
extends SocketFactoryHelper {
    private static final TraceComponent tc = Tr.register(DefaultSocketFactory.class);
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    static final long serialVersionUID = -8463391571836110227L;

    public DefaultSocketFactory() {
        super(tc);
    }

    public Socket createSocket(String host, int port) throws IOException, ConnectException {
        if (port == 0) {
            Tr.error((TraceComponent)tc, (String)"PORT_ZERO", (Object[])new Object[]{host});
        }
        return this.createPlainSocket(host, port);
    }

    public Socket createSelfConnection(InetAddress address, int port) throws IOException, ConnectException {
        return new Socket(address, port);
    }

    public ServerSocket createServerSocket(int port, int backlog, String[] params) throws IOException {
        return this.createServerSocket(port, backlog, null, params);
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress address, String[] params) throws IOException {
        ServerSocket socket;
        IOException bindError;
        boolean soReuseAddr = true;
        for (int i = 0; i < params.length - 1; ++i) {
            String param = params[i];
            if (!"--soReuseAddr".equals(param)) continue;
            soReuseAddr = Boolean.parseBoolean(params[++i]);
            break;
        }
        if ((bindError = this.openSocket(port, backlog, address, socket = new ServerSocket(), soReuseAddr)) != null) {
            throw bindError;
        }
        return socket;
    }

    public int[] tags() {
        return EMPTY_INT_ARRAY;
    }

    public TransportAddress[] getEndpoints(TaggedComponent tc, Policy[] policies) {
        throw new UnsupportedOperationException();
    }
}

