/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.controller.impl;

import com.ibm.jbatch.container.IExecutionElementController;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution;
import com.ibm.jbatch.container.execution.impl.RuntimeStepExecution;
import com.ibm.jbatch.container.execution.impl.RuntimeWorkUnitExecution;
import com.ibm.jbatch.container.jsl.ModelSerializer;
import com.ibm.jbatch.container.jsl.ModelSerializerFactory;
import com.ibm.jbatch.container.persistence.jpa.StepThreadExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.StepThreadInstanceEntity;
import com.ibm.jbatch.container.persistence.jpa.StepThreadInstanceKey;
import com.ibm.jbatch.container.persistence.jpa.TopLevelStepInstanceEntity;
import com.ibm.jbatch.container.persistence.jpa.TopLevelStepInstanceKey;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerStaticAnchor;
import com.ibm.jbatch.container.status.ExecutionStatus;
import com.ibm.jbatch.container.status.ExtendedBatchStatus;
import com.ibm.jbatch.container.ws.JoblogUtil;
import com.ibm.jbatch.container.ws.PartitionReplyMsg;
import com.ibm.jbatch.container.ws.PartitionReplyQueue;
import com.ibm.jbatch.container.ws.WSStepThreadExecutionAggregate;
import com.ibm.jbatch.container.ws.events.BatchEventsPublisher;
import com.ibm.jbatch.container.ws.smf.ZosJBatchSMFLogging;
import com.ibm.jbatch.jsl.model.JSLProperties;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.jbatch.spi.services.ITransactionManagementService;
import com.ibm.jbatch.spi.services.TransactionManagerAdapter;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobStartException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public abstract class BaseStepControllerImpl
implements IExecutionElementController {
    private static final Logger logger = Logger.getLogger(BaseStepControllerImpl.class.getName());
    byte[] timeUsedBefore;
    protected RuntimeWorkUnitExecution runtimeWorkUnitExecution;
    protected RuntimeStepExecution runtimeStepExecution;
    private final Step step;
    private StepThreadInstanceEntity stepThreadInstance;
    private StepThreadExecutionEntity stepThreadExecution;
    private PartitionReplyQueue partitionReplyQueue;
    private TransactionManagerAdapter transactionManager;
    private final StepThreadHelper stepThreadHelper;
    private boolean issuedFailureMessageToJobLog;
    static final long serialVersionUID = 3298583709711069163L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected BaseStepControllerImpl(RuntimeWorkUnitExecution runtimeWorkUnitExecution, Step step) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "<init>", new Object[]{runtimeWorkUnitExecution, step});
        }
        this.timeUsedBefore = null;
        this.issuedFailureMessageToJobLog = false;
        this.runtimeWorkUnitExecution = runtimeWorkUnitExecution;
        if (step == null) {
            throw new IllegalArgumentException("Step parameter to ctor cannot be null. " + runtimeWorkUnitExecution);
        }
        this.step = step;
        this.stepThreadHelper = this.createStepHelper();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected BaseStepControllerImpl setPartitionReplyQueue(PartitionReplyQueue partitionReplyQueue) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "setPartitionReplyQueue", new Object[]{partitionReplyQueue});
        }
        this.partitionReplyQueue = partitionReplyQueue;
        BaseStepControllerImpl baseStepControllerImpl = this;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            baseStepControllerImpl = baseStepControllerImpl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "setPartitionReplyQueue", baseStepControllerImpl);
        }
        return baseStepControllerImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected PartitionReplyQueue getPartitionReplyQueue() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getPartitionReplyQueue", new Object[0]);
        }
        PartitionReplyQueue partitionReplyQueue = this.partitionReplyQueue;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            partitionReplyQueue = partitionReplyQueue;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getPartitionReplyQueue", partitionReplyQueue);
        }
        return partitionReplyQueue;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected long getJobInstanceId() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getJobInstanceId", new Object[0]);
        }
        long l = this.runtimeWorkUnitExecution.getTopLevelInstanceId();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getJobInstanceId", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected long getJobExecutionId() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getJobExecutionId", new Object[0]);
        }
        long l = this.runtimeWorkUnitExecution.getTopLevelExecutionId();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getJobExecutionId", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String getStepName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getStepName", new Object[0]);
        }
        String string = this.getStep().getId();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getStepName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Step getStep() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getStep", new Object[0]);
        }
        Step step = this.step;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            step = step;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getStep", step);
        }
        return step;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected StepThreadInstanceEntity getStepThreadInstance() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getStepThreadInstance", new Object[0]);
        }
        StepThreadInstanceEntity stepThreadInstanceEntity = this.stepThreadInstance;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stepThreadInstanceEntity = stepThreadInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getStepThreadInstance", stepThreadInstanceEntity);
        }
        return stepThreadInstanceEntity;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected IPersistenceManagerService getPersistenceManagerService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getPersistenceManagerService", new Object[0]);
        }
        IPersistenceManagerService iPersistenceManagerService = ServicesManagerStaticAnchor.getServicesManager().getPersistenceManagerService();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iPersistenceManagerService = iPersistenceManagerService;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getPersistenceManagerService", iPersistenceManagerService);
        }
        return iPersistenceManagerService;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ZosJBatchSMFLogging getJBatchSMFLoggingService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getJBatchSMFLoggingService", new Object[0]);
        }
        ZosJBatchSMFLogging zosJBatchSMFLogging = ServicesManagerStaticAnchor.getServicesManager().getJBatchSMFService();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            zosJBatchSMFLogging = zosJBatchSMFLogging;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getJBatchSMFLoggingService", zosJBatchSMFLogging);
        }
        return zosJBatchSMFLogging;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected IBatchKernelService getBatchKernelService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getBatchKernelService", new Object[0]);
        }
        IBatchKernelService iBatchKernelService = ServicesManagerStaticAnchor.getServicesManager().getBatchKernelService();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iBatchKernelService = iBatchKernelService;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getBatchKernelService", iBatchKernelService);
        }
        return iBatchKernelService;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ITransactionManagementService getTransactionManagementService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getTransactionManagementService", new Object[0]);
        }
        ITransactionManagementService iTransactionManagementService = ServicesManagerStaticAnchor.getServicesManager().getTransactionManagementService();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iTransactionManagementService = iTransactionManagementService;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getTransactionManagementService", iTransactionManagementService);
        }
        return iTransactionManagementService;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected TransactionManagerAdapter getTransactionManager() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getTransactionManager", new Object[0]);
        }
        TransactionManagerAdapter transactionManagerAdapter = this.transactionManager;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            transactionManagerAdapter = transactionManagerAdapter;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getTransactionManager", transactionManagerAdapter);
        }
        return transactionManagerAdapter;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected BatchEventsPublisher getBatchEventsPublisher() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getBatchEventsPublisher", new Object[0]);
        }
        BatchEventsPublisher batchEventsPublisher = ServicesManagerStaticAnchor.getServicesManager().getBatchEventsPublisher();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            batchEventsPublisher = batchEventsPublisher;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getBatchEventsPublisher", batchEventsPublisher);
        }
        return batchEventsPublisher;
    }

    protected abstract void invokeCoreStep() throws JobRestartException, JobStartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException;

    protected abstract void setupStepArtifacts();

    protected abstract void invokePreStepArtifacts();

    protected abstract void invokePostStepArtifacts();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={DoNotRestartStepThreadException.class})
    public ExecutionStatus execute() {
        RuntimeWorkUnitExecution.StopLock stopLock;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "execute", new Object[0]);
        }
        try {
            try {
                this.stepThreadExecution = this.createStepExecutionIfStepShouldBeExecuted();
                this.runtimeStepExecution = new RuntimeStepExecution(this.stepThreadExecution);
            }
            catch (DoNotRestartStepThreadException e) {
                String prevExitStatus22 = this.stepThreadInstance.getLatestStepThreadExecution().getExitStatus();
                logger.fine("Not going to run this step.  Returning previous exit status of: " + prevExitStatus22);
                ExecutionStatus executionStatus = new ExecutionStatus(ExtendedBatchStatus.DO_NOT_RUN, prevExitStatus22);
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    executionStatus = executionStatus;
                    logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "execute", executionStatus);
                }
                return executionStatus;
            }
        }
        catch (Throwable e) {
            void t;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", (String)"252", (Object)this, (Object[])new Object[0]);
            this.markJobOnlyForFailure();
            throw new BatchContainerRuntimeException("Caught throwable while determining if step should be executed.  Failing job.", (Throwable)t);
        }
        RuntimeWorkUnitExecution.StopLock prevExitStatus22 = stopLock = this.getStopLock();
        synchronized (prevExitStatus22) {
            if (this.wasStopIssuedOnJob()) {
                this.cleanupOnStepStoppedBeforeCoreExecution();
                ExecutionStatus executionStatus = new ExecutionStatus(ExtendedBatchStatus.JOB_OPERATOR_STOPPING);
                // MONITOREXIT @DISABLED, blocks:[16, 37] lbl26 : MonitorExitStatement: MONITOREXIT : prevExitStatus
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    executionStatus = executionStatus;
                    logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "execute", executionStatus);
                }
                return executionStatus;
            }
            try {
                ZosJBatchSMFLogging smflogger = this.getJBatchSMFLoggingService();
                if (smflogger != null) {
                    this.timeUsedBefore = smflogger.getTimeUsedData();
                }
                this.startStep();
                this.stepThreadHelper.publishEvent(this.getPersistenceManagerService().getStepExecutionAggregate(this.runtimeStepExecution.getTopLevelStepExecutionId()), this.runtimeStepExecution.getBatchStatus());
            }
            catch (Throwable smflogger) {
                void t;
                FFDCFilter.processException((Throwable)smflogger, (String)"com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", (String)"276", (Object)this, (Object[])new Object[0]);
                this.markJobAndStepForFailure();
                throw new BatchContainerRuntimeException("Caught throwable while starting step. Failing job.", (Throwable)t);
            }
        }
        prevExitStatus22 = stopLock;
        synchronized (prevExitStatus22) {
            if (this.wasStopIssuedOnJob()) {
                this.cleanupOnStepStoppedBeforeCoreExecution();
                ExecutionStatus executionStatus = new ExecutionStatus(ExtendedBatchStatus.JOB_OPERATOR_STOPPING);
                // MONITOREXIT @DISABLED, blocks:[17, 34] lbl48 : MonitorExitStatement: MONITOREXIT : prevExitStatus
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    executionStatus = executionStatus;
                    logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "execute", executionStatus);
                }
                return executionStatus;
            }
        }
        try {
            this.invokePreStepArtifacts();
            this.invokeCoreStep();
        }
        catch (Throwable prevExitStatus22) {
            void t;
            FFDCFilter.processException((Throwable)prevExitStatus22, (String)"com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", (String)"296", (Object)this, (Object[])new Object[0]);
            JoblogUtil.logToJobLogAndTraceOnly(Level.SEVERE, "exception.executing.step", new Object[]{this.stepThreadExecution.getStepName(), this.getExceptionString((Throwable)t)}, logger);
            this.markStepForFailure();
        }
        try {
            this.invokePostStepArtifacts();
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", (String)"308", (Object)this, (Object[])new Object[0]);
            JoblogUtil.logToJobLogAndTraceOnly(Level.SEVERE, "exception.after.step", new Object[]{this.stepThreadExecution.getStepName(), this.getExceptionString(t)}, logger);
            this.markStepForFailure();
        }
        RuntimeWorkUnitExecution.StopLock stopLock2 = stopLock;
        synchronized (stopLock2) {
            try {
                this.transitionToFinalBatchStatus();
                this.defaultExitStatusIfNecessary();
                this.persistStepExecutionOnEnd();
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", (String)"330", (Object)this, (Object[])new Object[0]);
                BatchContainerRuntimeException exceptionToLog = null;
                try {
                    exceptionToLog = new BatchContainerRuntimeException("Failure ending step execution", t);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", (String)"343", (Object)this, (Object[])new Object[0]);
                }
                try {
                    this.markJobAndStepForFailure();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", (String)"349", (Object)this, (Object[])new Object[0]);
                }
                try {
                    this.stepThreadHelper.publishEvent(this.getPersistenceManagerService().getStepExecutionAggregate(this.runtimeStepExecution.getTopLevelStepExecutionId()), this.runtimeStepExecution.getBatchStatus());
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", (String)"356", (Object)this, (Object[])new Object[0]);
                }
                try {
                    this.persistStepExecutionOnEnd();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", (String)"362", (Object)this, (Object[])new Object[0]);
                    JoblogUtil.logToJobLogAndTrace(Level.SEVERE, "error.persisting.stepExecution", new Object[]{this.getExceptionString(exceptionToLog)}, logger);
                    throw exceptionToLog;
                }
            }
        }
        this.stepThreadHelper.sendFinalPartitionReplyMsg();
        try {
            this.stepThreadHelper.publishEvent(this.getPersistenceManagerService().getStepExecutionAggregate(this.runtimeStepExecution.getTopLevelStepExecutionId()), this.runtimeStepExecution.getBatchStatus());
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", (String)"378", (Object)this, (Object[])new Object[0]);
        }
        if (this.runtimeStepExecution.getBatchStatus().equals((Object)BatchStatus.FAILED)) {
            ExecutionStatus executionStatus = new ExecutionStatus(ExtendedBatchStatus.EXCEPTION_THROWN, this.runtimeStepExecution.getExitStatus());
            if (logger != null && logger.isLoggable(Level.FINER)) {
                executionStatus = executionStatus;
                logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "execute", executionStatus);
            }
            return executionStatus;
        }
        this.stepThreadHelper.logEndedMessage();
        ExecutionStatus executionStatus = new ExecutionStatus(ExtendedBatchStatus.NORMAL_COMPLETION, this.runtimeStepExecution.getExitStatus());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            executionStatus = executionStatus;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "execute", executionStatus);
        }
        return executionStatus;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void cleanupOnStepStoppedBeforeCoreExecution() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "cleanupOnStepStoppedBeforeCoreExecution", new Object[0]);
        }
        this.updateStepBatchStatus(BatchStatus.STOPPED);
        this.defaultExitStatusIfNecessary();
        this.persistStepExecutionOnEnd();
        this.stepThreadHelper.sendFinalPartitionReplyMsg();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "cleanupOnStepStoppedBeforeCoreExecution");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void persistStepExecutionOnEnd() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "persistStepExecutionOnEnd", new Object[0]);
        }
        Date endTime = new Date();
        this.runtimeStepExecution.setLastUpdatedTime(endTime);
        this.runtimeStepExecution.setEndTime(endTime);
        this.updateStepExecution();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "persistStepExecutionOnEnd");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void defaultExitStatusIfNecessary() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "defaultExitStatusIfNecessary", new Object[0]);
        }
        String stepExitStatus = this.runtimeStepExecution.getExitStatus();
        String processRetVal = this.runtimeStepExecution.getBatchletProcessRetVal();
        if (stepExitStatus != null) {
            logger.fine("Returning with user-set exit status: " + stepExitStatus);
        } else if (processRetVal != null) {
            logger.fine("Returning with exit status from batchlet.process(): " + processRetVal);
            this.runtimeStepExecution.setExitStatus(processRetVal);
        } else {
            logger.fine("Returning with default exit status");
            this.runtimeStepExecution.setExitStatus(this.runtimeStepExecution.getBatchStatus().name());
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "defaultExitStatusIfNecessary");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void markStepForFailure() {
        RuntimeWorkUnitExecution.StopLock stopLock;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "markStepForFailure", new Object[0]);
        }
        RuntimeWorkUnitExecution.StopLock stopLock2 = stopLock = this.getStopLock();
        synchronized (stopLock2) {
            this.updateStepBatchStatus(BatchStatus.FAILED);
            if (!this.issuedFailureMessageToJobLog) {
                this.stepThreadHelper.logFailedMessage();
                this.issuedFailureMessageToJobLog = true;
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "markStepForFailure");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void updateStepExecution() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "updateStepExecution", new Object[0]);
        }
        this.getPersistenceManagerService().updateStepExecution(this.runtimeStepExecution);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "updateStepExecution");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void markJobAndStepForFailure() {
        RuntimeWorkUnitExecution.StopLock stopLock;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "markJobAndStepForFailure", new Object[0]);
        }
        RuntimeWorkUnitExecution.StopLock stopLock2 = stopLock = this.getStopLock();
        synchronized (stopLock2) {
            this.runtimeWorkUnitExecution.setBatchStatus(BatchStatus.FAILED);
            this.markStepForFailure();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "markJobAndStepForFailure");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void markJobOnlyForFailure() {
        RuntimeWorkUnitExecution.StopLock stopLock;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "markJobOnlyForFailure", new Object[0]);
        }
        RuntimeWorkUnitExecution.StopLock stopLock2 = stopLock = this.getStopLock();
        synchronized (stopLock2) {
            this.runtimeWorkUnitExecution.setBatchStatus(BatchStatus.FAILED);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "markJobOnlyForFailure");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected RuntimeWorkUnitExecution.StopLock getStopLock() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getStopLock", new Object[0]);
        }
        RuntimeWorkUnitExecution.StopLock stopLock = this.runtimeWorkUnitExecution.getStopLock();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stopLock = stopLock;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getStopLock", stopLock);
        }
        return stopLock;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void validateStartLimitNotExceeded() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "validateStartLimitNotExceeded", new Object[0]);
        }
        int startLimit = 0;
        String startLimitString = this.step.getStartLimit();
        if (startLimitString != null) {
            try {
                startLimit = Integer.parseInt(startLimitString);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", (String)"471", (Object)this, (Object[])new Object[0]);
                throw new IllegalArgumentException("Could not parse start limit value.  Received NumberFormatException for start-limit value:  " + startLimitString + " for stepId: " + this.getStepName() + ", with start-limit=" + this.step.getStartLimit());
            }
        }
        if (startLimit < 0) {
            throw new IllegalArgumentException("Found negative start-limit of " + startLimit + "for stepId: " + this.getStepName());
        }
        if (startLimit > 0) {
            int newStepStartCount = ((TopLevelStepInstanceEntity)this.stepThreadInstance).getStartCount() + 1;
            if (newStepStartCount > startLimit) {
                throw new IllegalStateException("For stepId: " + this.getStepName() + ", tried to start step for the " + newStepStartCount + " time, but startLimit = " + startLimit);
            }
            logger.fine("Starting (possibly restarting) step: " + this.getStepName() + ", since newStepStartCount = " + newStepStartCount + " and startLimit=" + startLimit);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "validateStartLimitNotExceeded");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void startStep() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "startStep", new Object[0]);
        }
        this.runtimeWorkUnitExecution.logStepExecutionCreatedMessage(this.runtimeStepExecution);
        this.setContextProperties();
        this.setupStepArtifacts();
        Date startTime = new Date();
        this.runtimeStepExecution.setLastUpdatedTime(startTime);
        this.runtimeStepExecution.setStartTime(startTime);
        this.updateStepBatchStatus(BatchStatus.STARTED);
        this.updateStepExecution();
        this.stepThreadHelper.logStartedMessage();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "startStep");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean wasStopIssuedOnJob() {
        RuntimeWorkUnitExecution.StopLock stopLock;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "wasStopIssuedOnJob", new Object[0]);
        }
        RuntimeWorkUnitExecution.StopLock stopLock2 = stopLock = this.getStopLock();
        // MONITORENTER : stopLock2
        if (this.runtimeWorkUnitExecution.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
            boolean bl = true;
            // MONITOREXIT : stopLock2
            if (logger == null) return bl;
            if (!logger.isLoggable(Level.FINER)) return bl;
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "wasStopIssuedOnJob", bl);
            return bl;
        }
        boolean bl = false;
        // MONITOREXIT : stopLock2
        if (logger == null) return bl;
        if (!logger.isLoggable(Level.FINER)) return bl;
        bl = bl;
        logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "wasStopIssuedOnJob", bl);
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isStepStartingOrStarted() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "isStepStartingOrStarted", new Object[0]);
        }
        if (this.runtimeStepExecution == null) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "isStepStartingOrStarted", bl);
            }
            return bl;
        }
        BatchStatus currentStatus = this.runtimeStepExecution.getBatchStatus();
        if (BatchStatus.STARTED.equals((Object)currentStatus) || BatchStatus.STARTING.equals((Object)currentStatus)) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "isStepStartingOrStarted", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "isStepStartingOrStarted", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void transitionToFinalBatchStatus() {
        RuntimeWorkUnitExecution.StopLock stopLock;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "transitionToFinalBatchStatus", new Object[0]);
        }
        RuntimeWorkUnitExecution.StopLock stopLock2 = stopLock = this.getStopLock();
        synchronized (stopLock2) {
            BatchStatus currentBatchStatus = this.runtimeStepExecution.getBatchStatus();
            if (currentBatchStatus.equals((Object)BatchStatus.STARTED)) {
                this.updateStepBatchStatus(BatchStatus.COMPLETED);
            } else if (currentBatchStatus.equals((Object)BatchStatus.STOPPING)) {
                this.updateStepBatchStatus(BatchStatus.STOPPED);
            } else if (currentBatchStatus.equals((Object)BatchStatus.FAILED)) {
                this.updateStepBatchStatus(BatchStatus.FAILED);
            } else {
                throw new IllegalStateException("Step batch status should not be in a " + currentBatchStatus.name() + " state");
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "transitionToFinalBatchStatus");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void updateStepBatchStatus(BatchStatus updatedBatchStatus) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "updateStepBatchStatus", new Object[]{updatedBatchStatus});
        }
        if (this.runtimeStepExecution != null) {
            this.runtimeStepExecution.setBatchStatus(updatedBatchStatus);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "updateStepBatchStatus");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void markRestartAfterCompletion() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "markRestartAfterCompletion", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "markRestartAfterCompletion");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected StepThreadExecutionEntity createStepExecutionIfStepShouldBeExecuted() throws DoNotRestartStepThreadException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "createStepExecutionIfStepShouldBeExecuted", new Object[0]);
        }
        StepThreadExecutionEntity newStepExecution = null;
        StepThreadInstanceKey stepThreadInstanceKey = this.getStepThreadInstanceKey();
        this.stepThreadInstance = this.getPersistenceManagerService().getStepThreadInstance(stepThreadInstanceKey);
        if (this.stepThreadInstance == null) {
            logger.finer("No existing step instance found.  Create new step execution and proceed to execution.");
            newStepExecution = this.stepThreadHelper.createStepThreadInstanceAndFirstExecution(stepThreadInstanceKey, this.runtimeWorkUnitExecution.isRemotePartitionDispatch());
            this.stepThreadInstance = this.getPersistenceManagerService().getStepThreadInstance(stepThreadInstanceKey);
            if (this.stepThreadInstance == null) {
                throw new IllegalStateException("Should have just created step thread instance.");
            }
        } else {
            logger.finer("Existing step instance found.");
            newStepExecution = this.stepThreadHelper.setupStepThreadExecutionForRestartIfNecessary(this.runtimeWorkUnitExecution.isRemotePartitionDispatch());
        }
        StepThreadExecutionEntity stepThreadExecutionEntity = newStepExecution;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stepThreadExecutionEntity = stepThreadExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "createStepExecutionIfStepShouldBeExecuted", stepThreadExecutionEntity);
        }
        return stepThreadExecutionEntity;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setContextProperties() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "setContextProperties", new Object[0]);
        }
        JSLProperties jslProps = this.step.getProperties();
        if (jslProps != null) {
            for (Property property : jslProps.getPropertyList()) {
                Properties contextProps = this.runtimeStepExecution.getJSLProperties();
                contextProps.setProperty(property.getName(), property.getValue());
            }
        }
        this.runtimeStepExecution.addMetric(Metric.MetricType.READ_COUNT, 0L);
        this.runtimeStepExecution.addMetric(Metric.MetricType.WRITE_COUNT, 0L);
        this.runtimeStepExecution.addMetric(Metric.MetricType.READ_SKIP_COUNT, 0L);
        this.runtimeStepExecution.addMetric(Metric.MetricType.PROCESS_SKIP_COUNT, 0L);
        this.runtimeStepExecution.addMetric(Metric.MetricType.WRITE_SKIP_COUNT, 0L);
        this.runtimeStepExecution.addMetric(Metric.MetricType.FILTER_COUNT, 0L);
        this.runtimeStepExecution.addMetric(Metric.MetricType.COMMIT_COUNT, 0L);
        this.runtimeStepExecution.addMetric(Metric.MetricType.ROLLBACK_COUNT, 0L);
        this.transactionManager = this.getTransactionManagementService().getTransactionManager(this.runtimeStepExecution);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "setContextProperties");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Long> getLastRunStepExecutions() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getLastRunStepExecutions", new Object[0]);
        }
        ArrayList<Long> stepExecIdList = new ArrayList<Long>(1);
        Long lastStepExecId = this.stepThreadHelper.getLastRunStepExecutionId();
        if (lastStepExecId != null) {
            stepExecIdList.add(lastStepExecId);
        }
        ArrayList<Long> arrayList = stepExecIdList;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getLastRunStepExecutions", arrayList);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void markStepStopping() {
        RuntimeWorkUnitExecution.StopLock stopLock;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "markStepStopping", new Object[0]);
        }
        RuntimeWorkUnitExecution.StopLock stopLock2 = stopLock = this.getStopLock();
        synchronized (stopLock2) {
            this.updateStepBatchStatus(BatchStatus.STOPPING);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "markStepStopping");
        }
    }

    public String toString() {
        return "BaseStepControllerImpl for step = " + this.getStepName();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isSubJobPartitionThread() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "isSubJobPartitionThread", new Object[0]);
        }
        boolean bl = this.runtimeWorkUnitExecution instanceof RuntimePartitionExecution;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "isSubJobPartitionThread", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private RuntimePartitionExecution getRuntimePartitionExecution() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getRuntimePartitionExecution", new Object[0]);
        }
        RuntimePartitionExecution runtimePartitionExecution = (RuntimePartitionExecution)this.runtimeWorkUnitExecution;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            runtimePartitionExecution = runtimePartitionExecution;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getRuntimePartitionExecution", runtimePartitionExecution);
        }
        return runtimePartitionExecution;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected StepThreadInstanceKey getStepThreadInstanceKey() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getStepThreadInstanceKey", new Object[0]);
        }
        StepThreadInstanceKey stepThreadInstanceKey = this.isSubJobPartitionThread() ? new StepThreadInstanceKey(this.getJobInstanceId(), this.getStepName(), this.getRuntimePartitionExecution().getPartitionNumber()) : new TopLevelStepInstanceKey(this.getJobInstanceId(), this.getStepName());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stepThreadInstanceKey = stepThreadInstanceKey;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getStepThreadInstanceKey", stepThreadInstanceKey);
        }
        return stepThreadInstanceKey;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private StepThreadHelper createStepHelper() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "createStepHelper", new Object[0]);
        }
        if (this.isSubJobPartitionThread()) {
            PartitionThreadHelper partitionThreadHelper = new PartitionThreadHelper();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                partitionThreadHelper = partitionThreadHelper;
                logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "createStepHelper", partitionThreadHelper);
            }
            return partitionThreadHelper;
        }
        TopLevelThreadHelper topLevelThreadHelper = new TopLevelThreadHelper();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            topLevelThreadHelper = topLevelThreadHelper;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "createStepHelper", topLevelThreadHelper);
        }
        return topLevelThreadHelper;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isTopLevelStepThreadOfPartitionedStep() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "isTopLevelStepThreadOfPartitionedStep", new Object[0]);
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "isTopLevelStepThreadOfPartitionedStep", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getExceptionString(Throwable t) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getExceptionString", new Object[]{t});
        }
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        String string = sw.toString();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl", "getExceptionString", string);
        }
        return string;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class TopLevelThreadHelper
    implements StepThreadHelper {
        static final long serialVersionUID = -8050169427320235040L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private TopLevelThreadHelper() {
        }

        @Override
        public StepThreadExecutionEntity setupStepThreadExecutionForRestartIfNecessary(boolean isRemoteDispatch) throws DoNotRestartStepThreadException {
            TopLevelStepInstanceEntity topLevelStepInstance = (TopLevelStepInstanceEntity)BaseStepControllerImpl.this.stepThreadInstance;
            boolean restartAfterCompletion = false;
            BatchStatus stepBatchStatus = topLevelStepInstance.getLatestStepThreadExecution().getBatchStatus();
            if (stepBatchStatus.equals((Object)BatchStatus.COMPLETED)) {
                if (!Boolean.parseBoolean(BaseStepControllerImpl.this.getStep().getAllowStartIfComplete())) {
                    logger.fine("Step: " + BaseStepControllerImpl.this.getStepName() + " already has batch status of COMPLETED, so won't be run again since it does not allow start if complete.");
                    throw new DoNotRestartStepThreadException();
                }
                logger.fine("Step: " + BaseStepControllerImpl.this.getStepName() + " already has batch status of COMPLETED, and allow-start-if-complete is set to 'true'");
                restartAfterCompletion = true;
            }
            BaseStepControllerImpl.this.validateStartLimitNotExceeded();
            if (restartAfterCompletion) {
                BaseStepControllerImpl.this.markRestartAfterCompletion();
                return BaseStepControllerImpl.this.getPersistenceManagerService().createTopLevelStepExecutionOnRestartAndCleanStepInstance(BaseStepControllerImpl.this.getJobExecutionId(), topLevelStepInstance);
            }
            return BaseStepControllerImpl.this.getPersistenceManagerService().createTopLevelStepExecutionOnRestartFromPreviousStepInstance(BaseStepControllerImpl.this.getJobExecutionId(), topLevelStepInstance);
        }

        @Override
        public Long getLastRunStepExecutionId() {
            return BaseStepControllerImpl.this.stepThreadInstance.getLatestStepThreadExecution().getStepExecutionId();
        }

        @Override
        public void sendFinalPartitionReplyMsg() {
        }

        @Override
        public StepThreadExecutionEntity createStepThreadInstanceAndFirstExecution(StepThreadInstanceKey instanceKey, boolean isRemoteDispatch) {
            return BaseStepControllerImpl.this.getPersistenceManagerService().createTopLevelStepExecutionAndNewThreadInstance(BaseStepControllerImpl.this.getJobExecutionId(), instanceKey, BaseStepControllerImpl.this.isTopLevelStepThreadOfPartitionedStep());
        }

        @Override
        public void logEndedMessage() {
            JoblogUtil.logToJobLogAndTraceOnly(Level.FINE, "step.ended", new Object[]{BaseStepControllerImpl.this.runtimeStepExecution.getStepName(), BaseStepControllerImpl.this.runtimeStepExecution.getBatchStatus(), BaseStepControllerImpl.this.runtimeStepExecution.getExitStatus(), BaseStepControllerImpl.this.getJobInstanceId(), BaseStepControllerImpl.this.getJobExecutionId()}, logger);
        }

        @Override
        public void logFailedMessage() {
            JoblogUtil.logToJobLogAndTraceOnly(Level.WARNING, "step.failed", new Object[]{BaseStepControllerImpl.this.runtimeStepExecution.getStepName(), BaseStepControllerImpl.this.runtimeStepExecution.getBatchStatus(), BaseStepControllerImpl.this.runtimeStepExecution.getExitStatus(), BaseStepControllerImpl.this.getJobInstanceId(), BaseStepControllerImpl.this.getJobExecutionId()}, logger);
        }

        @Override
        public void logStartedMessage() {
            JoblogUtil.logToJobLogAndTraceOnly(Level.FINE, "step.started", new Object[]{BaseStepControllerImpl.this.runtimeStepExecution.getStepName(), BaseStepControllerImpl.this.getJobInstanceId(), BaseStepControllerImpl.this.getJobExecutionId()}, logger);
        }

        @Override
        public void publishEvent(WSStepThreadExecutionAggregate objectToPublish, BatchStatus batchStatus) {
            BatchEventsPublisher publisher = BaseStepControllerImpl.this.getBatchEventsPublisher();
            logger.fine("in step publish event - publisher = " + publisher + "will attempt to cut smf - batchStatus = " + batchStatus);
            if (batchStatus == BatchStatus.COMPLETED || batchStatus.equals((Object)BatchStatus.STOPPED) || batchStatus.equals((Object)BatchStatus.FAILED)) {
                ZosJBatchSMFLogging smflogger = BaseStepControllerImpl.this.getJBatchSMFLoggingService();
                logger.fine("cutting an smf step end record");
                if (smflogger != null) {
                    int partitionPlanCount = -1;
                    int partitionCount = -1;
                    if (BaseStepControllerImpl.this.isTopLevelStepThreadOfPartitionedStep()) {
                        partitionPlanCount = ((TopLevelStepInstanceEntity)BaseStepControllerImpl.this.getPersistenceManagerService().getStepThreadInstance(BaseStepControllerImpl.this.getStepThreadInstanceKey())).getPartitionPlanSize();
                        partitionCount = objectToPublish.getPartitionLevelStepExecutions().size();
                    }
                    byte[] timeUsedAfter = smflogger.getTimeUsedData();
                    int rc = smflogger.buildAndWriteStepEndRecord(objectToPublish.getTopLevelStepExecution(), BaseStepControllerImpl.this.stepThreadExecution.getTopLevelStepExecution().getJobExecution(), BaseStepControllerImpl.this.runtimeWorkUnitExecution, partitionPlanCount, partitionCount, BaseStepControllerImpl.this.getPersistenceManagerService().getPersistenceType(), BaseStepControllerImpl.this.getPersistenceManagerService().getDisplayId(), BaseStepControllerImpl.this.getStep(), BaseStepControllerImpl.this.isTopLevelStepThreadOfPartitionedStep(), BaseStepControllerImpl.this.timeUsedBefore, timeUsedAfter);
                    logger.fine("back from calling native smf, rc = " + rc);
                }
            }
            if (publisher != null) {
                String correlationId = BaseStepControllerImpl.this.runtimeWorkUnitExecution.getCorrelationId();
                if (batchStatus == BatchStatus.STARTED) {
                    publisher.publishStepEvent(objectToPublish, "batch/jobs/execution/step/started", correlationId);
                } else if (batchStatus == BatchStatus.STOPPING) {
                    publisher.publishStepEvent(objectToPublish, "batch/jobs/execution/step/stopping", correlationId);
                } else if (batchStatus == BatchStatus.COMPLETED) {
                    publisher.publishStepEvent(objectToPublish, "batch/jobs/execution/step/completed", correlationId);
                } else if (batchStatus == BatchStatus.STOPPED) {
                    publisher.publishStepEvent(objectToPublish, "batch/jobs/execution/step/stopped", correlationId);
                } else if (batchStatus == BatchStatus.FAILED) {
                    publisher.publishStepEvent(objectToPublish, "batch/jobs/execution/step/failed", correlationId);
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(TopLevelThreadHelper.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class PartitionThreadHelper
    implements StepThreadHelper {
        static final long serialVersionUID = -8436475953101789831L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private PartitionThreadHelper() {
        }

        @Override
        public StepThreadExecutionEntity setupStepThreadExecutionForRestartIfNecessary(boolean isRemoteDispatch) throws DoNotRestartStepThreadException {
            BatchStatus stepBatchStatus = BaseStepControllerImpl.this.stepThreadInstance.getLatestStepThreadExecution().getBatchStatus();
            if (stepBatchStatus.equals((Object)BatchStatus.COMPLETED)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Step: " + BaseStepControllerImpl.this.getStepName() + ", partition + " + BaseStepControllerImpl.this.getRuntimePartitionExecution().getPartitionNumber() + " already has batch status of COMPLETED, so won't be run again.");
                }
                throw new DoNotRestartStepThreadException();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Found previous batchStatus of " + stepBatchStatus + ", so re-execute step: " + BaseStepControllerImpl.this.getStepName() + ", partition + " + BaseStepControllerImpl.this.getRuntimePartitionExecution().getPartitionNumber());
            }
            return BaseStepControllerImpl.this.getPersistenceManagerService().createPartitionStepExecutionOnRestartFromPreviousStepInstance(BaseStepControllerImpl.this.getJobExecutionId(), BaseStepControllerImpl.this.stepThreadInstance, isRemoteDispatch);
        }

        @Override
        public Long getLastRunStepExecutionId() {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("This is a meaningless call for a partition thread, easier for our impl to just make it and ignore.");
            }
            return null;
        }

        @Override
        public void sendFinalPartitionReplyMsg() {
            ZosJBatchSMFLogging smflogger;
            logger.fine("Send status from partition for analyzeStatus with batchStatus = " + BaseStepControllerImpl.this.runtimeStepExecution.getBatchStatus() + ", exitStatus = " + BaseStepControllerImpl.this.runtimeStepExecution.getExitStatus());
            if ((BaseStepControllerImpl.this.runtimeStepExecution.getBatchStatus() == BatchStatus.COMPLETED || BaseStepControllerImpl.this.runtimeStepExecution.getBatchStatus() == BatchStatus.FAILED || BaseStepControllerImpl.this.runtimeStepExecution.getBatchStatus() == BatchStatus.STOPPED) && (smflogger = BaseStepControllerImpl.this.getJBatchSMFLoggingService()) != null) {
                if (BaseStepControllerImpl.this.timeUsedBefore != null) {
                    byte[] timeUsedAfter = smflogger.getTimeUsedData();
                    int n = smflogger.buildAndWritePartitionEndRecord(BaseStepControllerImpl.this.getRuntimePartitionExecution(), BaseStepControllerImpl.this.stepThreadExecution.getTopLevelStepExecution().getJobExecution(), BaseStepControllerImpl.this.runtimeStepExecution, BaseStepControllerImpl.this.getPersistenceManagerService().getPersistenceType(), BaseStepControllerImpl.this.getPersistenceManagerService().getDisplayId(), BaseStepControllerImpl.this.timeUsedBefore, timeUsedAfter);
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Won't log SMF record since before time was never captured.  Probably step was stopped before execution.");
                }
            }
            PartitionReplyMsg msg = new PartitionReplyMsg(PartitionReplyMsg.PartitionReplyMsgType.PARTITION_FINAL_STATUS).setBatchStatus(BaseStepControllerImpl.this.runtimeStepExecution.getBatchStatus()).setExitStatus(BaseStepControllerImpl.this.runtimeStepExecution.getExitStatus()).setPartitionPlanConfig(((RuntimePartitionExecution)BaseStepControllerImpl.this.runtimeWorkUnitExecution).getPartitionPlanConfig());
            BaseStepControllerImpl.this.getPartitionReplyQueue().add(msg);
            BaseStepControllerImpl.this.getPartitionReplyQueue().close();
            ((RuntimePartitionExecution)BaseStepControllerImpl.this.runtimeWorkUnitExecution).setFinalStatusSent(true);
        }

        @Override
        public StepThreadExecutionEntity createStepThreadInstanceAndFirstExecution(StepThreadInstanceKey instanceKey, boolean isRemoteDispatch) {
            return BaseStepControllerImpl.this.getPersistenceManagerService().createPartitionStepExecutionAndNewThreadInstance(BaseStepControllerImpl.this.getJobExecutionId(), instanceKey, isRemoteDispatch);
        }

        @Override
        public void logStartedMessage() {
            JoblogUtil.logToJobLogAndTraceOnly(Level.FINE, "partition.started", new Object[]{BaseStepControllerImpl.this.getRuntimePartitionExecution().getPartitionNumber(), BaseStepControllerImpl.this.getStepName(), BaseStepControllerImpl.this.getJobInstanceId(), BaseStepControllerImpl.this.getJobExecutionId()}, logger);
            ModelSerializer<Step> ms = ModelSerializerFactory.createStepModelSerializer();
            String prettyXml = ms.prettySerializeModel(BaseStepControllerImpl.this.step);
            JoblogUtil.logToJobLogAndTraceOnly(Level.INFO, "display.resolved.jsl", new Object[]{"partition", prettyXml}, logger);
        }

        @Override
        public void logEndedMessage() {
            JoblogUtil.logToJobLogAndTraceOnly(Level.FINE, "partition.ended", new Object[]{BaseStepControllerImpl.this.getRuntimePartitionExecution().getPartitionNumber(), BaseStepControllerImpl.this.runtimeStepExecution.getBatchStatus(), BaseStepControllerImpl.this.runtimeStepExecution.getExitStatus(), BaseStepControllerImpl.this.getStepName(), BaseStepControllerImpl.this.getJobInstanceId(), BaseStepControllerImpl.this.getJobExecutionId()}, logger);
        }

        @Override
        public void logFailedMessage() {
            JoblogUtil.logToJobLogAndTraceOnly(Level.WARNING, "partition.failed", new Object[]{BaseStepControllerImpl.this.getRuntimePartitionExecution().getPartitionNumber(), BaseStepControllerImpl.this.runtimeStepExecution.getBatchStatus(), BaseStepControllerImpl.this.runtimeStepExecution.getExitStatus(), BaseStepControllerImpl.this.getStepName(), BaseStepControllerImpl.this.getJobInstanceId(), BaseStepControllerImpl.this.getJobExecutionId()}, logger);
        }

        @Override
        public void publishEvent(WSStepThreadExecutionAggregate objectToPublish, BatchStatus batchStatus) {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(PartitionThreadHelper.class);
        }
    }

    private static interface StepThreadHelper {
        public StepThreadExecutionEntity createStepThreadInstanceAndFirstExecution(StepThreadInstanceKey var1, boolean var2);

        public void logStartedMessage();

        public void logEndedMessage();

        public void logFailedMessage();

        public void sendFinalPartitionReplyMsg();

        public Long getLastRunStepExecutionId();

        public StepThreadExecutionEntity setupStepThreadExecutionForRestartIfNecessary(boolean var1) throws DoNotRestartStepThreadException;

        public void publishEvent(WSStepThreadExecutionAggregate var1, BatchStatus var2);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class DoNotRestartStepThreadException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(DoNotRestartStepThreadException.class);
        }
    }
}

