/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.spi.services.IBatchArtifactFactory;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamReader;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class JSEBatchArtifactFactoryImpl
implements IBatchArtifactFactory,
XMLStreamConstants {
    private static final Logger logger = Logger.getLogger(JSEBatchArtifactFactoryImpl.class.getName());
    private static final String CLASSNAME = JSEBatchArtifactFactoryImpl.class.getName();
    private static final String BATCH_XML = "META-INF/batch.xml";
    private static final QName BATCH_ROOT_ELEM = new QName("http://xmlns.jcp.org/xml/ns/javaee", "batch-artifacts");
    private boolean loaded;
    private volatile ArtifactMap artifactMap;
    static final long serialVersionUID = 7761812932259736956L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JSEBatchArtifactFactoryImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JSEBatchArtifactFactoryImpl", "<init>", new Object[0]);
        }
        this.loaded = false;
        this.artifactMap = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JSEBatchArtifactFactoryImpl", "<init>", this);
        }
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object load(String batchId) {
        String methodName = "load";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASSNAME, methodName, "Loading batch artifact id = " + batchId);
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("TCCL = " + tccl);
        }
        this.initArtifactMapFromClassLoader(tccl);
        Object loadedArtifact = this.artifactMap.getArtifactById(batchId);
        if (loadedArtifact == null) {
            throw new IllegalArgumentException("Could not load any artifacts with batch id=" + batchId);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASSNAME, methodName, "For batch artifact id = " + batchId + ", loaded artifact instance: " + loadedArtifact + " of type: " + loadedArtifact.getClass().getCanonicalName());
        }
        return loadedArtifact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void initArtifactMapFromClassLoader(ClassLoader loader) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JSEBatchArtifactFactoryImpl", "initArtifactMapFromClassLoader", new Object[]{loader});
        }
        ArtifactMap tempMap = this.artifactMap;
        if (tempMap == null) {
            JSEBatchArtifactFactoryImpl jSEBatchArtifactFactoryImpl = this;
            synchronized (jSEBatchArtifactFactoryImpl) {
                tempMap = this.artifactMap;
                if (tempMap == null) {
                    tempMap = new ArtifactMap();
                    InputStream is = this.getBatchXMLStreamFromClassLoader(loader);
                    this.artifactMap = this.populateArtifactMapFromStream(tempMap, is);
                }
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JSEBatchArtifactFactoryImpl", "initArtifactMapFromClassLoader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected InputStream getBatchXMLStreamFromClassLoader(ClassLoader loader) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JSEBatchArtifactFactoryImpl", "getBatchXMLStreamFromClassLoader", new Object[]{loader});
        }
        InputStream is = loader.getResourceAsStream(BATCH_XML);
        if (is == null) {
            throw new IllegalStateException("Unable to load batch.xml");
        }
        InputStream inputStream = is;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            inputStream = inputStream;
            logger.exiting("com.ibm.jbatch.container.services.impl.JSEBatchArtifactFactoryImpl", "getBatchXMLStreamFromClassLoader", inputStream);
        }
        return inputStream;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ArtifactMap populateArtifactMapFromStream(ArtifactMap tempMap, InputStream is) {
        ArtifactMap artifactMap;
        block8: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JSEBatchArtifactFactoryImpl", "populateArtifactMapFromStream", new Object[]{tempMap, is});
            }
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            try {
                int event;
                XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(is);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Loaded XMLStreamReader = " + xmlStreamReader);
                }
                boolean processedRoot = false;
                while (xmlStreamReader.hasNext() && (event = xmlStreamReader.next()) != 8) {
                    if (event != 1) continue;
                    if (!processedRoot) {
                        QName rootQName = xmlStreamReader.getName();
                        if (!rootQName.equals(BATCH_ROOT_ELEM)) {
                            throw new IllegalStateException("Expecting document with root element QName: " + BATCH_ROOT_ELEM + ", but found root element with QName: " + rootQName);
                        }
                        processedRoot = true;
                        continue;
                    }
                    String annotationShortName = xmlStreamReader.getLocalName();
                    String id = xmlStreamReader.getAttributeValue(null, "id");
                    String className = xmlStreamReader.getAttributeValue(null, "class");
                    tempMap.addEntry(annotationShortName, id, className);
                    while (event != 2) {
                        event = xmlStreamReader.next();
                    }
                }
                xmlStreamReader.close();
                is.close();
                artifactMap = tempMap;
                if (logger == null || !logger.isLoggable(Level.FINER)) break block8;
            }
            catch (Exception xmlStreamReader) {
                void e;
                FFDCFilter.processException((Throwable)xmlStreamReader, (String)"com.ibm.jbatch.container.services.impl.JSEBatchArtifactFactoryImpl", (String)"181", (Object)this, (Object[])new Object[]{tempMap, is});
                throw new RuntimeException((Throwable)e);
            }
            artifactMap = artifactMap;
            logger.exiting("com.ibm.jbatch.container.services.impl.JSEBatchArtifactFactoryImpl", "populateArtifactMapFromStream", artifactMap);
        }
        return artifactMap;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JSEBatchArtifactFactoryImpl", "init", new Object[]{batchConfig});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JSEBatchArtifactFactoryImpl", "init");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void shutdown() throws BatchContainerServiceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JSEBatchArtifactFactoryImpl", "shutdown", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JSEBatchArtifactFactoryImpl", "shutdown");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class ArtifactMap {
        private Map<String, Class> idToArtifactClassMap = new HashMap<String, Class>();
        private Map<String, List<String>> idToArtifactTypeListMap = new HashMap<String, List<String>>();
        static final long serialVersionUID = -3298737660583633859L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ArtifactMap() {
        }

        /*
         * WARNING - void declaration
         */
        private void addEntry(String batchTypeName, String id, String className) {
            try {
                if (!this.idToArtifactClassMap.containsKey(id)) {
                    Class<?> artifactClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                    this.idToArtifactClassMap.put(id, artifactClass);
                    ArrayList<String> typeList = new ArrayList<String>();
                    typeList.add(batchTypeName);
                    this.idToArtifactTypeListMap.put(id, typeList);
                } else {
                    Class<?> artifactClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                    if (!this.idToArtifactClassMap.get(id).equals(artifactClass)) {
                        Class alreadyLoaded = this.idToArtifactClassMap.get(id);
                        String msg = "Attempted to load batch artifact with id: " + id + ", and className: " + className + ". Found: " + artifactClass + ", however the artifact id: " + id + " is already associated with: " + alreadyLoaded + ", of className: " + alreadyLoaded.getCanonicalName();
                        throw new IllegalArgumentException(msg);
                    }
                    List<String> typeList = this.idToArtifactTypeListMap.get(id);
                    typeList.add(batchTypeName);
                }
            }
            catch (Exception artifactClass) {
                void e;
                FFDCFilter.processException((Throwable)artifactClass, (String)"com.ibm.jbatch.container.services.impl.JSEBatchArtifactFactoryImpl$ArtifactMap", (String)"223", (Object)this, (Object[])new Object[]{batchTypeName, id, className});
                throw new RuntimeException((Throwable)e);
            }
        }

        /*
         * WARNING - void declaration
         */
        private Object getArtifactById(String id) {
            Object artifactInstance = null;
            try {
                Class clazz = this.idToArtifactClassMap.get(id);
                if (clazz != null) {
                    artifactInstance = this.idToArtifactClassMap.get(id).newInstance();
                }
            }
            catch (IllegalAccessException clazz) {
                void e;
                FFDCFilter.processException((Throwable)clazz, (String)"com.ibm.jbatch.container.services.impl.JSEBatchArtifactFactoryImpl$ArtifactMap", (String)"237", (Object)this, (Object[])new Object[]{id});
                throw new BatchContainerRuntimeException("Tried but failed to load artifact with id: " + id, (Throwable)e);
            }
            catch (InstantiationException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.services.impl.JSEBatchArtifactFactoryImpl$ArtifactMap", (String)"239", (Object)this, (Object[])new Object[]{id});
                throw new BatchContainerRuntimeException("Tried but failed to load artifact with id: " + id, e);
            }
            return artifactInstance;
        }

        private List<String> getBatchTypeList(String id) {
            return this.idToArtifactTypeListMap.get(id);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ArtifactMap.class);
        }
    }
}

