/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.servicesmanager;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.exception.PersistenceException;
import com.ibm.jbatch.container.impl.BatchConfigImpl;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServiceTypes;
import com.ibm.jbatch.container.servicesmanager.ServicesManager;
import com.ibm.jbatch.container.util.BatchContainerConstants;
import com.ibm.jbatch.container.ws.BatchDispatcher;
import com.ibm.jbatch.container.ws.events.BatchEventsPublisher;
import com.ibm.jbatch.container.ws.smf.ZosJBatchSMFLogging;
import com.ibm.jbatch.spi.BatchSPIManager;
import com.ibm.jbatch.spi.DatabaseConfigurationBean;
import com.ibm.jbatch.spi.services.IBatchArtifactFactory;
import com.ibm.jbatch.spi.services.IBatchServiceBase;
import com.ibm.jbatch.spi.services.IBatchThreadPoolService;
import com.ibm.jbatch.spi.services.IJobXMLLoaderService;
import com.ibm.jbatch.spi.services.ITransactionManagementService;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class ServicesManagerImpl
implements BatchContainerConstants,
ServicesManager {
    private static final String sourceClass = ServicesManagerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private final byte[] isInitedLock;
    private volatile Boolean isInited;
    private DatabaseConfigurationBean databaseConfigBean;
    private BatchConfigImpl batchRuntimeConfig;
    private Properties batchContainerProps;
    private final Map<ServiceTypes.Name, String> serviceImplClassNames;
    private final Map<String, ServiceTypes.Name> propertyNameTable;
    private final ConcurrentHashMap<ServiceTypes.Name, IBatchServiceBase> serviceRegistry;
    private ITransactionManagementService transactionManagementService;
    private ZosJBatchSMFLogging jbatchSMF;
    private IPersistenceManagerService persistenceService;
    private IBatchThreadPoolService batchThreadPoolService;
    private IBatchKernelService batchKernelService;
    private IJobXMLLoaderService jobXMLLoaderService;
    private IBatchArtifactFactory batchArtifactFactory;
    private BatchEventsPublisher eventsPublisher;
    private BatchDispatcher batchJmsDispatcher;
    static final long serialVersionUID = -6322686229535152122L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ServicesManagerImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "<init>", new Object[0]);
        }
        this.isInitedLock = new byte[0];
        this.isInited = Boolean.FALSE;
        this.databaseConfigBean = null;
        this.batchContainerProps = null;
        this.serviceImplClassNames = ServiceTypes.getServiceImplClassNames();
        this.propertyNameTable = ServiceTypes.getServicePropertyNames();
        this.serviceRegistry = new ConcurrentHashMap();
        this.eventsPublisher = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "<init>", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void initIfNecessary() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "initIfNecessary", new Object[0]);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.config("In initIfNecessary().");
        }
        if (!this.isInited.booleanValue()) {
            byte[] byArray = this.isInitedLock;
            // MONITORENTER : this.isInitedLock
            if (!this.isInited.booleanValue()) {
                logger.config("--- Initializing ServicesManagerImpl ---");
                this.batchRuntimeConfig = new BatchConfigImpl();
                this.initFromPropertiesFiles();
                this.initServiceImplOverrides();
                this.initDatabaseConfig();
                this.initOtherConfig();
                this.isInited = Boolean.TRUE;
                logger.config("--- Completed initialization of ServicesManagerImpl ---");
            }
            // MONITOREXIT : byArray
        }
        logger.config("Exiting initIfNecessary()");
        if (logger == null) return;
        if (!logger.isLoggable(Level.FINER)) return;
        logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "initIfNecessary");
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void initFromPropertiesFiles() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "initFromPropertiesFiles", new Object[0]);
        }
        Properties serviceIntegratorProps = new Properties();
        InputStream batchServicesListInputStream = this.getClass().getResourceAsStream("/META-INF/services/batch-services.properties");
        if (batchServicesListInputStream != null) {
            try {
                logger.config("Batch Integrator Config File exists! loading it..");
                serviceIntegratorProps.load(batchServicesListInputStream);
                batchServicesListInputStream.close();
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", (String)"122", (Object)this, (Object[])new Object[0]);
                logger.config("Error loading /META-INF/services/batch-services.properties IOException=" + e.toString());
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", (String)"124", (Object)this, (Object[])new Object[0]);
                logger.config("Error loading /META-INF/services/batch-services.properties Exception=" + e.toString());
            }
        } else {
            logger.config("Could not find batch integrator config file: /META-INF/services/batch-services.properties");
        }
        HashSet<String> removeThese = new HashSet<String>();
        for (Object key : serviceIntegratorProps.keySet()) {
            String keyStr = (String)key;
            if (this.propertyNameTable.containsKey(keyStr)) continue;
            logger.fine("Found property named: " + keyStr + " with value: " + serviceIntegratorProps.get(keyStr) + " in " + "batch-services.properties" + " , but did not find a corresponding service type in the internal table of service types.\n Ignoring this property then.   Maybe this should have been set in batch-config.properties instead.");
            removeThese.add(keyStr);
        }
        for (String s : removeThese) {
            serviceIntegratorProps.remove(s);
        }
        Properties adminProps = new Properties();
        InputStream batchAdminConfigListInputStream = this.getClass().getResourceAsStream("/META-INF/services/batch-config.properties");
        if (batchServicesListInputStream != null) {
            try {
                logger.config("Batch Admin Config File exists! loading it..");
                adminProps.load(batchAdminConfigListInputStream);
                batchAdminConfigListInputStream.close();
            }
            catch (IOException keyStr) {
                void e;
                FFDCFilter.processException((Throwable)keyStr, (String)"com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", (String)"156", (Object)this, (Object[])new Object[0]);
                logger.config("Error loading /META-INF/services/batch-config.properties IOException=" + e.toString());
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", (String)"158", (Object)this, (Object[])new Object[0]);
                logger.config("Error loading /META-INF/services/batch-config.properties Exception=" + e.toString());
            }
        } else {
            logger.config("Could not find batch admin config file: /META-INF/services/batch-config.properties");
        }
        HashSet removeTheseToo = new HashSet();
        for (Object key : adminProps.keySet()) {
            String keyStr = (String)key;
            if (!this.propertyNameTable.containsKey(keyStr)) continue;
            logger.fine("Found property named: " + keyStr + " with value: " + adminProps.get(keyStr) + " in " + "batch-config.properties" + " , but this is a batch runtime service configuration.\nIgnoring this property then, since this should have been set in batch-services.properties instead.");
            removeThese.add(keyStr);
        }
        for (String s : removeTheseToo) {
            adminProps.remove(s);
        }
        this.batchContainerProps = new Properties();
        this.batchContainerProps.putAll((Map<?, ?>)adminProps);
        this.batchContainerProps.putAll((Map<?, ?>)serviceIntegratorProps);
        logger.fine("Dumping contents of batchContainerProps after reading properties files.");
        for (Object key : this.batchContainerProps.keySet()) {
            logger.config("key = " + key);
            logger.config("value = " + this.batchContainerProps.get(key));
        }
        this.batchRuntimeConfig.setConfigProperties(this.batchContainerProps);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "initFromPropertiesFiles");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void initServiceImplOverrides() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "initServiceImplOverrides", new Object[0]);
        }
        for (String propKey : this.propertyNameTable.keySet()) {
            String value = this.batchContainerProps.getProperty(propKey);
            if (value == null) continue;
            ServiceTypes.Name serviceType = this.propertyNameTable.get(propKey);
            String defaultServiceImplClassName = this.serviceImplClassNames.get((Object)serviceType);
            this.serviceImplClassNames.put(serviceType, value.trim());
            logger.config("Overriding serviceType: " + (Object)((Object)serviceType) + ", replacing default impl classname: " + defaultServiceImplClassName + " with override impl class name: " + value.trim());
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "initServiceImplOverrides");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void initDatabaseConfig() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "initDatabaseConfig", new Object[0]);
        }
        if (this.databaseConfigBean == null) {
            logger.config("First try to load 'suggested config' from BatchSPIManager");
            this.databaseConfigBean = BatchSPIManager.getInstance().getFinalDatabaseConfiguration();
            if (this.databaseConfigBean == null) {
                logger.fine("Loading database config from configuration properties file.");
                this.databaseConfigBean = new DatabaseConfigurationBean();
                this.databaseConfigBean.setJndiName(this.batchContainerProps.getProperty("JNDI_NAME", "jdbc/batch"));
                this.databaseConfigBean.setJdbcDriver(this.batchContainerProps.getProperty("JDBC_DRIVER", "org.apache.derby.jdbc.EmbeddedDriver"));
                this.databaseConfigBean.setJdbcUrl(this.batchContainerProps.getProperty("JDBC_URL", "jdbc:derby:RUNTIMEDB;create=true"));
                this.databaseConfigBean.setDbUser(this.batchContainerProps.getProperty("DB_USER"));
                this.databaseConfigBean.setDbPassword(this.batchContainerProps.getProperty("DB_PWD"));
                this.databaseConfigBean.setSchema(this.batchContainerProps.getProperty("DB_SCHEMA", "JBATCH"));
            }
        } else {
            logger.config("Database config has been set directly from SPI, do NOT load from properties file.");
        }
        this.batchRuntimeConfig.setDatabaseConfigurationBean(this.databaseConfigBean);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "initDatabaseConfig");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void initOtherConfig() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "initOtherConfig", new Object[0]);
        }
        String seMode = this.serviceImplClassNames.get((Object)ServiceTypes.Name.JAVA_EDITION_IS_SE_DUMMY_SERVICE);
        if (seMode.equalsIgnoreCase("true")) {
            this.batchRuntimeConfig.setJ2seMode(true);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "initOtherConfig");
        }
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private IBatchServiceBase getService(ServiceTypes.Name serviceType) throws BatchContainerServiceException {
        String sourceMethod = "getService";
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(sourceClass, sourceMethod + ", serviceType=" + (Object)((Object)serviceType));
        }
        this.initIfNecessary();
        IBatchServiceBase service = new ServiceLoader(serviceType).getService();
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(sourceClass, sourceMethod);
        }
        return service;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Deactivate
    protected void deactivate() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "deactivate", new Object[0]);
        }
        this.getBatchKernelService().shutdown();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "deactivate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    protected void setZosJBatchSMFLogging(ZosJBatchSMFLogging jbatchSMF) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "setZosJBatchSMFLogging", new Object[]{jbatchSMF});
        }
        this.jbatchSMF = jbatchSMF;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "setZosJBatchSMFLogging");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetZosJBatchSMFLogging(ZosJBatchSMFLogging jbatchSMF) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "unsetZosJBatchSMFLogging", new Object[]{jbatchSMF});
        }
        if (this.jbatchSMF == jbatchSMF) {
            this.jbatchSMF = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "unsetZosJBatchSMFLogging");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ZosJBatchSMFLogging getJBatchSMFService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "getJBatchSMFService", new Object[0]);
        }
        ZosJBatchSMFLogging zosJBatchSMFLogging = this.jbatchSMF;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            zosJBatchSMFLogging = zosJBatchSMFLogging;
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "getJBatchSMFService", zosJBatchSMFLogging);
        }
        return zosJBatchSMFLogging;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setITransactionManagementService(ITransactionManagementService ref) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "setITransactionManagementService", new Object[]{ref});
        }
        this.transactionManagementService = ref;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "setITransactionManagementService");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ITransactionManagementService getTransactionManagementService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "getTransactionManagementService", new Object[0]);
        }
        ITransactionManagementService iTransactionManagementService = this.transactionManagementService;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iTransactionManagementService = iTransactionManagementService;
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "getTransactionManagementService", iTransactionManagementService);
        }
        return iTransactionManagementService;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected void setIPersistenceManagerService(IPersistenceManagerService ref, Map<String, Object> props) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "setIPersistenceManagerService", new Object[]{ref, props});
        }
        this.persistenceService = ref;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "setIPersistenceManagerService");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public IPersistenceManagerService getPersistenceManagerService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "getPersistenceManagerService", new Object[0]);
        }
        IPersistenceManagerService iPersistenceManagerService = this.persistenceService;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iPersistenceManagerService = iPersistenceManagerService;
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "getPersistenceManagerService", iPersistenceManagerService);
        }
        return iPersistenceManagerService;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setIBatchThreadPoolService(IBatchThreadPoolService batchThreadPoolService) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "setIBatchThreadPoolService", new Object[]{batchThreadPoolService});
        }
        this.batchThreadPoolService = batchThreadPoolService;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "setIBatchThreadPoolService");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public IBatchThreadPoolService getThreadPoolService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "getThreadPoolService", new Object[0]);
        }
        IBatchThreadPoolService iBatchThreadPoolService = this.batchThreadPoolService;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iBatchThreadPoolService = iBatchThreadPoolService;
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "getThreadPoolService", iBatchThreadPoolService);
        }
        return iBatchThreadPoolService;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setIBatchKernelService(IBatchKernelService ref) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "setIBatchKernelService", new Object[]{ref});
        }
        this.batchKernelService = ref;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "setIBatchKernelService");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public IBatchKernelService getBatchKernelService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "getBatchKernelService", new Object[0]);
        }
        IBatchKernelService iBatchKernelService = this.batchKernelService;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iBatchKernelService = iBatchKernelService;
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "getBatchKernelService", iBatchKernelService);
        }
        return iBatchKernelService;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public IJobXMLLoaderService getPreferredJobXMLLoaderService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "getPreferredJobXMLLoaderService", new Object[0]);
        }
        IJobXMLLoaderService iJobXMLLoaderService = this.jobXMLLoaderService;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iJobXMLLoaderService = iJobXMLLoaderService;
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "getPreferredJobXMLLoaderService", iJobXMLLoaderService);
        }
        return iJobXMLLoaderService;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setIJobXMLLoaderService(IJobXMLLoaderService ref) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "setIJobXMLLoaderService", new Object[]{ref});
        }
        this.jobXMLLoaderService = ref;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "setIJobXMLLoaderService");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public IJobXMLLoaderService getDelegatingJobXMLLoaderService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "getDelegatingJobXMLLoaderService", new Object[0]);
        }
        IJobXMLLoaderService iJobXMLLoaderService = this.jobXMLLoaderService;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iJobXMLLoaderService = iJobXMLLoaderService;
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "getDelegatingJobXMLLoaderService", iJobXMLLoaderService);
        }
        return iJobXMLLoaderService;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public IBatchArtifactFactory getPreferredArtifactFactory() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "getPreferredArtifactFactory", new Object[0]);
        }
        IBatchArtifactFactory iBatchArtifactFactory = (IBatchArtifactFactory)this.getService(ServiceTypes.Name.CONTAINER_ARTIFACT_FACTORY_SERVICE);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iBatchArtifactFactory = iBatchArtifactFactory;
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "getPreferredArtifactFactory", iBatchArtifactFactory);
        }
        return iBatchArtifactFactory;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setIBatchArtifactFactory(IBatchArtifactFactory ref) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "setIBatchArtifactFactory", new Object[]{ref});
        }
        this.batchArtifactFactory = ref;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "setIBatchArtifactFactory");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public IBatchArtifactFactory getDelegatingArtifactFactory() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "getDelegatingArtifactFactory", new Object[0]);
        }
        IBatchArtifactFactory iBatchArtifactFactory = this.batchArtifactFactory;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iBatchArtifactFactory = iBatchArtifactFactory;
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "getDelegatingArtifactFactory", iBatchArtifactFactory);
        }
        return iBatchArtifactFactory;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEventsPublisher(BatchEventsPublisher publisher) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "setEventsPublisher", new Object[]{publisher});
        }
        this.eventsPublisher = publisher;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "setEventsPublisher");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetEventsPublisher(BatchEventsPublisher publisher) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "unsetEventsPublisher", new Object[]{publisher});
        }
        if (this.eventsPublisher == publisher) {
            this.eventsPublisher = publisher;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "unsetEventsPublisher");
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BatchEventsPublisher getBatchEventsPublisher() {
        return this.eventsPublisher;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(type=JMS)")
    protected void setBatchJmsDispatcher(BatchDispatcher ref) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "setBatchJmsDispatcher", new Object[]{ref});
        }
        this.batchJmsDispatcher = ref;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "setBatchJmsDispatcher");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetBatchJmsDispatcher(BatchDispatcher ref) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "unsetBatchJmsDispatcher", new Object[]{ref});
        }
        if (this.batchJmsDispatcher == ref) {
            this.batchJmsDispatcher = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "unsetBatchJmsDispatcher");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BatchDispatcher getBatchJmsDispatcher() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "getBatchJmsDispatcher", new Object[0]);
        }
        BatchDispatcher batchDispatcher = this.batchJmsDispatcher;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            batchDispatcher = batchDispatcher;
            logger.exiting("com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl", "getBatchJmsDispatcher", batchDispatcher);
        }
        return batchDispatcher;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class ServiceLoader {
        volatile IBatchServiceBase service = null;
        private ServiceTypes.Name serviceType = null;
        static final long serialVersionUID = -3608629752658438482L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ServiceLoader(ServiceTypes.Name name) {
            this.serviceType = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IBatchServiceBase getService() {
            this.service = (IBatchServiceBase)ServicesManagerImpl.this.serviceRegistry.get((Object)this.serviceType);
            if (this.service == null) {
                ConcurrentHashMap concurrentHashMap = ServicesManagerImpl.this.serviceRegistry;
                synchronized (concurrentHashMap) {
                    if (this.service == null) {
                        this.service = this._loadServiceHelper(this.serviceType);
                        this.service.init(ServicesManagerImpl.this.batchRuntimeConfig);
                        ServicesManagerImpl.this.serviceRegistry.putIfAbsent(this.serviceType, this.service);
                    }
                }
            }
            return this.service;
        }

        /*
         * WARNING - void declaration
         */
        private IBatchServiceBase _loadServiceHelper(ServiceTypes.Name serviceType) {
            IBatchServiceBase service = null;
            String className = (String)ServicesManagerImpl.this.serviceImplClassNames.get((Object)serviceType);
            try {
                if (className != null) {
                    service = this._loadService(className);
                }
            }
            catch (PersistenceException persistenceException) {
                void pe;
                FFDCFilter.processException((Throwable)persistenceException, (String)"com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl$ServiceLoader", (String)"429", (Object)this, (Object[])new Object[]{serviceType});
                throw pe;
            }
            catch (Throwable pe) {
                void e;
                FFDCFilter.processException((Throwable)pe, (String)"com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl$ServiceLoader", (String)"432", (Object)this, (Object[])new Object[]{serviceType});
                throw new RuntimeException("Could not instantiate service " + className, (Throwable)e);
            }
            if (service == null) {
                throw new RuntimeException("Instantiate of service=: " + className + " returned null. Aborting...");
            }
            return service;
        }

        private IBatchServiceBase _loadService(String className) throws Exception {
            Constructor<?> ctor;
            IBatchServiceBase service = null;
            Class<?> cls = Class.forName(className);
            if (cls != null) {
                ctor = cls.getConstructor(new Class[0]);
                if (ctor == null) {
                    throw new Exception("Service class " + className + " should  have a default constructor defined");
                }
            } else {
                throw new Exception("Exception loading Service class " + className + " make sure it exists");
            }
            service = (IBatchServiceBase)ctor.newInstance(new Object[0]);
            return service;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ServiceLoader.class);
        }
    }
}

