/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.handlers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.datatypes.ConversionException;
import com.ibm.ws.jmx.connector.datatypes.NotificationArea;
import com.ibm.ws.jmx.connector.datatypes.NotificationSettings;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper;
import com.ibm.ws.jmx.connector.server.rest.notification.NotificationManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMethodNotAllowedError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.custom.routing=true", "com.ibm.wsspi.rest.handler.context.root=/IBMJMXConnectorREST", "com.ibm.wsspi.rest.handler.root=/notifications"})
public class NotificationHandler
implements RESTHandler {
    public static final TraceComponent tc = Tr.register(NotificationHandler.class);
    static final long serialVersionUID = -1518683969986484011L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
    }

    public void handleRequest(RESTRequest request, RESTResponse response) {
        String method = request.getMethod();
        if (!RESTHelper.isPostMethod(method)) {
            throw new RESTHandlerMethodNotAllowedError("POST");
        }
        this.getNotificationArea(request, response);
    }

    @FFDCIgnore(value={ConversionException.class, IOException.class})
    private void getNotificationArea(RESTRequest request, RESTResponse response) {
        RESTHelper.ensureConsumesJson(request);
        JSONConverter converter = JSONConverter.getConverter();
        NotificationSettings notificationSettings = null;
        InputStream is = RESTHelper.getInputStream(request);
        try {
            notificationSettings = converter.readNotificationSettings(is);
        }
        catch (ConversionException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (IOException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        NotificationArea newArea = NotificationManager.getNotificationManager().createNotificationArea(request, "/IBMJMXConnectorREST/notifications/", notificationSettings);
        OutputHelper.writeNotificationAreaOutput(response, newArea, JSONConverter.getConverter());
    }
}

