/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.ConnectionSchemaSet;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import com.ibm.ws.sib.mfp.util.HexUtil;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public final class SchemaSet
implements ConnectionSchemaSet,
Set {
    private static TraceComponent tc = SibTr.register(SchemaSet.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final int DEFAULT_TABLE_SIZE = 28;
    private static final int MAX_ENTRY_DEPTH = 3;
    private Entry[] table;

    public SchemaSet() {
        this(28);
    }

    public SchemaSet(int size) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"SchemaSet", (Object)size);
        }
        this.table = new Entry[size];
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"SchemaSet");
        }
    }

    @Override
    public boolean contains(Object o) {
        Entry current;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"contains", (Object)SchemaSet.debugId(o));
        }
        boolean result = false;
        Entry[] safeTable = this.table;
        Long id = (Long)o;
        int i = this.hashToTable(id, safeTable);
        if (safeTable[i] != null && (current = safeTable[i]).contains(id, 0) == 0) {
            result = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"contains", (Object)result);
        }
        return result;
    }

    @Override
    public synchronized boolean add(Object o) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"add", (Object)SchemaSet.debugId(o));
        }
        boolean result = false;
        Long id = (Long)o;
        int i = this.hashToTable(id, this.table);
        if (this.table[i] == null) {
            this.table[i] = new Entry(id);
            result = true;
        } else {
            Entry current = this.table[i];
            int depth = current.contains(id, 0);
            if (depth > 0) {
                if (depth < 3) {
                    Entry newEntry;
                    this.table[i] = newEntry = new Entry(id, current);
                    result = true;
                } else {
                    Entry newEntry;
                    this.resize();
                    i = this.hashToTable(id, this.table);
                    current = this.table[i];
                    this.table[i] = newEntry = new Entry(id, current);
                    result = true;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"add", (Object)result);
        }
        return result;
    }

    @Override
    public int size() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"size");
        }
        Entry[] safeTable = this.table;
        long count = 0L;
        for (int i = 0; i < safeTable.length; ++i) {
            Entry current = safeTable[i];
            while (current != null) {
                ++count;
                current = current.next;
            }
        }
        if (count > Integer.MAX_VALUE) {
            count = Integer.MAX_VALUE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"size", (Object)((int)count));
        }
        return (int)count;
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray(Object[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    private int hashToTable(Long id, Entry[] table) {
        int posVal = id.intValue() & Integer.MAX_VALUE;
        return posVal % table.length;
    }

    private void resize() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"resize", (Object)this.table.length);
        }
        Entry[] newTable = new Entry[this.table.length + this.table.length / 2];
        for (int i = 0; i < this.table.length; ++i) {
            Entry ent = this.table[i];
            while (ent != null) {
                Entry newEntry;
                int j = this.hashToTable(ent.schemaId, newTable);
                newTable[j] = newEntry = new Entry(ent.schemaId, newTable[j]);
                ent = ent.next;
            }
        }
        this.table = newTable;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"resize", (Object)this.table.length);
        }
    }

    public String toVerboseString() {
        Entry[] tempTable = this.table;
        StringBuffer buf = new StringBuffer();
        buf.append("SchemaSet ");
        buf.append(this.hashCode());
        buf.append(" {\n");
        for (int i = 0; i < tempTable.length; ++i) {
            buf.append("  [");
            buf.append(i);
            buf.append("] ");
            Entry ent = tempTable[i];
            buf.append(ent);
            while (ent != null) {
                ent = ent.next;
                buf.append(" ");
                buf.append(ent);
            }
            buf.append("\n");
        }
        buf.append(" }\n");
        return buf.toString();
    }

    private static final String debugId(Object o) {
        Long id = (Long)o;
        byte[] buf = new byte[8];
        ArrayUtil.writeLong(buf, 0, id);
        return HexUtil.toString(buf);
    }

    private static final class Entry {
        private final Long schemaId;
        private final Entry next;

        Entry(Long id) {
            this.schemaId = id;
            this.next = null;
        }

        Entry(Long id, Entry nextEntry) {
            this.schemaId = id;
            this.next = nextEntry;
        }

        private int contains(Long id, int depth) {
            ++depth;
            if (this.schemaId.equals(id)) {
                return 0;
            }
            if (this.next != null) {
                return this.next.contains(id, depth);
            }
            return depth;
        }

        public String toString() {
            return SchemaSet.debugId(this.schemaId);
        }
    }
}

