/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.jmf.JMFFieldDef;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaViolationException;
import com.ibm.ws.sib.mfp.jmf.JMFType;
import com.ibm.ws.sib.mfp.jmf.JmfTr;
import com.ibm.ws.sib.mfp.jmf.impl.CompatibilityMap;
import com.ibm.ws.sib.mfp.jmf.impl.JSDynamic;
import com.ibm.ws.sib.mfp.jmf.impl.JSEnum;
import com.ibm.ws.sib.mfp.jmf.impl.JSField;
import com.ibm.ws.sib.mfp.jmf.impl.JSListCoder;
import com.ibm.ws.sib.mfp.jmf.impl.JSPrimitive;
import com.ibm.ws.sib.mfp.jmf.impl.JSRepeated;
import com.ibm.ws.sib.mfp.jmf.impl.JSTuple;
import com.ibm.ws.sib.mfp.jmf.impl.JSType;
import com.ibm.ws.sib.mfp.jmf.impl.JSVariant;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import com.ibm.ws.sib.mfp.util.HashedArray;
import com.ibm.ws.sib.utils.CryptoHash;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class JSchema
implements JMFSchema,
HashedArray.Element {
    private static TraceComponent tc = JmfTr.register(JSchema.class, "SIBJmf", "com.ibm.ws.sib.mfp.CWSIFMessages");
    public static final int VERSION = 1;
    private int version = 1;
    private byte[] serialForm;
    private String name;
    private long schemaID;
    private Long schemaLongID;
    private JSType jsTypeTree;
    private JSField[] fields;
    private JSVariant[] variants;
    private int[][] boxed;
    private Object[] interpCache;
    private static final int COMP_MAP_BUCKETS = 23;
    private HashedArray compMaps;

    public JSchema(JSType root) {
        this.jsTypeTree = root;
        this.initialize(new HashMap());
    }

    public JSchema(byte[] frame) {
        this(frame, 0, frame.length);
    }

    public JSchema(byte[] frame, int offset, int length) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(tc, "<init>", new Object[]{frame, offset, length});
        }
        this.serialForm = new byte[length];
        System.arraycopy(frame, offset, this.serialForm, 0, length);
        short namelen = ArrayUtil.readShort(frame, offset);
        try {
            this.name = new String(frame, offset + 2, (int)namelen, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            FFDCFilter.processException((Throwable)e, (String)"<init>", (String)"159");
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
        int[] limits = new int[]{offset + 2 + namelen, offset + length};
        this.version = JSType.getCount(frame, limits);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JmfTr.debug(tc, "Schema name & version: " + this.name + " " + this.version);
        }
        this.jsTypeTree = JSType.createJSType(frame, limits);
        while (limits[0] < limits[1]) {
            int mapLen = JSType.getCount(frame, limits);
            CompatibilityMap aMap = new CompatibilityMap(frame, limits[0], mapLen);
            limits[0] = limits[0] + mapLen;
            if (this.compMaps == null) {
                this.compMaps = new HashedArray(23, 2);
            }
            this.compMaps.set(aMap);
        }
        this.initialize(new HashMap());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(tc, "<init>");
        }
    }

    JSchema(JSType root, Map context) {
        this.jsTypeTree = root;
        this.initialize(context);
    }

    @Override
    public JMFFieldDef getFieldDef(int accessor) {
        if (accessor < 0) {
            return null;
        }
        if (accessor < this.fields.length) {
            return this.fields[accessor];
        }
        if ((accessor -= this.fields.length) < this.variants.length) {
            return this.variants[accessor];
        }
        if ((accessor -= this.variants.length) >= this.boxed.length) {
            return null;
        }
        return ((JSVariant)this.fields[this.boxed[accessor][0]]).getBoxed().getFieldDef(this.boxed[accessor][1]);
    }

    @Override
    public int getAccessorCount() {
        return this.fields.length + this.variants.length + this.boxed.length;
    }

    public JSField[] getFields() {
        return this.fields;
    }

    public JSVariant[] getVariants() {
        return this.variants;
    }

    public int[][] getBoxed() {
        return this.boxed;
    }

    @Override
    public JMFType getJMFType() {
        return this.jsTypeTree;
    }

    @Override
    public byte[] toByteArray() {
        return this.serialForm;
    }

    @Override
    public long getID() {
        return this.schemaID;
    }

    @Override
    public Long getLongID() {
        return this.schemaLongID;
    }

    @Override
    public long getIndex() {
        return this.schemaID;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setInterpreterCache(int version, Object toCache) {
        if (this.interpCache == null) {
            this.interpCache = new Object[1];
        }
        this.interpCache[version - 1] = toCache;
    }

    public Object getInterpreterCache(int version) {
        if (this.interpCache != null && version <= this.interpCache.length) {
            return this.interpCache[version - 1];
        }
        return null;
    }

    public int hashCode() {
        return (int)this.schemaID;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JSchema)) {
            return false;
        }
        JSchema oSchema = (JSchema)o;
        if (oSchema.serialForm.length != this.serialForm.length) {
            return false;
        }
        for (int i = 0; i < this.serialForm.length; ++i) {
            if (oSchema.serialForm[i] == this.serialForm[i]) continue;
            return false;
        }
        return true;
    }

    public CompatibilityMap getCompatibility(JSchema access) throws JMFSchemaViolationException {
        CompatibilityMap ans = null;
        if (this.compMaps == null) {
            this.compMaps = new HashedArray(23, 2);
        } else {
            ans = (CompatibilityMap)this.compMaps.get(access.getID());
        }
        if (ans != null) {
            return ans;
        }
        ans = new CompatibilityMap(access, this);
        this.compMaps.set(ans);
        return ans;
    }

    @Override
    public int getAccessor(String name) {
        if (name == null) {
            name = "";
        }
        StringTokenizer path = new StringTokenizer(name, "/");
        JMFType pos = this.getEffectiveType(this.jsTypeTree);
        while (pos != null && path.hasMoreTokens()) {
            pos = this.findChild(this.getEffectiveType(pos), path.nextToken());
        }
        if (pos instanceof JSVariant && ((JSVariant)pos).getBoxed() != null) {
            return ((JSVariant)pos).getBoxed().getAccessor("");
        }
        if (pos instanceof JSField) {
            return ((JSField)pos).getAccessor();
        }
        return -1;
    }

    private JMFType getEffectiveType(JMFType start) {
        while (start instanceof JSRepeated) {
            start = ((JSRepeated)start).getItemType();
        }
        return start;
    }

    private JMFType findChild(JMFType start, String segment) {
        if (start instanceof JSPrimitive || start instanceof JSDynamic || start instanceof JSEnum) {
            return null;
        }
        if (segment.charAt(0) == '[') {
            return this.findChildByIndex(start, Integer.parseInt(segment.substring(1, segment.length() - 1)));
        }
        if (start instanceof JSVariant) {
            return this.findVariantChildByName((JSVariant)start, segment);
        }
        return this.findTupleChildByName((JSTuple)start, segment);
    }

    private JMFType findChildByIndex(JMFType start, int index) {
        if (index < 0) {
            return null;
        }
        if (start instanceof JSVariant) {
            JSVariant var = (JSVariant)start;
            int cases = var.getCaseCount();
            if (index >= cases) {
                return null;
            }
            return this.getEffectiveType(var.getCase(index));
        }
        JSTuple tup = (JSTuple)start;
        int fields = tup.getFieldCount();
        if (index >= fields) {
            return null;
        }
        return this.getEffectiveType(tup.getField(index));
    }

    private JMFType findVariantChildByName(JSVariant var, String name) {
        for (int i = 0; i < var.getCaseCount(); ++i) {
            JMFType theCase = this.getEffectiveType(var.getCase(i));
            String caseName = theCase.getFeatureName();
            if (caseName == null || !caseName.equals(name)) continue;
            return theCase;
        }
        return null;
    }

    private JMFType findTupleChildByName(JSTuple tup, String name) {
        for (int i = 0; i < tup.getFieldCount(); ++i) {
            JMFType theField = this.getEffectiveType(tup.getField(i));
            String fieldName = theField.getFeatureName();
            if (fieldName == null || !fieldName.equals(name)) continue;
            return theField;
        }
        return null;
    }

    @Override
    public int getCaseIndex(int accessor, String name) {
        JMFFieldDef field = this.getFieldDef(accessor);
        if (!(field instanceof JSVariant)) {
            return -1;
        }
        JMFType target = this.findVariantChildByName((JSVariant)field, name);
        if (target != null) {
            return this.getEffectiveSiblingPosition(target);
        }
        return -1;
    }

    @Override
    public String getPathName(int accessor) {
        JMFFieldDef field = this.getFieldDef(accessor);
        if (field == null) {
            return null;
        }
        if (field instanceof JSVariant && ((JSVariant)field).getBoxed() != null) {
            return null;
        }
        return this.getPathName(field);
    }

    @Override
    public String getPathName(JMFType type) {
        JSVariant boxedBy;
        if (type instanceof JSVariant && (boxedBy = ((JSVariant)type).getBoxedBy()) != null) {
            type = boxedBy;
        }
        JMFType parent = type.getParent();
        while (parent instanceof JSRepeated) {
            parent = parent.getParent();
        }
        if (parent == null) {
            return "";
        }
        String prePath = this.getPathName(parent);
        if (type instanceof JSRepeated) {
            return prePath;
        }
        String segment = type.getFeatureName();
        if (segment == null) {
            segment = "[" + this.getEffectiveSiblingPosition(type) + "]";
        }
        if (prePath.length() > 0) {
            return prePath + "/" + segment;
        }
        return segment;
    }

    private int getEffectiveSiblingPosition(JMFType child) {
        JMFType parent = child.getParent();
        while (parent instanceof JSRepeated) {
            child = parent;
            parent = child.getParent();
        }
        return child.getSiblingPosition();
    }

    private void initialize(Map context) {
        context.put(this.jsTypeTree, this);
        ArrayList tmpFields = new ArrayList();
        ArrayList tmpVariants = new ArrayList();
        this.number(this.jsTypeTree, context, false, 0, tmpFields, tmpVariants);
        this.fields = tmpFields.toArray(new JSField[0]);
        this.variants = tmpVariants.toArray(new JSVariant[0]);
        int boxLen = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            if (!(this.fields[i] instanceof JSVariant)) continue;
            boxLen += ((JSVariant)this.fields[i]).box(context).getAccessorCount();
        }
        this.boxed = new int[boxLen][];
        int boxIndex = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            if (!(this.fields[i] instanceof JSVariant)) continue;
            int j = 0;
            while (j < ((JSVariant)this.fields[i]).getBoxed().getAccessorCount()) {
                this.boxed[boxIndex++] = new int[]{i, j++};
            }
        }
        this.setAccessors(0, this);
        this.jsTypeTree.setMultiChoiceCount();
        if (this.serialForm == null) {
            this.name = this.jsTypeTree.getFeatureName();
            if (this.name == null) {
                this.name = "";
            }
            try {
                byte[] utfname = this.name.getBytes("UTF8");
                this.serialForm = new byte[2 + utfname.length + 2 + this.jsTypeTree.encodedTypeLength()];
                ArrayUtil.writeShort(this.serialForm, 0, (short)utfname.length);
                System.arraycopy(utfname, 0, this.serialForm, 2, utfname.length);
                int[] limits = new int[]{2 + utfname.length, this.serialForm.length};
                JSType.setCount(this.serialForm, limits, this.version);
                this.jsTypeTree.encodeType(this.serialForm, limits);
            }
            catch (UnsupportedEncodingException e) {
                FFDCFilter.processException((Throwable)e, (String)"initialize", (String)"604");
                IllegalArgumentException ex = new IllegalArgumentException();
                ex.initCause(e);
                throw ex;
            }
        }
        this.schemaID = CryptoHash.hash((byte[])this.serialForm);
        this.schemaLongID = this.schemaID;
    }

    private void number(JSType node, Map context, boolean boxVariant, int arrayCount, List tmpFields, List tmpVariants) {
        if (node instanceof JSField && arrayCount > 0) {
            ((JSField)node).setCoder(new JSListCoder(arrayCount - 1, (JSField)node));
        }
        if (node instanceof JSPrimitive || node instanceof JSEnum) {
            tmpFields.add(node);
        } else if (node instanceof JSDynamic) {
            tmpFields.add(node);
            ((JSDynamic)node).getExpectedSchema(context);
        } else if (node instanceof JSVariant) {
            if (boxVariant) {
                tmpFields.add(node);
            } else {
                JSVariant var = (JSVariant)node;
                var.setIndex(tmpVariants.size());
                tmpVariants.add(var);
                for (int i = 0; i < var.getCaseCount(); ++i) {
                    this.number((JSType)var.getCase(i), context, false, arrayCount, tmpFields, tmpVariants);
                }
            }
        } else if (node instanceof JSRepeated) {
            JSRepeated arr = (JSRepeated)node;
            this.number((JSType)arr.getItemType(), context, true, arrayCount + 1, tmpFields, tmpVariants);
        } else {
            JSTuple tup = (JSTuple)node;
            for (int i = 0; i < tup.getFieldCount(); ++i) {
                this.number((JSType)tup.getField(i), context, boxVariant, arrayCount, tmpFields, tmpVariants);
            }
        }
    }

    private void setAccessors(int bias, JMFSchema schema) {
        int i;
        int nextBoxBias = bias + this.fields.length + this.variants.length;
        for (i = 0; i < this.fields.length; ++i) {
            JSField field = this.fields[i];
            if (field instanceof JSVariant) {
                JSchema boxed = (JSchema)((JSVariant)field).getBoxed();
                boxed.setAccessors(nextBoxBias, schema);
                JSVariant boxVar = (JSVariant)boxed.getJMFType();
                field.setAccessor(boxVar.getAccessor(boxed), boxed);
                field.setAccessor(boxVar.getAccessor(schema), schema);
                ((JSVariant)field).setBoxAccessor(i + bias, schema);
                nextBoxBias += boxed.getAccessorCount();
                continue;
            }
            field.setAccessor(i + bias, schema);
        }
        for (i = 0; i < this.variants.length; ++i) {
            this.variants[i].setAccessor(i + bias + this.fields.length, schema);
        }
    }
}

