/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal.chains;

import com.ibm.websphere.channelfw.EndPointInfo;
import com.ibm.websphere.channelfw.EndPointMgr;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channelfw.internal.chains.EndPointInfoImpl;
import com.ibm.ws.staticvalue.StaticValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class EndPointMgrImpl
implements EndPointMgr {
    private static final TraceComponent tc = Tr.register(EndPointMgrImpl.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private static final String MBEAN_OBJECT_NAME_PREFIX = "WebSphere:feature=channelfw,type=endpoint,name=";
    private final BundleContext bundleContext;
    private final Map<String, EndPointInfoImpl> endpoints;
    private final ConcurrentMap<String, ServiceRegistration<DynamicMBean>> endpointMBeans;

    public EndPointMgrImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.endpoints = new HashMap<String, EndPointInfoImpl>();
        this.endpointMBeans = new ConcurrentHashMap<String, ServiceRegistration<DynamicMBean>>();
    }

    public static EndPointMgr getRef() {
        return (EndPointMgr)EndpointManagerHolder.singleton.get();
    }

    public static void setRef(final EndPointMgr singleton) {
        EndpointManagerHolder.singleton = StaticValue.mutateStaticValue((StaticValue)EndpointManagerHolder.singleton, (Callable)new Callable<EndPointMgr>(){

            @Override
            public EndPointMgr call() throws Exception {
                return singleton;
            }
        });
    }

    private String getMBeanObjectName(String name) {
        return MBEAN_OBJECT_NAME_PREFIX + name;
    }

    private Hashtable<String, String> createMBeanServiceProperties(String name, EndPointInfo endpoint) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.vendor", "IBM");
        properties.put("jmx.objectname", this.getMBeanObjectName(name));
        properties.put("type", "endpoint");
        return properties;
    }

    private ServiceRegistration<DynamicMBean> registerMBeanAsService(String name, EndPointInfoImpl endpoint) {
        return this.bundleContext.registerService(DynamicMBean.class, (Object)endpoint, this.createMBeanServiceProperties(name, endpoint));
    }

    private void registerEndpointMBean(String name, EndPointInfoImpl ep) {
        this.endpointMBeans.put(name, this.registerMBeanAsService(name, ep));
    }

    private EndPointInfoImpl updateEndpointMBean(String name, String host, int port) {
        EndPointInfoImpl existingEP = this.endpoints.get(name);
        existingEP.updateHost(host);
        existingEP.updatePort(port);
        return existingEP;
    }

    private void destroyEndpointMBeans() {
        for (Map.Entry mbean : this.endpointMBeans.entrySet()) {
            String mbeanName = (String)mbean.getKey();
            this.endpointMBeans.remove(mbeanName);
            ((ServiceRegistration)mbean.getValue()).unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyEndpoints() {
        EndPointMgrImpl _this = (EndPointMgrImpl)EndPointMgrImpl.getRef();
        Map<String, EndPointInfoImpl> map = _this.endpoints;
        synchronized (map) {
            _this.destroyEndpointMBeans();
            _this.endpoints.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EndPointInfo defineEndPoint(String name, String host, int port) {
        try {
            EndPointInfoImpl ep;
            Map<String, EndPointInfoImpl> map = this.endpoints;
            synchronized (map) {
                if (this.endpoints.containsKey(name)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("The new endpoint " + name + "already exists. Update the properties of the registered service"), (Object[])new Object[0]);
                    }
                    ep = this.updateEndpointMBean(name, host, port);
                } else {
                    ep = new EndPointInfoImpl(name, host, port);
                    this.registerEndpointMBean(name, ep);
                    this.endpoints.put(name, ep);
                }
            }
            return ep;
        }
        catch (NotCompliantMBeanException ex) {
            throw new IllegalStateException("Encountered a situation that should never occur. The EndPointInfo resulted in NotCompliantMBeanException", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EndPointInfo getEndPoint(String name) {
        Map<String, EndPointInfoImpl> map = this.endpoints;
        synchronized (map) {
            return this.endpoints.get(name);
        }
    }

    private void unregisterMBeanInService(String name) {
        ServiceRegistration existingMBean = (ServiceRegistration)this.endpointMBeans.remove(name);
        if (existingMBean != null) {
            existingMBean.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEndPoint(String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Deleting endpoint: " + name), (Object[])new Object[0]);
        }
        Map<String, EndPointInfoImpl> map = this.endpoints;
        synchronized (map) {
            if (this.endpoints.remove(name) != null) {
                this.unregisterMBeanInService(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EndPointInfo> getEndPoints(String address, int port) {
        LinkedList<EndPointInfo> rc = new LinkedList<EndPointInfo>();
        if (null == address) {
            return rc;
        }
        boolean isAddrWild = "*".equals(address);
        Map<String, EndPointInfoImpl> map = this.endpoints;
        synchronized (map) {
            for (EndPointInfo endPointInfo : this.endpoints.values()) {
                if ((!isAddrWild && !"*".equals(endPointInfo.getHost()) && !address.equals(endPointInfo.getHost()) || 0 != port && 0 != endPointInfo.getPort()) && port != endPointInfo.getPort()) continue;
                rc.add(endPointInfo);
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EndPointInfo> getEndsPoints() {
        Map<String, EndPointInfoImpl> map = this.endpoints;
        synchronized (map) {
            return new ArrayList<EndPointInfo>(this.endpoints.values());
        }
    }

    private static class EndpointManagerHolder {
        private static StaticValue<EndPointMgr> singleton = StaticValue.createStaticValue((Callable)new Callable<EndPointMgr>(){

            @Override
            public EndPointMgr call() throws Exception {
                BundleContext bundleContext = null;
                Bundle b = FrameworkUtil.getBundle(EndpointManagerHolder.class);
                if (b != null) {
                    bundleContext = b.getBundleContext();
                }
                return new EndPointMgrImpl(bundleContext);
            }
        });

        private EndpointManagerHolder() {
        }
    }
}

