/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.tcpchannel.internal.FilterCellFastStr;
import com.ibm.ws.tcpchannel.internal.FilterListStr;
import java.io.UnsupportedEncodingException;

public class FilterListFastStr
implements FilterListStr {
    private static final TraceComponent tc = Tr.register(FilterListFastStr.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    private byte PERIOD_VALUE = (byte)46;
    private byte WILDCARD_VALUE = (byte)42;
    private FilterCellFastStr firstCell = new FilterCellFastStr();
    private boolean active = false;

    @Override
    public void setActive(boolean value) {
        this.active = value;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public boolean buildData(String[] data) {
        int length = data.length;
        for (int i = 0; i < length; ++i) {
            if (this.addAddressToList(data[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean findInList(String address) {
        return this.findInList(this.convertToEntries(address));
    }

    private boolean addAddressToList(String newAddress) {
        return this.putInList(this.convertToEntries(newAddress));
    }

    private boolean findInList(Entry oEntry) {
        return this.findInList(oEntry.getHashcodes(), oEntry.getLengths(), this.firstCell, oEntry.getCurrentSize() - 1);
    }

    private boolean findInList(int[] hashcodes, int[] lengths, FilterCellFastStr cell, int index) {
        if (cell.getWildcardCell() != null) {
            return true;
        }
        FilterCellFastStr nextCell = cell.findNextCellWithLength(hashcodes[index], lengths[index]);
        if (nextCell != null) {
            if (index == 0) {
                return true;
            }
            return this.findInList(hashcodes, lengths, nextCell, index - 1);
        }
        return false;
    }

    private boolean putInList(Entry entry) {
        int lastIndex;
        FilterCellFastStr currentCell = this.firstCell;
        FilterCellFastStr nextCell = null;
        int[] hashcodes = entry.getHashcodes();
        int[] lengths = entry.getLengths();
        for (int i = lastIndex = entry.getCurrentSize() - 1; i >= 0; --i) {
            if (hashcodes[i] == 0 && lengths[i] == 0) {
                currentCell.addNewCell(hashcodes[i], lengths[i]);
                return true;
            }
            nextCell = currentCell.findNextCell(hashcodes[i]);
            if (nextCell != null && nextCell.getHashLength() != lengths[i]) {
                return false;
            }
            if (nextCell == null) {
                for (int j = i; j >= 0; --j) {
                    currentCell = currentCell.addNewCell(hashcodes[j], lengths[j]);
                    if (hashcodes[j] != 0 || lengths[j] != 0) continue;
                    return true;
                }
                return true;
            }
            currentCell = nextCell;
        }
        return true;
    }

    private Entry convertToEntries(String newAddress) {
        byte[] ba = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"convertToEntries", (Object[])new Object[0]);
        }
        try {
            ba = newAddress.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException x) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("ISO-8859-1 encoding not supported.  Exception: " + x), (Object[])new Object[0]);
            }
            ba = newAddress.getBytes();
        }
        int baLength = ba.length;
        int hashValue = 0;
        int hashLength = 0;
        int e31 = 1;
        Entry oEntry = new Entry();
        for (int i = 0; i < baLength; ++i) {
            if (ba[i] == this.WILDCARD_VALUE) {
                boolean valid = true;
                if (i != 0) {
                    valid = false;
                }
                if (baLength >= 2 && ba[1] != this.PERIOD_VALUE) {
                    valid = false;
                }
                if (valid) {
                    oEntry.addEntry(0, 0);
                    i = 1;
                    continue;
                }
            }
            if (ba[i] != this.PERIOD_VALUE) {
                hashValue += e31 * ba[i];
                e31 *= 31;
                ++hashLength;
            }
            if (ba[i] != this.PERIOD_VALUE && i != baLength - 1) continue;
            if (hashLength > 0) {
                oEntry.addEntry(hashValue, hashLength);
            }
            hashLength = 0;
            e31 = 1;
            hashValue = 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"convertToEntries");
        }
        return oEntry;
    }

    private static class Entry {
        private int incrementalSize = 100;
        private int[] hashcodes1 = new int[this.incrementalSize];
        private int[] lengths1 = new int[this.incrementalSize];
        private int[] hashcodes2;
        private int[] lengths2;
        private int index = 0;
        private int iSwitch = 1;
        private int currentSize = this.incrementalSize;

        public int getCurrentSize() {
            return this.index;
        }

        public int[] getHashcodes() {
            if (this.iSwitch == 1) {
                return this.hashcodes1;
            }
            return this.hashcodes2;
        }

        public int[] getLengths() {
            if (this.iSwitch == 1) {
                return this.lengths1;
            }
            return this.lengths2;
        }

        public void addEntry(int hashcode, int length) {
            if (this.iSwitch == 1) {
                if (this.index < this.currentSize) {
                    this.hashcodes1[this.index] = hashcode;
                    this.lengths1[this.index] = length;
                    ++this.index;
                } else {
                    this.currentSize += this.incrementalSize;
                    this.hashcodes2 = new int[this.currentSize];
                    this.lengths2 = new int[this.currentSize];
                    System.arraycopy(this.hashcodes1, 0, this.hashcodes2, 0, this.hashcodes1.length);
                    System.arraycopy(this.lengths1, 0, this.lengths2, 0, this.lengths1.length);
                    this.iSwitch = 2;
                    this.hashcodes2[this.index] = hashcode;
                    this.lengths2[this.index] = length;
                    ++this.index;
                }
            } else if (this.index < this.currentSize) {
                this.hashcodes2[this.index] = hashcode;
                this.lengths2[this.index] = length;
                ++this.index;
            } else {
                this.currentSize += this.incrementalSize;
                this.hashcodes1 = new int[this.currentSize];
                this.lengths1 = new int[this.currentSize];
                System.arraycopy(this.hashcodes2, 0, this.hashcodes1, 0, this.hashcodes2.length);
                System.arraycopy(this.lengths2, 0, this.lengths1, 0, this.lengths2.length);
                this.iSwitch = 1;
                this.hashcodes1[this.index] = hashcode;
                this.lengths1[this.index] = length;
                ++this.index;
            }
        }
    }
}

