/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils.ffdc;

import com.ibm.ejs.ras.Traceable;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class SibDiagnosticModule
extends DiagnosticModule {
    private static TraceComponent _tc = SibTr.register(SibDiagnosticModule.class, "", null);
    private static final String SIB_PACKAGE_NAME = ".sib.";
    private static boolean _registeredMasterDiagnosticModule = false;
    private static final String[] SIB_PACKAGE_LIST = new String[]{"com.ibm.ws.sib", "com.ibm.wsspi.sib", "com.ibm.websphere.sib"};
    protected static final String lineSeparator = System.getProperty("line.separator", "\n");
    protected int multiple_object_count_to_ffdc = 20;

    protected SibDiagnosticModule() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(String[] specificPackageList) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.entry(_tc, "register", new Object[]{this, specificPackageList});
        }
        Class<SibDiagnosticModule> clazz = SibDiagnosticModule.class;
        synchronized (SibDiagnosticModule.class) {
            if (!_registeredMasterDiagnosticModule) {
                SibDiagnosticModule masterModule = new SibDiagnosticModule();
                masterModule.registerModule(SIB_PACKAGE_LIST);
                _registeredMasterDiagnosticModule = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.registerModule(specificPackageList);
            if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
                SibTr.exit(_tc, "register");
            }
            return;
        }
    }

    protected void captureDefaultInformation(IncidentStream is) {
        this.captureDefaultInformation(is, null);
    }

    protected void captureDefaultInformation(IncidentStream is, Throwable th) {
        is.writeLine("Platform Messaging :: Messaging engine:", SibTr.getMEName(null));
        if (th != null) {
            StackTraceElement[] ste = th.getStackTrace();
            HashSet<String> classes = new HashSet<String>();
            for (int i = 0; i < ste.length; ++i) {
                StackTraceElement elem = ste[i];
                try {
                    String className = elem.getClassName();
                    if (className.indexOf(SIB_PACKAGE_NAME) < 0 || classes.contains(className)) continue;
                    classes.add(className);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void registerModule(String[] packageList) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.entry(_tc, "registerModule", new Object[]{this, packageList});
        }
        int rc = 0;
        for (int i = 0; rc == 0 && i < packageList.length; ++i) {
            if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                SibTr.debug(_tc, "Registering diagnostic module " + (Object)((Object)this) + " for package: " + packageList[i]);
            }
            if ((rc = FFDC.registerDiagnosticModule((DiagnosticModule)this, (String)packageList[i])) == 0 || !TraceComponent.isAnyTracingEnabled() || !_tc.isDebugEnabled()) continue;
            SibTr.debug(_tc, "Registration failed, return code=" + rc);
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.exit(_tc, "registerModule");
        }
    }

    public void ffdcDumpDefault(Throwable t, IncidentStream is, Object callerThis, Object[] objs, String sourceId) {
        is.writeLine("SIB FFDC dump for:", (Object)t);
        this.captureDefaultInformation(is, t);
        if (callerThis != null) {
            is.writeLine("SibDiagnosticModule :: Dump of callerThis (DiagnosticModule)", this.toFFDCString(callerThis));
            is.introspectAndWriteLine("Introspection of callerThis:", callerThis);
        }
        if (objs != null) {
            for (int i = 0; i < objs.length; ++i) {
                is.writeLine("callerArg (DiagnosticModule) [" + i + "]", this.toFFDCString(objs[i]));
                is.introspectAndWriteLine("callerArg [" + i + "] (Introspection)", objs[i]);
            }
        }
    }

    public final String toFFDCString(Object obj) {
        if (obj instanceof Map) {
            return this.toFFDCString((Map)obj);
        }
        if (obj instanceof Collection) {
            return this.toFFDCString((Collection)obj);
        }
        if (obj instanceof Object[]) {
            return this.toFFDCString((Object[])obj);
        }
        return this.toFFDCStringSingleObject(obj);
    }

    protected String toFFDCStringSingleObject(Object obj) {
        if (obj == null) {
            return "<null>";
        }
        if (obj instanceof Traceable) {
            return ((Traceable)obj).toTraceString();
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return this.toFFDCString((byte[])obj);
        }
        return obj.toString();
    }

    protected final String toFFDCString(byte[] toDump) {
        boolean text = true;
        for (int i = 0; i < toDump.length; ++i) {
            byte b = toDump[i];
            if (b < 32 || b > 126) {
                text = false;
                break;
            }
            text = true;
        }
        String result = text ? new String(toDump) : this.toFFDCString(toDump, 0, toDump.length);
        return result;
    }

    protected final String toFFDCString(byte[] toDump, int start, int length) {
        StringBuffer result = new StringBuffer();
        for (int lineStart = 0; lineStart < length; lineStart += 32) {
            int lineEnd = Math.min(lineStart + 32, length);
            StringBuffer hex = new StringBuffer();
            StringBuffer ascii = new StringBuffer();
            for (int i = lineStart; i < lineEnd; ++i) {
                int b = toDump[start + i];
                b = (b + 256) % 256;
                int c1 = b / 16;
                int c2 = b % 16;
                hex.append((char)(c1 < 10 ? 48 + c1 : 97 + c1 - 10));
                hex.append((char)(c2 < 10 ? 48 + c2 : 97 + c2 - 10));
                if (b >= 32 && b <= 126) {
                    ascii.append((char)b);
                } else {
                    ascii.append('.');
                }
                if (i % 32 != 15) continue;
                hex.append("  ");
                ascii.append("  ");
            }
            int pad = 32 - (lineEnd - lineStart);
            for (int i = 0; i < pad; ++i) {
                hex.append("  ");
                if (i % 32 != 16) continue;
                hex.append("  ");
            }
            hex.append("   ");
            String offset = "0000" + Integer.toHexString(lineStart + start);
            offset = offset.substring(offset.length() - 4);
            result.append(offset);
            result.append(":  ");
            result.append(hex.toString());
            result.append(ascii.toString());
            result.append(lineSeparator);
        }
        return result.toString();
    }

    public final String toFFDCString(Collection aCollection) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('{');
        if (aCollection == null) {
            buffer.append("<null>");
        } else {
            Iterator i = aCollection.iterator();
            boolean hasNext = i.hasNext();
            int ctr = 0;
            while (hasNext) {
                Object value = i.next();
                buffer.append((value == aCollection ? "<this list>" : this.toFFDCStringSingleObject(value)) + lineSeparator);
                hasNext = i.hasNext();
                if (ctr <= this.multiple_object_count_to_ffdc) continue;
                buffer.append("........contd");
                hasNext = false;
            }
        }
        buffer.append('}');
        return buffer.toString();
    }

    public final String toFFDCString(Object[] objects) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('{');
        if (objects == null) {
            buffer.append("<null>");
        } else {
            for (int i = 0; i < objects.length; ++i) {
                Object value = objects[i];
                buffer.append((value == objects ? "<this array>" : this.toFFDCStringSingleObject(value)) + lineSeparator);
                if (i <= this.multiple_object_count_to_ffdc) continue;
                buffer.append("........contd");
                break;
            }
        }
        buffer.append('}');
        return buffer.toString();
    }

    public final String toFFDCString(Map aMap) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('{');
        if (aMap == null) {
            buffer.append("<null>");
        } else {
            Iterator i = aMap.entrySet().iterator();
            boolean hasNext = i.hasNext();
            int ctr = 0;
            while (hasNext) {
                Map.Entry entry = i.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                buffer.append((key == aMap ? "<this map>" : this.toFFDCStringSingleObject(key)) + "=" + (value == aMap ? "<this map>" : this.toFFDCStringSingleObject(value)) + lineSeparator);
                hasNext = i.hasNext();
                if (ctr <= this.multiple_object_count_to_ffdc) continue;
                buffer.append("........contd");
                hasNext = false;
            }
        }
        buffer.append('}');
        return buffer.toString();
    }
}

