/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.war.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.ApplicationManager;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedAppInfoFactory;
import com.ibm.ws.app.manager.module.internal.DeployedAppInfoFactoryBase;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.app.manager.war.internal.WARDeployedAppInfo;
import com.ibm.ws.app.manager.war.internal.ZipUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={DeployedAppInfoFactory.class}, property={"service.vendor=IBM", "type:String=war"})
public class WARDeployedAppInfoFactoryImpl
extends DeployedAppInfoFactoryBase {
    private static final TraceComponent tc = Tr.register(WARDeployedAppInfoFactoryImpl.class);
    protected ModuleHandler webModuleHandler;
    private ApplicationManager applicationManager;
    private final ZipUtils zipUtils = new ZipUtils();
    private static final Map<String, Long> timestamps = new HashMap<String, Long>();
    static final long serialVersionUID = -5572482233301532271L;

    @Reference(target="(type=web)")
    protected void setWebModuleHandler(ModuleHandler handler) {
        this.webModuleHandler = handler;
    }

    protected void unsetWebModuleHandler(ModuleHandler handler) {
        this.webModuleHandler = null;
    }

    @Reference
    protected void setApplicationManager(ApplicationManager mgr) {
        this.applicationManager = mgr;
    }

    protected void unsetApplicationManager(ApplicationManager mgr) {
        this.applicationManager = null;
    }

    /*
     * WARNING - void declaration
     */
    public WARDeployedAppInfo createDeployedAppInfo(ApplicationInformation<DeployedAppInfo> applicationInformation) throws UnableToAdaptException {
        try {
            String location;
            File warFile;
            if (this.applicationManager.getExpandApps() && (warFile = new File(location = applicationInformation.getLocation())).isFile() && !location.toLowerCase().endsWith(".xml")) {
                WsResource expandedAppsDir = this.getLocationAdmin().resolveResource("${server.config.dir}/apps/expanded/");
                expandedAppsDir.create();
                Long warFileTimestamp = timestamps.put(warFile.getAbsolutePath(), warFile.lastModified());
                WsResource expandedWarDir = this.getLocationAdmin().resolveResource("${server.config.dir}/apps/expanded/" + applicationInformation.getName() + ".war/");
                if (expandedWarDir.exists()) {
                    if (warFileTimestamp == null || warFileTimestamp.longValue() != warFile.lastModified()) {
                        this.zipUtils.recursiveDelete(expandedWarDir.asFile());
                        expandedWarDir.create();
                        this.zipUtils.unzip(warFile, expandedWarDir.asFile());
                    }
                } else {
                    expandedWarDir.create();
                    this.zipUtils.unzip(warFile, expandedWarDir.asFile());
                }
                Container container = this.setupContainer(applicationInformation.getPid(), expandedWarDir.asFile());
                applicationInformation.setContainer(container);
            }
        }
        catch (IOException location) {
            void ex;
            FFDCFilter.processException((Throwable)location, (String)"com.ibm.ws.app.manager.war.internal.WARDeployedAppInfoFactoryImpl", (String)"113", (Object)((Object)this), (Object[])new Object[]{applicationInformation});
            Tr.error((TraceComponent)tc, (String)"warning.could.not.expand.application", (Object[])new Object[]{applicationInformation.getName(), ex.getMessage()});
        }
        WARDeployedAppInfo deployedApp = new WARDeployedAppInfo(applicationInformation, this);
        applicationInformation.setHandlerInfo((Object)deployedApp);
        return deployedApp;
    }
}

