/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.objectManager;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectStore;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.persistence.BatchingContextFactory;
import com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.utils.ras.SibTr;

public class BatchingContextFactoryImpl
implements BatchingContextFactory {
    private static TraceComponent tc = SibTr.register(BatchingContextFactoryImpl.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private ObjectManager _objectManager;
    private ObjectStore _objectStore;

    public BatchingContextFactoryImpl(ObjectManager objectManager, ObjectStore objectStore) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>", (Object)("ObjectManager=" + objectManager + ", ObjectStore=" + objectStore));
        }
        this._objectManager = objectManager;
        this._objectStore = objectStore;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public BatchingContext createBatchingContext() {
        return this.createBatchingContext(10, false);
    }

    @Override
    public BatchingContext createBatchingContext(int capacity) {
        return this.createBatchingContext(capacity, false);
    }

    @Override
    public BatchingContext createBatchingContext(int capacity, boolean useEnlistedConnections) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createBatchingContext", (Object)("Capacity=" + capacity));
        }
        BatchingContextImpl bc = new BatchingContextImpl(this._objectManager, this._objectStore);
        bc.setCapacity(capacity);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createBatchingContext", (Object)("return" + bc));
        }
        return bc;
    }

    @Override
    public BatchingContext getBatchingContext(PersistentTransaction transaction, int capacity) {
        return this.getBatchingContext(transaction, capacity, false);
    }

    @Override
    public BatchingContext getBatchingContext(PersistentTransaction transaction, int capacity, boolean useEnlistedConnections) {
        BatchingContext bc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBatchingContext", (Object)("Transaction=" + transaction + ", Capacity=" + capacity));
        }
        if ((bc = transaction.getBatchingContext()) == null) {
            bc = this.createBatchingContext(capacity, useEnlistedConnections);
            transaction.setBatchingContext(bc);
        } else {
            bc.clear();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBatchingContext", (Object)("return=" + bc));
        }
        return bc;
    }
}

