/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.classsource.specification.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.anno.classsource.specification.ClassSource_Specification_Container;
import com.ibm.ws.anno.classsource.specification.internal.ClassSourceImpl_Specification;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_Exception;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class ClassSourceImpl_Specification_Container
extends ClassSourceImpl_Specification
implements ClassSource_Specification_Container {
    protected ClassSource_Specification_Container.ContainerData immediateContainerData;
    protected ClassSource_Specification_Container.ContainerData applicationLibraryContainerData;
    protected List<ClassSource_Specification_Container.ContainerData> applicationLibrariesContainerData;
    protected List<ClassSource_Specification_Container.ContainerData> manifestContainerData;
    static final long serialVersionUID = 559328900958659163L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected ClassSourceImpl_Specification_Container(ClassSourceImpl_Factory factory) {
        super(factory);
    }

    @Override
    public String getImmediateContainerName() {
        return this.immediateContainerData.name;
    }

    @Override
    public Container getImmediateContainer() {
        return this.immediateContainerData.container;
    }

    @Override
    public void setImmediateContainerData(String name, Container immediateContainer) {
        this.immediateContainerData = new ClassSource_Specification_Container.ContainerData(name, immediateContainer);
    }

    @Override
    public void setImmediateContainerData(ClassSource_Specification_Container.ContainerData immediateContainerData) {
        this.immediateContainerData = immediateContainerData;
    }

    @Override
    public ClassSource_Specification_Container.ContainerData getImmediateContainerData() {
        return this.immediateContainerData;
    }

    @Override
    public String getApplicationLibraryContainerName() {
        return this.applicationLibraryContainerData == null ? null : this.applicationLibraryContainerData.name;
    }

    @Override
    public Container getApplicationLibraryContainer() {
        return this.applicationLibraryContainerData == null ? null : this.applicationLibraryContainerData.container;
    }

    @Override
    public void setApplicationLibraryContainerData(String name, Container applicationLibraryContainer) {
        this.applicationLibraryContainerData = new ClassSource_Specification_Container.ContainerData(name, applicationLibraryContainer);
    }

    @Override
    public void setApplicationLibraryContainerData(ClassSource_Specification_Container.ContainerData applicationLibraryContainerData) {
        this.applicationLibraryContainerData = applicationLibraryContainerData;
    }

    @Override
    public ClassSource_Specification_Container.ContainerData getApplicationLibraryContainerData() {
        return this.applicationLibraryContainerData;
    }

    @Override
    public List<ClassSource_Specification_Container.ContainerData> getApplicationLibrariesContainerData() {
        return this.applicationLibrariesContainerData;
    }

    @Override
    public void addApplicationLibrariesContainerData(String name, Container applicationLibraryContainer) {
        if (this.applicationLibrariesContainerData == null) {
            this.applicationLibrariesContainerData = new ArrayList<ClassSource_Specification_Container.ContainerData>();
        }
        this.applicationLibrariesContainerData.add(new ClassSource_Specification_Container.ContainerData(name, applicationLibraryContainer));
    }

    @Override
    public void addApplicationLibrariesContainerData(ClassSource_Specification_Container.ContainerData applicationLibraryContainerData) {
        if (this.applicationLibrariesContainerData == null) {
            this.applicationLibrariesContainerData = new ArrayList<ClassSource_Specification_Container.ContainerData>();
        }
        this.applicationLibrariesContainerData.add(applicationLibraryContainerData);
    }

    @Override
    public void addApplicationLibrariesContainerData(List<ClassSource_Specification_Container.ContainerData> applicationLibrariesContainerData) {
        if (applicationLibrariesContainerData == null) {
            applicationLibrariesContainerData = new ArrayList<ClassSource_Specification_Container.ContainerData>();
        }
        this.applicationLibrariesContainerData.addAll(applicationLibrariesContainerData);
    }

    @Override
    public List<ClassSource_Specification_Container.ContainerData> getManifestContainerData() {
        return this.manifestContainerData;
    }

    @Override
    public void addManifestContainerData(String name, Container manifestContainer) {
        if (this.manifestContainerData == null) {
            this.manifestContainerData = new ArrayList<ClassSource_Specification_Container.ContainerData>();
        }
        this.manifestContainerData.add(new ClassSource_Specification_Container.ContainerData(name, manifestContainer));
    }

    @Override
    public void addManifestContainerData(List<ClassSource_Specification_Container.ContainerData> manifestContainerData) {
        if (this.manifestContainerData == null) {
            this.manifestContainerData = new ArrayList<ClassSource_Specification_Container.ContainerData>();
        }
        this.manifestContainerData.addAll(manifestContainerData);
    }

    @Override
    public void addManifestContainerData(ClassSource_Specification_Container.ContainerData manifestContainer) {
        if (this.manifestContainerData == null) {
            this.manifestContainerData = new ArrayList<ClassSource_Specification_Container.ContainerData>();
        }
        this.manifestContainerData.addAll(this.manifestContainerData);
    }

    @Override
    public abstract ClassSource_Aggregate createClassSource(String var1, ClassLoader var2) throws ClassSource_Exception;

    protected void addStandardClassSources(String targetName, ClassLoader rootClassLoader, ClassSource_Aggregate classSource) throws ClassSource_Exception {
        List<ClassSource_Specification_Container.ContainerData> manifestContainerData;
        ClassSource_Specification_Container.ContainerData useApplicationLibContainerData = this.getApplicationLibraryContainerData();
        List<ClassSource_Specification_Container.ContainerData> applicationLibrariesContainerData = useApplicationLibContainerData != null ? this.selectJars(useApplicationLibContainerData) : this.getApplicationLibrariesContainerData();
        if (applicationLibrariesContainerData != null) {
            for (ClassSource_Specification_Container.ContainerData nextContainerData : applicationLibrariesContainerData) {
                String nextContainerName = targetName + " application library " + nextContainerData.name;
                Container nextContainer = nextContainerData.container;
                if (nextContainer == null) {
                    throw new ClassSource_Exception("Container [ " + nextContainerName + " ] could not be resolved");
                }
                this.getFactory().addContainerClassSource(classSource, nextContainerData.name, nextContainerData.container, ClassSource_Aggregate.ScanPolicy.EXTERNAL);
            }
        }
        if ((manifestContainerData = this.getManifestContainerData()) != null) {
            for (ClassSource_Specification_Container.ContainerData nextManifestContainerData : manifestContainerData) {
                String nextContainerName = targetName + " manifest " + nextManifestContainerData.name;
                Container nextContainer = nextManifestContainerData.container;
                if (nextContainer == null) {
                    throw new ClassSource_Exception("Container [ " + nextContainerName + " ] could not be resolved");
                }
                this.getFactory().addContainerClassSource(classSource, nextContainerName, nextContainer, ClassSource_Aggregate.ScanPolicy.EXTERNAL);
            }
        }
        if (rootClassLoader != null) {
            this.getFactory().addClassLoaderClassSource(classSource, "classloader", rootClassLoader);
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<ClassSource_Specification_Container.ContainerData> selectJars(ClassSource_Specification_Container.ContainerData targetContainerData) throws ClassSource_Exception {
        ArrayList<ClassSource_Specification_Container.ContainerData> jarContainers = new ArrayList<ClassSource_Specification_Container.ContainerData>();
        Container targetContainer = targetContainerData.container;
        if (targetContainer == null) {
            throw new ClassSource_Exception("Container [ " + targetContainerData.name + " ] was not resolved");
        }
        for (Entry nextEntry : targetContainerData.container) {
            String nextEntryName = nextEntry.getName();
            if (!nextEntryName.toUpperCase().endsWith(".JAR")) continue;
            try {
                Container nextContainer = (Container)nextEntry.adapt(Container.class);
                if (nextContainer == null) continue;
                ClassSource_Specification_Container.ContainerData nextContainerData = new ClassSource_Specification_Container.ContainerData(targetContainerData.name + " to " + nextEntryName, nextContainer);
                jarContainers.add(nextContainerData);
            }
            catch (UnableToAdaptException nextContainer) {
                void e;
                FFDCFilter.processException((Throwable)nextContainer, (String)"com.ibm.ws.anno.classsource.specification.internal.ClassSourceImpl_Specification_Container", (String)"261", (Object)this, (Object[])new Object[]{targetContainerData});
                throw new ClassSource_Exception("JAR select [ " + nextEntryName + " ] could not be used as a container: " + e);
            }
        }
        return jarContainers;
    }

    @Override
    public abstract void log(TraceComponent var1);

    protected void logCommon(TraceComponent logger) {
        List<ClassSource_Specification_Container.ContainerData> useManifestContainerData;
        List<ClassSource_Specification_Container.ContainerData> useLibrariesContainerData;
        ClassSource_Specification_Container.ContainerData useImmediateContainerData = this.getImmediateContainerData();
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Immediate container [ {0} ] [ {1} ]", useImmediateContainerData.name, useImmediateContainerData.container), (Object[])new Object[0]);
        ClassSource_Specification_Container.ContainerData useApplicationLibraryContainerData = this.getApplicationLibraryContainerData();
        if (useApplicationLibraryContainerData != null) {
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Application library container [ {0} ] [ {1} ]", useApplicationLibraryContainerData.name, useApplicationLibraryContainerData.container), (Object[])new Object[0]);
        }
        if ((useLibrariesContainerData = this.getApplicationLibrariesContainerData()) != null) {
            for (ClassSource_Specification_Container.ContainerData nextContainerData : useLibrariesContainerData) {
                Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Application library element container [ {0} ] [ {1} ]", nextContainerData.name, nextContainerData.container), (Object[])new Object[0]);
            }
        }
        if ((useManifestContainerData = this.getManifestContainerData()) != null) {
            for (ClassSource_Specification_Container.ContainerData nextContainerData : useManifestContainerData) {
                Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Manifest element container  [ {0} ] [ {1} ]", nextContainerData.name, nextContainerData.container), (Object[])new Object[0]);
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ClassSourceImpl_Specification_Container.class);
    }
}

