/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.info.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.anno.info.internal.AnnotationInfoImpl;
import com.ibm.ws.anno.info.internal.AnnotationValueImpl;
import com.ibm.ws.anno.info.internal.FieldInfoImpl;
import com.ibm.ws.anno.info.internal.InfoImpl;
import com.ibm.ws.anno.info.internal.InfoStoreImpl;
import com.ibm.ws.anno.info.internal.InfoVisitor_Annotation;
import com.ibm.ws.anno.info.internal.MethodInfoImpl;
import com.ibm.ws.anno.info.internal.NonDelayedClassInfo;
import com.ibm.ws.anno.info.internal.PackageInfoImpl;
import com.ibm.ws.anno.info.internal.empty.EmptyCollections;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class InfoVisitor
extends ClassVisitor {
    private static final TraceComponent tc = Tr.register(InfoVisitor.class);
    public static final String CLASS_NAME = InfoVisitor.class.getName();
    private final InfoMethodVisitor methodVisitor = new InfoMethodVisitor();
    private final InfoFieldVisitor fieldVisitor = new InfoFieldVisitor();
    protected final String hashText;
    protected final Object[] logParms;
    protected final InfoStoreImpl infoStore;
    private PackageInfoImpl packageInfo;
    private NonDelayedClassInfo classInfo;
    private final List<FieldInfoImpl> fieldInfos = new LinkedList<FieldInfoImpl>();
    private final List<MethodInfoImpl> constructorInfos = new LinkedList<MethodInfoImpl>();
    private final List<MethodInfoImpl> methodInfos = new LinkedList<MethodInfoImpl>();
    private final List<AnnotationInfoImpl> annotationInfos = new LinkedList<AnnotationInfoImpl>();
    protected final String externalName;
    public static final VisitEnded VISIT_ENDED_DUPLICATE_CLASS = new VisitEnded(VisitEndCase.VISIT_END_DUPLICATE_CLASS);
    public static final VisitEnded VISIT_ENDED_CLASS_MISMATCH = new VisitEnded(VisitEndCase.VISIT_END_CLASS_MISMATCH);
    public static final VisitEnded VISIT_ENDED_DUPLICATE_PACKAGE = new VisitEnded(VisitEndCase.VISIT_END_DUPLICATE_PACKAGE);
    public static final VisitEnded VISIT_ENDED_PACKAGE_MISMATCH = new VisitEnded(VisitEndCase.VISIT_END_PACKAGE_MISMATCH);
    static final long serialVersionUID = 3440062930041921279L;

    @Trivial
    public String getHashText() {
        return this.hashText;
    }

    protected static String fixName(String name) {
        return name == null ? null : name.replace('/', '.');
    }

    protected static String[] fixNames(String[] names) {
        String[] fixedNames = new String[names.length];
        for (int nameNo = 0; nameNo < names.length; ++nameNo) {
            fixedNames[nameNo] = InfoVisitor.fixName(names[nameNo]);
        }
        return fixedNames;
    }

    public InfoVisitor(InfoStoreImpl infoStore, String externalName) {
        super(327680);
        this.infoStore = infoStore;
        this.externalName = externalName;
        this.hashText = ((Object)((Object)this)).getClass().getName() + "@" + Integer.toString(new Object().hashCode());
        if (tc.isDebugEnabled()) {
            this.logParms = new Object[]{this.getHashText(), this.getInfoStore().getHashText(), this.externalName};
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Info Store [ {1} ] External [ {2} ]", this.logParms), (Object[])new Object[0]);
        } else {
            this.logParms = null;
        }
    }

    public InfoStoreImpl getInfoStore() {
        return this.infoStore;
    }

    public InfoImpl getInfo() {
        if (this.packageInfo != null) {
            return this.packageInfo;
        }
        return this.classInfo;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public void visit(int version, int access, String partialResourceName, String signature, String superName, String[] interfaceNames) {
        String name = InfoVisitor.fixName(partialResourceName);
        if (PackageInfoImpl.isPackageName(name)) {
            String packageName = PackageInfoImpl.stripPackageNameFromClassName(name);
            this.visitPackage(version, access, packageName);
        } else {
            this.visitClass(version, access, name, signature, superName, interfaceNames);
        }
    }

    protected void visitPackage(int version, int access, String packageName) {
        InfoStoreImpl useInfoStore;
        String useExternalName = this.getExternalName();
        if (PackageInfoImpl.isPackageName(useExternalName)) {
            useExternalName = PackageInfoImpl.stripPackageNameFromClassName(useExternalName);
        }
        if (this.logParms != null) {
            this.logParms[1] = packageName;
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] [ {1} ] ENTER External name [ {2} ]", this.logParms), (Object[])new Object[0]);
        }
        if (!packageName.equals(useExternalName)) {
            if (this.logParms != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] [ {1} ] RETURN External name [ {2} ] mismatch", this.logParms), (Object[])new Object[0]);
            }
            throw VISIT_ENDED_PACKAGE_MISMATCH;
        }
        if (this.logParms != null) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] [ {1} ] External name match; continuing", this.logParms), (Object[])new Object[0]);
        }
        if ((useInfoStore = this.getInfoStore()).basicGetPackageInfo(packageName) != null) {
            Tr.warning((TraceComponent)tc, (String)"ANNO_INFOVISITOR_VISIT1", (Object[])new Object[]{this.getHashText(), packageName});
            String eMsg = "Duplicate package [" + packageName + "]";
            FFDCFilter.processException((Throwable)new Exception(eMsg), (String)CLASS_NAME, (String)"379");
            if (this.logParms != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] [ {1} ] RETURN Duplicate package", this.logParms), (Object[])new Object[0]);
            }
            throw VISIT_ENDED_DUPLICATE_PACKAGE;
        }
        this.packageInfo = this.getInfoStore().basicAddPackageInfo(packageName, access);
        if (this.logParms != null) {
            this.logParms[2] = this.packageInfo.getHashText();
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] [ {1} ] RETURN Move to package [ {2} ]", this.logParms), (Object[])new Object[0]);
        }
    }

    protected void visitClass(int version, int access, String name, String signature, String superName, String[] interfaceNames) {
        String useExternalName = this.getExternalName();
        if (this.logParms != null) {
            this.logParms[1] = name;
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] [ {1} ] External name [ {2} ]", this.logParms), (Object[])new Object[0]);
        }
        if (!name.equals(useExternalName)) {
            if (this.logParms != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] [ {1} ] RETURN External name [ {2} ] does not match", this.logParms), (Object[])new Object[0]);
            }
            throw VISIT_ENDED_CLASS_MISMATCH;
        }
        if (this.logParms != null) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] [ {1} ] External name match; continuing", this.logParms), (Object[])new Object[0]);
        }
        this.classInfo = this.getInfoStore().createClassInfo(name, InfoVisitor.fixName(superName), access, InfoVisitor.fixNames(interfaceNames));
        if (this.logParms != null) {
            this.logParms[2] = this.classInfo.getHashText();
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] [ {1} ] RETURN Move to class [ {2} ]", this.logParms), (Object[])new Object[0]);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        InfoVisitor_Annotation.AnnotationInfoVisitor av = InfoVisitor.visitAnnotation(this.getInfo(), desc, visible);
        this.annotationInfos.add(av.getAnnotationInfo());
        return av;
    }

    static InfoVisitor_Annotation.AnnotationInfoVisitor visitAnnotation(InfoImpl info, String desc, boolean visible) {
        Type annotationType = Type.getType((String)desc);
        String annotationClassName = annotationType.getClassName();
        AnnotationInfoImpl annotationInfo = new AnnotationInfoImpl(annotationClassName, info.getInfoStore());
        return new InfoVisitor_Annotation.AnnotationInfoVisitor(annotationInfo);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object defaultValue) {
        if (name.toLowerCase().equals("enum$values")) {
            return null;
        }
        FieldInfoImpl fieldInfo = new FieldInfoImpl(name, desc, access, defaultValue, this.classInfo);
        this.fieldInfos.add(fieldInfo);
        if (this.logParms != null) {
            this.logParms[1] = name;
            this.logParms[2] = fieldInfo.getHashText();
        }
        this.fieldVisitor.setFieldInfo(fieldInfo);
        return this.fieldVisitor;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.equals("<clinit>")) {
            return null;
        }
        MethodInfoImpl methodInfo = new MethodInfoImpl(name, desc, exceptions, access, this.classInfo);
        if (name.equals("<init>")) {
            this.constructorInfos.add(methodInfo);
        } else {
            this.methodInfos.add(methodInfo);
        }
        if (this.logParms != null) {
            this.logParms[1] = name;
            this.logParms[2] = methodInfo.getHashText();
        }
        this.methodVisitor.setMethodInfo(methodInfo);
        return this.methodVisitor;
    }

    public void visitEnd() {
        if (this.packageInfo != null) {
            this.visitEndPackage();
        } else if (this.classInfo != null) {
            this.visitEndClass();
        } else {
            Tr.warning((TraceComponent)tc, (String)"ANNO_INFOVISITOR_VISIT4", (Object[])new Object[]{this.getHashText()});
            FFDCFilter.processException((Throwable)new Exception("The visitor object can not be identified"), (String)"com.ibm.wsspi.anno.info.internal.InfoVisitor", (String)"559");
        }
    }

    public void visitEndPackage() {
        if (this.logParms != null) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Package [ {1} ]", this.logParms), (Object[])new Object[0]);
        }
        this.packageInfo.setDeclaredAnnotations(this.annotationInfos.toArray(new AnnotationInfoImpl[this.annotationInfos.size()]));
        this.packageInfo = null;
    }

    public void visitEndClass() {
        if (this.logParms != null) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER Class [ {1} ]", this.logParms), (Object[])new Object[0]);
        }
        this.classInfo.setFields(this.fieldInfos.toArray(new FieldInfoImpl[this.fieldInfos.size()]));
        this.classInfo.setConstructors(this.constructorInfos.toArray(new MethodInfoImpl[this.constructorInfos.size()]));
        this.classInfo.setMethods(this.methodInfos.toArray(new MethodInfoImpl[this.methodInfos.size()]));
        this.classInfo.setDeclaredAnnotations(this.annotationInfos.toArray(new AnnotationInfoImpl[this.annotationInfos.size()]));
        boolean didAdd = this.getInfoStore().addClassInfo(this.classInfo);
        if (!didAdd) {
            if (this.logParms != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN Already added [ {1} ]", this.logParms), (Object[])new Object[0]);
            }
        } else {
            if (this.logParms != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Added [ {1} ]", this.logParms), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Applying rules to class [ {1} ]", this.logParms), (Object[])new Object[0]);
            }
            if (this.logParms != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN Applied rules to class [ {1} ]", this.logParms), (Object[])new Object[0]);
            }
        }
        this.classInfo = null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class VisitEnded
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        protected final VisitEndCase endCase;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public VisitEnded(VisitEndCase endCase) {
            this.endCase = endCase;
        }

        @Override
        public Throwable fillInStackTrace() {
            return null;
        }

        public VisitEndCase getEndCase() {
            return this.endCase;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(VisitEnded.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class VisitEndCase
    extends Enum<VisitEndCase> {
        public static final /* enum */ VisitEndCase VISIT_END_DUPLICATE_CLASS;
        public static final /* enum */ VisitEndCase VISIT_END_CLASS_MISMATCH;
        public static final /* enum */ VisitEndCase VISIT_END_DUPLICATE_PACKAGE;
        public static final /* enum */ VisitEndCase VISIT_END_PACKAGE_MISMATCH;
        private static final /* synthetic */ VisitEndCase[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static VisitEndCase[] values() {
            return (VisitEndCase[])$VALUES.clone();
        }

        public static VisitEndCase valueOf(String name) {
            return Enum.valueOf(VisitEndCase.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(VisitEndCase.class);
            VISIT_END_DUPLICATE_CLASS = new VisitEndCase();
            VISIT_END_CLASS_MISMATCH = new VisitEndCase();
            VISIT_END_DUPLICATE_PACKAGE = new VisitEndCase();
            VISIT_END_PACKAGE_MISMATCH = new VisitEndCase();
            $VALUES = new VisitEndCase[]{VISIT_END_DUPLICATE_CLASS, VISIT_END_CLASS_MISMATCH, VISIT_END_DUPLICATE_PACKAGE, VISIT_END_PACKAGE_MISMATCH};
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    class InfoFieldVisitor
    extends FieldVisitor {
        private FieldInfoImpl fieldInfo;
        private List<AnnotationInfoImpl> annotations;
        static final long serialVersionUID = -9066697005427844589L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public InfoFieldVisitor() {
            super(327680);
        }

        void setFieldInfo(FieldInfoImpl fii) {
            this.fieldInfo = fii;
            this.annotations = new LinkedList<AnnotationInfoImpl>();
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            InfoVisitor_Annotation.AnnotationInfoVisitor av = InfoVisitor.visitAnnotation(this.fieldInfo, desc, visible);
            this.annotations.add(av.getAnnotationInfo());
            return av;
        }

        public void visitEnd() {
            if (InfoVisitor.this.logParms != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Field [ {1} ]", InfoVisitor.this.logParms), (Object[])new Object[0]);
                }
                InfoVisitor.this.logParms[1] = this.fieldInfo.getDeclaringClass().getName();
                InfoVisitor.this.logParms[2] = this.fieldInfo.getDeclaringClass().getHashText();
            }
            AnnotationInfoImpl[] annos = EmptyCollections.emptyAnnotationInfoArray;
            if (this.annotations.size() > 0) {
                annos = this.annotations.toArray(new AnnotationInfoImpl[this.annotations.size()]);
            }
            this.fieldInfo.setDeclaredAnnotations(annos);
            this.fieldInfo = null;
            this.annotations = null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(InfoFieldVisitor.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    class InfoMethodVisitor
    extends MethodVisitor {
        private MethodInfoImpl methodInfo;
        private List<AnnotationInfoImpl> annotations;
        private List<AnnotationInfoImpl>[] paramAnnotations;
        static final long serialVersionUID = 6135423551100056588L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public InfoMethodVisitor() {
            super(327680);
        }

        void setMethodInfo(MethodInfoImpl mii) {
            this.methodInfo = mii;
            this.annotations = new LinkedList<AnnotationInfoImpl>();
            this.paramAnnotations = new List[mii.getParameterTypeNames().size()];
        }

        public AnnotationVisitor visitAnnotationDefault() {
            final MethodInfoImpl mii = this.methodInfo;
            return new InfoVisitor_Annotation(mii.getInfoStore()){
                static final long serialVersionUID = -4999167853598438249L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                protected void storeAnnotationValue(String name, AnnotationValueImpl newAnnotationValue) {
                    mii.setAnnotationDefaultValue(newAnnotationValue);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            };
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            InfoVisitor_Annotation.AnnotationInfoVisitor av = InfoVisitor.visitAnnotation(this.methodInfo, desc, visible);
            this.annotations.add(av.getAnnotationInfo());
            return av;
        }

        public AnnotationVisitor visitParameterAnnotation(int param, String desc, boolean visible) {
            Type annotationType = Type.getType((String)desc);
            String annotationClassName = annotationType.getClassName();
            AnnotationInfoImpl annotationInfo = new AnnotationInfoImpl(annotationClassName, InfoVisitor.this.getInfoStore());
            List<AnnotationInfoImpl> annoList = this.paramAnnotations[param];
            if (annoList == null) {
                this.paramAnnotations[param] = annoList = new LinkedList<AnnotationInfoImpl>();
            }
            annoList.add(annotationInfo);
            return new InfoVisitor_Annotation.AnnotationInfoVisitor(annotationInfo);
        }

        public void visitEnd() {
            if (InfoVisitor.this.logParms != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Method [ {1} ]", InfoVisitor.this.logParms), (Object[])new Object[0]);
                }
                InfoVisitor.this.logParms[1] = this.methodInfo.getDeclaringClass().getName();
                InfoVisitor.this.logParms[2] = this.methodInfo.getDeclaringClass().getHashText();
            }
            AnnotationInfoImpl[][] arrAnnos = new AnnotationInfoImpl[this.paramAnnotations.length][];
            for (int i = 0; i < this.paramAnnotations.length; ++i) {
                List<AnnotationInfoImpl> annos = this.paramAnnotations[i];
                AnnotationInfoImpl[] aAnnos = annos == null || annos.isEmpty() ? EmptyCollections.emptyAnnotationInfoArray : annos.toArray(new AnnotationInfoImpl[annos.size()]);
                arrAnnos[i] = aAnnos;
            }
            this.methodInfo.setParameterAnnotations(arrAnnos);
            AnnotationInfoImpl[] annos = EmptyCollections.emptyAnnotationInfoArray;
            if (this.annotations.size() > 0) {
                annos = this.annotations.toArray(new AnnotationInfoImpl[this.annotations.size()]);
            }
            this.methodInfo.setDeclaredAnnotations(annos);
            this.methodInfo = null;
            this.paramAnnotations = null;
            this.annotations = null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(InfoMethodVisitor.class);
        }
    }
}

