/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RLSAccessFile
extends RandomAccessFile {
    private static final com.ibm.tx.util.logging.TraceComponent tc;
    private static HashMap _accessFiles;
    private int _useCount;
    private File _file;
    static final long serialVersionUID = -6623246717619471799L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    RLSAccessFile(File file, String mode) throws FileNotFoundException {
        super(file, mode);
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"RLSAccessFile", (Object)new Object[]{file, mode});
        }
        this._useCount = 1;
        this._file = file;
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"RLSAccessFile", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"close", (Object)new Object[]{this, this._file});
        }
        Class<RLSAccessFile> clazz = RLSAccessFile.class;
        synchronized (RLSAccessFile.class) {
            --this._useCount;
            if (tc.isDebugEnabled()) {
                Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)"remaining file use count", (Object)new Integer(this._useCount));
            }
            if (tc.isDebugEnabled() && this._useCount <= 0) {
                Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)"call stack", (Object)new Exception("Dummy traceback"));
            }
            if (this._useCount == 0) {
                super.close();
                _accessFiles.remove(this._file);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (tc.isEntryEnabled()) {
                Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"close");
            }
            return;
        }
    }

    static synchronized RLSAccessFile getRLSAccessFile(File file) throws FileNotFoundException {
        RLSAccessFile raf;
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"getRLSAccessFile", (Object)file);
        }
        if ((raf = (RLSAccessFile)_accessFiles.get(file)) == null) {
            raf = new RLSAccessFile(file, "rw");
            _accessFiles.put(file, raf);
        } else {
            ++raf._useCount;
            if (tc.isDebugEnabled()) {
                Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)"total file use count", (Object)new Integer(raf._useCount));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"getRLSAccessFile", (Object)raf);
        }
        return raf;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register(RLSAccessFile.class);
        tc = Tr.register(RLSAccessFile.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
        _accessFiles = new HashMap();
    }
}

