/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.tx.util.logging.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.DataItem;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.ReadableLogRecord;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl;
import java.nio.BufferUnderflowException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SingleDataItem
extends DataItem {
    private static final com.ibm.tx.util.logging.TraceComponent tc;
    static final long serialVersionUID = 63360680050986032L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SingleDataItem(int storageMode, byte[] data, RecoverableUnitSectionImpl rus) {
        super(storageMode, data, rus);
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"SingleDataItem", (Object)new Object[]{new Integer(storageMode), RLSUtils.toHexString(data, 32), rus});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"SingleDataItem", (Object)this);
        }
    }

    public SingleDataItem(int storageMode, ReadableLogRecord logRecord, RecoverableUnitSectionImpl rus) throws InternalLogException {
        super(storageMode, logRecord, rus);
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"SingleDataItem", (Object)new Object[]{new Integer(storageMode), logRecord, rus});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"SingleDataItem", (Object)this);
        }
    }

    protected void setData(byte[] data) {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"setData", (Object)new Object[]{RLSUtils.toHexString(data, 32), this});
        }
        int totalDataSize = this._dataSize + 4;
        int unwrittenDataSize = 0;
        if (!this._written) {
            unwrittenDataSize = totalDataSize;
        }
        this._rus.payloadDeleted(totalDataSize, unwrittenDataSize);
        this._data = data;
        this._dataSize = data.length;
        this._filePosition = -1;
        this._written = false;
        this._rus.payloadAdded(this._data.length + 4);
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"setData");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setData(ReadableLogRecord logRecord) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"setData", (Object)new Object[]{this, logRecord});
        }
        int totalDataSize = this._dataSize + 4;
        int unwrittenDataSize = 0;
        if (!this._written) {
            unwrittenDataSize = totalDataSize;
        }
        this._rus.payloadDeleted(totalDataSize, unwrittenDataSize);
        this._logRecord = logRecord;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Reading data size field @ position " + logRecord.position()));
            }
            this._dataSize = logRecord.getInt();
            if (tc.isDebugEnabled()) {
                Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("This data item contains " + this._dataSize + " bytes of data"));
            }
            this._rus.payloadAdded(this._dataSize + 4);
            this._rus.payloadWritten(this._dataSize + 4);
            this._written = true;
            if (this._storageMode == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Reading " + this._dataSize + "bytes of data @ position " + logRecord.position()));
                }
                this._data = new byte[this._dataSize];
                this._logRecord.get(this._data);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Tracking " + this._dataSize + "bytes of data @ position " + logRecord.position()));
                }
                this._filePosition = logRecord.position();
                this._data = null;
                this._logRecord.advancePosition(this._dataSize);
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            void exc;
            com.ibm.ws.ffdc.FFDCFilter.processException((Throwable)bufferUnderflowException, (String)"com.ibm.ws.recoverylog.spi.SingleDataItem", (String)"167", (Object)this, (Object[])new Object[]{logRecord});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SingleDataItem.setData", (String)"180", (Object)this);
            throw new InternalLogException((Throwable)exc);
        }
        catch (Exception exc) {
            com.ibm.ws.ffdc.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SingleDataItem", (String)"172", (Object)this, (Object[])new Object[]{logRecord});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SingleDataItem.setData", (String)"185", (Object)this);
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"setData");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register(SingleDataItem.class);
        tc = Tr.register(SingleDataItem.class, (String)"Transaction", null);
    }
}

