/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.LogRecord;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import java.nio.ByteBuffer;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WriteableLogRecord
extends LogRecord {
    private static final com.ibm.tx.util.logging.TraceComponent tc;
    private long _sequenceNumber = 0L;
    static final long serialVersionUID = 5038729747347654825L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected WriteableLogRecord(ByteBuffer buffer, long sequenceNumber, int length, int absolutePosition) {
        super(buffer, absolutePosition);
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"WriteableLogRecord", (Object)new Object[]{buffer, new Long(sequenceNumber), new Integer(length), new Integer(absolutePosition)});
        }
        this._buffer.put(RECORD_MAGIC_NUMBER);
        this._buffer.putLong(sequenceNumber);
        this._buffer.putInt(length);
        this._sequenceNumber = sequenceNumber;
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"WriteableLogRecord", (Object)this);
        }
    }

    protected void put(byte[] bytes) {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"put", (Object)new Object[]{RLSUtils.toHexString(bytes, 32), this});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Writing at position " + this._buffer.position()));
        }
        this._buffer.put(bytes);
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"put");
        }
    }

    protected void putInt(int data) {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"putInt", (Object)new Object[]{this, new Integer(data)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Writing at position " + this._buffer.position()));
        }
        this._buffer.putInt(data);
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"putInt");
        }
    }

    protected void putLong(long data) {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"putLong", (Object)new Object[]{this, new Long(data)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Writing at position " + this._buffer.position()));
        }
        this._buffer.putLong(data);
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"putLong");
        }
    }

    protected void putShort(short data) {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"putShort", (Object)new Object[]{this, new Short(data)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Writing at position " + this._buffer.position()));
        }
        this._buffer.putShort(data);
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"putShort");
        }
    }

    protected void putBoolean(boolean data) {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"putBoolean", (Object)new Object[]{this, new Boolean(data)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Writing at position " + this._buffer.position()));
        }
        this._buffer.put(data ? (byte)1 : 0);
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"putBoolean");
        }
    }

    protected void close() {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"close", (Object)this);
        }
        this._buffer.putLong(this._sequenceNumber);
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"close");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register(WriteableLogRecord.class);
        tc = Tr.register(WriteableLogRecord.class, (String)"Transaction", null);
    }
}

