/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.url.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NotABundleResourceURLConnection
extends URLConnection {
    private static final String PROTOCOL = "notabundleresource";
    private static final String MANIFESTPATH = "META-INF/MANIFEST.MF";
    private static final Map<String, Delegate> delegates;
    static final long serialVersionUID = 320809855717094294L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private static final String getManifestKeyForBundle(Bundle owningBundle) {
        URL manifestKeyURL = owningBundle.getEntry(MANIFESTPATH);
        if (manifestKeyURL == null) {
            throw new IllegalArgumentException(owningBundle.getSymbolicName());
        }
        String manifestKey = manifestKeyURL.toExternalForm();
        return manifestKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static URL addURL(final URL urlToConvert, Bundle owningBundle) {
        try {
            String manifestKey = NotABundleResourceURLConnection.getManifestKeyForBundle(owningBundle);
            URL newURL = AccessController.doPrivileged(new PrivilegedAction<URL>(){
                static final long serialVersionUID = 94035377461289810L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public URL run() {
                    try {
                        return new URL(NotABundleResourceURLConnection.PROTOCOL, urlToConvert.getHost(), urlToConvert.getPort(), urlToConvert.getFile());
                    }
                    catch (MalformedURLException malformedURLException) {
                        void mue;
                        FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.artifact.url.internal.NotABundleResourceURLConnection$1", (String)"66", (Object)this, (Object[])new Object[0]);
                        throw new IllegalStateException((Throwable)mue);
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
            String key = newURL.toExternalForm();
            Delegate d = new Delegate();
            d.delegateURL = urlToConvert;
            d.owningBundleManifestKey = manifestKey;
            Map<String, Delegate> map = delegates;
            synchronized (map) {
                delegates.put(key, d);
            }
            return newURL;
        }
        catch (IllegalStateException manifestKey) {
            void ise;
            FFDCFilter.processException((Throwable)manifestKey, (String)"com.ibm.ws.artifact.url.internal.NotABundleResourceURLConnection", (String)"85", null, (Object[])new Object[]{urlToConvert, owningBundle});
            throw ise;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forgetBundle(Bundle owningBundle) {
        String manifestKey = NotABundleResourceURLConnection.getManifestKeyForBundle(owningBundle);
        Map<String, Delegate> map = delegates;
        synchronized (map) {
            ArrayList<String> toRemove = new ArrayList<String>();
            for (Map.Entry<String, Delegate> delegateEntry : delegates.entrySet()) {
                if (!delegateEntry.getValue().owningBundleManifestKey.equals(manifestKey)) continue;
                toRemove.add(delegateEntry.getKey());
            }
            for (String s : toRemove) {
                delegates.remove(s);
            }
        }
    }

    public NotABundleResourceURLConnection(URL url) {
        super(url);
    }

    @Override
    public void connect() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        Map<String, Delegate> map = delegates;
        synchronized (map) {
            String key = this.getURL().toExternalForm();
            if (delegates.containsKey(key)) {
                Delegate d = delegates.get(key);
                if (d != null) {
                    return d.delegateURL.openStream();
                }
                throw new IOException(new IllegalStateException("" + this.getURL()));
            }
        }
        throw new FileNotFoundException("" + this.getURL());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(NotABundleResourceURLConnection.class);
        delegates = Collections.synchronizedMap(new HashMap());
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class Delegate {
        URL delegateURL;
        String owningBundleManifestKey;
        static final long serialVersionUID = 5665027962890822060L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private Delegate() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(Delegate.class);
        }
    }
}

