/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.FieldDescriptor;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.ObjectWriter;
import org.apache.yoko.rmi.impl.TypeRepository;

class ShortFieldDescriptor
extends FieldDescriptor {
    ShortFieldDescriptor(Class owner, Class type, String name, Field f, TypeRepository repository) {
        super(owner, type, name, f, repository);
    }

    @Override
    public void read(ObjectReader reader, Object obj) throws IOException {
        if (this.field == null) {
            throw new IOException("cannot read/write using serialPersistentFields");
        }
        try {
            short value = reader.readShort();
            this.field.setShort(obj, value);
        }
        catch (IllegalAccessException ex) {
            throw (IOException)new IOException(ex.getMessage()).initCause(ex);
        }
    }

    @Override
    public void write(ObjectWriter writer, Object obj) throws IOException {
        if (this.field == null) {
            throw new IOException("cannot read/write using serialPersistentFields");
        }
        try {
            writer.writeShort(this.field.getShort(obj));
        }
        catch (IllegalAccessException ex) {
            throw (IOException)new IOException(ex.getMessage()).initCause(ex);
        }
    }

    @Override
    void copyState(Object orig, Object copy, CopyState state) {
        try {
            this.field.setShort(copy, this.field.getShort(orig));
        }
        catch (IllegalAccessException ex) {
            throw (InternalError)new InternalError(ex.getMessage()).initCause(ex);
        }
    }

    @Override
    void print(PrintWriter pw, Map recurse, Object val) {
        try {
            pw.print(this.java_name);
            pw.print("=");
            pw.print(this.field.getShort(val));
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    void readFieldIntoMap(ObjectReader reader, Map map) throws IOException {
        Short value = new Short(reader.readShort());
        map.put(this.java_name, value);
    }

    @Override
    void writeFieldFromMap(ObjectWriter writer, Map map) throws IOException {
        Short value = (Short)map.get(this.java_name);
        if (value == null) {
            writer.writeShort(0);
        } else {
            writer.writeShort(value.shortValue());
        }
    }
}

