/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.PrintWriter;
import java.rmi.Remote;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.ModelElement;
import org.apache.yoko.rmi.impl.RemoteInterfaceDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

abstract class TypeDescriptor
extends ModelElement {
    static Logger logger = Logger.getLogger(TypeDescriptor.class.getName());
    final Class type;
    private volatile String _repid = null;
    private volatile String packageName = null;
    private volatile String typeName = null;
    private volatile FullKey key = null;
    private volatile RemoteInterfaceDescriptor remoteInterface = null;
    private volatile TypeCode typeCode = null;

    protected String genPackageName() {
        int idx = this.java_name.lastIndexOf(46);
        return idx < 0 ? "" : this.java_name.substring(0, idx);
    }

    public final String getPackageName() {
        if (null == this.packageName) {
            this.packageName = this.genPackageName();
        }
        return this.packageName;
    }

    protected String genTypeName() {
        int idx = this.java_name.lastIndexOf(46);
        return idx < 0 ? this.java_name : this.java_name.substring(idx + 1);
    }

    public final String getTypeName() {
        if (null == this.typeName) {
            this.typeName = this.genTypeName();
        }
        return this.typeName;
    }

    private FullKey genKey() {
        return new FullKey(this.getRepositoryID(), this.type);
    }

    public final FullKey getKey() {
        if (null == this.key) {
            this.key = this.genKey();
        }
        return this.key;
    }

    public String toString() {
        return String.format("%s{class=\"%s\",repId=\"%s\"}", this.getClass().getName(), this.type, this.getRepositoryID());
    }

    protected TypeDescriptor(Class type, TypeRepository repository) {
        super(repository, type.getName());
        this.type = type;
    }

    @Override
    protected String genIDLName() {
        return this.java_name.replace('.', '_');
    }

    protected String genRepId() {
        return String.format("RMI:%s:%016X", this.type.getName(), 0);
    }

    public final String getRepositoryID() {
        if (this._repid == null) {
            this._repid = this.genRepId();
        }
        return this._repid;
    }

    protected RemoteInterfaceDescriptor genRemoteInterface() {
        throw new UnsupportedOperationException("class " + this.type + " does not implement " + Remote.class.getName());
    }

    final RemoteInterfaceDescriptor getRemoteInterface() {
        if (null == this.remoteInterface) {
            this.remoteInterface = this.genRemoteInterface();
        }
        return this.remoteInterface;
    }

    public abstract Object read(InputStream var1);

    public abstract void write(OutputStream var1, Object var2);

    public boolean isCustomMarshalled() {
        return false;
    }

    String makeSignature(Class type) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return "Z";
            }
            if (type == Byte.TYPE) {
                return "B";
            }
            if (type == Short.TYPE) {
                return "S";
            }
            if (type == Character.TYPE) {
                return "C";
            }
            if (type == Integer.TYPE) {
                return "I";
            }
            if (type == Long.TYPE) {
                return "J";
            }
            if (type == Float.TYPE) {
                return "F";
            }
            if (type == Double.TYPE) {
                return "D";
            }
            if (type == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("unknown primitive class" + type);
        }
        if (type.isArray()) {
            int i = 0;
            Class<?> elem = type;
            while (elem.isArray()) {
                ++i;
                elem = elem.getComponentType();
            }
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < i; ++j) {
                sb.append('[');
            }
            sb.append(this.makeSignature(elem));
            return sb.toString();
        }
        return "L" + type.getName().replace('.', '/') + ";";
    }

    long getHashCode() {
        return 0L;
    }

    @Override
    protected void init() {
        this.getTypeCode();
    }

    protected abstract TypeCode genTypeCode();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final TypeCode getTypeCode() {
        if (null == this.typeCode) {
            TypeRepository typeRepository = this.repo;
            synchronized (typeRepository) {
                if (null == this.typeCode) {
                    this.typeCode = this.genTypeCode();
                }
            }
        }
        return this.typeCode;
    }

    protected final void setTypeCode(TypeCode tc) {
        this.typeCode = tc;
    }

    Object copyObject(Object value, CopyState state) {
        throw new InternalError("cannot copy " + value.getClass().getName());
    }

    void writeMarshalValue(PrintWriter pw, String outName, String paramName) {
        pw.print(outName);
        pw.print('.');
        pw.print("write_");
        pw.print(this.getIDLName());
        pw.print('(');
        pw.print(paramName);
        pw.print(')');
    }

    void writeUnmarshalValue(PrintWriter pw, String inName) {
        pw.print(inName);
        pw.print('.');
        pw.print("read_");
        pw.print(this.getIDLName());
        pw.print('(');
        pw.print(')');
    }

    void addDependencies(Set<Class<?>> classes) {
    }

    boolean copyInStub() {
        return true;
    }

    void print(PrintWriter pw, Map<Object, Integer> recurse, Object val) {
        Integer old;
        if (val == null) {
            pw.print("null");
        }
        if ((old = recurse.get(val)) != null) {
            pw.print("^" + old);
        } else {
            Integer key = new Integer(System.identityHashCode(val));
            pw.println(this.type.getName() + "@" + Integer.toHexString(key));
        }
    }

    public boolean copyBetweenStates() {
        return true;
    }

    public boolean copyWithinState() {
        return true;
    }

    public static final class FullKey
    extends SimpleKey {
        private final Class<?> localType;

        public FullKey(String repid, Class<?> localType) {
            super(repid);
            this.localType = localType;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SimpleKey)) {
                return false;
            }
            if (obj instanceof FullKey && !Objects.equals(this.localType, ((FullKey)obj).localType)) {
                return false;
            }
            return super.equals(obj);
        }
    }

    public static class SimpleKey {
        private final String repid;

        public SimpleKey(String repid) {
            this.repid = repid;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.repid == null ? 0 : this.repid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SimpleKey)) {
                return false;
            }
            return Objects.equals(this.repid, ((SimpleKey)obj).repid);
        }
    }
}

